/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.addUniquenessPredicates$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001u2A!\u0001\u0002\u0001'\tY\u0012\t\u001a3V]&\fX/\u001a8fgN\u0004&/\u001a3jG\u0006$Xm\u001d+fgRT!a\u0001\u0003\u0002\u0013I,wO]5uKJ\u001c(BA\u0003\u0007\u0003\r\t7\u000f\u001e\u0006\u0003\u000f!\tAA\u001e\u001a`e)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001!\"\u0004\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0015\u000591m\\7n_:\u001c\u0018BA\r\u0017\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u0017I+wO]5uKR+7\u000f\u001e\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"a\u0007\u0001\t\u000f\r\u0002!\u0019!C\u0001I\u0005\t\"/Z<sSR,'/\u00168eKJ$Vm\u001d;\u0016\u0003\u0015\u0002\"A\n\u001d\u000f\u0005\u001d2dB\u0001\u00156\u001d\tICG\u0004\u0002+g9\u00111F\r\b\u0003YEr!!\f\u0019\u000e\u00039R!a\f\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\b\u0011\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!a\u000e\u0004\u0002\u000fA\f7m[1hK&\u0011\u0011H\u000f\u0002\t%\u0016<(/\u001b;fe*\u0011qG\u0002\u0005\u0007y\u0001\u0001\u000b\u0011B\u0013\u0002%I,wO]5uKJ,f\u000eZ3s)\u0016\u001cH\u000f\t")
public class AddUniquenessPredicatesTest
extends CypherFunSuite
implements RewriteTest {
    private final Function1<Object, Object> rewriterUnderTest;
    private final SemanticChecker semanticChecker;

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$RewriteTest$_setter_$semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        RewriteTest$class.assertRewrite(this, originalQuery, expectedQuery);
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    public AddUniquenessPredicatesTest() {
        RewriteTest$class.$init$(this);
        this.test("does not introduce predicate not needed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten("RETURN 42");
                this.$outer.assertIsNotRewritten("MATCH n RETURN n");
                this.$outer.assertIsNotRewritten("MATCH (n)-[r1]->(m) RETURN n");
                this.$outer.assertIsNotRewritten("MATCH (n)-[r1]->(m) MATCH (m)-[r2]->(x) RETURN x");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("uniqueness check is done between relationships of simple and variable pattern lengths", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2*0..1]->(c) RETURN *", "MATCH (a)-[r1]->(b)-[r2*0..1]->(c) WHERE NONE(r2 IN r2 WHERE r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1*0..1]->(b)-[r2]->(c) RETURN *", "MATCH (a)-[r1*0..1]->(b)-[r2]->(c) WHERE NONE(r1 IN r1 WHERE r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1*0..1]->(b)-[r2*0..1]->(c) RETURN *", "MATCH (a)-[r1*0..1]->(b)-[r2*0..1]->(c) WHERE NONE(r1 IN r1 WHERE ANY(r2 IN r2 WHERE r1 = r2)) RETURN *");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("uniqueness check is done between relationships", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->(c) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->(c) WHERE not(r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->(c)-[r3]->(d) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->(c)-[r3]->(d) WHERE not(r2 = r3) AND not(r1 = r3) AND not(r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b), (b)-[r2]->(c), (c)-[r3]->(d) RETURN *", "MATCH (a)-[r1]->(b), (b)-[r2]->(c), (c)-[r3]->(d) WHERE not(r1 = r2) AND not(r1 = r3) AND not(r2 = r3) RETURN *");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("no uniqueness check between relationships of different type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1:X]->(b)-[r2:Y]->(c) RETURN *", "MATCH (a)-[r1:X]->(b)-[r2:Y]->(c) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1:X]->(b)-[r2:X|Y]->(c) RETURN *", "MATCH (a)-[r1:X]->(b)-[r2:X|Y]->(c) WHERE not(r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2:X]->(c) RETURN *", "MATCH (a)-[r1]->(b)-[r2:X]->(c) WHERE not(r1 = r2) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->(c) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->(c) WHERE not(r1 = r2) RETURN *");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ignores shortestPath relationships for uniqueness", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b), shortestPath((a)-[r]->(b)) RETURN *", "MATCH (a)-[r1]->(b), shortestPath((a)-[r]->(b)) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->c, shortestPath((a)-[r]->(b)) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->c, shortestPath((a)-[r]->(b)) WHERE not(r1 = r2) RETURN *");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("ignores allShortestPaths relationships for uniqueness", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddUniquenessPredicatesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b), allShortestPaths((a)-[r]->(b)) RETURN *", "MATCH (a)-[r1]->(b), allShortestPaths((a)-[r]->(b)) RETURN *");
                this.$outer.assertRewrite("MATCH (a)-[r1]->(b)-[r2]->c, allShortestPaths((a)-[r]->(b)) RETURN *", "MATCH (a)-[r1]->(b)-[r2]->c, allShortestPaths((a)-[r]->(b)) WHERE not(r1 = r2) RETURN *");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.rewriterUnderTest = addUniquenessPredicates$.MODULE$;
    }
}

