/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.Rewritable;
import org.neo4j.cypher.internal.compiler.v2_2.Rewritable$;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.expandStar;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.compiler.v2_2.inSequence$;
import org.neo4j.cypher.internal.compiler.v2_2.parser.ParserFixture$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001'\tqQ\t\u001f9b]\u0012\u001cF/\u0019:UKN$(BA\u0002\u0005\u0003%\u0011Xm\u001e:ji\u0016\u00148O\u0003\u0002\u0006\r\u0005\u0019\u0011m\u001d;\u000b\u0005\u001dA\u0011\u0001\u0002<3?JR!!\u0003\u0006\u0002\u0011\r|W\u000e]5mKJT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\r\rL\b\u000f[3s\u0015\ty\u0001#A\u0003oK>$$NC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001AC\u0007\t\u0003+ai\u0011A\u0006\u0006\u0003/)\tqaY8n[>t7/\u0003\u0002\u001a-\tq1)\u001f9iKJ4UO\\*vSR,\u0007CA\u000e\u001d\u001b\u0005!\u0011BA\u000f\u0005\u0005i\t5\u000f^\"p]N$(/^2uS>tG+Z:u'V\u0004\bo\u001c:u\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t!\u0001C\u0003%\u0001\u0011%Q%A\u0007bgN,'\u000f\u001e*foJLG/\u001a\u000b\u0004M1*\u0004CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDQ!L\u0012A\u00029\nQb\u001c:jO&t\u0017\r\\)vKJL\bCA\u00183\u001d\t9\u0003'\u0003\u00022Q\u00051\u0001K]3eK\u001aL!a\r\u001b\u0003\rM#(/\u001b8h\u0015\t\t\u0004\u0006C\u00037G\u0001\u0007a&A\u0007fqB,7\r^3e#V,'/\u001f")
public class ExpandStarTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Identifier ident(String name) {
        return AstConstructionTestSupport$class.ident(this, name);
    }

    @Override
    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, identifier, propKey, intValue);
    }

    public void org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite(String originalQuery, String expectedQuery) {
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(originalQuery, (Option)new Some((Object)this.pos()));
        Statement original = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)ParserFixture$.MODULE$.parser().parse(originalQuery, ParserFixture$.MODULE$.parser().parse$default$2())), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        Statement expected = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)ParserFixture$.MODULE$.parser().parse(expectedQuery, ParserFixture$.MODULE$.parser().parse$default$2())), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        SemanticCheckResult checkResult = (SemanticCheckResult)original.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        expandStar rewriter = new expandStar(checkResult.state());
        Object result = Rewritable.RewritableAny$.MODULE$.rewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)original), (Function1)rewriter);
        TripleEqualsSupport.Equalizer<Object> $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public ExpandStarTest() {
        AstConstructionTestSupport$class.$init$(this);
        this.test("rewrites * in return", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n return *", "match n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n,c return *", "match n,c return c,n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n-->c return *", "match n-->c return c,n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n-[r]->c return *", "match n-[r]->c return c,n,r");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("create (n) return *", "create (n) return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match p = shortestPath((a)-[r*]->(x)) return *", "match p = shortestPath((a)-[r*]->(x)) return a,p,r,x");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match p=(a:Start)-->b return *", "match p=(a:Start)-->b return a, b, p");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrites * in with", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n with * return n", "match n with n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n,c with * return n", "match n,c with c,n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n-->c with * return n", "match n-->c with c,n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n-[r]->c with * return n", "match n-[r]->c with c,n,r return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match n-[r]->c with *, r.pi as x return n", "match n-[r]->c with c, n, r, r.pi as x return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("create (n) with * return n", "create (n) with n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match p = shortestPath((a)-[r*]->(x)) with * return p", "match p = shortestPath((a)-[r*]->(x)) with a,p,r,x return p");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("symbol shadowing should be taken into account", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("match a,x,y with a match b return *", "match a,x,y with a match b return a, b");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("expands _PRAGMA WITHOUT", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("MATCH a,x,y _PRAGMA WITHOUT a MATCH b RETURN *", "MATCH a,x,y WITH x, y MATCH b RETURN b, x, y");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("keeps listed items during expand", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$ExpandStarTest$$assertRewrite("MATCH (n) WITH *, 1 AS b RETURN *", "MATCH (n) WITH n, 1 AS b RETURN b, n");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

