/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.Rewritable;
import org.neo4j.cypher.internal.compiler.v2_2.Rewritable$;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.isolateAggregation$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.compiler.v2_2.inSequence$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00013A!\u0001\u0002\u0001'\t1\u0012j]8mCR,\u0017iZ4sK\u001e\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005I!/Z<sSR,'o\u001d\u0006\u0003\u000b\u0019\t1!Y:u\u0015\t9\u0001\"\u0001\u0003we}\u0013$BA\u0005\u000b\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0006\u000e\u001f!\t)\u0002$D\u0001\u0017\u0015\t9\"\"A\u0004d_6lwN\\:\n\u0005e1\"AD\"za\",'OR;o'VLG/\u001a\t\u00037qi\u0011AA\u0005\u0003;\t\u00111BU3xe&$X\rV3tiB\u0011q\u0004I\u0007\u0002\t%\u0011\u0011\u0005\u0002\u0002\u001b\u0003N$8i\u001c8tiJ,8\r^5p]R+7\u000f^*vaB|'\u000f\u001e\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0015\u0002\"a\u0007\u0001\t\u000f\u001d\u0002!\u0019!C\u0001Q\u0005\t\"/Z<sSR,'/\u00168eKJ$Vm\u001d;\u0016\u0003%r!a\u0007\u0016\n\u0005-\u0012\u0011AE5t_2\fG/Z!hOJ,w-\u0019;j_:Da!\f\u0001!\u0002\u0013I\u0013A\u0005:foJLG/\u001a:V]\u0012,'\u000fV3ti\u0002BQa\f\u0001\u0005RA\n\u0011\u0003]1sg\u00164uN\u001d*foJLG/\u001b8h)\t\tD\u0007\u0005\u0002 e%\u00111\u0007\u0002\u0002\n'R\fG/Z7f]RDQ!\u000e\u0018A\u0002Y\n\u0011\"];fef$V\r\u001f;\u0011\u0005]jdB\u0001\u001d<\u001b\u0005I$\"\u0001\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qJ\u0014A\u0002)sK\u0012,g-\u0003\u0002?\u007f\t11\u000b\u001e:j]\u001eT!\u0001P\u001d")
public class IsolateAggregationTest
extends CypherFunSuite
implements RewriteTest,
AstConstructionTestSupport {
    private final isolateAggregation$ rewriterUnderTest;
    private final InputPosition pos;
    private final SemanticChecker semanticChecker;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Identifier ident(String name) {
        return AstConstructionTestSupport$class.ident(this, name);
    }

    @Override
    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, identifier, propKey, intValue);
    }

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$RewriteTest$_setter_$semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        RewriteTest$class.assertRewrite(this, originalQuery, expectedQuery);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    public isolateAggregation$ rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(queryText, (Option)new Some((Object)this.pos()));
        return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)RewriteTest$class.parseForRewriting(this, queryText)), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
    }

    public IsolateAggregationTest() {
        RewriteTest$class.$init$(this);
        AstConstructionTestSupport$class.$init$(this);
        this.rewriterUnderTest = isolateAggregation$.MODULE$;
        this.test("does not rewrite things that should not be rewritten", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten("MATCH n RETURN n AS n");
                this.$outer.assertIsNotRewritten("MATCH n RETURN n AS n, count(*) AS count, max(n.prop) AS max");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (n) RETURN { name: n.name, count: count(*) } AS result", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (n) RETURN { name: n.name, count: count(*) } AS result", "MATCH (n) WITH n.name AS `  AGGREGATION27`, count(*) AS `  AGGREGATION40` RETURN { name: `  AGGREGATION27`, count: `  AGGREGATION40` } AS result");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH n RETURN n.foo + count(*) AS result", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH n RETURN n.foo + count(*) AS result", "MATCH n WITH n.foo AS `  AGGREGATION17`, count(*) AS `  AGGREGATION23` RETURN `  AGGREGATION17` + `  AGGREGATION23` AS result");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH n RETURN count(*)/60/42 AS result", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH n RETURN count(*)/60/42 AS result", "MATCH n WITH count(*) AS `  AGGREGATION15` RETURN `  AGGREGATION15`/60/42 AS result");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH n-->() RETURN (n)-->({k: count(*)}) AS result", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH n-->() RETURN (n)-->({k: count(*)}) AS result", "MATCH n-->() WITH n, count(*) AS `  AGGREGATION31` RETURN (n)-->({k:`  AGGREGATION31`}) AS result");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH n RETURN n.prop AS prop, n.foo + count(*) AS count", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH n RETURN n.prop AS prop, n.foo + count(*) AS count", "MATCH n WITH n.prop AS `  AGGREGATION17`, n.foo AS `  AGGREGATION33`, count(*) AS `  AGGREGATION39` RETURN `  AGGREGATION17` AS prop, `  AGGREGATION33` + `  AGGREGATION39` AS count");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH n RETURN n AS n, count(n) + 3 AS count", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH n RETURN n AS n, count(n) + 3 AS count", "MATCH n WITH n AS n, count(n) as `  AGGREGATION23`  RETURN n AS n, `  AGGREGATION23` + 3 AS count");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND [1,2,3] AS a RETURN reduce(y=0, x IN collect(a) | x) AS z", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("UNWIND [1,2,3] AS a RETURN reduce(y=0, x IN collect(a) | x) AS z", "UNWIND [1,2,3] AS a WITH collect(a) AS `  AGGREGATION44` RETURN reduce(y=0, x IN `  AGGREGATION44` | x) AS z");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND [1,2,3] AS a RETURN filter(x IN collect(a) WHERE x <> 0) AS z", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("UNWIND [1,2,3] AS a RETURN filter(x IN collect(a) WHERE x <> 0) AS z", "UNWIND [1,2,3] AS a WITH collect(a) AS `  AGGREGATION39` RETURN filter(x IN `  AGGREGATION39` WHERE x <> 0) AS z");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND [1,2,3] AS a RETURN extract(x IN collect(a) | x) AS z", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("UNWIND [1,2,3] AS a RETURN extract(x IN collect(a) | x) AS z", "UNWIND [1,2,3] AS a WITH collect(a) AS `  AGGREGATION40` RETURN extract(x IN `  AGGREGATION40` | x) AS z");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("UNWIND [1,2,3] AS a RETURN [x IN collect(a) | x] AS z", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("UNWIND [1,2,3] AS a RETURN [x IN collect(a) | x] AS z", "UNWIND [1,2,3] AS a WITH collect(a) AS `  AGGREGATION33` RETURN [x IN `  AGGREGATION33` | x] AS z");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH n WITH 60/60/count(*) AS x RETURN x AS x", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH n WITH 60/60/count(*) AS x RETURN x AS x", "MATCH n WITH 60/60 AS `  AGGREGATION15`, count(*) AS `  AGGREGATION19` WITH `  AGGREGATION15`/`  AGGREGATION19` AS x RETURN x AS x");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (a:Start)<-[:R]-(b) RETURN { foo:a.prop=42, bar:collect(b.prop2) } AS result", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH (a:Start)<-[:R]-(b) RETURN { foo:a.prop=42, bar:collect(b.prop2) } AS result", "MATCH (a:Start)<-[:R]-(b) WITH a.prop=42 AS `  AGGREGATION45`, collect(b.prop2) AS `  AGGREGATION54` RETURN { foo:`  AGGREGATION45`, bar:`  AGGREGATION54`} AS result");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH n RETURN count(*) + max(id(n)) AS r", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH n RETURN count(*) + max(id(n)) AS r", "MATCH n WITH count(*) AS `  AGGREGATION15`, max(id(n)) AS `  AGGREGATION26` RETURN `  AGGREGATION15`+`  AGGREGATION26` AS r");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH a RETURN length(collect(a)) AS length", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH a RETURN length(collect(a)) AS length", "MATCH a WITH collect(a) AS `  AGGREGATION22` RETURN length(`  AGGREGATION22`) AS length");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH a RETURN count(a) > 0 AS bool", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH a RETURN count(a) > 0 AS bool", "MATCH a WITH count(a) AS `  AGGREGATION15` RETURN `  AGGREGATION15` > 0 AS bool");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH a RETURN count(a) > {param} AS bool", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("MATCH a RETURN count(a) > {param} AS bool", "MATCH a WITH count(a) AS `  AGGREGATION15` RETURN `  AGGREGATION15` > {param} AS bool");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not introduce multiple return items for the same expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IsolateAggregationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("WITH 1 AS x, 2 AS y RETURN sum(x)*y AS a, sum(x)*y AS b", "WITH 1 AS x, 2 AS y WITH sum(x) as `  AGGREGATION27`, y as y RETURN `  AGGREGATION27`*y AS a, `  AGGREGATION27`*y AS b");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

