/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.Rewritable;
import org.neo4j.cypher.internal.compiler.v2_2.Rewritable$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.ASTNode;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.literalReplacement$;
import org.neo4j.cypher.internal.compiler.v2_2.parser.ParserFixture$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001'\t1B*\u001b;fe\u0006d'+\u001a9mC\u000e,W.\u001a8u)\u0016\u001cHO\u0003\u0002\u0004\t\u0005I!/Z<sSR,'o\u001d\u0006\u0003\u000b\u0019\t1!Y:u\u0015\t9\u0001\"\u0001\u0003we}\u0013$BA\u0005\u000b\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0003/)\tqaY8n[>t7/\u0003\u0002\u001a-\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"B\u000e\u0001\t\u0003a\u0012A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u0015\u0001\u0003\u0001\"\u0003\"\u00035\t7o]3siJ+wO]5uKR!!\u0005K\u00194!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0011)f.\u001b;\t\u000b%z\u0002\u0019\u0001\u0016\u0002\u001b=\u0014\u0018nZ5oC2\fV/\u001a:z!\tYcF\u0004\u0002$Y%\u0011Q\u0006J\u0001\u0007!J,G-\u001a4\n\u0005=\u0002$AB*ue&twM\u0003\u0002.I!)!g\ba\u0001U\u0005iQ\r\u001f9fGR,G-U;fefDQ\u0001N\u0010A\u0002U\nAB]3qY\u0006\u001cW-\\3oiN\u0004Ba\u000b\u001c+q%\u0011q\u0007\r\u0002\u0004\u001b\u0006\u0004\bCA\u0012:\u0013\tQDEA\u0002B]f\u0004")
public class LiteralReplacementTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(String originalQuery, String expectedQuery, Map<String, Object> replacements) {
        Statement original = ParserFixture$.MODULE$.parser().parse(originalQuery, ParserFixture$.MODULE$.parser().parse$default$2());
        Statement expected = ParserFixture$.MODULE$.parser().parse(expectedQuery, ParserFixture$.MODULE$.parser().parse$default$2());
        Tuple2 tuple2 = literalReplacement$.MODULE$.apply((ASTNode)original);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Function1 rewriter = (Function1)tuple2._1();
            Map replacedLiterals = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)rewriter, (Object)replacedLiterals);
            Function1 rewriter2 = (Function1)tuple23._1();
            Map replacedLiterals2 = (Map)tuple23._2();
            Object result = Rewritable.RewritableAny$.MODULE$.rewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)original), rewriter2);
            TripleEqualsSupport.Equalizer<Object> $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
            Statement $org_scalatest_assert_macro_right = expected;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            TripleEqualsSupport.Equalizer<Map<String, Object>> $org_scalatest_assert_macro_left2 = this.convertToEqualizer(replacements);
            Map $org_scalatest_assert_macro_right2 = replacedLiterals2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
            this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public LiteralReplacementTest() {
        this.test("should extract literals in return clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN 1 as result"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {`  AUTOINT0`} as result"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)1))}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN 1.1 as result"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {`  AUTODOUBLE0`} as result"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTODOUBLE0"), (Object)BoxesRunTime.boxToDouble((double)1.1))}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN true as result"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {`  AUTOBOOL0`} as result"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOBOOL0"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN false as result"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {`  AUTOBOOL0`} as result"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOBOOL0"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite("RETURN 'apa' as result", "RETURN {`  AUTOSTRING0`} as result", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa")}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite("RETURN \"apa\" as result", "RETURN {`  AUTOSTRING0`} as result", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa")}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in match clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:1})"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:{`  AUTOINT0`}})"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)1))}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:1.1})"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:{`  AUTODOUBLE0`}})"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTODOUBLE0"), (Object)BoxesRunTime.boxToDouble((double)1.1))}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:true})"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:{`  AUTOBOOL0`}})"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOBOOL0"), (Object)BoxesRunTime.boxToBoolean((boolean)true))}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:false})"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MATCH ({a:{`  AUTOBOOL0`}})"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOBOOL0"), (Object)BoxesRunTime.boxToBoolean((boolean)false))}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite("MATCH ({a:'apa'})", "MATCH ({a:{`  AUTOSTRING0`}})", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa")}))));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite("MATCH ({a:\"apa\"})", "MATCH ({a:{`  AUTOSTRING0`}})", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa")}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in skip limit clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN 0 as x SKIP 1 limit 2"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RETURN {`  AUTOINT0`} as x SKIP {`  AUTOINT1`} LIMIT {`  AUTOINT2`}"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT1"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT2"), (Object)BoxesRunTime.boxToInteger((int)2))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in create statement clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite("create (a {a:0, b:'name 0', c:10000000, d:'a very long string 0'})", "create (a {a:{`  AUTOINT0`}, b:{`  AUTOSTRING1`}, c:{`  AUTOINT2`}, d:{`  AUTOSTRING3`}})", (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING1"), (Object)"name 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT2"), (Object)BoxesRunTime.boxToInteger((int)10000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING3"), (Object)"a very long string 0")}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in merge clause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MERGE (n {a:'apa'}) ON CREATE SET n.foo = 'apa' ON MATCH SET n.foo = 'apa'"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MERGE (n {a:{`  AUTOSTRING0`}}) ON CREATE SET n.foo = {`  AUTOSTRING1`} ON MATCH SET n.foo = {`  AUTOSTRING2`}"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING0"), (Object)"apa"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING1"), (Object)"apa"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING2"), (Object)"apa")}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should extract literals in multiple patterns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create (a {a:0, b:'name 0', c:10000000, d:'a very long string 0'}) create (b {a:0, b:'name 0', c:10000000, d:'a very long string 0'}) create (a)-[:KNOWS {since: 0}]->(b)"})).s((Seq)Nil$.MODULE$), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"create (a {a:{`  AUTOINT0`}, b:{`  AUTOSTRING1`}, c:{`  AUTOINT2`}, d:{`  AUTOSTRING3`}}) create (b {a:{`  AUTOINT4`}, b:{`  AUTOSTRING5`}, c:{`  AUTOINT6`}, d:{`  AUTOSTRING7`}}) create (a)-[:KNOWS {since: {`  AUTOINT8`}}]->(b)"})).s((Seq)Nil$.MODULE$), (Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT0"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING1"), (Object)"name 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT2"), (Object)BoxesRunTime.boxToInteger((int)10000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING3"), (Object)"a very long string 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT4"), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING5"), (Object)"name 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT6"), (Object)BoxesRunTime.boxToInteger((int)10000000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOSTRING7"), (Object)"a very long string 0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"  AUTOINT8"), (Object)BoxesRunTime.boxToInteger((int)0))}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not rewrite queries that already have params in them", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LiteralReplacementTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$LiteralReplacementTest$$assertRewrite("CREATE (a:Person {name:'Jakub', age:{age} })", "CREATE (a:Person {name:'Jakub', age:{age} })", (Map<String, Object>)Predef$.MODULE$.Map().empty());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

