/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxException;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.normalizeReturnClauses;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001'\tQbj\u001c:nC2L'0\u001a*fiV\u0014hn\u00117bkN,7\u000fV3ti*\u00111\u0001B\u0001\ne\u0016<(/\u001b;feNT!!\u0002\u0004\u0002\u0007\u0005\u001cHO\u0003\u0002\b\u0011\u0005!aOM03\u0015\tI!\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYA\"\u0001\u0005j]R,'O\\1m\u0015\tia\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001fA\tQA\\3pi)T\u0011!E\u0001\u0004_J<7\u0001A\n\u0005\u0001QQb\u0004\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0015\u000591m\\7n_:\u001c\u0018BA\r\u0017\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u0017I+wO]5uKR+7\u000f\u001e\t\u0003?\u0001j\u0011\u0001B\u0005\u0003C\u0011\u0011!$Q:u\u0007>t7\u000f\u001e:vGRLwN\u001c+fgR\u001cV\u000f\u001d9peRDQa\t\u0001\u0005\u0002\u0011\na\u0001P5oSRtD#A\u0013\u0011\u0005m\u0001\u0001bB\u0014\u0001\u0005\u0004%\t\u0001K\u0001\f[.,\u0005pY3qi&|g.F\u0001*!\tQ3&D\u0001\u0007\u0013\tacA\u0001\fTs:$\u0018\r_#yG\u0016\u0004H/[8o\u0007J,\u0017\r^8s\u0011\u0019q\u0003\u0001)A\u0005S\u0005aQn[#yG\u0016\u0004H/[8oA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014!\u0005:foJLG/\u001a:V]\u0012,'\u000fV3tiV\t!\u0007\u0005\u00024\u000b:\u0011Ag\u0011\b\u0003k\ts!AN!\u000f\u0005]\u0002eB\u0001\u001d@\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=%\u00051AH]8pizJ\u0011!E\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002E\r\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u0005!\u0011Vm\u001e:ji\u0016\u0014(B\u0001#\u0007\u0011\u0019I\u0005\u0001)A\u0005e\u0005\u0011\"/Z<sSR,'/\u00168eKJ$Vm\u001d;!\u0011\u0015Y\u0005\u0001\"\u0015M\u00035\t7o]3siJ+wO]5uKR\u0019Qj\u0015/\u0011\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\tUs\u0017\u000e\u001e\u0005\u0006)*\u0003\r!V\u0001\u000e_JLw-\u001b8bYF+XM]=\u0011\u0005YKfB\u0001(X\u0013\tAv*\u0001\u0004Qe\u0016$WMZ\u0005\u00035n\u0013aa\u0015;sS:<'B\u0001-P\u0011\u0015i&\n1\u0001V\u00035)\u0007\u0010]3di\u0016$\u0017+^3ss\")q\f\u0001C\tA\u0006I!/Z<sSRLgn\u001a\u000b\u0003\u001b\u0006DQA\u00190A\u0002U\u000b\u0011\"];fef$V\r\u001f;")
public class NormalizeReturnClausesTest
extends CypherFunSuite
implements RewriteTest,
AstConstructionTestSupport {
    private final SyntaxExceptionCreator mkException;
    private final Function1<Object, Object> rewriterUnderTest;
    private final InputPosition pos;
    private final SemanticChecker semanticChecker;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Identifier ident(String name) {
        return AstConstructionTestSupport$class.ident(this, name);
    }

    @Override
    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, identifier, propKey, intValue);
    }

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$RewriteTest$_setter_$semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    public SyntaxExceptionCreator mkException() {
        return this.mkException;
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        Statement original = this.parseForRewriting(originalQuery);
        Statement expected = this.parseForRewriting(expectedQuery);
        Statement result = this.endoRewrite(original);
        TripleEqualsSupport.Equalizer<Statement> $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"\n").append((Object)originalQuery).toString());
    }

    public void rewriting(String queryText) {
        this.endoRewrite(this.parseForRewriting(queryText));
    }

    public NormalizeReturnClausesTest() {
        RewriteTest$class.$init$(this);
        AstConstructionTestSupport$class.$init$(this);
        this.mkException = new SyntaxExceptionCreator("<Query>", (Option)new Some((Object)this.pos()));
        this.rewriterUnderTest = new normalizeReturnClauses((Function2)this.mkException());
        this.test("alias RETURN clause items", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN n, n.foo AS foo, n.bar\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN n AS `n`, n.foo AS foo, n.bar AS `n.bar`\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduce WITH clause for ORDER BY", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN n.foo AS foo, n.bar ORDER BY foo SKIP 2 LIMIT 5")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.foo AS `  FRESHID17`, n.bar AS `  FRESHID31` ORDER BY `  FRESHID17` SKIP 2 LIMIT 5\n        |RETURN `  FRESHID17` AS foo, `  FRESHID31` AS `n.bar`")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduce WITH clause for ORDER BY where returning all IDs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN * ORDER BY n.foo SKIP 2 LIMIT 5")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH * ORDER BY n.foo SKIP 2 LIMIT 5\n        |RETURN *")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduce WITH clause for ORDER BY where returning all IDs and additional columns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN *, n.foo AS bar ORDER BY n.foo SKIP 2 LIMIT 5")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH *, n.foo AS `  FRESHID20` ORDER BY `  FRESHID20` SKIP 2 LIMIT 5\n        |RETURN *, `  FRESHID20` AS bar")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match n return n, count(*) as c order by c", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite("match n return n, count(*) as c order by c", new StringOps(Predef$.MODULE$.augmentString("match n\n        |with n as `  FRESHID15`, count(*) as `  FRESHID18` order by `  FRESHID18`\n        |return `  FRESHID15` as n, `  FRESHID18` as c")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rejects use of aggregation in ORDER BY if aggregation is not used in associated RETURN", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    this.$outer.rewrite(this.$outer.parseForRewriting(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n          |RETURN n.prop AS prop ORDER BY max(n.foo)\n        ")).stripMargin()));
                    throw this.$outer.fail("We shouldn't get here");
                }
                catch (SyntaxException syntaxException) {
                    this.$outer.convertToStringShouldWrapper(syntaxException.getMessage()).should(this.$outer.equal("Cannot use aggregation in ORDER BY if there are no aggregate expressions in the preceding RETURN (line 2, column 1 (offset: 8))"), (Object)Equality$.MODULE$.default());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("accepts use of aggregation in ORDER BY if aggregation is used in associated RETURN", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN n.prop AS prop, max(n.foo) AS m ORDER BY max(n.foo)\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS `  FRESHID17`, max(n.foo) AS `  FRESHID31` ORDER BY `  FRESHID31`\n        |RETURN  `  FRESHID17` AS prop,  `  FRESHID31` AS m\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should replace the aggregation function in the order by", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeReturnClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN n as n, count(n) as count ORDER BY count(n)")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS `  FRESHID15`, count(n) AS `  FRESHID23` ORDER BY `  FRESHID23`\n        |RETURN `  FRESHID15` AS n, `  FRESHID23` as count")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

