/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticError;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxException;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.NormalizeWithClausesTest$;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.normalizeWithClauses;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000154A!\u0001\u0002\u0001'\tAbj\u001c:nC2L'0Z,ji\"\u001cE.Y;tKN$Vm\u001d;\u000b\u0005\r!\u0011!\u0003:foJLG/\u001a:t\u0015\t)a!A\u0002bgRT!a\u0002\u0005\u0002\tY\u0014tL\r\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u00155y\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0006\u0002\u000f\r|W.\\8og&\u0011\u0011D\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\tYB$D\u0001\u0003\u0013\ti\"AA\u0006SK^\u0014\u0018\u000e^3UKN$\bCA\u0010!\u001b\u0005!\u0011BA\u0011\u0005\u0005i\t5\u000f^\"p]N$(/^2uS>tG+Z:u'V\u0004\bo\u001c:u\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002\u001c\u0001!9q\u0005\u0001b\u0001\n\u0003A\u0013aC7l\u000bb\u001cW\r\u001d;j_:,\u0012!\u000b\t\u0003U-j\u0011AB\u0005\u0003Y\u0019\u0011acU=oi\u0006DX\t_2faRLwN\\\"sK\u0006$xN\u001d\u0005\u0007]\u0001\u0001\u000b\u0011B\u0015\u0002\u00195\\W\t_2faRLwN\u001c\u0011\t\u000fA\u0002!\u0019!C\u0001c\u0005\t\"/Z<sSR,'/\u00168eKJ$Vm\u001d;\u0016\u0003I\u0002\"aM#\u000f\u0005Q\u001aeBA\u001bC\u001d\t1\u0014I\u0004\u00028\u0001:\u0011\u0001h\u0010\b\u0003syr!AO\u001f\u000e\u0003mR!\u0001\u0010\n\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA\b\u0011\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!\u0001\u0012\u0004\u0002\u000fA\f7m[1hK&\u0011ai\u0012\u0002\t%\u0016<(/\u001b;fe*\u0011AI\u0002\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\u001a\u0002%I,wO]5uKJ,f\u000eZ3s)\u0016\u001cH\u000f\t\u0005\u0006\u0017\u0002!\t\u0006T\u0001\u000eCN\u001cXM\u001d;SK^\u0014\u0018\u000e^3\u0015\u00075\u001bF\f\u0005\u0002O#6\tqJC\u0001Q\u0003\u0015\u00198-\u00197b\u0013\t\u0011vJ\u0001\u0003V]&$\b\"\u0002+K\u0001\u0004)\u0016!D8sS\u001eLg.\u00197Rk\u0016\u0014\u0018\u0010\u0005\u0002W3:\u0011ajV\u0005\u00031>\u000ba\u0001\u0015:fI\u00164\u0017B\u0001.\\\u0005\u0019\u0019FO]5oO*\u0011\u0001l\u0014\u0005\u0006;*\u0003\r!V\u0001\u000eKb\u0004Xm\u0019;fIF+XM]=\t\u000b}\u0003A\u0011\u00031\u0002=\u0005\u001c8/\u001a:u%\u0016<(/\u001b;f\u0003:$7+Z7b]RL7-\u0012:s_J\u001cH\u0003B'bE\u000eDQ\u0001\u00160A\u0002UCQ!\u00180A\u0002UCQ\u0001\u001a0A\u0002\u0015\fab]3nC:$\u0018nY#se>\u00148\u000fE\u0002OMVK!aZ(\u0003\u0015q\u0012X\r]3bi\u0016$g\bC\u0003j\u0001\u0011E!.A\u0005sK^\u0014\u0018\u000e^5oOR\u0011Qj\u001b\u0005\u0006Y\"\u0004\r!V\u0001\ncV,'/\u001f+fqR\u0004")
public class NormalizeWithClausesTest
extends CypherFunSuite
implements RewriteTest,
AstConstructionTestSupport {
    private final SyntaxExceptionCreator mkException;
    private final Function1<Object, Object> rewriterUnderTest;
    private final InputPosition pos;
    private final SemanticChecker semanticChecker;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Identifier ident(String name) {
        return AstConstructionTestSupport$class.ident(this, name);
    }

    @Override
    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, identifier, propKey, intValue);
    }

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$RewriteTest$_setter_$semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    public SyntaxExceptionCreator mkException() {
        return this.mkException;
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        Statement original = this.parseForRewriting(originalQuery.replace("\r\n", "\n"));
        Statement expected = this.parseForRewriting(expectedQuery.replace("\r\n", "\n"));
        Statement result = this.endoRewrite(original);
        TripleEqualsSupport.Equalizer<Statement> $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"\n").append((Object)originalQuery).toString());
        SemanticCheckResult checkResult = (SemanticCheckResult)result.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        TripleEqualsSupport.Equalizer<Seq> $org_scalatest_assert_macro_left2 = this.convertToEqualizer(checkResult.errors());
        Seq $org_scalatest_assert_macro_right2 = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"");
    }

    public void assertRewriteAndSemanticErrors(String originalQuery, String expectedQuery, Seq<String> semanticErrors) {
        Statement original = this.parseForRewriting(originalQuery);
        Statement expected = this.parseForRewriting(expectedQuery);
        Statement result = this.endoRewrite(original);
        TripleEqualsSupport.Equalizer<Statement> $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"\n").append((Object)originalQuery).toString());
        SemanticCheckResult checkResult = (SemanticCheckResult)result.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        Set errors = ((TraversableOnce)checkResult.errors().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(SemanticError error) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{error.msg(), error.position()}));
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        semanticErrors.foreach((Function1)new Serializable(this, errors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;
            private final Set errors$1;

            public final void apply(String msg) {
                Set $org_scalatest_assert_macro_left = this.errors$1;
                String $org_scalatest_assert_macro_right = msg;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error '", "' not produced (errors: ", ")}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg, this.errors$1})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.errors$1 = errors$1;
            }
        });
    }

    public void rewriting(String queryText) {
        this.endoRewrite(this.parseForRewriting(queryText));
    }

    public NormalizeWithClausesTest() {
        RewriteTest$class.$init$(this);
        AstConstructionTestSupport$class.$init$(this);
        this.mkException = new SyntaxExceptionCreator("<Query>", (Option)new Some((Object)this.pos()));
        this.rewriterUnderTest = new normalizeWithClauses((Function2)this.mkException());
        this.test("ensure identifiers are aliased", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attach ORDER BY expressions to existing aliases", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY n.prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("attach WHERE expression to existing aliases", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH length(n.prop) > 10 AS result WHERE length(n.prop) > 10\n        |RETURN result\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH length(n.prop) > 10 AS result WHERE result\n        |RETURN result\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("does not introduce aliases for ORDER BY with existing alias", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("does not introduce aliases for WHERE with existing alias", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduces aliases for ORDER BY expressions the depend on existing identifiers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n ORDER BY length(n.prop)\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |WITH n AS n, length(n.prop) AS `  FRESHID24` ORDER BY `  FRESHID24`\n        |_PRAGMA WITHOUT `  FRESHID24`\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduces aliases for WHERE expression the depends on existing identifiers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n WHERE length(n.prop) > 10\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |WITH n AS n, length(n.prop) > 10 AS `  FRESHID36` WHERE `  FRESHID36`\n        |_PRAGMA WITHOUT `  FRESHID36`\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduces aliases for ORDER BY expressions that depend on existing aliases", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY length(n.prop)\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop, length(prop) AS `  FRESHID37` ORDER BY `  FRESHID37`\n        |_PRAGMA WITHOUT `  FRESHID37`\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduces aliases for WHERE expression that depends on existing aliases", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop WHERE length(n.prop) > 10\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop, length(prop) > 10 AS `  FRESHID49` WHERE `  FRESHID49`\n        |_PRAGMA WITHOUT `  FRESHID49`\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduces identifiers for ORDER BY expressions that depend on non-aliased identifiers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY n.foo DESC\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop AS prop\n        |WITH prop AS prop, n.foo AS `  FRESHID39` ORDER BY `  FRESHID39` DESC\n        |_PRAGMA WITHOUT `  FRESHID39`\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("introduces identifiers for WHERE expression that depend on non-aliased identifiers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop WHERE n.foo > 10\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop AS prop\n        |WITH prop AS prop, n.foo > 10 AS `  FRESHID40` WHERE `  FRESHID40`\n        |_PRAGMA WITHOUT `  FRESHID40`\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("does not introduce identifiers for ORDER BY expressions in WITH *", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH *, n.prop AS prop ORDER BY n.foo DESC\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH *, n.prop AS prop\n        |WITH *, n.foo AS `  FRESHID42` ORDER BY `  FRESHID42` DESC\n        |_PRAGMA WITHOUT `  FRESHID42`\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("does not introduce identifiers for WHERE expression in WITH *", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH *, n.prop AS prop WHERE n.foo > 10\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH *, n.prop AS prop\n        |WITH *, n.foo > 10 AS `  FRESHID43` WHERE `  FRESHID43`\n        |_PRAGMA WITHOUT `  FRESHID43`\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("does not attach ORDER BY expressions to unaliased items", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewriteAndSemanticErrors(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop ORDER BY n.prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop\n        |WITH n.prop, n.prop AS `  FRESHID31` ORDER BY `  FRESHID31`\n        |_PRAGMA WITHOUT `  FRESHID31`\n        |RETURN prop\n      ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expression in WITH must be aliased (use AS) (line 2, column 6 (offset: 13))"}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("does not attach WHERE expression to unaliased items", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewriteAndSemanticErrors(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop WHERE n.prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop\n        |WITH n.prop, n.prop AS `  FRESHID28` WHERE `  FRESHID28`\n        |_PRAGMA WITHOUT `  FRESHID28`\n        |RETURN prop\n      ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expression in WITH must be aliased (use AS) (line 2, column 6 (offset: 13))"}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("rejects use of aggregation in ORDER BY if aggregation is not used in associated WITH", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    this.$outer.rewrite(this.$outer.parseForRewriting(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n          |WITH n.prop AS prop ORDER BY max(n.foo)\n          |RETURN prop\n        ")).stripMargin()));
                    throw this.$outer.fail("We shouldn't get here");
                }
                catch (SyntaxException syntaxException) {
                    this.$outer.convertToStringShouldWrapper(syntaxException.getMessage()).should(this.$outer.equal("Cannot use aggregation in ORDER BY if there are no aggregate expressions in the preceding WITH (line 2, column 1 (offset: 8))"), (Object)Equality$.MODULE$.default());
                    return;
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("accepts use of aggregation in ORDER BY if aggregation is used in associated WITH", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n          |WITH n.prop AS prop, max(n.foo) AS m ORDER BY max(n.foo)\n        |RETURN prop AS prop, m AS m\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, max(n.foo) AS m ORDER BY m\n        |RETURN  prop AS prop, m AS m\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("does not introduce alias for WHERE containing aggregate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewriteAndSemanticErrors(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop WHERE max(n.foo)\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop WHERE max(n.foo)\n        |RETURN prop\n      ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid use of aggregating function max(...) in this context (line 2, column 27 (offset: 34))"}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("preserves SKIP and LIMIT", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n SKIP 5 LIMIT 2\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n SKIP 5 LIMIT 2\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("preserves SKIP and LIMIT when introducing aliases for ORDER BY expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n ORDER BY n.prop SKIP 5 LIMIT 2\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |WITH n AS n, n.prop AS `  FRESHID26` ORDER BY `  FRESHID26` SKIP 5 LIMIT 2\n        |_PRAGMA WITHOUT `  FRESHID26`\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("preserves SKIP and LIMIT when introducing aliases for WHERE expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n SKIP 5 LIMIT 2 WHERE n.prop > 10\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |WITH n AS n, n.prop > 10 AS `  FRESHID43` SKIP 5 LIMIT 2 WHERE `  FRESHID43`\n        |_PRAGMA WITHOUT `  FRESHID43`\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregating: preserves DISTINCT when replacing ORDER BY expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop ORDER BY n.prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregating: preserves DISTINCT when replacing WHERE expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop WHERE n.prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregating: does not change grouping set when introducing aliases for ORDER BY", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop ORDER BY length(n.prop)\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop, length(prop) AS `  FRESHID46` ORDER BY `  FRESHID46`\n        |_PRAGMA WITHOUT `  FRESHID46`\n        |RETURN prop\n      ")).stripMargin());
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, count(*) AS count ORDER BY length(n.prop)\n        |RETURN prop, count\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, count(*) AS count\n        |WITH prop AS prop, count AS count, length(prop) AS `  FRESHID56` ORDER BY `  FRESHID56`\n        |_PRAGMA WITHOUT `  FRESHID56`\n        |RETURN prop, count\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregating: does not change grouping set when introducing aliases for WHERE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop WHERE length(n.prop) = 1\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop, length(prop) = 1 AS `  FRESHID58` WHERE `  FRESHID58`\n        |_PRAGMA WITHOUT `  FRESHID58`\n        |RETURN prop\n      ")).stripMargin());
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, count(*) AS count WHERE length(n.prop) = 1\n        |RETURN prop, count\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, count(*) AS count\n        |WITH prop AS prop, count AS count, length(prop) = 1 AS `  FRESHID68` WHERE `  FRESHID68`\n        |_PRAGMA WITHOUT `  FRESHID68`\n        |RETURN prop, count\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregating: does not change grouping set when introducing aliases for ORDER BY with non-grouping expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewriteAndSemanticErrors(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop ORDER BY n.foo\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop, n.foo AS `  FRESHID48` ORDER BY `  FRESHID48`\n        |_PRAGMA WITHOUT `  FRESHID48`\n        |RETURN prop\n      ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n not defined (line 2, column 39 (offset: 46))"}));
                this.$outer.assertRewriteAndSemanticErrors(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, collect(n.foo) AS foos ORDER BY n.foo\n        |RETURN prop, foos\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, collect(n.foo) AS foos\n        |WITH prop AS prop, foos AS foos, n.foo AS `  FRESHID63` ORDER BY `  FRESHID63`\n        |_PRAGMA WITHOUT `  FRESHID63`\n        |RETURN prop, foos\n      ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n not defined (line 2, column 54 (offset: 61))"}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aggregating: does not change grouping set when introducing aliases for WHERE with non-grouping expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewriteAndSemanticErrors(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop WHERE n.foo\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop, n.foo AS `  FRESHID45` WHERE `  FRESHID45`\n        |_PRAGMA WITHOUT `  FRESHID45`\n        |RETURN prop\n      ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n not defined (line 2, column 36 (offset: 43))"}));
                this.$outer.assertRewriteAndSemanticErrors(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, collect(n.foo) AS foos WHERE n.foo\n        |RETURN prop, foos\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop, collect(n.foo) AS foos\n        |WITH prop AS prop, foos AS foos, n.foo AS `  FRESHID60` WHERE `  FRESHID60`\n        |_PRAGMA WITHOUT `  FRESHID60`\n        |RETURN prop, foos\n      ")).stripMargin(), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n not defined (line 2, column 51 (offset: 58))"}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (u)-[r1]->(v) WITH r1 AS r2, rand() AS c ORDER BY c MATCH (a)-[r2]->(b) RETURN r2 AS rel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH (u)-[r1]->(v)\n        |WITH r1 AS r2, rand() AS c ORDER BY c\n        |MATCH (a)-[r2]->(b)\n        |RETURN r2 AS rel\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH foo WITH {meh} AS x ORDER BY x.prop DESC LIMIT 4 RETURN x", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH foo\n        |WITH {meh} AS x ORDER BY x.prop DESC LIMIT 4\n        |RETURN x\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH foo\n        |WITH {meh} AS x\n        |WITH x AS x, x.prop AS `  FRESHID37` ORDER BY `  FRESHID37` DESC LIMIT 4\n        |_PRAGMA WITHOUT `  FRESHID37`\n        |RETURN x\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match n with n order by n.name ASC skip 2 return n", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("match n\n        |with n order by n.name ASC skip 2\n        |return n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("match n\n        |with n AS n\n        |with n AS n, n.name AS `  FRESHID26` order by `  FRESHID26` ASC skip 2\n        |_PRAGMA WITHOUT `  FRESHID26`\n        |return n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match x WITH DISTINCT x as otherName ORDER BY x.name RETURN otherName", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("match x\n        |WITH DISTINCT x as otherName ORDER BY x.name\n        |RETURN otherName\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("match x\n        |WITH DISTINCT x as otherName\n        |WITH otherName AS otherName, otherName.name AS `  FRESHID48` ORDER BY `  FRESHID48`\n        |_PRAGMA WITHOUT `  FRESHID48`\n        |RETURN otherName\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match x WITH x as otherName ORDER BY x.name + otherName.name RETURN otherName", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("match x\n        |WITH x as otherName ORDER BY x.name + otherName.name\n        |RETURN otherName\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("match x\n        |WITH x as otherName\n        |WITH otherName as otherName, otherName.name + otherName.name AS `  FRESHID44` ORDER BY `  FRESHID44`\n        |_PRAGMA WITHOUT `  FRESHID44`\n        |RETURN otherName\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("MATCH (a)-[r]->(b) WITH a, r, b, rand() AS c ORDER BY c MATCH (a)-[r]->(b) RETURN r AS rel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (a)-[r]->(b)\n        |WITH a, r, b, rand() AS c ORDER BY c\n        |MATCH (a)-[r]->(b)\n        |RETURN r AS rel\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH (a)-[r]->(b)\n        |WITH a AS a, r AS r, b AS b, rand() AS c ORDER BY c\n        |MATCH (a)-[r]->(b)\n        |RETURN r AS rel\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match n where id(n) IN [0,1,2,3] WITH n.division AS div, max(n.age) AS age order by max(n.age) RETURN div, age", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("match n where id(n) IN [0,1,2,3]\n        |WITH n.division AS div, max(n.age) AS age order by max(n.age)\n        |RETURN div, age\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("match n where id(n) IN [0,1,2,3]\n        |WITH n.division AS div, max(n.age) AS age order by age\n        |RETURN div, age\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match (a) with a where true return a", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("match (a)\n        |with a where true\n        |return a\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("match (a)\n        |with a as a\n        |with a as a, true as `  FRESHID23` where `  FRESHID23`\n        |_PRAGMA WITHOUT `  FRESHID23`\n        |return a\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match (n) return * order by id(n)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH (n)\n        |WITH * ORDER BY id(n)\n        |RETURN *\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("match (n)\n        |WITH *\n        |WITH *, id(n) AS `  FRESHID26` ORDER BY `  FRESHID26`\n        |_PRAGMA WITHOUT `  FRESHID26`\n        |RETURN *\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match n with n as n order by max(n) return n", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NormalizeWithClausesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$37 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$NormalizeWithClausesTest$$anonfun$$$outer().rewriting("match n with n as n order by max(n) return n");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(SyntaxException.class)));
            }

            public /* synthetic */ NormalizeWithClausesTest org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$NormalizeWithClausesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

