/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.Rewritable;
import org.neo4j.cypher.internal.compiler.v2_2.Rewritable$;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticCheckResult;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v2_2.SemanticState$;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.RewriteTest$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.expandStar;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.compiler.v2_2.ast.rewriters.projectFreshSortExpressions$;
import org.neo4j.cypher.internal.compiler.v2_2.inSequence$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001'\ty\u0002K]8kK\u000e$hI]3tQN{'\u000f^#yaJ,7o]5p]N$Vm\u001d;\u000b\u0005\r!\u0011!\u0003:foJLG/\u001a:t\u0015\t)a!A\u0002bgRT!a\u0002\u0005\u0002\tY\u0014tL\r\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011\u0003\u0002\u0001\u00155y\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0006\u0002\u000f\r|W.\\8og&\u0011\u0011D\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f!\tYB$D\u0001\u0003\u0013\ti\"AA\u0006SK^\u0014\u0018\u000e^3UKN$\bCA\u0010!\u001b\u0005!\u0011BA\u0011\u0005\u0005i\t5\u000f^\"p]N$(/^2uS>tG+Z:u'V\u0004\bo\u001c:u\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0003\u0019a\u0014N\\5u}Q\tQ\u0005\u0005\u0002\u001c\u0001!9q\u0005\u0001b\u0001\n\u0003A\u0013!\u0005:foJLG/\u001a:V]\u0012,'\u000fV3tiV\t\u0011\u0006\u0005\u0002+y9\u00111F\u000f\b\u0003Yer!!\f\u001d\u000f\u00059:dBA\u00187\u001d\t\u0001TG\u0004\u00022i5\t!G\u0003\u00024%\u00051AH]8pizJ\u0011!E\u0005\u0003\u001fAI!!\u0004\b\n\u0005-a\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002<\r\u00059\u0001/Y2lC\u001e,\u0017BA\u001f?\u0005!\u0011Vm\u001e:ji\u0016\u0014(BA\u001e\u0007\u0011\u0019\u0001\u0005\u0001)A\u0005S\u0005\u0011\"/Z<sSR,'/\u00168eKJ$Vm\u001d;!\u0011\u0015\u0011\u0005\u0001\"\u0015D\u00035\t7o]3siJ+wO]5uKR\u0019AIS*\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0017\u0006\u0003\r\u0001T\u0001\u000e_JLw-\u001b8bYF+XM]=\u0011\u00055\u0003fBA#O\u0013\tye)\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(G\u0011\u0015!\u0016\t1\u0001M\u00035)\u0007\u0010]3di\u0016$\u0017+^3ss\")Q\u0001\u0001C\u0005-R\u0011qK\u0017\t\u0003?aK!!\u0017\u0003\u0003\u0013M#\u0018\r^3nK:$\b\"B.V\u0001\u0004a\u0015!C9vKJLH+\u001a=u\u0001")
public class ProjectFreshSortExpressionsTest
extends CypherFunSuite
implements RewriteTest,
AstConstructionTestSupport {
    private final Function1<Object, Object> rewriterUnderTest;
    private final InputPosition pos;
    private final SemanticChecker semanticChecker;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Identifier ident(String name) {
        return AstConstructionTestSupport$class.ident(this, name);
    }

    @Override
    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, identifier, propKey, intValue);
    }

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$rewriters$RewriteTest$_setter_$semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public Statement parseForRewriting(String queryText) {
        return RewriteTest$class.parseForRewriting(this, queryText);
    }

    @Override
    public Object rewrite(Statement original) {
        return RewriteTest$class.rewrite(this, original);
    }

    @Override
    public Statement endoRewrite(Statement original) {
        return RewriteTest$class.endoRewrite(this, original);
    }

    @Override
    public void assertIsNotRewritten(String query) {
        RewriteTest$class.assertIsNotRewritten(this, query);
    }

    @Override
    public Function1<Object, Object> rewriterUnderTest() {
        return this.rewriterUnderTest;
    }

    @Override
    public void assertRewrite(String originalQuery, String expectedQuery) {
        Statement original = this.ast(originalQuery);
        Statement expected = this.ast(expectedQuery);
        Statement result = this.endoRewrite(original);
        TripleEqualsSupport.Equalizer<Statement> $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder().append((Object)"\n").append((Object)originalQuery).toString());
    }

    private Statement ast(String queryText) {
        Statement parsed = this.parseForRewriting(queryText);
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(queryText, (Option)new Some((Object)this.pos()));
        Statement normalized = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)parsed), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        SemanticCheckResult checkResult = (SemanticCheckResult)normalized.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)normalized), (Function1)inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new expandStar(checkResult.state())})));
    }

    public ProjectFreshSortExpressionsTest() {
        RewriteTest$class.$init$(this);
        AstConstructionTestSupport$class.$init$(this);
        this.rewriterUnderTest = projectFreshSortExpressions$.MODULE$;
        this.test("dont adjust WITH without ORDER BY or WHERE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |RETURN n\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |RETURN n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate WITH containing ORDER BY", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("duplicate WITH containing WHERE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop WHERE prop\n        |RETURN prop AS prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("preserve DISTINCT on first WITH", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop ORDER BY prop\n        |RETURN prop\n      ")).stripMargin());
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH DISTINCT n.prop AS prop\n        |WITH prop AS prop WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("carry SKIP and LIMIT with ORDER BY", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop SKIP 2 LIMIT 5\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop SKIP 2 LIMIT 5\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("carry SKIP and LIMIT with WHERE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop SKIP 2 LIMIT 5 WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop SKIP 2 LIMIT 5 WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("keep WHERE with ORDER BY", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop ORDER BY prop WHERE prop\n        |RETURN prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n.prop AS prop\n        |WITH prop AS prop ORDER BY prop WHERE prop\n        |RETURN prop\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("handle RETURN * ORDERBY property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |RETURN * ORDER BY n.prop\n      ")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n\n        |WITH n AS n, n.prop AS `  FRESHID28`\n        |WITH n AS n, `  FRESHID28` AS `  FRESHID28` ORDER BY `  FRESHID28`\n        |WITH n AS n\n        |RETURN n AS n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not introduce WITH for ORDER BY over preserved identifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n      |WITH n AS n, n.prop AS prop\n      |WITH n AS n, prop AS prop ORDER BY prop\n      |RETURN n AS n\n    ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not introduce WITH for WHERE over preserved identifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProjectFreshSortExpressionsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.assertIsNotRewritten(new StringOps(Predef$.MODULE$.augmentString("MATCH n\n        |WITH n AS n, n.prop AS prop\n        |WITH n AS n, prop AS prop WHERE prop\n        |RETURN n AS n\n      ")).stripMargin());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

