/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.commands.expressions;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.PathImpl;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.PathValueBuilder;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001'\t!\u0002+\u0019;i-\u0006dW/\u001a\"vS2$WM\u001d+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u000f!\tAA\u001e\u001a`e)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u000b\u0003\u001d\u0019w.\\7p]NL!!\u0007\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0011\r\u0011\"\u0001\"\u0003\u0005\tU#\u0001\u0012\u0011\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015r\u0011aB4sCBDGMY\u0005\u0003O\u0011\u0012AAT8eK\"1\u0011\u0006\u0001Q\u0001\n\t\n!!\u0011\u0011\t\u000f-\u0002!\u0019!C\u0001C\u0005\t!\t\u0003\u0004.\u0001\u0001\u0006IAI\u0001\u0003\u0005\u0002Bqa\f\u0001C\u0002\u0013\u0005\u0011%A\u0001D\u0011\u0019\t\u0004\u0001)A\u0005E\u0005\u00111\t\t\u0005\bg\u0001\u0011\r\u0011\"\u0001\"\u0003\u0005!\u0005BB\u001b\u0001A\u0003%!%\u0001\u0002EA!9q\u0007\u0001b\u0001\n\u0003\t\u0013!A#\t\re\u0002\u0001\u0015!\u0003#\u0003\t)\u0005\u0005C\u0004<\u0001\t\u0007I\u0011\u0001\u001f\u0002\tI,G.M\u000b\u0002{A\u00111EP\u0005\u0003\u007f\u0011\u0012ABU3mCRLwN\\:iSBDa!\u0011\u0001!\u0002\u0013i\u0014!\u0002:fYF\u0002\u0003bB\"\u0001\u0005\u0004%\t\u0001P\u0001\u0005e\u0016d'\u0007\u0003\u0004F\u0001\u0001\u0006I!P\u0001\u0006e\u0016d'\u0007\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001=\u0003\u0011\u0011X\r\\\u001a\t\r%\u0003\u0001\u0015!\u0003>\u0003\u0015\u0011X\r\\\u001a!\u0011\u001dY\u0005A1A\u0005\u0002q\nAA]3mi!1Q\n\u0001Q\u0001\nu\nQA]3mi\u0001BQa\u0014\u0001\u0005\nA\u000b!#\\8dW\u0016$'+\u001a7bi&|gn\u001d5jaR!Q(U-\\\u0011\u0015\u0011f\n1\u0001T\u0003\tIG\r\u0005\u0002U/6\tQKC\u0001W\u0003\u0015\u00198-\u00197b\u0013\tAVK\u0001\u0003M_:<\u0007\"\u0002.O\u0001\u0004\u0011\u0013!B:uCJ$\b\"\u0002/O\u0001\u0004\u0011\u0013aA3oI\")a\f\u0001C\u0005?\u0006QQn\\2lK\u0012tu\u000eZ3\u0015\u0005\t\u0002\u0007\"\u0002*^\u0001\u0004\u0019\u0006")
public class PathValueBuilderTest
extends CypherFunSuite {
    private final Node A = this.mockedNode(1L);
    private final Node B = this.mockedNode(2L);
    private final Node C = this.mockedNode(3L);
    private final Node D = this.mockedNode(4L);
    private final Node E = this.mockedNode(5L);
    private final Relationship rel1 = this.mockedRelationship(1L, this.A(), this.B());
    private final Relationship rel2 = this.mockedRelationship(2L, this.B(), this.C());
    private final Relationship rel3 = this.mockedRelationship(3L, this.C(), this.D());
    private final Relationship rel4 = this.mockedRelationship(3L, this.D(), this.E());

    public Node A() {
        return this.A;
    }

    public Node B() {
        return this.B;
    }

    public Node C() {
        return this.C;
    }

    public Node D() {
        return this.D;
    }

    public Node E() {
        return this.E;
    }

    public Relationship rel1() {
        return this.rel1;
    }

    public Relationship rel2() {
        return this.rel2;
    }

    public Relationship rel3() {
        return this.rel3;
    }

    public Relationship rel4() {
        return this.rel4;
    }

    private Relationship mockedRelationship(long id, Node start, Node end) {
        Relationship rel = (Relationship)this.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)rel.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        Mockito.when((Object)rel.getStartNode()).thenReturn((Object)start);
        Mockito.when((Object)rel.getEndNode()).thenReturn((Object)end);
        Mockito.when((Object)rel.getType()).thenReturn((Object)DynamicRelationshipType.withName((String)"X"));
        Mockito.when((Object)rel.getOtherNode(start)).thenReturn((Object)end);
        Mockito.when((Object)rel.getOtherNode(end)).thenReturn((Object)start);
        return rel;
    }

    /*
     * WARNING - void declaration
     */
    private Node mockedNode(long id) {
        void var3_2;
        Node node2 = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        return var3_2;
    }

    public PathValueBuilderTest() {
        this.test("p = (a)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]->(b)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addOutgoingRelationship(this.$outer.rel1());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X]-(a)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.B()).addIncomingRelationship(this.$outer.rel1());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]-(b)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationship(this.$outer.rel1());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X]-(a)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.B()).addUndirectedRelationship(this.$outer.rel1());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = <empty> should throw", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                this.$outer.evaluating((Function0<Object>)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final PathValueBuilder builder$1;

                    public final PathImpl apply() {
                        return this.builder$1.result();
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(IllegalArgumentException.class)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X*]->(b)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addOutgoingRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X*]->(b) when rels is null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addOutgoingRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal((Null$)null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]->(b)--(c)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addOutgoingRelationship(this.$outer.rel1()).addUndirectedRelationship(this.$outer.rel2());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X*]-(a)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.C()).addIncomingRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X*]-(a) when rels is null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addIncomingRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal((Null$)null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.C()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a) reversed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.C()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-()", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()}))).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel3(), this.$outer.rel4()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r1", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()}))).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel3(), this.$outer.rel4()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()}))).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel4(), this.$outer.rel3()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r1 && r2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()}))).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel4(), this.$outer.rel3()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*0]-(a)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.C()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a) when rels is null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal((Null$)null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a) when single node is null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                PathImpl result = builder.addNode(null).result();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal((Null$)null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a) when single node is null also for mutable builder", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal((Null$)null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r]->(b) when relationship is null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                PathImpl result = builder.addNode(this.$outer.A()).addIncomingRelationship(null).result();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal((Null$)null));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

