/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.commands.expressions;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.SplitFunction;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryStateHelper$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001'\t\t2\u000b\u001d7ji\u001a+hn\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r|W.\\1oINT!a\u0002\u0005\u0002\tY\u0014tL\r\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\"\"A\u0004d_6lwN\\:\n\u0005e1\"AD\"za\",'OR;o'VLG/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAq\u0001\t\u0001C\u0002\u0013\u0005\u0011%A\u0004ok2d7+Z9\u0016\u0003\t\u00022aI\u00171\u001d\t!#F\u0004\u0002&Q5\taE\u0003\u0002(%\u00051AH]8pizJ\u0011!K\u0001\u0006g\u000e\fG.Y\u0005\u0003W1\nq\u0001]1dW\u0006<WMC\u0001*\u0013\tqsFA\u0002TKFT!a\u000b\u0017\u0011\u0005E*dB\u0001\u001a4\u001b\u0005a\u0013B\u0001\u001b-\u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Qb\u0003BB\u001d\u0001A\u0003%!%\u0001\u0005ok2d7+Z9!\u0011\u001dY\u0004A1A\u0005\u0002q\n!B\\;mYN#(/\u001b8h+\u0005\u0001\u0004B\u0002 \u0001A\u0003%\u0001'A\u0006ok2d7\u000b\u001e:j]\u001e\u0004\u0003\"\u0002!\u0001\t\u0013\t\u0015!B:qY&$Hc\u0001\"F\u000fB\u0011!gQ\u0005\u0003\t2\u00121!\u00118z\u0011\u00151u\b1\u00011\u0003\u0011y'/[4\t\u000b!{\u0004\u0019\u0001\u0019\u0002\u0019M\u0004H.\u001b;QCR$XM\u001d8")
public class SplitFunctionTest
extends CypherFunSuite {
    private final Seq<String> nullSeq = null;
    private final String nullString;

    public Seq<String> nullSeq() {
        return this.nullSeq;
    }

    public String nullString() {
        return this.nullString;
    }

    public Object org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split(String orig, String splitPattern) {
        SplitFunction expr = new SplitFunction((Expression)new Literal((Object)orig), (Expression)new Literal((Object)splitPattern));
        return expr.apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public SplitFunctionTest() {
        this.nullString = null;
        this.test("passing null to split() returns null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split("something", this.$outer.nullString())).should(this.$outer.be().apply(this.$outer.nullSeq()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split(this.$outer.nullString(), "something")).should(this.$outer.be().apply(this.$outer.nullSeq()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("splitting non-empty strings with one character", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split("first,second", ",")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("splitting non-empty strings with more than one character", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split("first11second11third", "11")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second", "third"}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("splitting an empty string should return an empty string", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split("", ",")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("splitting a string containing only the split pattern should return two empty strings", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split(",", ",")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("using an empty separator should split on every character", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split("banana", "")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "a", "n", "a", "n", "a"}))));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split("a", "")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$SplitFunctionTest$$split("", "")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

