/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.commands.expressions;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_2.ParameterWrongTypeException;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ToFloatFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ToFloatFunctionTest$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryStateHelper$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001'\t\u0019Bk\u001c$m_\u0006$h)\u001e8di&|g\u000eV3ti*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1m\\7nC:$7O\u0003\u0002\b\u0011\u0005!aOM03\u0015\tI!\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYA\"\u0001\u0005j]R,'O\\1m\u0015\tia\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001fA\tQA\\3pi)T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0006\u0002\u000f\r|W.\\8og&\u0011\u0011D\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0003!\u0001\u0011%\u0011%A\u0004u_\u001acw.\u0019;\u0015\u0005\tB\u0003CA\u0012'\u001b\u0005!#\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d\"#aA!os\")\u0011f\ba\u0001E\u0005!qN]5h\u0001")
public class ToFloatFunctionTest
extends CypherFunSuite {
    public Object org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat(Object orig) {
        return new ToFloatFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public ToFloatFunctionTest() {
        this.test("should return null if argument is null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Object> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat(null));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string to a float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat("10.599")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)10.599)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert an integer string to a float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat("21")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)21.0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert an integer to a float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat(BoxesRunTime.boxToInteger((int)23))).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)23.0)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a partially numeric string", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Object> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat("20foobar2"));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading zeros to a float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat("000123121.5")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)123121.5)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus to a negative float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat("-12.66")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)-12.66)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus and zeros to a negative float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat("-00012.91")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)-12.91)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should throw an exception if the argument is an object which cannot be converted to a float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat(new Object());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)));
            }

            public /* synthetic */ ToFloatFunctionTest org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("given a float should give the same value back", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToFloatFunctionTest$$toFloat(BoxesRunTime.boxToDouble((double)50.5))).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)50.5)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

