/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.commands.expressions;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.CypherTypeException;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ToIntFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ToIntFunctionTest$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryStateHelper$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001'\t\tBk\\%oi\u001a+hn\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r|W.\\1oINT!a\u0002\u0005\u0002\tY\u0014tL\r\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)\u0002$D\u0001\u0017\u0015\t9\"\"A\u0004d_6lwN\\:\n\u0005e1\"AD\"za\",'OR;o'VLG/\u001a\u0005\u00067\u0001!\t\u0001H\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003\tAQ\u0001\t\u0001\u0005\n\u0005\nQ\u0001^8J]R$\"A\t\u0015\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\u0007\u0005s\u0017\u0010C\u0003*?\u0001\u0007!%\u0001\u0003pe&<\u0007")
public class ToIntFunctionTest
extends CypherFunSuite {
    public Object org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt(Object orig) {
        return new ToIntFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public ToIntFunctionTest() {
        this.test("should return null if argument is null", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Object> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt(null));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string to an integer", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("10")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)10)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a double to an integer", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt(BoxesRunTime.boxToDouble((double)23.5))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)23)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse float and truncate to int if the argument is a float literal", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("20.5")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)20)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a partially numeric string", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Object> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("20foobar2"));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a hexadecimal string", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer<Object> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("0x20"));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading zeros to an integer", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("000123121")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)123121)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus in a negative integer", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("-12")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)-12)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus and zeros in a negative integer", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("-00012")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)-12)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should throw an exception if the argument is an object which cannot be converted to integer", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt(new Object());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
            }

            public /* synthetic */ ToIntFunctionTest org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("given an integer should give the same value back", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt(BoxesRunTime.boxToInteger((int)50))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)50)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should truncate floats if given a float", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt(BoxesRunTime.boxToFloat((float)20.6f))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)20)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail for larger integers larger that 8 bytes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("10508455564958384115");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
            }

            public /* synthetic */ ToIntFunctionTest org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle floats larger than 2^31 - 1", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("8589934592.0")).should(this.$outer.equal(BoxesRunTime.boxToLong((long)0x200000000L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle -2^63", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("-9223372036854775808")).should(this.$outer.equal(BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("cannot handle -2^63-1", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("-9223372036854775809");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
            }

            public /* synthetic */ ToIntFunctionTest org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle 2^63 - 1", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("9223372036854775807")).should(this.$outer.equal(BoxesRunTime.boxToLong((long)Long.MAX_VALUE)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("cannot handle 2^63", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$toInt("9223372036854775808");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
            }

            public /* synthetic */ ToIntFunctionTest org$neo4j$cypher$internal$compiler$v2_2$commands$expressions$ToIntFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

