/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.executionplan;

import java.net.URL;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.LoadCsvPeriodicCommitObserver;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.ExternalResource;
import org.neo4j.cypher.internal.compiler.v2_2.spi.QueryContext;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001#\t\tCj\\1e\u0007N4\b+\u001a:j_\u0012L7mQ8n[&$xJY:feZ,'\u000fV3ti*\u00111\u0001B\u0001\u000eKb,7-\u001e;j_:\u0004H.\u00198\u000b\u0005\u00151\u0011\u0001\u0002<3?JR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u000591m\\7n_:\u001c\u0018BA\f\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u0013y\u0001\u0001\u0019!a\u0001\n\u0003y\u0012!\u0005:fg>,(oY3V]\u0012,'\u000fV3tiV\t\u0001\u0005\u0005\u0002\u001dC%\u0011!E\u0001\u0002\u001e\u0019>\fGmQ:w!\u0016\u0014\u0018n\u001c3jG\u000e{W.\\5u\u001f\n\u001cXM\u001d<fe\"IA\u0005\u0001a\u0001\u0002\u0004%\t!J\u0001\u0016e\u0016\u001cx.\u001e:dKVsG-\u001a:UKN$x\fJ3r)\t1C\u0006\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0003V]&$\bbB\u0017$\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004BB\u0018\u0001A\u0003&\u0001%\u0001\nsKN|WO]2f+:$WM\u001d+fgR\u0004\u0003\"C\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u00013\u00031\tX/\u001a:z\u0007>tG/\u001a=u+\u0005\u0019\u0004C\u0001\u001b8\u001b\u0005)$B\u0001\u001c\u0005\u0003\r\u0019\b/[\u0005\u0003qU\u0012A\"U;fef\u001cuN\u001c;fqRD\u0011B\u000f\u0001A\u0002\u0003\u0007I\u0011A\u001e\u0002!E,XM]=D_:$X\r\u001f;`I\u0015\fHC\u0001\u0014=\u0011\u001di\u0013(!AA\u0002MBaA\u0010\u0001!B\u0013\u0019\u0014!D9vKJL8i\u001c8uKb$\b\u0005C\u0005A\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0006A!/Z:pkJ\u001cW-F\u0001C!\t\u0019e)D\u0001E\u0015\t)E!A\u0003qSB,7/\u0003\u0002H\t\n\u0001R\t\u001f;fe:\fGNU3t_V\u00148-\u001a\u0005\n\u0013\u0002\u0001\r\u00111A\u0005\u0002)\u000bAB]3t_V\u00148-Z0%KF$\"AJ&\t\u000f5B\u0015\u0011!a\u0001\u0005\"1Q\n\u0001Q!\n\t\u000b\u0011B]3t_V\u00148-\u001a\u0011\t\u000f=\u0003!\u0019!C\u0001!\u0006\u0019QO\u001d7\u0016\u0003E\u0003\"AU,\u000e\u0003MS!\u0001V+\u0002\u00079,GOC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&aA+S\u0019\"1!\f\u0001Q\u0001\nE\u000bA!\u001e:mA!)A\f\u0001C);\u0006Q!-\u001a4pe\u0016,\u0015m\u00195\u0015\u0003\u0019\u0002")
public class LoadCsvPeriodicCommitObserverTest
extends CypherFunSuite {
    private LoadCsvPeriodicCommitObserver resourceUnderTest;
    private QueryContext queryContext;
    private ExternalResource resource;
    private final URL url = new URL("file:///tmp/something.csv");

    public LoadCsvPeriodicCommitObserver resourceUnderTest() {
        return this.resourceUnderTest;
    }

    public void resourceUnderTest_$eq(LoadCsvPeriodicCommitObserver x$1) {
        this.resourceUnderTest = x$1;
    }

    public QueryContext queryContext() {
        return this.queryContext;
    }

    public void queryContext_$eq(QueryContext x$1) {
        this.queryContext = x$1;
    }

    public ExternalResource resource() {
        return this.resource;
    }

    public void resource_$eq(ExternalResource x$1) {
        this.resource = x$1;
    }

    public URL url() {
        return this.url;
    }

    @Override
    public void beforeEach() {
        this.queryContext_$eq((QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class)));
        this.resource_$eq((ExternalResource)this.mock(ManifestFactory$.MODULE$.classType(ExternalResource.class)));
        this.resourceUnderTest_$eq(new LoadCsvPeriodicCommitObserver(1L, this.resource(), this.queryContext()));
    }

    public LoadCsvPeriodicCommitObserverTest() {
        this.test("writing should not trigger tx restart until next csv line is fetched", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any())).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})})));
                LoadCsvPeriodicCommitObserver qual$1 = this.$outer.resourceUnderTest();
                URL x$1 = this.$outer.url();
                Option x$2 = qual$1.getCsvIterator$default$2();
                Iterator iterator = qual$1.getCsvIterator(x$1, x$2);
                ((QueryContext)Mockito.verify((Object)this.$outer.queryContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                iterator.next();
                ((QueryContext)Mockito.verify((Object)this.$outer.queryContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple iterators are still handled correctly only commit when the first iterator advances", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any())).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})}))).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})})));
                LoadCsvPeriodicCommitObserver qual$2 = this.$outer.resourceUnderTest();
                URL x$3 = this.$outer.url();
                Option x$4 = qual$2.getCsvIterator$default$2();
                Iterator iterator1 = qual$2.getCsvIterator(x$3, x$4);
                LoadCsvPeriodicCommitObserver qual$3 = this.$outer.resourceUnderTest();
                URL x$5 = this.$outer.url();
                Option x$6 = qual$3.getCsvIterator$default$2();
                Iterator iterator2 = qual$3.getCsvIterator(x$5, x$6);
                iterator2.next();
                ((QueryContext)Mockito.verify((Object)this.$outer.queryContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                iterator1.next();
                ((QueryContext)Mockito.verify((Object)this.$outer.queryContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("if a custom iterator is specified should be passed to the wrapped resource", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resourceUnderTest().getCsvIterator(this.$outer.url(), (Option)new Some((Object)";"));
                ((ExternalResource)Mockito.verify((Object)this.$outer.resource(), (VerificationMode)Mockito.times((int)1))).getCsvIterator(this.$outer.url(), (Option)new Some((Object)";"));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

