/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.executionplan;

import java.util.concurrent.TimeUnit;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.LabelId;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.PlanFingerprint;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.PlanFingerprintReference;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.Cardinality$;
import org.neo4j.cypher.internal.compiler.v2_2.spi.GraphStatistics;
import org.neo4j.cypher.internal.compiler.v2_2.spi.GraphStatisticsSnapshot;
import org.neo4j.cypher.internal.compiler.v2_2.spi.NodesWithLabelCardinality;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001#\ta\u0002\u000b\\1o\r&tw-\u001a:qe&tGOU3gKJ,gnY3UKN$(BA\u0002\u0005\u00035)\u00070Z2vi&|g\u000e\u001d7b]*\u0011QAB\u0001\u0005mJz&G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011aB2p[6|gn]\u0005\u0003/Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!)a\u0004\u0001C\u0002?\u0005aA.\u001b4u)>|\u0005\u000f^5p]V\u0011\u0001%\u000b\u000b\u0003CI\u00022AI\u0013(\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB(qi&|g\u000e\u0005\u0002)S1\u0001A!\u0002\u0016\u001e\u0005\u0004Y#!\u0001+\u0012\u00051z\u0003C\u0001\u0012.\u0013\tq3EA\u0004O_RD\u0017N\\4\u0011\u0005\t\u0002\u0014BA\u0019$\u0005\r\te.\u001f\u0005\u0006gu\u0001\raJ\u0001\u0005SR,W\u000eC\u00036\u0001\u0011\u0005a'\u0001\b%[&tWo\u001d\u0013he\u0016\fG/\u001a:\u0016\u0005]bDC\u0001\u001d>!\r\u0011\u0013hO\u0005\u0003u\r\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005!bD!\u0002\u00165\u0005\u0004Y\u0003\"B\u001a5\u0001\u0004Y\u0004\"B \u0001\t\u0003\u0001\u0015!\u00027bE\u0016dGCA!F!\t\u00115)D\u0001\u0005\u0013\t!EAA\u0004MC\n,G.\u00133\t\u000b\u0019s\u0004\u0019A$\u0002\u0003%\u0004\"A\t%\n\u0005%\u001b#aA%oi\u0002")
public class PlanFingerprintReferenceTest
extends CypherFunSuite {
    public <T> Option<T> liftToOption(T item) {
        return Option$.MODULE$.apply(item);
    }

    public <T> Function0<T> $minus$greater(T item) {
        return new Serializable(this, item){
            public static final long serialVersionUID = 0L;
            private final Object item$1;

            public final T apply() {
                return (T)this.item$1;
            }
            {
                this.item$1 = item$1;
            }
        };
    }

    public LabelId label(int i) {
        return new LabelId(i);
    }

    public PlanFingerprintReferenceTest() {
        this.test("should be stale if all properties are out of date", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.0;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.currentTimeMillis(), 17L, snapshot);
                clock.forward(2L, TimeUnit.SECONDS);
                boolean stale = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint)).isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)42L)), stats);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)stale)).should(this.$outer.be().apply(true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not be stale if stats are not diverged over the threshold", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.5;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.currentTimeMillis(), 17L, snapshot);
                clock.forward(2L, TimeUnit.SECONDS);
                boolean stale = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint)).isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)42L)), stats);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)stale)).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not be stale if txId didn't change", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.0;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.currentTimeMillis(), 17L, snapshot);
                clock.forward(2L, TimeUnit.SECONDS);
                boolean stale = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint)).isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)17L)), stats);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)stale)).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not be stale if life time has not expired", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.0;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.currentTimeMillis(), 17L, snapshot);
                clock.forward(500L, TimeUnit.MILLISECONDS);
                boolean stale = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint)).isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)42L)), stats);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)stale)).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should update the timestamp if the life time is expired but transaction has not changed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.0;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.currentTimeMillis(), 17L, snapshot);
                PlanFingerprintReference reference = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint));
                clock.forward(2L, TimeUnit.SECONDS);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)reference.isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)17L)), stats))).should(this.$outer.be().apply(false));
                clock.forward(500L, TimeUnit.MILLISECONDS);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)reference.isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)23L)), stats))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should update the timestamp and the txId if the life time is expired the txId is old but stats has not changed over the threshold", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlanFingerprintReferenceTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                GraphStatisticsSnapshot snapshot = new GraphStatisticsSnapshot((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new NodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))), (Object)BoxesRunTime.boxToDouble((double)5.0))})));
                long ttl = 1000L;
                double threshold = 0.1;
                FakeClock clock = new FakeClock();
                GraphStatistics stats = (GraphStatistics)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphStatistics.class));
                Mockito.when((Object)stats.nodesWithLabelCardinality(this.$outer.liftToOption(this.$outer.label(21)))).thenReturn((Object)Cardinality$.MODULE$.lift(5.0));
                PlanFingerprint fingerprint = new PlanFingerprint(clock.currentTimeMillis(), 17L, snapshot);
                PlanFingerprintReference reference = new PlanFingerprintReference((Clock)clock, ttl, threshold, this.$outer.liftToOption(fingerprint));
                clock.forward(2L, TimeUnit.SECONDS);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)reference.isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)23L)), stats))).should(this.$outer.be().apply(false));
                clock.forward(2L, TimeUnit.SECONDS);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)reference.isStale(this.$outer.$minus$greater(BoxesRunTime.boxToLong((long)23L)), stats))).should(this.$outer.be().apply(false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

