/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.executionplan;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.Monitors;
import org.neo4j.cypher.internal.compiler.v2_2.PreparedQuery;
import org.neo4j.cypher.internal.compiler.v2_2.Scope;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.LegacyPipeBuilder;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.LegacyPipeBuilder$;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.RulePipeBuilderTest$;
import org.neo4j.cypher.internal.compiler.v2_2.parser.CypherParser;
import org.neo4j.cypher.internal.compiler.v2_2.parser.ParserMonitor;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.DistinctPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.EagerPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.NodeStartPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.TraversalMatchPipe;
import org.neo4j.cypher.internal.compiler.v2_2.planner.SemanticTable;
import org.neo4j.cypher.internal.compiler.v2_2.spi.PlanContext;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001#\t\u0019\"+\u001e7f!&\u0004XMQ;jY\u0012,'\u000fV3ti*\u00111\u0001B\u0001\u000eKb,7-\u001e;j_:\u0004H.\u00198\u000b\u0005\u00151\u0011\u0001\u0002<3?JR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u000591m\\7n_:\u001c\u0018BA\f\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0001?\u0005Y\u0001\u000f\\1o\u0007>tG/\u001a=u+\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u0005\u0003\r\u0019\b/[\u0005\u0003K\t\u00121\u0002\u00157b]\u000e{g\u000e^3yi\"1q\u0005\u0001Q\u0001\n\u0001\nA\u0002\u001d7b]\u000e{g\u000e^3yi\u0002Bq!\u000b\u0001C\u0002\u0013\u0005!&\u0001\u0004qCJ\u001cXM]\u000b\u0002WA\u0011AFL\u0007\u0002[)\u0011\u0011\u0006B\u0005\u0003_5\u0012AbQ=qQ\u0016\u0014\b+\u0019:tKJDa!\r\u0001!\u0002\u0013Y\u0013a\u00029beN,'\u000f\t\u0005\bg\u0001\u0011\r\u0011\"\u00015\u0003-\u0001H.\u00198Ck&dG-\u001a:\u0016\u0003U\u0002\"\u0001\b\u001c\n\u0005]\u0012!!\u0005'fO\u0006\u001c\u0017\u0010U5qK\n+\u0018\u000e\u001c3fe\"1\u0011\b\u0001Q\u0001\nU\nA\u0002\u001d7b]\n+\u0018\u000e\u001c3fe\u0002BQa\u000f\u0001\u0005\u0002q\n\u0001#Y:tKJ$\b+\u001b9f\u000bbL7\u000f^:\u0016\u0005u:Fc\u0001 E\u0019B\u0011qHQ\u0007\u0002\u0001*\t\u0011)A\u0003tG\u0006d\u0017-\u0003\u0002D\u0001\n!QK\\5u\u0011\u0015)%\b1\u0001G\u0003\u0011\u0001\u0018\u000e]3\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%#\u0011!\u00029ja\u0016\u001c\u0018BA&I\u0005\u0011\u0001\u0016\u000e]3\t\u000b5S\u0004\u0019\u0001(\u0002\u000b-d\u0017m]:\u0011\u0007=\u0013VK\u0004\u0002@!&\u0011\u0011\u000bQ\u0001\u0007!J,G-\u001a4\n\u0005M#&!B\"mCN\u001c(BA)A!\t1v\u000b\u0004\u0001\u0005\u000baS$\u0019A-\u0003\u0003Q\u000b\"AW/\u0011\u0005}Z\u0016B\u0001/A\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\u00100\n\u0005}\u0003%aA!os\")\u0011\r\u0001C\u0001E\u00061\u0012m]:feR\u0004\u0016\u000e]3E_\u0016\u001chj\u001c;Fq&\u001cH/\u0006\u0002dQR\u0019a\bZ3\t\u000b\u0015\u0003\u0007\u0019\u0001$\t\u000b5\u0003\u0007\u0019\u00014\u0011\u0007=\u0013v\r\u0005\u0002WQ\u0012)\u0001\f\u0019b\u00013\")!\u000e\u0001C\u0005W\u0006\u0011\"-^5mI\u0016CXmY;uS>t\u0007+\u001b9f)\t1E\u000eC\u0003nS\u0002\u0007a.A\u0001r!\tyu.\u0003\u0002q)\n11\u000b\u001e:j]\u001e\u0004")
public class RulePipeBuilderTest
extends CypherFunSuite {
    private final PlanContext planContext = (PlanContext)this.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
    private final CypherParser parser = new CypherParser((ParserMonitor)this.mock(ManifestFactory$.MODULE$.classType(ParserMonitor.class, ManifestFactory$.MODULE$.classType(Statement.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0]))));
    private final LegacyPipeBuilder planBuilder = new LegacyPipeBuilder((Monitors)this.mock(ManifestFactory$.MODULE$.classType(Monitors.class)), (Function1)new $anonfun$9(this), LegacyPipeBuilder$.MODULE$.$lessinit$greater$default$3());

    public PlanContext planContext() {
        return this.planContext;
    }

    public CypherParser parser() {
        return this.parser;
    }

    public LegacyPipeBuilder planBuilder() {
        return this.planBuilder;
    }

    public <T> void assertPipeExists(Pipe pipe, Class<T> klass) {
        Pipe $org_scalatest_assert_macro_left = pipe;
        Class<T> $org_scalatest_assert_macro_right = klass;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.existsMacroBool((Object)$org_scalatest_assert_macro_left, $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.exists((Function1)new Serializable(this, klass){
            public static final long serialVersionUID = 0L;
            private final Class klass$2;

            public final boolean apply(Pipe x$3) {
                Class<?> clazz = x$3.getClass();
                Class clazz2 = this.klass$2;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
            {
                this.klass$2 = klass$2;
            }
        }));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected to contain a pipe of type ", ". Got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{klass, pipe})));
    }

    public <T> void assertPipeDoesNotExist(Pipe pipe, Class<T> klass) {
        Pipe $org_scalatest_assert_macro_left = pipe;
        Class<T> $org_scalatest_assert_macro_right = klass;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.existsMacroBool((Object)$org_scalatest_assert_macro_left, $org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.exists((Function1)new Serializable(this, klass){
            public static final long serialVersionUID = 0L;
            private final Class klass$1;

            public final boolean apply(Pipe x$4) {
                Class<?> clazz = x$4.getClass();
                Class clazz2 = this.klass$1;
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }
            {
                this.klass$1 = klass$1;
            }
        })));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expected not to contain a pipe of type ", ". Got: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{klass, pipe})));
    }

    public Pipe org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe(String q) {
        Statement statement = this.parser().parse(q, this.parser().parse$default$2());
        PreparedQuery parsedQ = new PreparedQuery(statement, q, Predef$.MODULE$.Map().empty(), (SemanticTable)this.mock(ManifestFactory$.MODULE$.classType(SemanticTable.class)), Predef$.MODULE$.Set().empty(), (Scope)this.mock(ManifestFactory$.MODULE$.classType(Scope.class)));
        return this.planBuilder().producePlan(parsedQ, this.planContext()).pipe();
    }

    public RulePipeBuilderTest() {
        this.test("should_use_distinct_pipe_for_distinct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RulePipeBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe("MATCH n RETURN DISTINCT n");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pipe x$1) {
                        return x$1 instanceof DistinctPipe;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_traversal_matcher_when_possible", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RulePipeBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Foo")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe("match (n:Foo)-->(x) return x");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Pipe x$2) {
                        return x$2 instanceof TraversalMatchPipe;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_schema_index_with_load_csv", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RulePipeBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Person")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getOptPropertyKeyId("name")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getIndexRule("Person", "name")).thenReturn((Object)new Some((Object)new IndexDescriptor(1, 1)));
                Mockito.when((Object)this.$outer.planContext().getUniquenessConstraint("Person", "name")).thenReturn((Object)None$.MODULE$);
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe("LOAD CSV FROM 'file:///tmp/foo.csv' AS line MATCH (p:Person { name: line[0] }) RETURN p;");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Pipe pipe) {
                        if (!(pipe instanceof NodeStartPipe)) return false;
                        String string = ((NodeStartPipe)pipe).createSource().producerType();
                        String string2 = "SchemaIndex";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_use_schema_index_with_load_csv_2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RulePipeBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.planContext().getOptLabelId("Person")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getOptPropertyKeyId("name")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)this.$outer.planContext().getIndexRule("Person", "name")).thenReturn((Object)new Some((Object)new IndexDescriptor(1, 1)));
                Mockito.when((Object)this.$outer.planContext().getUniquenessConstraint("Person", "name")).thenReturn((Object)None$.MODULE$);
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe("LOAD CSV FROM 'file:///tmp/foo.csv' AS line MATCH (p:Person { name: \"Foo Bar Baz\" }) RETURN p;");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)pipe.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Pipe pipe) {
                        if (!(pipe instanceof NodeStartPipe)) return false;
                        String string = ((NodeStartPipe)pipe).createSource().producerType();
                        String string2 = "SchemaIndex";
                        if (string != null) {
                            if (!string.equals(string2)) return false;
                            return true;
                        }
                        if (string2 == null) return true;
                        return false;
                    }
                }))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not introduce an eager pipe between two node reads and a relationships create", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RulePipeBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe("MATCH (a), (b) CREATE (a)-[:TYPE]->(b)");
                this.$outer.assertPipeDoesNotExist(pipe, EagerPipe.class);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not introduce an eager pipe between two node reads and a relationships create when theres is sorting between the two", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RulePipeBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe("MATCH (a), (b) WITH a, b ORDER BY id(a) CREATE (a)-[:TYPE]->(b)");
                this.$outer.assertPipeDoesNotExist(pipe, EagerPipe.class);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should introduce an eager pipe between a node read and a relationship + node create", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RulePipeBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe("MATCH (a) CREATE (a)-[:TYPE]->()");
                this.$outer.assertPipeExists(pipe, EagerPipe.class);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should introduce an eager pipe between a relationship read and a relationship create", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RulePipeBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Pipe pipe = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$RulePipeBuilderTest$$buildExecutionPipe("MATCH (a)-[:TYPE]->(b) CREATE (a)-[:TYPE]->(b)");
                this.$outer.assertPipeExists(pipe, EagerPipe.class);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

