/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.executionplan.builders;

import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_2.IndexHintException;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AnyIndex$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.EntityProducerFactory;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NodeByLabel;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SchemaIndex;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SchemaIndexKind;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SingleQueryExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.builders.EntityProducerFactoryTest$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.EntityProducer;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.ExternalResource;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.PipeDecorator;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_2.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v2_2.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v2_2.spi.TokenContext;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001A3A!\u0001\u0002\u0001'\tIRI\u001c;jif\u0004&o\u001c3vG\u0016\u0014h)Y2u_JLH+Z:u\u0015\t\u0019A!\u0001\u0005ck&dG-\u001a:t\u0015\t)a!A\u0007fq\u0016\u001cW\u000f^5p]Bd\u0017M\u001c\u0006\u0003\u000f!\tAA\u001e\u001a`e)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"BA\f\u000b\u0003\u001d\u0019w.\\7p]NL!!\u0007\f\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")1\u0004\u0001C\u00019\u00051A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011A\u0001\u0005\bA\u0001\u0001\r\u0011\"\u0001\"\u0003-\u0001H.\u00198D_:$X\r\u001f;\u0016\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R!!\n\u0004\u0002\u0007M\u0004\u0018.\u0003\u0002(I\tY\u0001\u000b\\1o\u0007>tG/\u001a=u\u0011\u001dI\u0003\u00011A\u0005\u0002)\nq\u0002\u001d7b]\u000e{g\u000e^3yi~#S-\u001d\u000b\u0003WE\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012A!\u00168ji\"9!\u0007KA\u0001\u0002\u0004\u0011\u0013a\u0001=%c!1A\u0007\u0001Q!\n\t\nA\u0002\u001d7b]\u000e{g\u000e^3yi\u0002BqA\u000e\u0001A\u0002\u0013\u0005q'A\u0004gC\u000e$xN]=\u0016\u0003a\u0002\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0004\u0002\u0011\r|W.\\1oINL!!\u0010\u001e\u0003+\u0015sG/\u001b;z!J|G-^2fe\u001a\u000b7\r^8ss\"9q\b\u0001a\u0001\n\u0003\u0001\u0015a\u00034bGR|'/_0%KF$\"aK!\t\u000fIr\u0014\u0011!a\u0001q!11\t\u0001Q!\na\n\u0001BZ1di>\u0014\u0018\u0010\t\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0003\u001d\u0019wN\u001c;fqR,\u0012a\u0012\t\u0003\u0011&k\u0011AB\u0005\u0003\u0015\u001a\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\r1\u0003\u0001\u0015!\u0003H\u0003!\u0019wN\u001c;fqR\u0004\u0003\"\u0002(\u0001\t\u0003z\u0015A\u00032fM>\u0014X-R1dQR\t1\u0006")
public class EntityProducerFactoryTest
extends CypherFunSuite {
    private PlanContext planContext = null;
    private EntityProducerFactory factory = null;
    private final ExecutionContext context = ExecutionContext$.MODULE$.empty();

    public PlanContext planContext() {
        return this.planContext;
    }

    public void planContext_$eq(PlanContext x$1) {
        this.planContext = x$1;
    }

    public EntityProducerFactory factory() {
        return this.factory;
    }

    public void factory_$eq(EntityProducerFactory x$1) {
        this.factory = x$1;
    }

    public ExecutionContext context() {
        return this.context;
    }

    @Override
    public void beforeEach() {
        super.beforeEach();
        this.planContext_$eq((PlanContext)this.mock(ManifestFactory$.MODULE$.classType(PlanContext.class)));
        this.factory_$eq(new EntityProducerFactory());
    }

    public EntityProducerFactoryTest() {
        this.test("throws_error_when_index_is_missing", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityProducerFactoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String label = "label";
                String prop = "prop";
                Mockito.when((Object)this.$outer.planContext().getIndexRule(label, prop)).thenReturn((Object)None$.MODULE$);
                this.$outer.intercept((Function0<Object>)new Serializable(this, label, prop){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;
                    private final String label$1;
                    private final String prop$1;

                    public final EntityProducer<Node> apply() {
                        return (EntityProducer)this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$builders$EntityProducerFactoryTest$$anonfun$$$outer().factory().nodeByIndexHint().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.org$neo4j$cypher$internal$compiler$v2_2$executionplan$builders$EntityProducerFactoryTest$$anonfun$$$outer().planContext()), (Object)new SchemaIndex("id", this.label$1, this.prop$1, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)None$.MODULE$)));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.label$1 = label$1;
                        this.prop$1 = prop$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IndexHintException.class));
            }

            public /* synthetic */ EntityProducerFactoryTest org$neo4j$cypher$internal$compiler$v2_2$executionplan$builders$EntityProducerFactoryTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("calls_the_right_methods", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityProducerFactoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String label = "label";
                String prop = "prop";
                IndexDescriptor index = new IndexDescriptor(123, 456);
                int value = 42;
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)this.$outer.planContext().getIndexRule(label, prop)).thenReturn((Object)new Some((Object)index));
                Iterator indexResult = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}));
                Mockito.when((Object)queryContext.exactIndexSearch(index, (Object)BoxesRunTime.boxToInteger((int)value))).thenReturn((Object)indexResult);
                QueryContext x$1 = queryContext;
                GraphDatabaseService x$2 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$3 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$4 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                PipeDecorator x$5 = QueryStateHelper$.MODULE$.emptyWith$default$5();
                Option<ExecutionContext> x$6 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState state = QueryStateHelper$.MODULE$.emptyWith(x$2, x$1, x$3, x$4, x$5, x$6);
                EntityProducer func = (EntityProducer)this.$outer.factory().nodeByIndexHint().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.planContext()), (Object)new SchemaIndex("id", label, prop, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)new Some((Object)new SingleQueryExpression((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)value)))))));
                this.$outer.convertToAnyShouldWrapper(func.apply((Object)this.$outer.context(), (Object)state)).should(this.$outer.equal(indexResult), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("retries_every_time_if_the_label_did_not_exist_at_plan_building", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityProducerFactoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String label = "label";
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)this.$outer.planContext().getOptLabelId(label)).thenReturn((Object)None$.MODULE$);
                Mockito.when((Object)queryContext.getOptLabelId(label)).thenReturn((Object)None$.MODULE$);
                QueryContext x$7 = queryContext;
                GraphDatabaseService x$8 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$9 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$10 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                PipeDecorator x$11 = QueryStateHelper$.MODULE$.emptyWith$default$5();
                Option<ExecutionContext> x$12 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState state = QueryStateHelper$.MODULE$.emptyWith(x$8, x$7, x$9, x$10, x$11, x$12);
                EntityProducer func = (EntityProducer)this.$outer.factory().nodeByLabel().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.planContext()), (Object)new NodeByLabel("id", label)));
                this.$outer.convertToAnyShouldWrapper(func.apply((Object)this.$outer.context(), (Object)state)).should(this.$outer.equal(package$.MODULE$.Iterator().empty()), (Object)Equality$.MODULE$.default());
                ((TokenContext)Mockito.verify((Object)queryContext, (VerificationMode)Mockito.times((int)1))).getOptLabelId(label);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_translate_values_to_neo4j", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EntityProducerFactoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryContext queryContext;
                String labelName = "Label";
                String propertyKey = "prop";
                IndexDescriptor index = new IndexDescriptor(123, 456);
                Mockito.when((Object)this.$outer.planContext().getIndexRule(labelName, propertyKey)).thenReturn((Object)new Some((Object)index));
                EntityProducer producer = (EntityProducer)this.$outer.factory().nodeByIndexHint().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.$outer.planContext()), (Object)new SchemaIndex("x", labelName, propertyKey, (SchemaIndexKind)AnyIndex$.MODULE$, (Option)new Some((Object)new SingleQueryExpression((Object)new Literal((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))))))));
                QueryContext x$13 = queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                GraphDatabaseService x$14 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$15 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$16 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                PipeDecorator x$17 = QueryStateHelper$.MODULE$.emptyWith$default$5();
                Option<ExecutionContext> x$18 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState state = QueryStateHelper$.MODULE$.emptyWith(x$14, x$13, x$15, x$16, x$17, x$18);
                Mockito.when((Object)queryContext.exactIndexSearch(index, (Object)new int[]{1, 2, 3})).thenReturn((Object)package$.MODULE$.Iterator().empty());
                producer.apply((Object)this.$outer.context(), (Object)state);
                ((QueryContext)Mockito.verify((Object)queryContext, (VerificationMode)Mockito.times((int)1))).exactIndexSearch(index, (Object)new int[]{1, 2, 3});
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

