/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.executionplan.builders;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AnyInCollection;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.commands.HasLabel;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Predicate;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Collection;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.UnresolvedLabel$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.UnresolvedProperty$;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.builders.NodeFetchStrategy$;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.builders.RatedStartItem;
import org.neo4j.cypher.internal.compiler.v2_2.spi.PlanContext;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.SymbolTable;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.SymbolTable$;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.package$;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A2A!\u0001\u0002\u0001'\t)bj\u001c3f\r\u0016$8\r[*ue\u0006$XmZ=UKN$(BA\u0002\u0005\u0003!\u0011W/\u001b7eKJ\u001c(BA\u0003\u0007\u00035)\u00070Z2vi&|g\u000e\u001d7b]*\u0011q\u0001C\u0001\u0005mJz&G\u0003\u0002\n\u0015\u0005A1m\\7qS2,'O\u0003\u0002\f\u0019\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u000e\u001d\u000511-\u001f9iKJT!a\u0004\t\u0002\u000b9,w\u000e\u000e6\u000b\u0003E\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000b\u0011\u0005UAR\"\u0001\f\u000b\u0005]Q\u0011aB2p[6|gn]\u0005\u00033Y\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0013\u0001\u00049s_B,'\u000f^=OC6,W#\u0001\u0012\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013\u0001\u00027b]\u001eT\u0011aJ\u0001\u0005U\u00064\u0018-\u0003\u0002*I\t11\u000b\u001e:j]\u001eDaa\u000b\u0001!\u0002\u0013\u0011\u0013!\u00049s_B,'\u000f^=OC6,\u0007\u0005C\u0004.\u0001\t\u0007I\u0011A\u0011\u0002\u00131\f'-\u001a7OC6,\u0007BB\u0018\u0001A\u0003%!%\u0001\u0006mC\n,GNT1nK\u0002\u0002")
public class NodeFetchStrategyTest
extends CypherFunSuite {
    private final String propertyName;
    private final String labelName;

    public String propertyName() {
        return this.propertyName;
    }

    public String labelName() {
        return this.labelName;
    }

    public NodeFetchStrategyTest() {
        this.propertyName = "prop";
        this.labelName = "Label";
        this.test("should_not_select_schema_index_when_expression_is_missing_dependencies", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeFetchStrategyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable noSymbols = new SymbolTable(SymbolTable$.MODULE$.$lessinit$greater$default$1());
                Equals equalityPredicate = new Equals((Expression)new Property((Expression)new Identifier("a"), UnresolvedProperty$.MODULE$.apply(this.$outer.propertyName())), (Expression)new Identifier("b"));
                HasLabel labelPredicate = new HasLabel((Expression)new Identifier("a"), UnresolvedLabel$.MODULE$.apply(this.$outer.labelName()));
                PlanContext planCtx = (PlanContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
                IndexDescriptor indexDescriptor = new IndexDescriptor(0, 0);
                Mockito.when((Object)planCtx.getIndexRule(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)new Some((Object)indexDescriptor));
                RatedStartItem foundStartItem = NodeFetchStrategy$.MODULE$.findStartStrategy("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{equalityPredicate, labelPredicate})), planCtx, noSymbols);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)foundStartItem.rating())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)NodeFetchStrategy$.MODULE$.LabelScan())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_select_schema_index_when_expression_valid", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeFetchStrategyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable noSymbols = new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())})));
                Equals equalityPredicate = new Equals((Expression)new Property((Expression)new Identifier("a"), UnresolvedProperty$.MODULE$.apply(this.$outer.propertyName())), (Expression)new Identifier("b"));
                HasLabel labelPredicate = new HasLabel((Expression)new Identifier("a"), UnresolvedLabel$.MODULE$.apply(this.$outer.labelName()));
                PlanContext planCtx = (PlanContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
                IndexDescriptor indexDescriptor = new IndexDescriptor(0, 0);
                Mockito.when((Object)planCtx.getIndexRule(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)new Some((Object)indexDescriptor));
                Mockito.when((Object)planCtx.getUniquenessConstraint(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)None$.MODULE$);
                RatedStartItem foundStartItem = NodeFetchStrategy$.MODULE$.findStartStrategy("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{equalityPredicate, labelPredicate})), planCtx, noSymbols);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)foundStartItem.rating())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)NodeFetchStrategy$.MODULE$.IndexEquality())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_select_schema_index_when_expression_property_check_with_in", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeFetchStrategyTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable noSymbols = new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())})));
                AnyInCollection inPredicate = new AnyInCollection((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Identifier("b")})), "_inner_", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), UnresolvedProperty$.MODULE$.apply(this.$outer.propertyName())), (Expression)new Identifier("_inner_")));
                HasLabel labelPredicate = new HasLabel((Expression)new Identifier("a"), UnresolvedLabel$.MODULE$.apply(this.$outer.labelName()));
                PlanContext planCtx = (PlanContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(PlanContext.class));
                IndexDescriptor indexDescriptor = new IndexDescriptor(0, 0);
                Mockito.when((Object)planCtx.getIndexRule(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)new Some((Object)indexDescriptor));
                Mockito.when((Object)planCtx.getUniquenessConstraint(this.$outer.labelName(), this.$outer.propertyName())).thenReturn((Object)None$.MODULE$);
                RatedStartItem foundStartItem = NodeFetchStrategy$.MODULE$.findStartStrategy("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Predicate[]{inPredicate, labelPredicate})), planCtx, noSymbols);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)foundStartItem.rating())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)NodeFetchStrategy$.MODULE$.IndexEquality())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

