/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.executionplan.builders;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Pattern;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Predicate;
import org.neo4j.cypher.internal.compiler.v2_2.commands.RelatedTo;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SingleNode;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SingleNode$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.True;
import org.neo4j.cypher.internal.compiler.v2_2.commands.VarLengthRelatedTo;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.KeyToken;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.TokenType;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.builders.LongestTrail;
import org.neo4j.cypher.internal.compiler.v2_2.executionplan.builders.TrailBuilder$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.EndPoint;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.NodeIdentifier;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.RelationshipIdentifier;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.SingleStepTrail;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.Trail;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.VariableLengthStepTrail;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001'\t\u0001BK]1jY\n+\u0018\u000e\u001c3feR+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001BY;jY\u0012,'o\u001d\u0006\u0003\u000b\u0019\tQ\"\u001a=fGV$\u0018n\u001c8qY\u0006t'BA\u0004\t\u0003\u00111(g\u0018\u001a\u000b\u0005%Q\u0011\u0001C2p[BLG.\u001a:\u000b\u0005-a\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u00055q\u0011AB2za\",'O\u0003\u0002\u0010!\u0005)a.Z85U*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011qCC\u0001\bG>lWn\u001c8t\u0013\tIbC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0005\u0004%\t!I\u0001\u0002\u0003V\t!\u0005\u0005\u0002$M5\tAE\u0003\u0002&\u001d\u00059qM]1qQ\u0012\u0014\u0017BA\u0014%\u0005]!\u0015P\\1nS\u000e\u0014V\r\\1uS>t7\u000f[5q)f\u0004X\r\u0003\u0004*\u0001\u0001\u0006IAI\u0001\u0003\u0003\u0002Bqa\u000b\u0001C\u0002\u0013\u0005\u0011%A\u0001C\u0011\u0019i\u0003\u0001)A\u0005E\u0005\u0011!\t\t\u0005\b_\u0001\u0011\r\u0011\"\u0001\"\u0003\u0005\u0019\u0005BB\u0019\u0001A\u0003%!%\u0001\u0002DA!91\u0007\u0001b\u0001\n\u0003\t\u0013!\u0001#\t\rU\u0002\u0001\u0015!\u0003#\u0003\t!\u0005\u0005C\u00048\u0001\t\u0007I\u0011\u0001\u001d\u0002\t\u0005#xNQ\u000b\u0002sA\u0011!(P\u0007\u0002w)\u0011AHB\u0001\tG>lW.\u00198eg&\u0011ah\u000f\u0002\n%\u0016d\u0017\r^3e)>Da\u0001\u0011\u0001!\u0002\u0013I\u0014!B!u_\n\u0003\u0003b\u0002\"\u0001\u0005\u0004%\t\u0001O\u0001\u0005\u0005R|7\t\u0003\u0004E\u0001\u0001\u0006I!O\u0001\u0006\u0005R|7\t\t\u0005\b\r\u0002\u0011\r\u0011\"\u00019\u0003\u0011\u0019Eo\u001c#\t\r!\u0003\u0001\u0015!\u0003:\u0003\u0015\u0019Eo\u001c#!\u0011\u001dQ\u0005A1A\u0005\u0002a\nQA\u0011;p\u0005JBa\u0001\u0014\u0001!\u0002\u0013I\u0014A\u0002\"u_\n\u0013\u0004\u0005C\u0004O\u0001\t\u0007I\u0011A(\u0002\t\t#x.R\u000b\u0002!B\u0011!(U\u0005\u0003%n\u0012!CV1s\u0019\u0016tw\r\u001e5SK2\fG/\u001a3U_\"1A\u000b\u0001Q\u0001\nA\u000bQA\u0011;p\u000b\u0002BqA\u0016\u0001C\u0002\u0013\u0005q*\u0001\u0003Fi>4\u0005B\u0002-\u0001A\u0003%\u0001+A\u0003Fi>4\u0005\u0005C\u0004[\u0001\t\u0007I\u0011\u0001\u001d\u0002\t\u0015#xn\u0012\u0005\u00079\u0002\u0001\u000b\u0011B\u001d\u0002\u000b\u0015#xn\u0012\u0011")
public class TrailBuilderTest
extends CypherFunSuite {
    private final DynamicRelationshipType A = DynamicRelationshipType.withName((String)"A");
    private final DynamicRelationshipType B = DynamicRelationshipType.withName((String)"B");
    private final DynamicRelationshipType C = DynamicRelationshipType.withName((String)"C");
    private final DynamicRelationshipType D = DynamicRelationshipType.withName((String)"D");
    private final RelatedTo AtoB = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
    private final RelatedTo BtoC = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
    private final RelatedTo CtoD = new RelatedTo(new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("d", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr3", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
    private final RelatedTo BtoB2 = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b2", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr4", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"D"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
    private final VarLengthRelatedTo BtoE = new VarLengthRelatedTo("p", new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("e", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), Direction.OUTGOING, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
    private final VarLengthRelatedTo EtoF = new VarLengthRelatedTo("p2", new SingleNode("e", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("f", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), Direction.BOTH, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty());
    private final RelatedTo EtoG = new RelatedTo(new SingleNode("e", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("g", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr5", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"E"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());

    public DynamicRelationshipType A() {
        return this.A;
    }

    public DynamicRelationshipType B() {
        return this.B;
    }

    public DynamicRelationshipType C() {
        return this.C;
    }

    public DynamicRelationshipType D() {
        return this.D;
    }

    public RelatedTo AtoB() {
        return this.AtoB;
    }

    public RelatedTo BtoC() {
        return this.BtoC;
    }

    public RelatedTo CtoD() {
        return this.CtoD;
    }

    public RelatedTo BtoB2() {
        return this.BtoB2;
    }

    public VarLengthRelatedTo BtoE() {
        return this.BtoE;
    }

    public VarLengthRelatedTo EtoF() {
        return this.EtoF;
    }

    public RelatedTo EtoG() {
        return this.EtoG;
    }

    public TrailBuilderTest() {
        this.test("find_longest_path_for_single_pattern", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"b"), (Trail)new SingleStepTrail((Trail)new EndPoint("b"), Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))));
                this.$outer.convertToAnyShouldWrapper(TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), TrailBuilder$.MODULE$.findLongestTrail$default$3())).should(this.$outer.equal(expectedTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single_path_is_reversed_to_be_able_to_start_from_startpoint", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SingleStepTrail trail = new SingleStepTrail((Trail)new EndPoint("a"), Direction.INCOMING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expectedTrail = new Some((Object)new LongestTrail("b", (Option)None$.MODULE$, (Trail)trail));
                this.$outer.convertToAnyShouldWrapper(TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), TrailBuilder$.MODULE$.findLongestTrail$default$3())).should(this.$outer.equal(expectedTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("find_longest_path_between_two_points", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint boundPoint = new EndPoint("c");
                SingleStepTrail second = new SingleStepTrail((Trail)boundPoint, Direction.OUTGOING, "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.BtoC(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail first = new SingleStepTrail((Trail)second, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"c"), (Trail)first));
                this.$outer.convertToAnyShouldWrapper(expectedTrail).should(this.$outer.equal(TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), this.$outer.BtoB2()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})), TrailBuilder$.MODULE$.findLongestTrail$default$3())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("find_longest_path_between_two_points_with_a_predicate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Equals r1Pred = new Equals((Expression)new Property((Expression)new Identifier("pr1"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)));
                Equals r2Pred = new Equals((Expression)new Property((Expression)new Identifier("pr2"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)"FOO"));
                Seq predicates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{r1Pred, r2Pred}));
                Equals rewrittenR1 = new Equals((Expression)new Property((Expression)new RelationshipIdentifier(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)));
                Equals rewrittenR2 = new Equals((Expression)new Property((Expression)new RelationshipIdentifier(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)"FOO"));
                EndPoint boundPoint = new EndPoint("c");
                SingleStepTrail second = new SingleStepTrail((Trail)boundPoint, Direction.OUTGOING, "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "b", (Predicate)rewrittenR2, (Predicate)new True(), (Pattern)this.$outer.BtoC(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{r2Pred})));
                SingleStepTrail first = new SingleStepTrail((Trail)second, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)rewrittenR1, (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{r1Pred})));
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"c"), (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), this.$outer.BtoB2()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})), predicates);
                this.$outer.convertToAnyShouldWrapper(expectedTrail).should(this.$outer.equal(foundTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("find_longest_path_between_two_points_with_a_node_predicate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Equals nodePred = new Equals((Expression)new Property((Expression)new Identifier("b"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)));
                Seq predicates = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{nodePred}));
                Equals rewrittenPredicate = new Equals((Expression)new Property((Expression)new NodeIdentifier(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)));
                EndPoint boundPoint = new EndPoint("c");
                SingleStepTrail second = new SingleStepTrail((Trail)boundPoint, Direction.OUTGOING, "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.BtoC(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail first = new SingleStepTrail((Trail)second, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)rewrittenPredicate, (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{nodePred})));
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"c"), (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), this.$outer.BtoB2()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})), predicates);
                this.$outer.convertToAnyShouldWrapper(expectedTrail).should(this.$outer.equal(foundTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_not_accept_trails_with_bound_points_in_the_middle", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LongestTrail longestTrail = (LongestTrail)TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).get();
                if (longestTrail != null) {
                    Trail trail;
                    Trail trail2;
                    Trail trail3 = trail2 = (trail = longestTrail.longestTrail());
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)trail3.size())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                    return;
                }
                throw new MatchError((Object)longestTrail);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("find_longest_path_with_single_start", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint boundPoint = new EndPoint("d");
                SingleStepTrail third = new SingleStepTrail((Trail)boundPoint, Direction.OUTGOING, "pr3", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), "c", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.CtoD(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail second = new SingleStepTrail((Trail)third, Direction.OUTGOING, "pr2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.BtoC(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail first = new SingleStepTrail((Trail)second, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expectedTrail = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), this.$outer.BtoB2(), this.$outer.CtoD()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expectedTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single_varlength_path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint boundPoint = new EndPoint("e");
                VariableLengthStepTrail first = new VariableLengthStepTrail((Trail)boundPoint, Direction.OUTGOING, Direction.OUTGOING, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                Some expectedTrail = new Some((Object)new LongestTrail("b", (Option)None$.MODULE$, (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VarLengthRelatedTo[]{this.$outer.BtoE()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expectedTrail), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single_rel_followed_by_varlength_with_single_bound_point", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail last = new VariableLengthStepTrail((Trail)endPoint, Direction.OUTGOING, Direction.OUTGOING, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail first = new SingleStepTrail((Trail)last, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)first));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("two_varlength_paths_with_both_ends_bound", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail trail = new VariableLengthStepTrail((Trail)endPoint, Direction.OUTGOING, Direction.OUTGOING, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                Some expected = new Some((Object)new LongestTrail("b", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VarLengthRelatedTo[]{this.$outer.BtoE(), this.$outer.EtoF()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "f"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("mono_directional_trails_can_end_in_varlength_paths", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail second = new VariableLengthStepTrail((Trail)endPoint, Direction.OUTGOING, Direction.OUTGOING, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail trail = new SingleStepTrail((Trail)second, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE(), this.$outer.BtoC()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("mono_directional_trails_can_only_have_single_varlength_paths", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail second = new VariableLengthStepTrail((Trail)endPoint, Direction.OUTGOING, Direction.OUTGOING, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail trail = new SingleStepTrail((Trail)second, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE(), this.$outer.EtoF()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("mono_directional_trails_can_only_have_varlength_paths_at_the_end", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail second = new VariableLengthStepTrail((Trail)endPoint, Direction.OUTGOING, Direction.OUTGOING, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail trail = new SingleStepTrail((Trail)second, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE(), this.$outer.EtoG()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("two_varlength_paths_with_one_end_bound", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                EndPoint endPoint = new EndPoint("e");
                VariableLengthStepTrail second = new VariableLengthStepTrail((Trail)endPoint, Direction.OUTGOING, Direction.OUTGOING, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), 1, (Option)None$.MODULE$, "p", (Option)None$.MODULE$, "b", (Pattern)this.$outer.BtoE());
                SingleStepTrail trail = new SingleStepTrail((Trail)second, Direction.OUTGOING, "pr1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)this.$outer.AtoB(), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)trail));
                Option foundTrail = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{this.$outer.AtoB(), this.$outer.BtoE(), this.$outer.BtoC()})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Nil$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(foundTrail).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_handle_loops", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo AtoX = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr5", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo XtoC = new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "pr6", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
                EndPoint endPoint = new EndPoint("c");
                SingleStepTrail last = new SingleStepTrail((Trail)endPoint, Direction.OUTGOING, "pr6", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), "x", (Predicate)new True(), (Predicate)new True(), (Pattern)XtoC, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail trail = new SingleStepTrail((Trail)last, Direction.OUTGOING, "pr5", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)AtoX, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Option result = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{this.$outer.AtoB(), this.$outer.BtoC(), AtoX, XtoC})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c"})), (Seq)Seq$.MODULE$.empty());
                Some expected = new Some((Object)new LongestTrail("a", (Option)new Some((Object)"c"), (Trail)trail));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_handle_long_paths_with_unnamed_nodes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RelatedTo s1 = new RelatedTo(new SingleNode("  UNNAMED13", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED15", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s2 = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED13", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED16", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s3 = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED14", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED17", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s4 = new RelatedTo(new SingleNode("  UNNAMED14", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED18", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
                EndPoint fifth = new EndPoint("c");
                SingleStepTrail fourth = new SingleStepTrail((Trail)fifth, Direction.OUTGOING, "  UNNAMED18", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "  UNNAMED14", (Predicate)new True(), (Predicate)new True(), (Pattern)s4, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail third = new SingleStepTrail((Trail)fourth, Direction.OUTGOING, "  UNNAMED17", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "b", (Predicate)new True(), (Predicate)new True(), (Pattern)s3, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail second = new SingleStepTrail((Trail)third, Direction.INCOMING, "  UNNAMED16", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "  UNNAMED13", (Predicate)new True(), (Predicate)new True(), (Pattern)s2, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail first = new SingleStepTrail((Trail)second, Direction.INCOMING, "  UNNAMED15", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "a", (Predicate)new True(), (Predicate)new True(), (Pattern)s1, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                Option result = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{s1, s2, s3, s4})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.empty());
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)first));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_handle_predicates_in_the_middle", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TrailBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Equals predForB = new Equals((Expression)new Property((Expression)new Identifier("b"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"b"));
                Equals predForC = new Equals((Expression)new Property((Expression)new Identifier("c"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"c"));
                Equals expectedForB = new Equals((Expression)new Property((Expression)new NodeIdentifier(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"b"));
                Equals expectedForC = new Equals((Expression)new Property((Expression)new NodeIdentifier(), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"c"));
                RelatedTo s1 = new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s2 = new RelatedTo(new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r2", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty());
                RelatedTo s3 = new RelatedTo(new SingleNode("c", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("d", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r3", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.INCOMING, (Map)Predef$.MODULE$.Map().empty());
                EndPoint fourth = new EndPoint("d");
                SingleStepTrail third = new SingleStepTrail((Trail)fourth, Direction.INCOMING, "r3", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "c", (Predicate)new True(), (Predicate)new True(), (Pattern)s3, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                SingleStepTrail second = new SingleStepTrail((Trail)third, Direction.OUTGOING, "r2", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "b", (Predicate)new True(), (Predicate)expectedForC, (Pattern)s2, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{predForC})));
                SingleStepTrail first = new SingleStepTrail((Trail)second, Direction.OUTGOING, "r1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), "a", (Predicate)new True(), (Predicate)expectedForB, (Pattern)s1, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{predForB})));
                Option result = TrailBuilder$.MODULE$.findLongestTrail((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{s1, s2, s3})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Equals[]{predForB, predForC})));
                Some expected = new Some((Object)new LongestTrail("a", (Option)None$.MODULE$, (Trail)first));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

