/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.parser;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.AbstractPattern;
import org.neo4j.cypher.internal.compiler.v2_2.ParsedEntity;
import org.neo4j.cypher.internal.compiler.v2_2.ParsedEntity$;
import org.neo4j.cypher.internal.compiler.v2_2.ParsedRelation;
import org.neo4j.cypher.internal.compiler.v2_2.ParsedRelation$;
import org.neo4j.cypher.internal.compiler.v2_2.ParsedVarLengthRelation;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxException;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Statement;
import org.neo4j.cypher.internal.compiler.v2_2.ast.convert.commands.StatementConverters;
import org.neo4j.cypher.internal.compiler.v2_2.ast.convert.commands.StatementConverters$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AbstractQuery;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AllIdentifiers;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AllInCollection;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AllNodes;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AllRelationships;
import org.neo4j.cypher.internal.compiler.v2_2.commands.And$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AnyInCollection;
import org.neo4j.cypher.internal.compiler.v2_2.commands.AnyIndex$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.CreateIndex;
import org.neo4j.cypher.internal.compiler.v2_2.commands.CreateIndex$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.CreateNodeStartItem;
import org.neo4j.cypher.internal.compiler.v2_2.commands.CreateRelationshipStartItem;
import org.neo4j.cypher.internal.compiler.v2_2.commands.CreateUniqueConstraint;
import org.neo4j.cypher.internal.compiler.v2_2.commands.CreateUniqueConstraint$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.CreateUniqueStartItem;
import org.neo4j.cypher.internal.compiler.v2_2.commands.DropIndex;
import org.neo4j.cypher.internal.compiler.v2_2.commands.DropIndex$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.commands.GreaterThan;
import org.neo4j.cypher.internal.compiler.v2_2.commands.GreaterThanOrEqual;
import org.neo4j.cypher.internal.compiler.v2_2.commands.HasLabel;
import org.neo4j.cypher.internal.compiler.v2_2.commands.IsNull;
import org.neo4j.cypher.internal.compiler.v2_2.commands.LabelAction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.LabelOp;
import org.neo4j.cypher.internal.compiler.v2_2.commands.LabelRemoveOp$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.LabelSetOp$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.LessThan;
import org.neo4j.cypher.internal.compiler.v2_2.commands.LessThanOrEqual;
import org.neo4j.cypher.internal.compiler.v2_2.commands.LiteralRegularExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.LoadCSV;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NamedPath;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NodeById;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NodeById$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NodeByIndex;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NodeByIndexQuery;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NodeByLabel;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NonEmpty;
import org.neo4j.cypher.internal.compiler.v2_2.commands.NoneInCollection;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Not;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Or;
import org.neo4j.cypher.internal.compiler.v2_2.commands.PathExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.PathExpression$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Pattern;
import org.neo4j.cypher.internal.compiler.v2_2.commands.PeriodicCommitQuery;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Predicate;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Query;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Query$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.QueryString$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.RegularExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.RelatedTo;
import org.neo4j.cypher.internal.compiler.v2_2.commands.RelatedTo$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.RelationshipById;
import org.neo4j.cypher.internal.compiler.v2_2.commands.RelationshipById$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.RelationshipByIndex;
import org.neo4j.cypher.internal.compiler.v2_2.commands.ReturnColumn;
import org.neo4j.cypher.internal.compiler.v2_2.commands.ReturnItem;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SchemaIndex;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SchemaIndexKind;
import org.neo4j.cypher.internal.compiler.v2_2.commands.ShortestPath;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SingleInCollection;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SingleNode;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SingleNode$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.SortItem;
import org.neo4j.cypher.internal.compiler.v2_2.commands.StartItem;
import org.neo4j.cypher.internal.compiler.v2_2.commands.True;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Union;
import org.neo4j.cypher.internal.compiler.v2_2.commands.VarLengthRelatedTo;
import org.neo4j.cypher.internal.compiler.v2_2.commands.VarLengthRelatedTo$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Xor;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.AbsFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Add;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.AggregationExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Avg;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.CoalesceFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Collection;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.CollectionIndex;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.CollectionSliceExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.CosFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Count;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.CountStar;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Distinct;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Divide;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ExtractFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.FilterFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.GenericCase;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.IdFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.LengthFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.LiteralMap;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Max;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Min;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Modulo;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Multiply;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.NodesFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ParameterExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.PercentileCont;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.PercentileDisc;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Pow;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ReduceFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.RelationshipEndPoints;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.RelationshipFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.RelationshipTypeFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.RoundFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ShortestPathExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.SignFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.SimpleCase;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.SqrtFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Stdev;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.StdevP;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Subtract;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Sum;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.KeyToken;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.TokenType;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.UnresolvedLabel$;
import org.neo4j.cypher.internal.compiler.v2_2.helpers.LabelSupport$;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.CreateNode;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.CreateRelationship;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.CreateUniqueAction;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.DeleteEntityAction;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.DeletePropertyAction;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.ForeachAction;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.MapPropertySetAction;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.NamedExpectation;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.NamedExpectation$;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.PropertySetAction;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.RelationshipEndpoint;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.RelationshipEndpoint$;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.UniqueLink;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.UniqueLink$;
import org.neo4j.cypher.internal.compiler.v2_2.mutation.UpdateAction;
import org.neo4j.cypher.internal.compiler.v2_2.parser.CypherParserTest$;
import org.neo4j.cypher.internal.compiler.v2_2.parser.ParserFixture$;
import org.neo4j.graphdb.Direction;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001#\t\u00012)\u001f9iKJ\u0004\u0016M]:feR+7\u000f\u001e\u0006\u0003\u0007\u0011\ta\u0001]1sg\u0016\u0014(BA\u0003\u0007\u0003\u00111(g\u0018\u001a\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011Q\u0003C\u0001\bG>lWn\u001c8t\u0013\t9BC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0013y\u0012aC3ya\u0016\u001cG/U;fef$2\u0001\t\u00140!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0011)f.\u001b;\t\u000b\u001dj\u0002\u0019\u0001\u0015\u0002\u000bE,XM]=\u0011\u0005%bcBA\u0011+\u0013\tY#%\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016#\u0011\u0015\u0001T\u00041\u00012\u00035)\u0007\u0010]3di\u0016$\u0017+^3ssB\u0011!'N\u0007\u0002g)\u0011A\u0007B\u0001\tG>lW.\u00198eg&\u0011ag\r\u0002\u000e\u0003\n\u001cHO]1diF+XM]=")
public class CypherParserTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery(String query, AbstractQuery expectedQuery) {
        Statement parsedQuery = ParserFixture$.MODULE$.parser().parse(query, ParserFixture$.MODULE$.parser().parse$default$2());
        AbstractQuery abstractQuery = StatementConverters.StatementConverter$.MODULE$.asQuery$extension(StatementConverters$.MODULE$.StatementConverter(parsedQuery));
        try {
            Assert.assertThat((String)query, (Object)abstractQuery, (Matcher)CoreMatchers.equalTo((Object)expectedQuery));
            return;
        }
        catch (AssertionError assertionError) {
            throw new AssertionError((Object)((Throwable)((Object)assertionError)).getMessage().replace("WrappedArray", "List"));
        }
    }

    public CypherParserTest() {
        this.test("shouldParseEasiestPossibleQuery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should return string literal", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = node(1) return \"apa\"", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"apa"), "\"apa\"")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should return string literal with escaped sequence in", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = node(1) return \"a\\tp\\\"a\\'b\"", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"a\tp\"a'b"), "\"a\\tp\\\"a\\'b\"")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = node(1) return 'a\\tp\\'a\\\"b'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"a\tp'a\"b"), "'a\\tp\\'a\\\"b'")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should return string literal containing UTF-16 escape sequence", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = node(1) return \"a\\uE12345\" AS x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"a\ue12345"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should return string literal containing UTF-32 escape sequence", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = node(1) return \"a\\U000292b145\" AS x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)"a\ud864\udeb145"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("allTheNodes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(*) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new AllNodes("s")})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("allTheRels", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start r = relationship(*) return r", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new AllRelationships("r")})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("r"), "r")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleAliasingOfColumnNames", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s as somethingElse", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "somethingElse")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sourceIsAnIndex", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node:index(key = \"value\") return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndex("a", "index", (Expression)new Literal((Object)"key"), (Expression)new Literal((Object)"value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sourceIsAnNonParsedIndexQuery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node:index(\"key:value\") return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndexQuery("a", "index", (Expression)new Literal((Object)"key:value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseEasiestPossibleRelationshipQuery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = relationship(1) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{RelationshipById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseEasiestPossibleRelationshipQueryShort", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = rel(1) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{RelationshipById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sourceIsARelationshipIndex", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = rel:index(key = \"value\") return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new RelationshipByIndex("a", "index", (Expression)new Literal((Object)"key"), (Expression)new Literal((Object)"value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("keywordsShouldBeCaseInsensitive", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START s = NODE(1) RETURN s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseMultipleNodes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1,2,3) return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseMultipleInputs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1), b = NODE(2) return a,b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldFilterOnProp", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) where a.name = \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldReturnLiterals", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return 12", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)12)), "12")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldReturnAdditions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return 12+a.x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Add((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)12)), (Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("x"))), "12+a.x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("arithmeticsPrecedence", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a.a/a.b*a.c-a.d*a.e", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Subtract((Expression)new Multiply((Expression)new Divide((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("a")), (Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("b"))), (Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("c"))), (Expression)new Multiply((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("d")), (Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("e")))), "a.a/a.b*a.c-a.d*a.e")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return (10 - 5)^2 * COS(3.1415927/4)^2", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Multiply((Expression)new Pow((Expression)new Subtract((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)10)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)5))), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2))), (Expression)new Pow((Expression)new CosFunction((Expression)new Divide((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)3.1415927)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)4)))), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)))), "(10 - 5)^2 * COS(3.1415927/4)^2")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldFilterOnPropWithDecimals", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where a.extractReturnItems = 3.1415 return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("extractReturnItems")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)3.1415)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleNot", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where not(a.name = \"andres\") return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleNotEqualTo", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name <> \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleLessThan", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name < \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new LessThan((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleGreaterThan", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name > \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new GreaterThan((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleLessThanOrEqual", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name <= \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new LessThanOrEqual((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleRegularComparison", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where \"Andres\" =~ 'And.*' return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new LiteralRegularExpression((Expression)new Literal((Object)"Andres"), new Literal((Object)"And.*"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleMultipleRegularComparison", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name =~ 'And.*' AnD a.name =~ 'And.*' return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where(And$.MODULE$.apply((Predicate)new LiteralRegularExpression((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), new Literal((Object)"And.*")), (Predicate)new LiteralRegularExpression((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), new Literal((Object)"And.*")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleEscapedRegexs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name =~ 'And\\\\/.*' return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new LiteralRegularExpression((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), new Literal((Object)"And\\/.*"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleGreaterThanOrEqual", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where a.name >= \"andres\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new GreaterThanOrEqual((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("booleanLiterals", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where true = false return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new True(), (Expression)new Not((Predicate)new True()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldFilterOnNumericProp", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) where 35 = a.age return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)35)), (Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleNegativeLiteralsAsExpected", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) where -35 = a.age AND (a.age > -1.2 AND a.weight=-50) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where(And$.MODULE$.apply((Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-35)), (Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), And$.MODULE$.apply((Predicate)new GreaterThan((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)-1.2))), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("weight")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-50)))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldCreateNotEqualsQuery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) where 35 <> a.age return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)35)), (Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multipleFilters", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) where a.name = \"andres\" or a.name = \"mattias\" return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Or((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"mattias")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldCreateXorQuery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) where a.name = 'andres' xor a.name = 'mattias' return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Xor((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"mattias")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedTo", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a -[:KNOWS]-> (b) return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED26", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToUsingUnicodeDashes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a \u2014[:KNOWS]\ufe58> (b) return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED26", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToUsingUnicodeArrowHeads", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a\u3008\u2014[:KNOWS]\ufe58\u27e9b return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED25", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.BOTH)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToWithoutRelType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a --> (b) return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED26", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToWithoutRelTypeButWithRelVariable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a-[r]->b return r", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("r"), "r")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToTheOtherWay", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a <-[:KNOWS]- (b) return a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED26", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.INCOMING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("twoDoubleOptionalWithFourHalfs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START a=node(1), b=node(2) OPTIONAL MATCH a-[r1]->X<-[r2]-b, a<-[r3]-Z-[r4]->b return r1,r2,r3,r4 order by id(r1),id(r2),id(r3),id(r4)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("X", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty()), new RelatedTo(new SingleNode("X", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r2", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.INCOMING, (Map)Predef$.MODULE$.Map().empty()), new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("Z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r3", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.INCOMING, (Map)Predef$.MODULE$.Map().empty()), new RelatedTo(new SingleNode("Z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r4", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).makeOptional().orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new IdFunction((Expression)new Identifier("r1")), true), new SortItem((Expression)new IdFunction((Expression)new Identifier("r2")), true), new SortItem((Expression)new IdFunction((Expression)new Identifier("r3")), true), new SortItem((Expression)new IdFunction((Expression)new Identifier("r4")), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("r1"), "r1"), new ReturnItem((Expression)new Identifier("r2"), "r2"), new ReturnItem((Expression)new Identifier("r3"), "r3"), new ReturnItem((Expression)new Identifier("r4"), "r4")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldOutputVariables", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a.name", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), "a.name")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldReadPropertiesOnExpressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return (a).name", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), "(a).name")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleAndPredicates", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) where a.name = \"andres\" and a.lastname = \"taylor\" return a.name", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"andres")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("lastname")), (Expression)new Literal((Object)"taylor")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), "a.name")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToWithRelationOutput", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a -[rel:KNOWS]-> (b) return rel", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "rel", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("rel"), "rel")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedToWithoutEndName", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a -[r:MARRIED]-> () return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "  UNNAMED41", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relatedInTwoSteps", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a -[:KNOWS]-> b -[:FRIEND]-> (c) return c", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED26", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING), RelatedTo$.MODULE$.apply("b", "c", "  UNNAMED40", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FRIEND"})), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("c"), "c")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("djangoCTRelationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a -[r:`<<KNOWS>>`]-> b return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"<<KNOWS>>"})), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("countTheNumberOfHits", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a --> b return a, b, count(*)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED26", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new CountStar()})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "count(*)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b"), new ReturnItem((Expression)new CountStar(), "count(*)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("countStar", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return count(*) order by count(*)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new CountStar()})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count(*)"})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new CountStar(), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new CountStar(), "count(*)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("distinct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a -[r]-> b return distinct a, b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).aggregation((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sumTheAgesOfPeople", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a -[r]-> b return a, b, sum(a.age)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Sum((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "sum(a.age)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b"), new ReturnItem((Expression)new Sum((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), "sum(a.age)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("avgTheAgesOfPeople", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a --> b return a, b, avg(a.age)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED26", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Avg((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "avg(a.age)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b"), new ReturnItem((Expression)new Avg((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), "avg(a.age)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("minTheAgesOfPeople", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a) --> b return a, b, min(a.age)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Min((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "min(a.age)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b"), new ReturnItem((Expression)new Min((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), "min(a.age)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("maxTheAgesOfPeople", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match a --> b return a, b, max(a.age)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED26", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Max((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "max(a.age)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b"), new ReturnItem((Expression)new Max((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age"))), "max(a.age)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("singleColumnSorting", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sortOnAggregatedColumn", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by avg(a.name)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Avg((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name"))), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("sortOnAliasedAggregatedColumn", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n = node(0) match (n)-[r:KNOWS]-(c) return n, count(c) as cnt order by cnt", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "c", "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.BOTH)})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Identifier("cnt"), true)})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Count((Expression)new Identifier("c"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n"), new ReturnItem((Expression)new Count((Expression)new Identifier("c")), "cnt")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleTwoSortColumns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name, a.age", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), true), new SortItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleTwoSortColumnsAscending", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name ASCENDING, a.age ASC", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), true), new SortItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), true)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("orderByDescending", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name DESCENDING", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), false)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("orderByDesc", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a order by a.name desc", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), false)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("nestedBooleanOperatorsAndParentesis", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n = NODE(1,2,3) where (n.animal = \"monkey\" and n.food = \"banana\") or (n.animal = \"cow\" and n\n      .food=\"grass\") return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L}))})).where((Predicate)new Or(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("animal")), (Expression)new Literal((Object)"monkey")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("food")), (Expression)new Literal((Object)"banana"))), And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("animal")), (Expression)new Literal((Object)"cow")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("food")), (Expression)new Literal((Object)"grass"))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("nestedBooleanOperatorsAndParentesisXor", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n = NODE(1,2,3) where (n.animal = \"monkey\" and n.food = \"banana\") xor (n.animal = \"cow\" and n\n      .food=\"grass\") return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L}))})).where((Predicate)new Xor(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("animal")), (Expression)new Literal((Object)"monkey")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("food")), (Expression)new Literal((Object)"banana"))), And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("animal")), (Expression)new Literal((Object)"cow")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("food")), (Expression)new Literal((Object)"grass"))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("limit5", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) return n limit 5", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).limit(5).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("skip5", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) return n skip 5", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).skip(5).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("skip5limit5", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) return n skip 5 limit 5", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).limit(5).skip(5).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relationshipType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) match n-[r]->(x) where type(r) = \"something\" return r", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).where((Predicate)new Equals((Expression)new RelationshipTypeFunction((Expression)new Identifier("r")), (Expression)new Literal((Object)"something"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("r"), "r")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("pathLength", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) match p=(n-[r]->x) where LENGTH(p) = 10 return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "n", "x", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).where((Predicate)new Equals((Expression)new LengthFunction((Expression)new Identifier("p")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)10.0)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("stringLength", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("return LENGTH('foo') = 10 as n", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Equals((Expression)new LengthFunction((Expression)new Literal((Object)"foo")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)10.0))), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("collectionSize", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("return SIZE([1, 2]) = 10 as n", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Equals((Expression)new LengthFunction((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1)), new Literal((Object)BoxesRunTime.boxToInteger((int)2))}))), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)10.0))), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relationshipTypeOut", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) match n-[r]->(x) return TYPE(r)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new RelationshipTypeFunction((Expression)new Identifier("r")), "TYPE(r)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldBeAbleToParseCoalesce", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) match n-[r]->(x) return COALESCE(r.name,x.name)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new CoalesceFunction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Property((Expression)new Identifier("r"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name"))})), "COALESCE(r.name,x.name)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relationshipsFromPathOutput", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) match p=n-[r]->x return RELATIONSHIPS(p)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "n", "x", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new RelationshipFunction((Expression)new Identifier("p")), "RELATIONSHIPS(p)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("keepDirectionForNamedPaths", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START a=node(1) match p=b<-[r]-a return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("b", "a", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.INCOMING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "b", "a", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.INCOMING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relationshipsFromPathInWhere", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=NODE(1) match p=n-[r]->x where length(rels(p))=1 return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "x", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "n", "x", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).where((Predicate)new Equals((Expression)new LengthFunction((Expression)new RelationshipFunction((Expression)new Identifier("p"))), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("countNonNullValues", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) return a, count(a)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Count((Expression)new Identifier("a"))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "count(a)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Count((Expression)new Identifier("a")), "count(a)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleIdBothInReturnAndWhere", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) where id(a) = 0 return ID(a)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new IdFunction((Expression)new Identifier("a")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new IdFunction((Expression)new Identifier("a")), "ID(a)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldBeAbleToHandleStringLiteralsWithApostrophe", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node:index(key = 'value') return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndex("a", "index", (Expression)new Literal((Object)"key"), (Expression)new Literal((Object)"value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleQuotationsInsideApostrophes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node:index(key = 'val\"ue') return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndex("a", "index", (Expression)new Literal((Object)"key"), (Expression)new Literal((Object)"val\"ue"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simplePathExample", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(0) match p = a-->b return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED29", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("  UNNAMED29", "a", "b", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("threeStepsPath", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(0) match p = ( a-[r1]->b-[r2]->c ) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r1", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING), RelatedTo$.MODULE$.apply("b", "c", "r2", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r1", "a", "b", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING), ParsedRelation$.MODULE$.apply("r2", "b", "c", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("pathsShouldBePossibleWithoutParenthesis", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(0) match p = a-[r]->b return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPath", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match a -[:knows*1..3]-> x return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED24", "a", "x", (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), "knows", Direction.OUTGOING, VarLengthRelatedTo$.MODULE$.apply$default$8())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPathWithRelsIterable", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match a -[r:knows*1..3]-> x return length(r)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED24", "a", "x", (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), "knows", Direction.OUTGOING, (Option)new Some((Object)"r"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new LengthFunction((Expression)new Identifier("r")), "length(r)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("fixedVarLengthPath", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match a -[*3]-> x return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED24", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPathWithoutMinDepth", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match a -[:knows*..3]-> x return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED24", "a", "x", (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), "knows", Direction.OUTGOING, VarLengthRelatedTo$.MODULE$.apply$default$8())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPathWithRelationshipIdentifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match a -[r:knows*2..]-> x return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED24", "a", "x", (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)None$.MODULE$, "knows", Direction.OUTGOING, (Option)new Some((Object)"r"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("variableLengthPathWithoutMaxDepth", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match a -[:knows*2..]-> x return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED24", "a", "x", (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)None$.MODULE$, "knows", Direction.OUTGOING, VarLengthRelatedTo$.MODULE$.apply$default$8())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("unboundVariableLengthPath", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match a -[:knows*]-> x return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{VarLengthRelatedTo$.MODULE$.apply("  UNNAMED24", "a", "x", (Option)None$.MODULE$, (Option)None$.MODULE$, "knows", Direction.OUTGOING, VarLengthRelatedTo$.MODULE$.apply$default$8())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("optionalRelationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) optional match a --> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED35", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("optionalTypedRelationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) optional match a -[:KNOWS]-> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "  UNNAMED35", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING)})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("optionalTypedAndNamedRelationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) optional match a -[r:KNOWS]-> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("optionalNamedRelationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) optional match a -[r]-> (b) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testAllIterablePredicate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) match p=(a-[r]->b) where all(x in NODES(p) WHERE x.name = \"Andres\") return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)}))})).where((Predicate)new AllInCollection((Expression)new NodesFunction((Expression)new Identifier("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testAnyIterablePredicate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) match p=(a-[r]->b) where any(x in NODES(p) WHERE x.name = \"Andres\") return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new SingleInCollection((Expression)new NodesFunction((Expression)new Identifier("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)}))})).where((Predicate)new AnyInCollection((Expression)new NodesFunction((Expression)new Identifier("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testNoneIterablePredicate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) match p=(a-[r]->b) where none(x in NODES(p) WHERE x.name = \"Andres\") return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)}))})).where((Predicate)new NoneInCollection((Expression)new NodesFunction((Expression)new Identifier("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testSingleIterablePredicate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) match p=(a-[r]->b) where single(x in NODES(p) WHERE x.name = \"Andres\") return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING)}))})).where((Predicate)new SingleInCollection((Expression)new NodesFunction((Expression)new Identifier("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamAsStartNode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node({a}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeById("pA", (Expression)new ParameterExpression("a"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamAsStartRel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = relationship({a}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new RelationshipById("pA", (Expression)new ParameterExpression("a"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testNumericParamNameAsStartNode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node({0}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeById("pA", (Expression)new ParameterExpression("0"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForWhereLiteral", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node(1) where pA.name = {name} return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Identifier("pA"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new ParameterExpression("name"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForIndexValue", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node:idx(key = {Value}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndex("pA", "idx", (Expression)new Literal((Object)"key"), (Expression)new ParameterExpression("Value"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForIndexQuery", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node:idx({query}) return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByIndexQuery("pA", "idx", (Expression)new ParameterExpression("query"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForSkip", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node(0) return pA skip {skipper}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).skip("skipper").returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForLimit", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node(0) return pA limit {stop}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).limit("stop").returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForLimitAndSkip", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node(0) return pA skip {skipper} limit {stop}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).skip("skipper").limit("stop").returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testQuotedParams", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node({`id`}) where pA.name =~ {`regex`} return pA skip {`ski``pper`} limit {`stop`}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeById("pA", (Expression)new ParameterExpression("id"))})).where((Predicate)new RegularExpression((Expression)new Property((Expression)new Identifier("pA"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new ParameterExpression("regex"))).skip("ski`pper").limit("stop").returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testParamForRegex", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start pA = node(0) where pA.name =~ {regex} return pA", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("pA", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new RegularExpression((Expression)new Property((Expression)new Identifier("pA"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new ParameterExpression("regex"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("pA"), "pA")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathWithMaxDepth", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) match p = shortestPath( a-[*..6]->b ) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)6)), true, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathWithMaxDepth and rel iterator", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) match p = shortestPath( a-[r*..6]->b ) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)6)), true, (Option)new Some((Object)"r"))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathWithType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) match p = shortestPath( a-[:KNOWS*..6]->b ) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)6)), true, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testAllShortestPathsWithType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) match p = allShortestPaths( a-[:KNOWS*..6]->b ) return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)6)), false, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathWithoutStart", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match p = shortestPath( a-[*1..3]->b ) WHERE a.name = 'John' AND b.name = 'Sarah' return p", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), true, (Option)None$.MODULE$)})).where(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"John")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("b"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Sarah")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testShortestPathExpression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) return shortestPath(a-[:KNOWS*0..3]->b) AS path", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ShortestPathExpression(new ShortestPath("  UNNAMED34", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING, true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), true, (Option)None$.MODULE$)), "path")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shortest path with 0 as min length and no max length", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) return shortestPath(a-[:KNOWS*0..]->b) AS path", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ShortestPathExpression(new ShortestPath("  UNNAMED34", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING, true, (Option)None$.MODULE$, true, (Option)None$.MODULE$)), "path")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testForNull", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) where a is null return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new IsNull((Expression)new Identifier("a"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testForNotNull", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) where a is not null return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new Not((Predicate)new IsNull((Expression)new Identifier("a")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("testCountDistinct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) return count(distinct a)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{new Distinct((AggregationExpression)new Count((Expression)new Identifier("a")), (Expression)new Identifier("a"))})).columns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count(distinct a)"})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Distinct((AggregationExpression)new Count((Expression)new Identifier("a")), (Expression)new Identifier("a")), "count(distinct a)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("supportsPatternExistsInTheWhereClause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) where a-->b return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED34", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})), PathExpression$.MODULE$.apply$default$2()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) where exists((a)-->(b)) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED43", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})), PathExpression$.MODULE$.apply$default$2()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("supportsPatternExistsInTheReturnClause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) return exists((a)-->(b)) AS result", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED44", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})), PathExpression$.MODULE$.apply$default$2())), "result")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("supportsNotHasRelationshipInTheWhereClause", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) where not(a-->()) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED41", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED38", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})), PathExpression$.MODULE$.apply$default$2())))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleLFAsWhiteSpace", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start\na=node(0)\nwhere\na.prop=12\nreturn\na", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)12)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleUpperCaseDistinct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) return DISTINCT s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).aggregation((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseMathFunctions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(0) return 5 % s.x, abs(-1), round(3.1415), 2 ^ s.x, sqrt(16), sign(1)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Modulo((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)5)), (Expression)new Property((Expression)new Identifier("s"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("x"))), "5 % s.x"), new ReturnItem((Expression)new AbsFunction((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-1))), "abs(-1)"), new ReturnItem((Expression)new RoundFunction((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)3.1415))), "round(3.1415)"), new ReturnItem((Expression)new Pow((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)), (Expression)new Property((Expression)new Identifier("s"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("x"))), "2 ^ s.x"), new ReturnItem((Expression)new SqrtFunction((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)16))), "sqrt(16)"), new ReturnItem((Expression)new SignFunction((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1))), "sign(1)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldAllowCommentAtEnd", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s // COMMENT", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldAllowCommentAlone", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s\n      // COMMENT", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldAllowCommentsInsideStrings", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) where s.apa = '//NOT A COMMENT' return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Equals((Expression)new Property((Expression)new Identifier("s"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("apa")), (Expression)new Literal((Object)"//NOT A COMMENT"))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldHandleCommentsFollowedByWhiteSpace", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1)\n      //I can haz more comment?\n      return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("first last and rest", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return head(nodes(p)), last(nodes(p)), tail(nodes(p))", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new CollectionIndex((Expression)new NodesFunction((Expression)new Identifier("p")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0))), "head(nodes(p))"), new ReturnItem((Expression)new CollectionIndex((Expression)new NodesFunction((Expression)new Identifier("p")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-1))), "last(nodes(p))"), new ReturnItem((Expression)new CollectionSliceExpression((Expression)new NodesFunction((Expression)new Identifier("p")), (Option)new Some((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)1))), (Option)None$.MODULE$), "tail(nodes(p))")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("filter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return filter(x in nodes(p) WHERE x.prop = 123)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new FilterFunction((Expression)new NodesFunction((Expression)new Identifier("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)123)))), "filter(x in nodes(p) WHERE x.prop = 123)")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return [x in nodes(p) WHERE x.prop = 123]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new FilterFunction((Expression)new NodesFunction((Expression)new Identifier("p")), "x", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)123)))), "[x in nodes(p) WHERE x.prop = 123]")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("extract", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return [x in nodes(p) | x.prop]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ExtractFunction((Expression)new NodesFunction((Expression)new Identifier("p")), "x", (Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop"))), "[x in nodes(p) | x.prop]")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("listComprehension", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) match p=x-[r]->z return [x in rels(p) WHERE x.prop > 123 | x.prop]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "x", "z", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ExtractFunction((Expression)new FilterFunction((Expression)new RelationshipFunction((Expression)new Identifier("p")), "x", (Predicate)new GreaterThan((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)123)))), "x", (Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop"))), "[x in rels(p) WHERE x.prop > 123 | x.prop]")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("collection literal", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) return ['a','b','c']", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"a"), new Literal((Object)"b"), new Literal((Object)"c")})), "['a','b','c']")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("collection literal2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) return []", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Collection((Seq)Nil$.MODULE$), "[]")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("collection literal3", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) return [1,2,3]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1)), new Literal((Object)BoxesRunTime.boxToInteger((int)2)), new Literal((Object)BoxesRunTime.boxToInteger((int)3))})), "[1,2,3]")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("collection literal4", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) return ['a',2]", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"a"), new Literal((Object)BoxesRunTime.boxToInteger((int)2))})), "['a',2]")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("in with collection literal", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) where x.prop in ['a','b'] return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new AnyInCollection((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"a"), new Literal((Object)"b")})), "-_-INNER-_-", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Identifier("-_-INNER-_-")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("in with collection prop", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) where x.prop in x.props return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new AnyInCollection((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("props")), "-_-INNER-_-", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Identifier("-_-INNER-_-")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple relationship type in match", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) match x-[:REL1|:REL2|:REL3]->z return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED25", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL1", "REL2", "REL3"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple relationship type in varlength rel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) match x-[:REL1|:REL2|:REL3]->z return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED25", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL1", "REL2", "REL3"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple relationship type in shortest path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start x = NODE(1) match x-[:REL1|:REL2|:REL3]->z return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("z", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED25", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL1", "REL2", "REL3"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple relationship type in relationship predicate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) where a-[:KNOWS|:BLOCKS]-b return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED34", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS", "BLOCKS"})), Direction.BOTH, (Map)Predef$.MODULE$.Map().empty())})), PathExpression$.MODULE$.apply$default$2()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("first parsed pipe query", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Nil$.MODULE$).where((Predicate)new Equals((Expression)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("foo")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START x = node(1) WITH x WHERE x.foo = 42 RETURN x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("read first and update next", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("b", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)new Multiply((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)2.0))))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) with a create (b {age : a.age * 2}) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("variable length path with collection for relationships", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) optional match a -[r*1..3]-> x return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED33", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)3)), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Option)new Some((Object)"r"), (Map)Predef$.MODULE$.Map().empty())})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("binary precedence", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(0) where n.a = 'x' and n.b = 'x' xor n.c = 'x' or n.d = 'x' return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new Or((Predicate)new Xor(And$.MODULE$.apply((Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("a")), (Expression)new Literal((Object)"x")), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("b")), (Expression)new Literal((Object)"x"))), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("c")), (Expression)new Literal((Object)"x"))), (Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("d")), (Expression)new Literal((Object)"x")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create node from param", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create ({param})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("  UNNAMED7", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("param"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with a property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a {name : 'Andres'})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Andres"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with a property and return it", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a {name : 'Andres'}) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Andres"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create node from map expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a {param})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("param"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with a label", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a:FOO)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO"}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with multiple labels", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a:FOO:BAR)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO", "BAR"}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create node with multiple labels with spaces", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a :FOO :BAR)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO", "BAR"}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create nodes with labels and a rel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("CREATE (n:Person:Husband)-[:FOO]->(x:Person)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED25", new RelationshipEndpoint((Expression)new Identifier("n"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person", "Husband"}))), new RelationshipEndpoint((Expression)new Identifier("x"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Person"}))), "FOO", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("start with two nodes and create relationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) with a,b create a-[r:REL]->b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("start with two nodes and create relationship make outgoing", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) create a<-[r:REL]-b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("start with two nodes and create relationship make outgoing named", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL"})), Direction.INCOMING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) create p=a<-[r:REL]-b return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create relationship with properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"why"), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)42))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"foo"), (Object)new Literal((Object)"bar"))}))))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) with a,b create a-[r:REL {why : 42, foo : 'bar'}]->b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create relationship without identifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a {a})-[:REL]->(b {b})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED14", new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("a"))})), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("b"))})), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create relationship with properties from map", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a {a})-[:REL {param}]->(b {b})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED14", new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("a"))})), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("b"))})), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("param"))}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create relationship without identifier2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a {a})-[:REL]->(b {b})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED14", new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("a"))})), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("b"))})), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("delete node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeleteEntityAction((Expression)new Identifier("a"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) with a delete a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple delete node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeleteEntityAction((Expression)new Identifier("a"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) delete a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("delete rel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeleteEntityAction((Expression)new Identifier("r"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match (a)-[r:REL]->(b) delete r", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "REL", Direction.OUTGOING)})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("delete path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeleteEntityAction((Expression)new Identifier("p"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match p=(a)-[r:REL]->(b) delete p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "REL", Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL"})), Direction.OUTGOING)}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("set property on node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("hello")), (Expression)new Literal((Object)"world"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) with a set a.hello = 'world'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("set property on node from expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("hello")), (Expression)new Literal((Object)"world"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) with a set (a).hello = 'world'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("set multiple properties on node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("hello")), (Expression)new Literal((Object)"world")), new PropertySetAction(new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("foo")), (Expression)new Literal((Object)"bar"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) with a set a.hello = 'world', a.foo = 'bar'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("update property with expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary")), (Expression)new Multiply((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)2.0))))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) with a set a.salary = a.salary * 2 ", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("remove property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new DeletePropertyAction((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) remove a.salary", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("foreach on path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new ForeachAction((Expression)new NodesFunction((Expression)new Identifier("p")), "n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertySetAction[]{new PropertySetAction(new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("touched")), (Expression)new True())})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match p = a-[r:REL]->b with p foreach(n in nodes(p) | set n.touched = true ) ", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "REL", Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL"})), Direction.OUTGOING)}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("foreach on path with multiple updates", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new ForeachAction((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1)), new Literal((Object)BoxesRunTime.boxToInteger((int)2)), new Literal((Object)BoxesRunTime.boxToInteger((int)3))})), "n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateRelationship[]{new CreateRelationship("r1", RelationshipEndpoint$.MODULE$.apply("x"), RelationshipEndpoint$.MODULE$.apply("z"), "HAS", (Map)Predef$.MODULE$.Map().empty()), new CreateRelationship("r2", RelationshipEndpoint$.MODULE$.apply("x"), RelationshipEndpoint$.MODULE$.apply("z2"), "HAS", (Map)Predef$.MODULE$.Map().empty())})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match n foreach(n in [1,2,3] | create (x)-[r1:HAS]->(z) create (x)-[r2:HAS]->(z2) )", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple read first and update next", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("b", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"age"), (Object)new Multiply((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("age")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)2.0))))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("b"), "b")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) create (b {age : a.age * 2}) return b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple start with two nodes and create relationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) create a-[r:REL]->b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple create relationship with properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "REL", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"why"), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)42))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"foo"), (Object)new Literal((Object)"bar"))}))))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0), b=node(1) create a<-[r:REL {why : 42, foo : 'bar'}]-b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple set property on node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("hello")), (Expression)new Literal((Object)"world"))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) set a.hello = 'world'", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple update property with expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new PropertySetAction(new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary")), (Expression)new Multiply((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("salary")), (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)2.0))))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) set a.salary = a.salary * 2 ", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple foreach on path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new ForeachAction((Expression)new NodesFunction((Expression)new Identifier("p")), "n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertySetAction[]{new PropertySetAction(new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("touched")), (Expression)new True())})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) match p = a-[r:REL]->b foreach(n in nodes(p) | set n.touched = true ) ", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "REL", Direction.OUTGOING)})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL"})), Direction.OUTGOING)}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("returnAll", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) return *", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single create unique", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "b", "  UNNAMED44", "reltype", Direction.OUTGOING)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1), b=node(2) create unique a-[:reltype]->b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single create unique with rel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "b", "r", "reltype", Direction.OUTGOING)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1), b=node(2) create unique a-[r:reltype]->b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single relate with empty parenthesis", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "  UNNAMED57", "  UNNAMED44", "reltype", Direction.OUTGOING)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1), b=node(2) create unique a-[:reltype]->()", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create unique with two patterns", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "b", "  UNNAMED33", "X", Direction.OUTGOING), UniqueLink$.MODULE$.apply("c", "b", "  UNNAMED41", "X", Direction.OUTGOING)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) create unique a-[:X]->b<-[:X]-c", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relate with initial values for node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{new UniqueLink(NamedExpectation$.MODULE$.apply("a"), NamedExpectation$.MODULE$.apply("b", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Andres"))}))), NamedExpectation$.MODULE$.apply("  UNNAMED33"), "X", Direction.OUTGOING)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) create unique a-[:X]->(b {name:'Andres'})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create unique with initial values for rel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{new UniqueLink(NamedExpectation$.MODULE$.apply("a"), NamedExpectation$.MODULE$.apply("b"), NamedExpectation$.MODULE$.apply("  UNNAMED33", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Andres"))}))), "X", Direction.OUTGOING)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) create unique a-[:X {name:'Andres'}]->b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("foreach with literal collection", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query tail = Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new ForeachAction((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToDouble((double)1.0)), new Literal((Object)BoxesRunTime.boxToDouble((double)2.0)), new Literal((Object)BoxesRunTime.boxToDouble((double)3.0))})), "x", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateNode[]{new CreateNode("a", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"number"), (Object)new Identifier("x"))})), (Seq)Seq$.MODULE$.empty())})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create root foreach(x in [1,2,3] | create (a {number:x}))", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("root", (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()))})).tail(tail).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("string literals should not be mistaken for identifiers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (tag1 {name:'tag2'}), (tag2 {name:'tag1'})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("tag1", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"tag2"))})), (Seq)Seq$.MODULE$.empty())), new CreateNodeStartItem(new CreateNode("tag2", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"tag1"))})), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relate with two rels to same node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query returns = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateUniqueStartItem(new CreateUniqueAction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("root", "x", "r1", "X", Direction.OUTGOING), UniqueLink$.MODULE$.apply("root", "x", "r2", "Y", Direction.OUTGOING)})))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("x"), "x")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start root=node(0) create unique x<-[r1:X]-root-[r2:Y]->x return x", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("root", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(returns).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("optional shortest path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a  = node(1), x = node(2,3)\n         optional match p = shortestPath(a -[*]-> x)\n         return *", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("x", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L, 3L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new ShortestPath("p", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, false, (Option)None$.MODULE$, true, (Option)None$.MODULE$)})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("return paths", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a  = node(1) return a-->()", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED30", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED27", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})), PathExpression$.MODULE$.apply$default$2()), "a-->()")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("not with parenthesis", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a  = node(1) where not(1=2) or 2=3 return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Or((Predicate)new Not((Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)))), (Predicate)new Equals((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)3))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("precedence of not without parenthesis", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where not true or false return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Or((Predicate)new Not((Predicate)new True()), (Predicate)new Not((Predicate)new True()))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = node(1) where not 1 < 2 return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).where((Predicate)new Not((Predicate)new LessThan((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("not with pattern", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (admin) WHERE NOT (admin)-[:MEMBER_OF]->() RETURN admin", (AbstractQuery)this.parsedQueryWithOffsets$1(31, 46));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (admin) WHERE NOT ((admin)-[:MEMBER_OF]->()) RETURN admin", (AbstractQuery)this.parsedQueryWithOffsets$1(32, 47));
            }

            private final Query parsedQueryWithOffsets$1(int offset1, int offset2) {
                return Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("admin", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).where((Predicate)new Not((Predicate)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{new RelatedTo(new SingleNode("admin", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode(new StringBuilder().append((Object)"  UNNAMED").append((Object)BoxesRunTime.boxToInteger((int)offset2)).toString(), SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new StringBuilder().append((Object)"  UNNAMED").append((Object)BoxesRunTime.boxToInteger((int)offset1)).toString(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MEMBER_OF"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})), PathExpression$.MODULE$.apply$default$2())))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("admin"), "admin")}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("full path in create", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r1", new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("  UNNAMED48"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "KNOWS", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), new CreateRelationshipStartItem(new CreateRelationship("r2", new RelationshipEndpoint((Expression)new Identifier("  UNNAMED48"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "LOVES", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(1), b=node(2) create a-[r1:KNOWS]->()-[r2:LOVES]->b", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L})), NodeById$.MODULE$.apply("b", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{2L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create and assign to path identifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create p = a-[r:KNOWS]->() return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r", new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("  UNNAMED24"), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Seq)Seq$.MODULE$.empty()), "KNOWS", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "  UNNAMED24", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("relate and assign to path identifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateUniqueStartItem(new CreateUniqueAction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("a", "  UNNAMED47", "r", "KNOWS", Direction.OUTGOING)})))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("r", "a", "  UNNAMED47", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a=node(0) create unique p = a-[r:KNOWS]->() return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("use predicate as expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(0) return id(n) = 0, n is null", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Equals((Expression)new IdFunction((Expression)new Identifier("n")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0))), "id(n) = 0"), new ReturnItem((Expression)new IsNull((Expression)new Identifier("n")), "n is null")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create unique should support parameter maps", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NamedExpectation start = NamedExpectation$.MODULE$.apply("n");
                NamedExpectation rel = NamedExpectation$.MODULE$.apply("  UNNAMED31");
                NamedExpectation end = NamedExpectation$.MODULE$.apply("  UNNAMED40", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"*"), (Object)new ParameterExpression("param"))})), (Seq)Seq$.MODULE$.empty());
                Query secondQ = Query$.MODULE$.unique((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{new UniqueLink(start, end, rel, "foo", Direction.OUTGOING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) CREATE UNIQUE n-[:foo]->({param}) RETURN *", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("with limit", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(0,1,2) with n limit 2 where ID(n) = 1 return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}))})).limit(2).tail(Query$.MODULE$.start((Seq)Nil$.MODULE$).where((Predicate)new Equals((Expression)new IdFunction((Expression)new Identifier("n")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")}))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("with sort limit", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(0,1,2) with n order by ID(n) desc limit 2 where ID(n) = 1 return n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}))})).orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{new SortItem((Expression)new IdFunction((Expression)new Identifier("n")), false)})).limit(2).tail(Query$.MODULE$.start((Seq)Nil$.MODULE$).where((Predicate)new Equals((Expression)new IdFunction((Expression)new Identifier("n")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")}))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("set to param", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new MapPropertySetAction((Expression)new Identifier("n"), (Expression)new ParameterExpression("prop"), true)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(0) set n = {prop}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("inclusive set to param", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new MapPropertySetAction((Expression)new Identifier("n"), (Expression)new ParameterExpression("prop"), false)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(0) set n += {prop}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("set to map", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new MapPropertySetAction((Expression)new Identifier("n"), (Expression)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"key"), (Object)new Literal((Object)"value")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"foo"), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))}))), true)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(0) set n = {key: 'value', foo: 1}", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("add label", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Identifier("n"), (LabelOp)LabelSetOp$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken.Unresolved[]{new KeyToken.Unresolved("LabelName", (TokenType)TokenType.Label$.MODULE$)})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) set n:LabelName", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("add short label", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Identifier("n"), (LabelOp)LabelSetOp$.MODULE$, (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken.Unresolved[]{new KeyToken.Unresolved("LabelName", (TokenType)TokenType.Label$.MODULE$)})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) SET n:LabelName", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("add multiple labels", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq coll = LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName2", "LabelName3"}));
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Identifier("n"), (LabelOp)LabelSetOp$.MODULE$, coll)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) set n :LabelName2 :LabelName3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("add multiple short labels", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq coll = LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName2", "LabelName3"}));
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Identifier("n"), (LabelOp)LabelSetOp$.MODULE$, coll)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) set n:LabelName2:LabelName3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("add multiple short labels2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq coll = LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName2", "LabelName3"}));
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Identifier("n"), (LabelOp)LabelSetOp$.MODULE$, coll)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) SET n :LabelName2 :LabelName3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("remove label", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Identifier("n"), (LabelOp)LabelRemoveOp$.MODULE$, LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName"})))})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) REMOVE n:LabelName", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("remove multiple labels", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq coll = LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LabelName2", "LabelName3"}));
                Query q2 = Query$.MODULE$.start((Seq)Nil$.MODULE$).updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new LabelAction((Expression)new Identifier("n"), (LabelOp)LabelRemoveOp$.MODULE$, coll)})).returns((Seq)Nil$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) REMOVE n:LabelName2:LabelName3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).tail(q2).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("filter by label in where", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) WHERE (n):Foo RETURN n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new HasLabel((Expression)new Identifier("n"), (KeyToken)new KeyToken.Unresolved("Foo", (TokenType)TokenType.Label$.MODULE$))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("filter by label in where with expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) WHERE (n):Foo RETURN n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where((Predicate)new HasLabel((Expression)new Identifier("n"), (KeyToken)new KeyToken.Unresolved("Foo", (TokenType)TokenType.Label$.MODULE$))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("filter by labels in where", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) WHERE n:Foo:Bar RETURN n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).where(And$.MODULE$.apply((Predicate)new HasLabel((Expression)new Identifier("n"), (KeyToken)new KeyToken.Unresolved("Foo", (TokenType)TokenType.Label$.MODULE$)), (Predicate)new HasLabel((Expression)new Identifier("n"), (KeyToken)new KeyToken.Unresolved("Bar", (TokenType)TokenType.Label$.MODULE$)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create no index without properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$218 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create index on :MyLabel", (AbstractQuery)new CreateIndex("MyLabel", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), CreateIndex$.MODULE$.apply$default$3()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(SyntaxException.class)));
            }

            public /* synthetic */ CypherParserTest org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create index on single property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create index on :MyLabel(prop1)", (AbstractQuery)new CreateIndex("MyLabel", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prop1"})), CreateIndex$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create index on multiple properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$220 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create index on :MyLabel(prop1, prop2)", (AbstractQuery)new CreateIndex("MyLabel", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prop1", "prop2"})), CreateIndex$.MODULE$.apply$default$3()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(SyntaxException.class)));
            }

            public /* synthetic */ CypherParserTest org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match left with single label", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a:foo) -[r:MARRIED]-> () return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("foo")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED47", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match left with multiple labels", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (a:foo:bar) -[r:MARRIED]-> () return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("foo"), UnresolvedLabel$.MODULE$.apply("bar")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED51", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match right with multiple labels", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match () -[r:MARRIED]-> (a:foo:bar) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("  UNNAMED24", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), SingleNode$.MODULE$.apply$default$3()), new SingleNode("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("foo"), UnresolvedLabel$.MODULE$.apply("bar")})), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("match both with labels", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start a = NODE(1) match (b:foo) -[r:MARRIED]-> (a:bar) return a", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("a", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("b", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("foo")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("a", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("bar")})), SingleNode$.MODULE$.apply$default$3()), "r", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("union ftw", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q1 = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")}));
                Query q2 = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("t", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("t"), "t")}));
                Query q3 = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("u", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("u"), "u")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s UNION all start t = NODE(1) return t UNION all start u = NODE(1) return u", (AbstractQuery)new Union((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Query[]{q1, q2, q3})), QueryString$.MODULE$.empty(), false));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("union distinct", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("s", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = NODE(1) return s UNION start s = NODE(1) return s UNION start s = NODE(1) return s", (AbstractQuery)new Union((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Query[]{q, q, q})), QueryString$.MODULE$.empty(), true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple unions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q = Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).limit(1).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "(n)")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (n) RETURN (n) LIMIT 1 UNION MATCH (n) RETURN (n) LIMIT 1 UNION MATCH (n) RETURN (n) LIMIT 1", (AbstractQuery)new Union((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Query[]{q, q, q})), QueryString$.MODULE$.empty(), true));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("keywords in reltype and label", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START n=node(0) MATCH (n:On)-[:WHERE]->() RETURN n", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("On")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED39", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED28", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHERE"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("remove index on single property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("drop index on :MyLabel(prop1)", (AbstractQuery)new DropIndex("MyLabel", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"prop1"})), DropIndex$.MODULE$.apply$default$3()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple query with index hint", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match (n:Person)-->() using index n:Person(name) where n.name = 'Andres' return n", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("Person")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED19", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED16", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).where((Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Literal((Object)"Andres"))).using((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new SchemaIndex("n", "Person", "name", (SchemaIndexKind)AnyIndex$.MODULE$, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple in expression with index hint", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match (n:Person)-->() using index n:Person(name) where n.name IN ['Andres'] return n", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(new SingleNode("n", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("Person")})), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED19", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED16", (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).where((Predicate)new AnyInCollection((Expression)new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)"Andres")})), "-_-INNER-_-", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("name")), (Expression)new Identifier("-_-INNER-_-")))).using((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new SchemaIndex("n", "Person", "name", (SchemaIndexKind)AnyIndex$.MODULE$, (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single node match pattern", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = node(*) match s return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new AllNodes("s")})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("s", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("awesome single labeled node match pattern", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match (s:nostart) return s", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("s", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("nostart")})), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single node match pattern path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start s = node(*) match p = s return s", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new AllNodes("s")})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("s", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedEntity$.MODULE$.apply("s")}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("s"), "s")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("label scan hint", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match (p:Person) using scan p:Person return p", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("p", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyToken[]{UnresolvedLabel$.MODULE$.apply("Person")})), SingleNode$.MODULE$.apply$default$3())})).using((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new NodeByLabel("p", "Person")})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("varlength named path", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(1) match p=n-[:KNOWS*..2]->x return p", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED25", new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{new ParsedVarLengthRelation("  UNNAMED25", (Map)Predef$.MODULE$.Map().empty(), ParsedEntity$.MODULE$.apply("n"), ParsedEntity$.MODULE$.apply("x"), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.OUTGOING, false, (Option)None$.MODULE$, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)None$.MODULE$)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("reduce function", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Collection collection = new Collection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Literal((Object)BoxesRunTime.boxToInteger((int)1)), new Literal((Object)BoxesRunTime.boxToInteger((int)2)), new Literal((Object)BoxesRunTime.boxToInteger((int)3))}));
                Add expression = new Add((Expression)new Identifier("acc"), (Expression)new Identifier("x"));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start n=node(1) return reduce(acc = 0, x in [1,2,3] | acc + x)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("n", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new ReduceFunction((Expression)collection, "x", (Expression)expression, "acc", (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0))), "reduce(acc = 0, x in [1,2,3] | acc + x)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("start and endNode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("start r=rel(1) return startNode(r), endNode(r)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{RelationshipById$.MODULE$.apply("r", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new RelationshipEndPoints((Expression)new Identifier("r"), true), "startNode(r)"), new ReturnItem((Expression)new RelationshipEndPoints((Expression)new Identifier("r"), false), "endNode(r)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("mathy aggregation expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property property = new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("property"));
                PercentileCont percentileCont = new PercentileCont((Expression)property, (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)0.4)));
                PercentileDisc percentileDisc = new PercentileDisc((Expression)property, (Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)0.5)));
                Stdev stdev = new Stdev((Expression)property);
                StdevP stdevP = new StdevP((Expression)property);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match n return percentileCont(n.property, 0.4), percentileDisc(n.property, 0.5), stdev(n.property), stdevp(n.property)", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).aggregation((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregationExpression[]{percentileCont, percentileDisc, stdev, stdevP})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)percentileCont, "percentileCont(n.property, 0.4)"), new ReturnItem((Expression)percentileDisc, "percentileDisc(n.property, 0.5)"), new ReturnItem((Expression)stdev, "stdev(n.property)"), new ReturnItem((Expression)stdevP, "stdevp(n.property)")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("escaped identifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match `Unusual identifier` return `Unusual identifier`.propertyName", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("Unusual identifier", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Identifier("Unusual identifier"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("propertyName")), "`Unusual identifier`.propertyName")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("aliased column does not keep escape symbols", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match a return a as `Escaped alias`", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "Escaped alias")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("create with labels and props with parens", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("CREATE (node :FOO:BAR {name: 'Stefan'})", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("node", (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Stefan"))})), LabelSupport$.MODULE$.labelCollection((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FOO", "BAR"}))))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("constraint creation", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("CREATE CONSTRAINT ON (id:Label) ASSERT id.property IS UNIQUE", (AbstractQuery)new CreateUniqueConstraint("id", "Label", "id", "property", CreateUniqueConstraint$.MODULE$.apply$default$5()));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("named path with variable length path and named relationships collection", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match p = (a)-[r*]->(b) return p", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED13", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING, (Option)new Some((Object)"r"), (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{new ParsedVarLengthRelation("  UNNAMED13", (Map)Predef$.MODULE$.Map().empty(), ParsedEntity$.MODULE$.apply("a"), ParsedEntity$.MODULE$.apply("b"), (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING, false, (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)"r"))}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p"), "p")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("variable length relationship with rel collection", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (a)-[rels*]->(b) WHERE ALL(r in rels WHERE r.prop = 42) RETURN rels", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED9", new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("b", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)None$.MODULE$, (Option)None$.MODULE$, (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING, (Option)new Some((Object)"rels"), (Map)Predef$.MODULE$.Map().empty())})).where((Predicate)new AllInCollection((Expression)new Identifier("rels"), "r", (Predicate)new Equals((Expression)new Property((Expression)new Identifier("r"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)42))))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("rels"), "rels")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("simple case statement", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (a) RETURN CASE a.prop WHEN 1 THEN 'hello' ELSE 'goodbye' END AS result", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new SimpleCase((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Literal((Object)"hello"))})), (Option)new Some((Object)new Literal((Object)"goodbye"))), "result")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("generic case statement", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (a) RETURN CASE WHEN a.prop = 1 THEN 'hello' ELSE 'goodbye' END AS result", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new GenericCase((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Equals((Expression)new Property((Expression)new Identifier("a"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1))), (Object)new Literal((Object)"hello"))})), (Option)new Some((Object)new Literal((Object)"goodbye"))), "result")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("genericCaseCoercesInWhen", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery(new StringOps(Predef$.MODULE$.augmentString("MATCH (a) RETURN CASE WHEN (a)-[:LOVES]->() THEN 1 ELSE 0 END AS result")).stripMargin(), (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new GenericCase((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new NonEmpty((Expression)new PathExpression((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RelatedTo[]{new RelatedTo(new SingleNode("a", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("  UNNAMED41", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED30", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LOVES"})), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})), PathExpression$.MODULE$.apply$default$2())), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)1)))})), (Option)new Some((Object)new Literal((Object)BoxesRunTime.boxToInteger((int)0)))), "result")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldGroupCreateAndCreateUpdate", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query thirdQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateUniqueStartItem(new CreateUniqueAction((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UniqueLink[]{UniqueLink$.MODULE$.apply("wife", "friendOfFriend", "  UNNAMED128", "KNOWS", Direction.BOTH)})))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p3", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{ParsedRelation$.MODULE$.apply("  UNNAMED128", "wife", "friendOfFriend", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KNOWS"})), Direction.BOTH)}))})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("p1"), "p1"), new ReturnItem((Expression)new Identifier("p2"), "p2"), new ReturnItem((Expression)new Identifier("p3"), "p3")}));
                Query secondQ = Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("  UNNAMED65", new RelationshipEndpoint((Expression)new Identifier("me"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("wife"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Gunhild"))})), (Seq)Seq$.MODULE$.empty()), "MARRIED_TO", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{new ParsedRelation("  UNNAMED65", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), ParsedEntity$.MODULE$.apply("me"), new ParsedEntity("wife", (Expression)new Identifier("wife"), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Gunhild"))})), (Seq)Seq$.MODULE$.empty()), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MARRIED_TO"})), Direction.OUTGOING, false)}))})).tail(thirdQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("START me=node(0) MATCH p1 = me-[*2]-friendOfFriend CREATE p2 = me-[:MARRIED_TO]->(wife {name:\"Gunhild\"}) CREATE UNIQUE p3 = wife-[:KNOWS]-friendOfFriend RETURN p1,p2,p3", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{NodeById$.MODULE$.apply("me", (Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L}))})).matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new VarLengthRelatedTo("  UNNAMED30", new SingleNode("me", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), new SingleNode("friendOfFriend", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Seq)Seq$.MODULE$.empty(), Direction.BOTH, (Option)None$.MODULE$, (Map)Predef$.MODULE$.Map().empty())})).namedPaths((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NamedPath[]{new NamedPath("p1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractPattern[]{new ParsedVarLengthRelation("  UNNAMED30", (Map)Predef$.MODULE$.Map().empty(), ParsedEntity$.MODULE$.apply("me"), ParsedEntity$.MODULE$.apply("friendOfFriend"), (Seq)Seq$.MODULE$.empty(), Direction.BOTH, false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)new Some((Object)BoxesRunTime.boxToInteger((int)2)), (Option)None$.MODULE$)}))})).tail(secondQ).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("return only query with literal map", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("RETURN { key: 'value' }", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"key"), (Object)new Literal((Object)"value"))}))), "{ key: 'value' }")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("access nested properties", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query tail = Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Property((Expression)new Identifier("person"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("address")), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("city")), "person.address.city")}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("WITH { name:'Alice', address: { city:'London', residential:true }} AS person RETURN person.address.city", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).tail(tail).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"name"), (Object)new Literal((Object)"Alice")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"address"), (Object)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"city"), (Object)new Literal((Object)"London")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"residential"), (Object)new True())}))))}))), "person")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("long match chain", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("match (a)<-[r1:REL1]-(b)<-[r2:REL2]-(c) return a, b, c", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL1"})), Direction.INCOMING), RelatedTo$.MODULE$.apply("b", "c", "r2", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"REL2"})), Direction.INCOMING)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("a"), "a"), new ReturnItem((Expression)new Identifier("b"), "b"), new ReturnItem((Expression)new Identifier("c"), "c")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("long create chain", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("create (a)<-[r1:REL1]-(b)<-[r2:REL2]-(c)", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateRelationshipStartItem(new CreateRelationship("r1", new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("a"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), "REL1", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$))), new CreateRelationshipStartItem(new CreateRelationship("r2", new RelationshipEndpoint((Expression)new Identifier("c"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), new RelationshipEndpoint((Expression)new Identifier("b"), (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()), "REL2", (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$)))})).returns((Seq)Nil$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("test literal numbers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("RETURN 0.5, .5, 50, -0.3, -33, 1E-10, -4.5E23, 0x45fd, -0xdc5e", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)0.5)), "0.5"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)0.5)), ".5"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)50)), "50"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)-0.3)), "-0.3"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-33)), "-33"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)1.0E-10)), "1E-10"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToDouble((double)-4.5E23)), "-4.5E23"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)17917)), "0x45fd"), new ReturnItem((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)-56414)), "-0xdc5e")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("test unary plus minus", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH n WHERE n.prop=+2 RETURN -n.prop, +n.foo, 1 + -n.bar", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).where((Predicate)new Equals((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop")), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)2)))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Subtract((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("prop"))), "-n.prop"), new ReturnItem((Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("foo")), "+n.foo"), new ReturnItem((Expression)new Add((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1)), (Expression)new Subtract((Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)0)), (Expression)new Property((Expression)new Identifier("n"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("bar")))), "1 + -n.bar")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile query integration test", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query q = (Query)StatementConverters.StatementConverter$.MODULE$.asQuery$extension(StatementConverters$.MODULE$.StatementConverter(ParserFixture$.MODULE$.parser().parse("create (a1) create (a2) create (a3) create (a4) create (a5) create (a6) create (a7)", ParserFixture$.MODULE$.parser().parse$default$2())));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(q.tail().nonEmpty(), "q.tail.nonEmpty");
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"wasn't compacted enough");
                Query compacted = q.compact();
                Option $org_scalatest_assert_macro_left = compacted.tail();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty());
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"wasn't compacted enough");
                TripleEqualsSupport.Equalizer<Integer> $org_scalatest_assert_macro_left2 = this.$outer.convertToEqualizer(BoxesRunTime.boxToInteger((int)compacted.start().size()));
                int $org_scalatest_assert_macro_right = 7;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"lost create commands");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle optional match", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("OPTIONAL MATCH n RETURN n", (AbstractQuery)Query$.MODULE$.optionalMatches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("compile query integration test 2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query compacted;
                Query q = (Query)StatementConverters.StatementConverter$.MODULE$.asQuery$extension(StatementConverters$.MODULE$.StatementConverter(ParserFixture$.MODULE$.parser().parse("create (a1) create (a2) create (a3) with a1 create (a4) return a1, a4", ParserFixture$.MODULE$.parser().parse$default$2())));
                Query lastQ = compacted = q.compact();
                while (lastQ.tail().nonEmpty()) {
                    lastQ = (Query)lastQ.tail().get();
                }
                TripleEqualsSupport.Equalizer<List> $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(lastQ.returns().columns());
                List $org_scalatest_assert_macro_right = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a1", "a4"}));
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Lost the tail while compacting");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle optional match following optional match", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Query last = Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "c", "r2", (Seq)Seq$.MODULE$.empty(), Direction.INCOMING)})).makeOptional().returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()}));
                Query second = Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("n", "b", "r1", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING)})).makeOptional().tail(last).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()}));
                Query first = Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).tail(second).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()}));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (n) OPTIONAL MATCH (n)-[r1]->(b) OPTIONAL MATCH (n)<-[r2]-(c) RETURN *", (AbstractQuery)first);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle match properties pointing to other parts of pattern", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SingleNode nodeA = new SingleNode("a", (Seq)Seq$.MODULE$.empty(), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"foo"), (Object)new Property((Expression)new Identifier("x"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("bar")))})));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (a { foo:x.bar })-->(x) RETURN *", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new RelatedTo(nodeA, new SingleNode("x", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3()), "  UNNAMED23", (Seq)Seq$.MODULE$.empty(), Direction.OUTGOING, (Map)Predef$.MODULE$.Map().empty())})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should allow both relationships and nodes to be set with maps", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("MATCH (a)-[r:KNOWS]->(b) SET r = { id: 42 }", (AbstractQuery)Query$.MODULE$.matches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{RelatedTo$.MODULE$.apply("a", "b", "r", "KNOWS", Direction.OUTGOING)})).tail(Query$.MODULE$.updates((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{new MapPropertySetAction((Expression)new Identifier("r"), (Expression)new LiteralMap((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"id"), (Object)new Literal((Object)BoxesRunTime.boxToInteger((int)42)))}))), true)})).returns((Seq)Nil$.MODULE$)).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should allow whitespace in multiple word operators", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("OPTIONAL\t MATCH (n) WHERE n  IS   NOT\n /* possibly */ NULL    RETURN n", (AbstractQuery)Query$.MODULE$.optionalMatches((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Pattern[]{new SingleNode("n", SingleNode$.MODULE$.apply$default$2(), SingleNode$.MODULE$.apply$default$3())})).where((Predicate)new Not((Predicate)new IsNull((Expression)new Identifier("n")))).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("n"), "n")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should allow append to empty collection", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("return [] + 1 AS result", (AbstractQuery)Query$.MODULE$.matches((Seq)Nil$.MODULE$).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Add((Expression)new Collection((Seq)Nil$.MODULE$), (Expression)new Literal((Object)BoxesRunTime.boxToInteger((int)1))), "result")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle load and return as map", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("LOAD CSV WITH HEADERS FROM 'file:///tmp/file.cvs' AS line RETURN line.key", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(true, (Expression)new Literal((Object)"file:///tmp/file.cvs"), "line", (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Identifier("line"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("key")), "line.key")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle LOAD CSV with the file URL specified as a parameter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("LOAD CSV WITH HEADERS FROM {path} AS line RETURN line.key", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(true, (Expression)new ParameterExpression("path"), "line", (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Property((Expression)new Identifier("line"), (KeyToken)TokenType.PropertyKey$.MODULE$.apply("key")), "line.key")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not handle LOAD CSV with the file URL specified being an arbitrary expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Statement apply() {
                        return ParserFixture$.MODULE$.parser().parse("MATCH n WITH n LOAD CSV WITH HEADERS FROM n.path AS line RETURN line.key", ParserFixture$.MODULE$.parser().parse$default$2());
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle load and return", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("LOAD CSV FROM 'file:///tmp/file.cvs' AS line RETURN line", (AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(false, (Expression)new Literal((Object)"file:///tmp/file.cvs"), "line", (Option)None$.MODULE$)})).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new ReturnItem((Expression)new Identifier("line"), "line")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse a periodic commit query with size followed by LOAD CSV", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("USING PERIODIC COMMIT 10 LOAD CSV FROM 'file:///tmp/foo.csv' AS line CREATE x", (AbstractQuery)new PeriodicCommitQuery((AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(false, (Expression)new Literal((Object)"file:///tmp/foo.csv"), "line", (Option)None$.MODULE$)})).tail(Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("x", (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$)).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})), (Option)new Some((Object)BoxesRunTime.boxToLong((long)10L))));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse a periodic commit query without size followed by LOAD CSV", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$parser$CypherParserTest$$expectQuery("USING PERIODIC COMMIT LOAD CSV FROM 'file:///tmp/foo.csv' AS line CREATE x", (AbstractQuery)new PeriodicCommitQuery((AbstractQuery)Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new LoadCSV(false, (Expression)new Literal((Object)"file:///tmp/foo.csv"), "line", (Option)None$.MODULE$)})).tail(Query$.MODULE$.start((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StartItem[]{new CreateNodeStartItem(new CreateNode("x", (Map)Predef$.MODULE$.Map().empty(), (Seq)Seq$.MODULE$.empty()))})).returns((Seq)Nil$.MODULE$)).returns((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReturnColumn[]{new AllIdentifiers()})), (Option)None$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject a periodic commit query not followed by LOAD CSV", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Statement apply() {
                        return ParserFixture$.MODULE$.parser().parse("USING PERIODIC COMMIT CREATE ()", ParserFixture$.MODULE$.parser().parse$default$2());
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should reject a periodic commit query followed by LOAD CSV and a union", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.intercept((Function0<Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Statement apply() {
                        return ParserFixture$.MODULE$.parser().parse("USING PERIODIC COMMIT LOAD CSV  FROM 'file:///tmp/foo.csv' AS line CREATE x UNION MATCH n RETURN n", ParserFixture$.MODULE$.parser().parse$default$2());
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

