/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.perty.recipe;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.perty.BreakDoc$;
import org.neo4j.cypher.internal.compiler.v2_2.perty.ConsDoc;
import org.neo4j.cypher.internal.compiler.v2_2.perty.ConsDoc$;
import org.neo4j.cypher.internal.compiler.v2_2.perty.Doc;
import org.neo4j.cypher.internal.compiler.v2_2.perty.GroupDoc;
import org.neo4j.cypher.internal.compiler.v2_2.perty.NestDoc;
import org.neo4j.cypher.internal.compiler.v2_2.perty.NilDoc$;
import org.neo4j.cypher.internal.compiler.v2_2.perty.PageDoc;
import org.neo4j.cypher.internal.compiler.v2_2.perty.TextDoc;
import org.neo4j.cypher.internal.compiler.v2_2.perty.recipe.PrintableDocRecipe;
import org.neo4j.cypher.internal.compiler.v2_2.perty.step.AddBreak$;
import org.neo4j.cypher.internal.compiler.v2_2.perty.step.AddText;
import org.neo4j.cypher.internal.compiler.v2_2.perty.step.PopFrame$;
import org.neo4j.cypher.internal.compiler.v2_2.perty.step.PrintableDocStep;
import org.neo4j.cypher.internal.compiler.v2_2.perty.step.PushGroupFrame$;
import org.neo4j.cypher.internal.compiler.v2_2.perty.step.PushNestFrame$;
import org.neo4j.cypher.internal.compiler.v2_2.perty.step.PushPageFrame$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}1A!\u0001\u0002\u0001'\t1\u0002K]5oi\u0006\u0014G.\u001a#pGJ+7-\u001b9f)\u0016\u001cHO\u0003\u0002\u0004\t\u00051!/Z2ja\u0016T!!\u0002\u0004\u0002\u000bA,'\u000f^=\u000b\u0005\u001dA\u0011\u0001\u0002<3?JR!!\u0003\u0006\u0002\u0011\r|W\u000e]5mKJT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\r\rL\b\u000f[3s\u0015\ty\u0001#A\u0003oK>$$NC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taC\u0003\u0002\u0018\u0015\u000591m\\7n_:\u001c\u0018BA\r\u0017\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQa\u0007\u0001\u0005\u0002q\ta\u0001P5oSRtD#A\u000f\u0011\u0005y\u0001Q\"\u0001\u0002")
public class PrintableDocRecipeTest
extends CypherFunSuite {
    public PrintableDocRecipeTest() {
        this.test("Builds complex document", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{new AddText("x"), PushGroupFrame$.MODULE$, PushNestFrame$.MODULE$, new AddText("y"), AddBreak$.MODULE$, new AddText("z"), PopFrame$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)new GroupDoc((Doc)new NestDoc((Doc)new ConsDoc((Doc)new TextDoc("y"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)new ConsDoc((Doc)new TextDoc("z"), ConsDoc$.MODULE$.apply$default$2()))))), (Doc)NilDoc$.MODULE$))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Builds multiple, unwrapped top-level leaves", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{new AddText("x"), AddBreak$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Builds nil doc for empty seq of doc ops", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(NilDoc$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Unwraps single top-level value doc in group", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AddText[]{new AddText("x")})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new TextDoc("x")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Makes groups containing non-consed doc", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushGroupFrame$.MODULE$, PushNestFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new GroupDoc((Doc)new NestDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$))))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Makes groups containing multiples leaves", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushGroupFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new GroupDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$)))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Returns nil when building group containing no leaves", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushGroupFrame$.MODULE$, PopFrame$.MODULE$})))).should(this.$outer.equal(NilDoc$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Unwraps double groupings", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushGroupFrame$.MODULE$, PushGroupFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new GroupDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$)))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Makes pages containing non-consed doc", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushPageFrame$.MODULE$, PushNestFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new PageDoc((Doc)new NestDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$))))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Makes pages containing multiples leaves", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushPageFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new PageDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$)))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Returns nil when building page containing no leaves", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushPageFrame$.MODULE$, PopFrame$.MODULE$})))).should(this.$outer.equal(NilDoc$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Unwraps single page in outer page", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushPageFrame$.MODULE$, PushPageFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new PageDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$)))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Makes nesting groups containing non-consed doc", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushNestFrame$.MODULE$, PushNestFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new NestDoc((Doc)new NestDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$))))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Makes nesting groups containing multiples leaves", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushNestFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new NestDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$)))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Returns nil when building nesting group containing no leaves", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushNestFrame$.MODULE$, PopFrame$.MODULE$})))).should(this.$outer.equal(NilDoc$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Does not unwrap double nesting groupings", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrintableDocRecipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Doc result = PrintableDocRecipe.eval$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PrintableDocStep[]{PushNestFrame$.MODULE$, PushNestFrame$.MODULE$, new AddText("x"), AddBreak$.MODULE$, PopFrame$.MODULE$, PopFrame$.MODULE$})));
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(new NestDoc((Doc)new NestDoc((Doc)new ConsDoc((Doc)new TextDoc("x"), (Doc)new ConsDoc((Doc)BreakDoc$.MODULE$, (Doc)NilDoc$.MODULE$))))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

