/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.pipes;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.LazyTypes;
import org.neo4j.cypher.internal.compiler.v2_2.spi.QueryContext;
import org.neo4j.cypher.internal.compiler.v2_2.spi.TokenContext;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001#\tiA*\u0019>z)f\u0004Xm\u001d+fgRT!a\u0001\u0003\u0002\u000bAL\u0007/Z:\u000b\u0005\u00151\u0011\u0001\u0002<3?JR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u000591m\\7n_:\u001c\u0018BA\f\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002")
public class LazyTypesTest
extends CypherFunSuite {
    public LazyTypesTest() {
        this.test("should not initialize state when state is complete", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyTypesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LazyTypes types = new LazyTypes((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})));
                QueryContext context = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)context.getOptRelTypeId("a")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)context.getOptRelTypeId("b")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)2)));
                Mockito.when((Object)context.getOptRelTypeId("c")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
                types.types(context);
                QueryContext newContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                types.types(newContext);
                Mockito.verifyZeroInteractions((Object[])new Object[]{newContext});
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should re-initialize if not fully initialized", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LazyTypesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LazyTypes types = new LazyTypes((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})));
                QueryContext context = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)context.getOptRelTypeId("a")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)context.getOptRelTypeId("b")).thenReturn((Object)None$.MODULE$);
                Mockito.when((Object)context.getOptRelTypeId("c")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
                types.types(context);
                QueryContext newContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Mockito.when((Object)newContext.getOptRelTypeId("a")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)));
                Mockito.when((Object)newContext.getOptRelTypeId("b")).thenReturn((Object)None$.MODULE$);
                Mockito.when((Object)newContext.getOptRelTypeId("c")).thenReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)3)));
                types.types(newContext);
                ((TokenContext)Mockito.verify((Object)newContext)).getOptRelTypeId("b");
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

