/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.pipes;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.commons.TestableIterator;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.NodeHashJoinPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.NodeHashJoinPipe$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.SymbolTable;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.package$;
import org.neo4j.graphdb.Node;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001#\t!bj\u001c3f\u0011\u0006\u001c\bNS8j]BK\u0007/\u001a+fgRT!a\u0001\u0003\u0002\u000bAL\u0007/Z:\u000b\u0005\u00151\u0011\u0001\u0002<3?JR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u000591m\\7n_:\u001c\u0018BA\f\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0002?\u00059Qn\u001c8ji>\u0014X#\u0001\u0011\u0011\u0005q\t\u0013B\u0001\u0012\u0003\u0005-\u0001\u0016\u000e]3N_:LGo\u001c:\t\r\u0011\u0002\u0001\u0015!\u0003!\u0003!iwN\\5u_J\u0004\u0003\"\u0002\u0014\u0001\t\u00139\u0013a\u0001:poR\u0011\u0001\u0006\f\t\u0003S)j\u0011\u0001B\u0005\u0003W\u0011\u0011\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000b5*\u0003\u0019\u0001\u0018\u0002\rY\fG.^3t!\ry#\u0007N\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\tQAH]3qK\u0006$X\r\u001a \u0011\t=*tGP\u0005\u0003mA\u0012a\u0001V;qY\u0016\u0014\u0004C\u0001\u001d<\u001d\ty\u0013(\u0003\u0002;a\u00051\u0001K]3eK\u001aL!\u0001P\u001f\u0003\rM#(/\u001b8h\u0015\tQ\u0004\u0007\u0005\u00020\u007f%\u0011\u0001\t\r\u0002\u0004\u0003:L\b\"\u0002\"\u0001\t\u0013\u0019\u0015!\u00048fo6{7m[3e\u001d>$W\r\u0006\u0002E\u0015B\u0011Q\tS\u0007\u0002\r*\u0011q\tD\u0001\bOJ\f\u0007\u000f\u001b3c\u0013\tIeI\u0001\u0003O_\u0012,\u0007\"B&B\u0001\u0004a\u0015AA5e!\tyS*\u0003\u0002Oa\t\u0019\u0011J\u001c;\t\u000bA\u0003A\u0011B)\u0002\u001b9,w/T8dW\u0016$\u0007+\u001b9f)\t\u0011V\u000b\u0005\u0002\u001d'&\u0011AK\u0001\u0002\u0005!&\u0004X\rC\u0003W\u001f\u0002\u0007q+A\u0006ts6\u0014w\u000e\u001c+bE2,\u0007C\u0001-\\\u001b\u0005I&B\u0001.\u0005\u0003\u001d\u0019\u00180\u001c2pYNL!\u0001X-\u0003\u0017MKXNY8m)\u0006\u0014G.\u001a")
public class NodeHashJoinPipeTest
extends CypherFunSuite {
    private final PipeMonitor monitor = (PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class));

    public PipeMonitor monitor() {
        return this.monitor;
    }

    public ExecutionContext org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row(Seq<Tuple2<String, Object>> values) {
        return ExecutionContext$.MODULE$.from(values);
    }

    /*
     * WARNING - void declaration
     */
    public Node org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(int id) {
        void var2_2;
        Node node2 = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        Mockito.when((Object)node2.toString()).thenReturn((Object)new StringBuilder().append((Object)"node - ").append((Object)((Object)BoxesRunTime.boxToInteger((int)id)).toString()).toString());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Pipe org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(SymbolTable symbolTable) {
        void var2_2;
        Pipe pipe = (Pipe)this.mock(ManifestFactory$.MODULE$.classType(Pipe.class));
        Mockito.when((Object)pipe.sources()).thenReturn((Object)Seq$.MODULE$.empty());
        Mockito.when((Object)pipe.symbols()).thenReturn((Object)symbolTable);
        return var2_2;
    }

    public NodeHashJoinPipeTest() {
        this.test("should support simple hash join over nodes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                Node node3 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(3);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node1)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2)}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node3)}))})));
                Set x$2 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$3 = left;
                Pipe x$4 = right;
                Option x$5 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$2, x$3, x$4);
                Iterator result = new NodeHashJoinPipe(x$2, x$3, x$4, x$5, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Object apply(ExecutionContext x$1) {
                        return x$1.apply((Object)"b");
                    }
                }).toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{node2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should support joining on two different identifiers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node0 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(0);
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                ExecutionContext[] executionContextArray = new ExecutionContext[5];
                executionContextArray[0] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1))}));
                executionContextArray[1] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)2))}));
                executionContextArray[2] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)3))}));
                executionContextArray[3] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)4))}));
                Tuple2[] tuple2Array = new Tuple2[3];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0);
                tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), null);
                tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)5));
                executionContextArray[4] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])executionContextArray)));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                ExecutionContext[] executionContextArray2 = new ExecutionContext[4];
                executionContextArray2[0] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)1))}));
                executionContextArray2[1] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)2))}));
                executionContextArray2[2] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)3))}));
                Tuple2[] tuple2Array2 = new Tuple2[3];
                tuple2Array2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), null);
                tuple2Array2[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2);
                tuple2Array2[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)4));
                executionContextArray2[3] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])executionContextArray2)));
                Set x$6 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"}));
                Pipe x$7 = left;
                Pipe x$8 = right;
                Option x$9 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$6, x$7, x$8);
                List result = new NodeHashJoinPipe(x$6, x$7, x$8, x$9, this.$outer.monitor()).createResults(queryState).toList();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)1))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)2))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)node0), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"d"), (Object)BoxesRunTime.boxToInteger((int)2))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should work when the inner pipe produces multiple rows with the same join key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)10))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))})));
                Set x$10 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$11 = left;
                Pipe x$12 = right;
                Option x$13 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$10, x$11, x$12);
                Iterator result = new NodeHashJoinPipe(x$10, x$11, x$12, x$13, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))})), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should work when the outer pipe produces rows with a null key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                ExecutionContext[] executionContextArray = new ExecutionContext[2];
                Tuple2[] tuple2Array = new Tuple2[2];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), null);
                tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)10));
                executionContextArray[0] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                executionContextArray[1] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])executionContextArray)));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))})));
                Set x$14 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$15 = left;
                Pipe x$16 = right;
                Option x$17 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$14, x$15, x$16);
                Iterator result = new NodeHashJoinPipe(x$14, x$15, x$16, x$17, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should work when the inner pipe produces rows with a null key", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)10))})), this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)20))}))})));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                ExecutionContext[] executionContextArray = new ExecutionContext[2];
                Tuple2[] tuple2Array = new Tuple2[2];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), null);
                tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)30));
                executionContextArray[0] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                executionContextArray[1] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])executionContextArray)));
                Set x$18 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$19 = left;
                Pipe x$20 = right;
                Option x$21 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$18, x$19, x$20);
                Iterator result = new NodeHashJoinPipe(x$18, x$19, x$20, x$21, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result.toList()).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new scala.collection.immutable.Map[]{(scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"c"), (Object)BoxesRunTime.boxToInteger((int)40))}))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not fetch results from RHS if LHS is empty", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().empty());
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Set x$22 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$23 = left;
                Pipe x$24 = right;
                Option x$25 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$22, x$23, x$24);
                Iterator result = new NodeHashJoinPipe(x$22, x$23, x$24, x$25, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                ((Pipe)Mockito.verify((Object)right, (VerificationMode)Mockito.times((int)0))).createResults((QueryState)Matchers.any());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not fetch results from RHS if no probe table was built", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                ExecutionContext[] executionContextArray = new ExecutionContext[2];
                Tuple2[] tuple2Array = new Tuple2[1];
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), null);
                executionContextArray[0] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
                Tuple2[] tuple2Array2 = new Tuple2[1];
                tuple2Array2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), null);
                executionContextArray[1] = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])executionContextArray)));
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                TestableIterator<A> rhsIterator = new TestableIterator<A>(scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(0))}))})));
                Mockito.when((Object)left.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().empty());
                Set x$26 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$27 = left;
                Pipe x$28 = right;
                Option x$29 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$26, x$27, x$28);
                Iterator result = new NodeHashJoinPipe(x$26, x$27, x$28, x$29, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)rhsIterator.fetched())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("if RHS is empty, terminate building of the probe map early", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ NodeHashJoinPipeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryState queryState = QueryStateHelper$.MODULE$.empty();
                Pipe left = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Node node1 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(1);
                Node node2 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedNode(2);
                TestableIterator<A> lhsIterator = new TestableIterator<A>(scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node1)})), this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$row((Seq<Tuple2<String, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)node2)}))})));
                Mockito.when((Object)left.createResults(queryState)).thenReturn(lhsIterator);
                Pipe right = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$pipes$NodeHashJoinPipeTest$$newMockedPipe(new SymbolTable((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"b"), (Object)package$.MODULE$.CTNode())}))));
                Mockito.when((Object)right.createResults(queryState)).thenReturn((Object)scala.package$.MODULE$.Iterator().empty());
                Set x$30 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"}));
                Pipe x$31 = left;
                Pipe x$32 = right;
                Option x$33 = NodeHashJoinPipe$.MODULE$.apply$default$4(x$30, x$31, x$32);
                Iterator result = new NodeHashJoinPipe(x$30, x$31, x$32, x$33, this.$outer.monitor()).createResults(queryState);
                this.$outer.convertToAnyShouldWrapper(result).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfAnyRefWithParameterlessIsEmptyMethod());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)lhsIterator.fetched())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

