/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.pipes.matching;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.AddedHistory;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.InitialHistory;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.MatchingPair;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.PatternElement;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.PatternNode;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.PatternNode$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.matching.PatternRelationship;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Relationship;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)2A!\u0001\u0002\u0001'\tY\u0001*[:u_JLH+Z:u\u0015\t\u0019A!\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\t)a!A\u0003qSB,7O\u0003\u0002\b\u0011\u0005!aOM03\u0015\tI!\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYA\"\u0001\u0005j]R,'O\\1m\u0015\tia\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001fA\tQA\\3pi)T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!\u0006\r\u000e\u0003YQ!a\u0006\u0006\u0002\u000f\r|W.\\8og&\u0011\u0011D\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015Y\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\t!\u0001C\u0004!\u0001\t\u0007I\u0011A\u0011\u0002\u0007QL\b/F\u0001#!\t\u0019c%D\u0001%\u0015\t)c\"A\u0004he\u0006\u0004\b\u000e\u001a2\n\u0005\u001d\"#a\u0006#z]\u0006l\u0017n\u0019*fY\u0006$\u0018n\u001c8tQ&\u0004H+\u001f9f\u0011\u0019I\u0003\u0001)A\u0005E\u0005!A/\u001f9!\u0001")
public class HistoryTest
extends CypherFunSuite {
    private final DynamicRelationshipType typ = DynamicRelationshipType.withName((String)"REL");

    public DynamicRelationshipType typ() {
        return this.typ;
    }

    public HistoryTest() {
        this.test("excludingPatternRelsWorksAsExpected", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HistoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PatternNode a = new PatternNode("a", PatternNode$.MODULE$.$lessinit$greater$default$2(), PatternNode$.MODULE$.$lessinit$greater$default$3());
                PatternNode b = new PatternNode("b", PatternNode$.MODULE$.$lessinit$greater$default$2(), PatternNode$.MODULE$.$lessinit$greater$default$3());
                PatternRelationship pr = a.relateTo("r", b, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), Direction.BOTH, a.relateTo$default$5());
                Relationship r = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                MatchingPair mp = new MatchingPair((PatternElement)pr, (Object)r);
                AddedHistory history = new InitialHistory(ExecutionContext$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty()).add(mp);
                this.$outer.convertToAnyShouldWrapper(history.removeSeen((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PatternRelationship[]{pr})))).shouldBe(this.$outer.empty(), Emptiness$.MODULE$.emptinessOfGenTraversable());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_known_that_it_has_seen_a_relationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HistoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship r = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                InitialHistory history = new InitialHistory(ExecutionContext$.MODULE$.empty(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{r})));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)history.hasSeen((Object)r))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should_know_that_it_has_not_seen_a_relationship", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HistoryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship r = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                InitialHistory history = new InitialHistory(ExecutionContext$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)history.hasSeen((Object)r))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

