/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.planDescription;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.Children;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.NoChildren$;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.SingleChild;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.TwoChildren;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001#\tY\u0012J\u001c;fe:\fG\u000e\u00157b]\u0012+7o\u0019:jaRLwN\u001c+fgRT!a\u0001\u0003\u0002\u001fAd\u0017M\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:T!!\u0002\u0004\u0002\tY\u0014tL\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)\u0002\"A\u0004d_6lwN\\:\n\u0005]!\"AD\"za\",'OR;o'VLG/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\u0002}\tA\u0001]5qKV\t\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$\t\u0005)\u0001/\u001b9fg&\u0011QE\t\u0002\u0005!&\u0004X\r")
public class InternalPlanDescriptionTest
extends CypherFunSuite {
    public Pipe pipe() {
        return (Pipe)this.mock(ManifestFactory$.MODULE$.classType(Pipe.class));
    }

    public InternalPlanDescriptionTest() {
        this.test("flatten behaves like expected for plan with two children", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InternalPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl child1 = new PlanDescriptionImpl(this.$outer.pipe(), "child1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl child2 = new PlanDescriptionImpl(this.$outer.pipe(), "child2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl top = new PlanDescriptionImpl(this.$outer.pipe(), "top", (Children)new TwoChildren((InternalPlanDescription)child1, (InternalPlanDescription)child2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(top.flatten()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlanDescriptionImpl[]{top, child1, child2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("single plan flattened stays single", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InternalPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl single2 = new PlanDescriptionImpl(this.$outer.pipe(), "single", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(single2.flatten()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlanDescriptionImpl[]{single2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("left leaning plan should also flatten out nicely", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InternalPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.pipe(), "leaf", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl lvl1 = new PlanDescriptionImpl(this.$outer.pipe(), "lvl1", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl lvl2 = new PlanDescriptionImpl(this.$outer.pipe(), "lvl2", (Children)new SingleChild((InternalPlanDescription)lvl1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl root = new PlanDescriptionImpl(this.$outer.pipe(), "root", (Children)new SingleChild((InternalPlanDescription)lvl2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(root.flatten()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlanDescriptionImpl[]{root, lvl2, lvl1, leaf}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("bushy tree flattens correctly", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InternalPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl C4 = new PlanDescriptionImpl(this.$outer.pipe(), "C4", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl C3 = new PlanDescriptionImpl(this.$outer.pipe(), "C3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl C2 = new PlanDescriptionImpl(this.$outer.pipe(), "C2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl C1 = new PlanDescriptionImpl(this.$outer.pipe(), "C1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl B2 = new PlanDescriptionImpl(this.$outer.pipe(), "B2", (Children)new TwoChildren((InternalPlanDescription)C3, (InternalPlanDescription)C4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl B1 = new PlanDescriptionImpl(this.$outer.pipe(), "B1", (Children)new TwoChildren((InternalPlanDescription)C1, (InternalPlanDescription)C2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl A = new PlanDescriptionImpl(this.$outer.pipe(), "A", (Children)new TwoChildren((InternalPlanDescription)B1, (InternalPlanDescription)B2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(A.flatten()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlanDescriptionImpl[]{A, B1, C1, C2, B2, C3, C4}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

