/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.planDescription;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.SingleRowPipe;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.Argument;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.Children;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.NoChildren$;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.SingleChild;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.TwoChildren;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.renderAsTree$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001!2A!\u0001\u0002\u0001#\t\t\"+\u001a8eKJ\f5\u000f\u0016:fKR+7\u000f^:\u000b\u0005\r!\u0011a\u00049mC:$Um]2sSB$\u0018n\u001c8\u000b\u0005\u00151\u0011\u0001\u0002<3?JR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0011\u000591m\\7n_:\u001c\u0018BA\f\u0015\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0001?\u0005!\u0001/\u001b9f+\u0005\u0001\u0003CA\u0011%\u001b\u0005\u0011#BA\u0012\u0005\u0003\u0015\u0001\u0018\u000e]3t\u0013\t)#EA\u0007TS:<G.\u001a*poBK\u0007/\u001a\u0005\u0007O\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u000bAL\u0007/\u001a\u0011")
public class RenderAsTreeTests
extends CypherFunSuite {
    private final SingleRowPipe pipe = new SingleRowPipe((PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));

    public SingleRowPipe pipe() {
        return this.pipe;
    }

    public RenderAsTreeTests() {
        this.test("single node is represented nicely", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderAsTreeTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(renderAsTree$.MODULE$.apply((InternalPlanDescription)new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)))).should(this.$outer.equal("NAME"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding from other node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderAsTreeTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = leaf.andThen((Pipe)this.$outer.mock(ManifestFactory$.MODULE$.classType(Pipe.class)), "ROOT", (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[0]));
                this.$outer.convertToStringShouldWrapper(renderAsTree$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("ROOT\n        |  |\n        |  +LEAF")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding from two nodes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderAsTreeTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTree$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("ROOT\n        |  |\n        |  +LEAF1\n        |  |\n        |  +LEAF2")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("node feeding of node that is feeding of node", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderAsTreeTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "INTERMEDIATE", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "ROOT", (Children)new SingleChild((InternalPlanDescription)intermediate), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                String tree = renderAsTree$.MODULE$.apply((InternalPlanDescription)plan);
                this.$outer.convertToStringShouldWrapper(tree).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("ROOT\n        |  |\n        |  +INTERMEDIATE\n        |    |\n        |    +LEAF")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two auto named nodes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderAsTreeTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                String tree = renderAsTree$.MODULE$.apply((InternalPlanDescription)plan);
                this.$outer.convertToStringShouldWrapper(tree).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("ROOT\n        |  |\n        |  +LEAF(0)\n        |  |\n        |  +LEAF(1)")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two leafs, one of which is deep", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderAsTreeTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)intermediate, (InternalPlanDescription)leaf3), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTree$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal("ROOT\n  |\n  +INTERMEDIATE\n  |  |\n  |  +LEAF1\n  |  |\n  |  +LEAF2\n  |\n  +LEAF3"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("root with two intermediate nodes coming from four leaf nodes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderAsTreeTests $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf1 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl leaf2 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                PlanDescriptionImpl leaf3 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"c"})));
                PlanDescriptionImpl leaf4 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "LEAF", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"d"})));
                PlanDescriptionImpl intermediate1 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf1, (InternalPlanDescription)leaf2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl intermediate2 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "INTERMEDIATE", (Children)new TwoChildren((InternalPlanDescription)leaf3, (InternalPlanDescription)leaf4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "ROOT", (Children)new TwoChildren((InternalPlanDescription)intermediate1, (InternalPlanDescription)intermediate2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToStringShouldWrapper(renderAsTree$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("ROOT\n        |  |\n        |  +INTERMEDIATE(0)\n        |  |  |\n        |  |  +LEAF(0)\n        |  |  |\n        |  |  +LEAF(1)\n        |  |\n        |  +INTERMEDIATE(1)\n        |     |\n        |     +LEAF(2)\n        |     |\n        |     +LEAF(3)")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

