/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.planDescription;

import java.util.Locale;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.commands.HasLabel;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Not;
import org.neo4j.cypher.internal.compiler.v2_2.commands.Predicate;
import org.neo4j.cypher.internal.compiler.v2_2.commands.PropertyExists;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.LengthFunction;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Property;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.KeyToken;
import org.neo4j.cypher.internal.compiler.v2_2.commands.values.TokenType;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.ExpandAllPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.LazyLabel;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.LazyTypes$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.NodeByLabelScanPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.NodeHashJoinPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.SingleRowPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.VarLengthExpandPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.VarLengthExpandPipe$;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.Argument;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.Children;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.NoChildren$;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.SingleChild;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.renderDetails$;
import org.neo4j.graphdb.Direction;
import org.scalactic.Equality$;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.ConfigMap;
import org.scalatest.FunSuiteLike;
import org.scalatest.Status;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00193A!\u0001\u0002\u0001#\t\u0001#+\u001a8eKJ\u0004F.\u00198EKN\u001c'/\u001b9uS>tG)\u001a;bS2\u001cH+Z:u\u0015\t\u0019A!A\bqY\u0006tG)Z:de&\u0004H/[8o\u0015\t)a!\u0001\u0003we}\u0013$BA\u0004\t\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0005\u000b\u0003!Ig\u000e^3s]\u0006d'BA\u0006\r\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011QBD\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011aB2p[6|gn]\u0005\u0003/Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\r\u0005\u0002\u001a95\t!D\u0003\u0002\u001c\u001d\u0005I1oY1mCR,7\u000f^\u0005\u0003;i\u0011\u0011CQ3g_J,\u0017I\u001c3BMR,'/\u00117m\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t!\u0001C\u0004%\u0001\t\u0007I\u0011B\u0013\u0002\u001b\u0011,g-Y;mi2{7-\u00197f+\u00051\u0003CA\u0014-\u001b\u0005A#BA\u0015+\u0003\u0011)H/\u001b7\u000b\u0003-\nAA[1wC&\u0011Q\u0006\u000b\u0002\u0007\u0019>\u001c\u0017\r\\3\t\r=\u0002\u0001\u0015!\u0003'\u00039!WMZ1vYRdunY1mK\u0002BQ!\r\u0001\u0005BI\n\u0011BY3g_J,\u0017\t\u001c7\u0015\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012A!\u00168ji\")!\b\u0001C!e\u0005A\u0011M\u001a;fe\u0006cG\u000eC\u0004=\u0001\t\u0007I\u0011A\u001f\u0002\tAL\u0007/Z\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tB\u0001\u0006a&\u0004Xm]\u0005\u0003\u0007\u0002\u0013QbU5oO2,'k\\<QSB,\u0007BB#\u0001A\u0003%a(A\u0003qSB,\u0007\u0005")
public class RenderPlanDescriptionDetailsTest
extends CypherFunSuite
implements BeforeAndAfterAll {
    private final Locale defaultLocale;
    private final SingleRowPipe pipe;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return FunSuiteLike.class.run((FunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public void beforeAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.beforeAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    public void afterAll(ConfigMap configMap) {
        BeforeAndAfterAll.class.afterAll((BeforeAndAfterAll)this, (ConfigMap)configMap);
    }

    @Override
    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.class.run((BeforeAndAfterAll)this, testName, (Args)args);
    }

    private Locale defaultLocale() {
        return this.defaultLocale;
    }

    public void beforeAll() {
        Locale.setDefault(Locale.US);
    }

    public void afterAll() {
        Locale.setDefault(this.defaultLocale());
    }

    public SingleRowPipe pipe() {
        return this.pipe;
    }

    public RenderPlanDescriptionDetailsTest() {
        BeforeAndAfterAll.class.$init$((BeforeAndAfterAll)this);
        this.defaultLocale = Locale.getDefault();
        this.pipe = new SingleRowPipe((PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
        this.test("single node is represented nicely", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+-------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers | Other |\n        |+----------+---------------+------+--------+-------------+-------+\n        ||     NAME |             1 |   42 |     33 |           n |       |\n        |+----------+---------------+------+--------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("extra identifiers are not a problem", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+-------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers | Other |\n        |+----------+---------------+------+--------+-------------+-------+\n        ||     NAME |             1 |   42 |     33 |     a, b, c |       |\n        |+----------+---------------+------+--------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("super many identifiers stretches the column", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L)}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c", "d", "e", "f"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+------------------+-------+\n        || Operator | EstimatedRows | Rows | DbHits |      Identifiers | Other |\n        |+----------+---------------+------+--------+------------------+-------+\n        ||     NAME |             1 |   42 |     33 | a, b, c, d, e, f |       |\n        |+----------+---------------+------+--------+------------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("execution plan without profiler stats are not shown", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+-------------+-------+\n        || Operator | EstimatedRows | Identifiers | Other |\n        |+----------+---------------+-------------+-------+\n        ||     NAME |             1 |           n |       |\n        |+----------+---------------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("two plans with the same name get unique-ified names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq args1 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L)}));
                Seq args2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(2L), new InternalPlanDescription.Arguments$.DbHits(633L), new InternalPlanDescription.Arguments$.Index("Label", "Prop")}));
                PlanDescriptionImpl plan1 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, args1, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"})));
                PlanDescriptionImpl plan2 = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)new SingleChild((InternalPlanDescription)plan1), args2, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan2)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+--------------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers |        Other |\n        |+----------+---------------+------+--------+-------------+--------------+\n        ||  NAME(0) |             1 |    2 |    633 |           b | :Label(Prop) |\n        ||  NAME(1) |             1 |   42 |     33 |           a |              |\n        |+----------+---------------+------+--------+-------------+--------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Expand contains information about its relations", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L)}));
                ExpandAllPipe expandPipe = new ExpandAllPipe((Pipe)this.$outer.pipe(), "from", "rel", "to", Direction.INCOMING, LazyTypes$.MODULE$.empty(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)expandPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-------------+---------------+-------------+---------------------+\n        ||    Operator | EstimatedRows | Identifiers |               Other |\n        |+-------------+---------------+-------------+---------------------+\n        || Expand(All) |             1 |     rel, to | (from)<-[rel:]-(to) |\n        |+-------------+---------------+-------------+---------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Label scan should be just as pretty as you would expect", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeByLabelScanPipe pipe = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)pipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+---------------+-------------+-------+\n        ||        Operator | EstimatedRows | Identifiers | Other |\n        |+-----------------+---------------+-------------+-------+\n        || NodeByLabelScan |             1 |           n |  :Foo |\n        |+-----------------+---------------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("Var length expand contains information about its relations", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L)}));
                VarLengthExpandPipe expandPipe = new VarLengthExpandPipe((Pipe)this.$outer.pipe(), "from", "rel", "to", Direction.INCOMING, Direction.OUTGOING, LazyTypes$.MODULE$.empty(), 0, (Option)None$.MODULE$, false, VarLengthExpandPipe$.MODULE$.apply$default$11(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)expandPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------------------+---------------+-------------+----------------------+\n        ||             Operator | EstimatedRows | Identifiers |                Other |\n        |+----------------------+---------------+-------------+----------------------+\n        || VarLengthExpand(All) |             1 |     rel, to | (from)-[rel:*]->(to) |\n        |+----------------------+---------------+-------------+----------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("do not show unnamed identifiers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.ExpandExpression("  UNNAMED123", "R", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WHOOP"})), "  UNNAMED24", Direction.OUTGOING, InternalPlanDescription.Arguments$.ExpandExpression$.MODULE$.apply$default$6())}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n", "  UNNAMED123", "  FRESHID12", "  AGGREGATION255"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-----------------------------------+------------------+\n        || Operator | EstimatedRows | Rows | DbHits |                       Identifiers |            Other |\n        |+----------+---------------+------+--------+-----------------------------------+------------------+\n        ||     NAME |             1 |   42 |     33 | anon[255], anon[12], anon[123], n | ()-[R:WHOOP]->() |\n        |+----------+---------------+------+--------+-----------------------------------+------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("show multiple relationship types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.ExpandExpression("source", "through", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SOME", "OTHER", "THING"})), "target", Direction.OUTGOING, InternalPlanDescription.Arguments$.ExpandExpression$.MODULE$.apply$default$6())}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+-------------------------------------------------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers |                                           Other |\n        |+----------+---------------+------+--------+-------------+-------------------------------------------------+\n        ||     NAME |             1 |   42 |     33 |           n | (source)-[through:SOME|:OTHER|:THING]->(target) |\n        |+----------+---------------+------+--------+-------------+-------------------------------------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("show nicer output instead of unnamed identifiers in equals expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Not((Predicate)new Equals((Expression)new Identifier("  UNNAMED123"), (Expression)new Identifier("  UNNAMED321"))))}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+-----------------------------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers |                       Other |\n        |+----------+---------------+------+--------+-------------+-----------------------------+\n        ||     NAME |             1 |   42 |     33 |           n | NOT(anon[123] == anon[321]) |\n        |+----------+---------------+------+--------+-------------+-----------------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("show hasLabels nicely without token id", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new HasLabel((Expression)new Identifier("x"), (KeyToken)new KeyToken.Resolved("Artist", 5, (TokenType)TokenType.Label$.MODULE$)))}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+----------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers |    Other |\n        |+----------+---------------+------+--------+-------------+----------+\n        ||     NAME |             1 |   42 |     33 |           n | x:Artist |\n        |+----------+---------------+------+--------+-------------+----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("format length properly", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new LengthFunction((Expression)new Identifier("n")))}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+-----------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers |     Other |\n        |+----------+---------------+------+--------+-------------+-----------+\n        ||     NAME |             1 |   42 |     33 |           n | length(n) |\n        |+----------+---------------+------+--------+-------------+-----------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("don't leak deduped names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Identifier("  id@23"))}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  n@76"})));
                String details = renderDetails$.MODULE$.apply((InternalPlanDescription)plan);
                this.$outer.convertToStringShouldWrapper(details).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+-------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers | Other |\n        |+----------+---------------+------+--------+-------------+-------+\n        ||     NAME |             1 |   42 |     33 |           n |    id |\n        |+----------+---------------+------+--------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("don't render planner in Other", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.Planner("COST"), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Identifier("  id@23"))}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+-------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers | Other |\n        |+----------+---------------+------+--------+-------------+-------+\n        ||     NAME |             1 |   42 |     33 |           n |    id |\n        |+----------+---------------+------+--------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("round estimated rows to int", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeByLabelScanPipe pipe1 = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)0.00123456789)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                NodeByLabelScanPipe pipe2 = new NodeByLabelScanPipe("n", new LazyLabel("Foo"), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)1.23456789)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)pipe1.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+---------------+-------------+-------+\n        ||        Operator | EstimatedRows | Identifiers | Other |\n        |+-----------------+---------------+-------------+-------+\n        || NodeByLabelScan |             0 |           n |  :Foo |\n        |+-----------------+---------------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)pipe2.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+-----------------+---------------+-------------+-------+\n        ||        Operator | EstimatedRows | Identifiers | Other |\n        |+-----------------+---------------+-------------+-------+\n        || NodeByLabelScan |             1 |           n |  :Foo |\n        |+-----------------+---------------+-------------+-------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("properly show Property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new Property((Expression)new Identifier("x"), (KeyToken)new KeyToken.Resolved("Artist", 5, (TokenType)TokenType.PropertyKey$.MODULE$)))}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+----------+\n                   || Operator | EstimatedRows | Rows | DbHits | Identifiers |    Other |\n                   |+----------+---------------+------+--------+-------------+----------+\n                   ||     NAME |             1 |   42 |     33 |           n | x.Artist |\n                   |+----------+---------------+------+--------+-------------+----------+\n                   |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("show hasProp with identifier and property", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L), new InternalPlanDescription.Arguments$.LegacyExpression((Expression)new PropertyExists((Expression)new Identifier("x"), (KeyToken)new KeyToken.Resolved("prop", 42, (TokenType)TokenType.PropertyKey$.MODULE$)))}));
                PlanDescriptionImpl plan = new PlanDescriptionImpl((Pipe)this.$outer.pipe(), "NAME", (Children)NoChildren$.MODULE$, arguments, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"n"})));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply((InternalPlanDescription)plan)).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+----------+---------------+------+--------+-------------+-----------------+\n        || Operator | EstimatedRows | Rows | DbHits | Identifiers |           Other |\n        |+----------+---------------+------+--------+-------------+-----------------+\n        ||     NAME |             1 |   42 |     33 |           n | hasProp(x.prop) |\n        |+----------+---------------+------+--------+-------------+-----------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("don't show unnamed identifiers in key names", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RenderPlanDescriptionDetailsTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                NodeHashJoinPipe joinPipe = new NodeHashJoinPipe((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "  UNNAMED45", "  FRESHID77"})), (Pipe)this.$outer.pipe(), (Pipe)this.$outer.pipe(), (Option)new Some((Object)BoxesRunTime.boxToDouble((double)42.0)), (PipeMonitor)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class)));
                Seq arguments = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Argument[]{new InternalPlanDescription.Arguments$.Rows(42L), new InternalPlanDescription.Arguments$.DbHits(33L)}));
                this.$outer.convertToStringShouldWrapper(renderDetails$.MODULE$.apply(joinPipe.planDescription())).should(this.$outer.equal(new StringOps(Predef$.MODULE$.augmentString("+--------------+---------------+-------------+-----------------------+\n        ||     Operator | EstimatedRows | Identifiers |                 Other |\n        |+--------------+---------------+-------------+-----------------------+\n        || NodeHashJoin |            42 |             | a, anon[45], anon[77] |\n        ||  Argument(1) |             - |             |                       |\n        ||  Argument(1) |             - |             |                       |\n        |+--------------+---------------+-------------+-----------------------+\n        |")).stripMargin()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

