/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.planner;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.InputPosition;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.compiler.v2_2.ast.AstConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Equals;
import org.neo4j.cypher.internal.compiler.v2_2.ast.Identifier;
import org.neo4j.cypher.internal.compiler.v2_2.ast.SortItem;
import org.neo4j.cypher.internal.compiler.v2_2.ast.UnsignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.compiler.v2_2.planner.PlannerQuery;
import org.neo4j.cypher.internal.compiler.v2_2.planner.PlannerQuery$;
import org.neo4j.cypher.internal.compiler.v2_2.planner.PlannerQueryTest$;
import org.neo4j.cypher.internal.compiler.v2_2.planner.QueryGraph;
import org.neo4j.cypher.internal.compiler.v2_2.planner.QueryGraph$;
import org.neo4j.cypher.internal.compiler.v2_2.planner.QueryHorizon;
import org.neo4j.cypher.internal.compiler.v2_2.planner.QueryProjection$;
import org.neo4j.cypher.internal.compiler.v2_2.planner.QueryShuffle;
import org.neo4j.cypher.internal.compiler.v2_2.planner.QueryShuffle$;
import org.neo4j.cypher.internal.compiler.v2_2.planner.RegularQueryProjection;
import org.neo4j.cypher.internal.compiler.v2_2.planner.Selections;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.plans.IdName;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.plans.LazyMode$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\r2A!\u0001\u0002\u0001#\t\u0001\u0002\u000b\\1o]\u0016\u0014\u0018+^3ssR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\u001d7b]:,'O\u0003\u0002\u0006\r\u0005!aOM03\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\t\u0003\u001d\u0019w.\\7p]NL!a\u0006\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uKB\u0011\u0011\u0004H\u0007\u00025)\u00111\u0004B\u0001\u0004CN$\u0018BA\u000f\u001b\u0005i\t5\u000f^\"p]N$(/^2uS>tG+Z:u'V\u0004\bo\u001c:u\u0011\u0015y\u0002\u0001\"\u0001!\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0005\u0005\u0002#\u00015\t!\u0001")
public class PlannerQueryTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    @Override
    public InputPosition pos() {
        return this.pos;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_2$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    @Override
    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport$class.withPos(this, expr);
    }

    @Override
    public Identifier ident(String name) {
        return AstConstructionTestSupport$class.ident(this, name);
    }

    @Override
    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport$class.propEquality(this, identifier, propKey, intValue);
    }

    public PlannerQueryTest() {
        AstConstructionTestSupport$class.$init$(this);
        this.test("pair map", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryGraph qg3;
                QueryGraph qg1 = QueryGraph$.MODULE$.empty();
                QueryGraph qg2 = QueryGraph$.MODULE$.empty();
                QueryGraph x$1 = qg3 = QueryGraph$.MODULE$.empty();
                None$ x$2 = None$.MODULE$;
                QueryHorizon x$3 = PlannerQuery$.MODULE$.apply$default$2();
                PlannerQuery pq3 = new PlannerQuery(x$1, x$3, (Option)x$2);
                QueryGraph x$4 = qg2;
                Some x$5 = new Some((Object)pq3);
                QueryHorizon x$6 = PlannerQuery$.MODULE$.apply$default$2();
                PlannerQuery pq2 = new PlannerQuery(x$4, x$6, (Option)x$5);
                QueryGraph x$7 = qg1;
                Some x$8 = new Some((Object)pq2);
                QueryHorizon x$9 = PlannerQuery$.MODULE$.apply$default$2();
                PlannerQuery pq1 = new PlannerQuery(x$7, x$9, (Option)x$8);
                ObjectRef seenOnPos1 = new ObjectRef((Object)List$.MODULE$.empty());
                ObjectRef seenOnPos2 = new ObjectRef((Object)List$.MODULE$.empty());
                PlannerQuery result = pq1.foldMap((Function2)new Serializable(this, seenOnPos1, seenOnPos2){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef seenOnPos1$1;
                    private final ObjectRef seenOnPos2$1;

                    public final PlannerQuery apply(PlannerQuery x0$1, PlannerQuery x1$1) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null) {
                                PlannerQuery plannerQuery = pq1;
                                if (pq2 != null) {
                                    PlannerQuery plannerQuery2 = pq2;
                                    this.seenOnPos1$1.elem = (List)((List)this.seenOnPos1$1.elem).$colon$plus((Object)plannerQuery, List$.MODULE$.canBuildFrom());
                                    this.seenOnPos2$1.elem = (List)((List)this.seenOnPos2$1.elem).$colon$plus((Object)plannerQuery2, List$.MODULE$.canBuildFrom());
                                    PlannerQuery plannerQuery3 = plannerQuery2;
                                    return plannerQuery3;
                                }
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.seenOnPos1$1 = seenOnPos1$1;
                        this.seenOnPos2$1 = seenOnPos2$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper((List)seenOnPos1.elem).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlannerQuery[]{pq1, pq2}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper((List)seenOnPos2.elem).should(this.$outer.equal(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlannerQuery[]{pq2, pq3}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(pq1), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("foldMap on single plannerQuery returns that PQ", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QueryGraph x$10 = QueryGraph$.MODULE$.empty();
                None$ x$11 = None$.MODULE$;
                QueryHorizon x$12 = PlannerQuery$.MODULE$.apply$default$2();
                PlannerQuery input = new PlannerQuery(x$10, x$12, (Option)x$11);
                PlannerQuery result = input.foldMap((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final PlannerQuery apply(PlannerQuery x0$2, PlannerQuery x1$2) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$2, (Object)x1$2);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null && pq2 != null) {
                                throw this.$outer.org$neo4j$cypher$internal$compiler$v2_2$planner$PlannerQueryTest$$anonfun$$$outer().fail("should not pass through here");
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(input), (Object)Equality$.MODULE$.default());
            }

            public /* synthetic */ PlannerQueryTest org$neo4j$cypher$internal$compiler$v2_2$planner$PlannerQueryTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("foldMap plannerQuery with tail should change when reverseMapped", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlannerQuery tail = new PlannerQuery(QueryGraph$.MODULE$.empty(), PlannerQuery$.MODULE$.apply$default$2(), PlannerQuery$.MODULE$.apply$default$3());
                QueryGraph firstQueryGraph = QueryGraph$.MODULE$.empty();
                Set x$13 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IdName[]{new IdName("a")}));
                Set x$14 = QueryGraph$.MODULE$.apply$default$1();
                Set x$15 = QueryGraph$.MODULE$.apply$default$3();
                Selections x$16 = QueryGraph$.MODULE$.apply$default$4();
                Seq x$17 = QueryGraph$.MODULE$.apply$default$5();
                Set x$18 = QueryGraph$.MODULE$.apply$default$6();
                Set x$19 = QueryGraph$.MODULE$.apply$default$7();
                QueryGraph secondQueryGraph = new QueryGraph(x$14, x$13, x$15, x$16, x$17, x$18, x$19);
                QueryGraph x$20 = firstQueryGraph;
                Some x$21 = new Some((Object)tail);
                QueryHorizon x$22 = PlannerQuery$.MODULE$.apply$default$2();
                PlannerQuery input = new PlannerQuery(x$20, x$22, (Option)x$21);
                PlannerQuery result = input.foldMap((Function2)new Serializable(this, secondQueryGraph){
                    public static final long serialVersionUID = 0L;
                    private final QueryGraph secondQueryGraph$1;

                    public final PlannerQuery apply(PlannerQuery x0$3, PlannerQuery x1$3) {
                        Tuple2 tuple2 = new Tuple2((Object)x0$3, (Object)x1$3);
                        if (tuple2 != null) {
                            PlannerQuery pq1 = (PlannerQuery)tuple2._1();
                            PlannerQuery pq2 = (PlannerQuery)tuple2._2();
                            if (pq1 != null && pq2 != null) {
                                PlannerQuery plannerQuery = pq2;
                                PlannerQuery plannerQuery2 = plannerQuery.withGraph(this.secondQueryGraph$1);
                                return plannerQuery2;
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        this.secondQueryGraph$1 = secondQueryGraph$1;
                    }
                });
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.not()).equal((Object)input, Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(result.graph()).should(this.$outer.equal(firstQueryGraph), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(((PlannerQuery)result.tail().get()).graph()).should(this.$outer.equal(secondQueryGraph), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should compute lazyness preference correctly for a single planner query", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RegularQueryProjection shuffleWithLimitAndSort;
                RegularQueryProjection shuffleWithLimit;
                RegularQueryProjection x$23 = QueryProjection$.MODULE$.empty();
                QueryGraph x$24 = PlannerQuery$.MODULE$.apply$default$1();
                Option x$25 = PlannerQuery$.MODULE$.apply$default$3();
                PlannerQuery noLimit = new PlannerQuery(x$24, (QueryHorizon)x$23, x$25);
                this.$outer.convertToAnyShouldWrapper(noLimit.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                Some x$26 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Seq x$27 = QueryShuffle$.MODULE$.apply$default$1();
                Option x$28 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$29 = shuffleWithLimit = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$27, x$28, (Option)x$26));
                QueryGraph x$30 = PlannerQuery$.MODULE$.apply$default$1();
                Option x$31 = PlannerQuery$.MODULE$.apply$default$3();
                PlannerQuery hasLimit = new PlannerQuery(x$30, (QueryHorizon)x$29, x$31);
                this.$outer.convertToAnyShouldWrapper(hasLimit.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                Seq x$32 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{(SortItem)this.$outer.mock(ManifestFactory$.MODULE$.classType(SortItem.class))}));
                Some x$33 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Option x$34 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$35 = shuffleWithLimitAndSort = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$32, x$34, (Option)x$33));
                QueryGraph x$36 = PlannerQuery$.MODULE$.apply$default$1();
                Option x$37 = PlannerQuery$.MODULE$.apply$default$3();
                PlannerQuery hasLimitAndSort = new PlannerQuery(x$36, (QueryHorizon)x$35, x$37);
                this.$outer.convertToAnyShouldWrapper(hasLimitAndSort.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should consider planner query tails when computing lazyness preference", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PlannerQueryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                RegularQueryProjection shuffleWithLimitAndSort;
                Some x$38 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Seq x$39 = QueryShuffle$.MODULE$.apply$default$1();
                Option x$40 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection shuffleWithLimit = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$39, x$40, (Option)x$38));
                Seq x$41 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SortItem[]{(SortItem)this.$outer.mock(ManifestFactory$.MODULE$.classType(SortItem.class))}));
                Some x$42 = new Some((Object)new UnsignedDecimalIntegerLiteral("42", this.$outer.pos()));
                Option x$43 = QueryShuffle$.MODULE$.apply$default$2();
                RegularQueryProjection x$44 = shuffleWithLimitAndSort = QueryProjection$.MODULE$.empty().withShuffle(new QueryShuffle(x$41, x$43, (Option)x$42));
                QueryGraph x$45 = PlannerQuery$.MODULE$.apply$default$1();
                Option x$46 = PlannerQuery$.MODULE$.apply$default$3();
                PlannerQuery pqWithLimitAndSort = new PlannerQuery(x$45, (QueryHorizon)x$44, x$46);
                RegularQueryProjection x$47 = shuffleWithLimit;
                Some x$48 = new Some((Object)pqWithLimitAndSort);
                QueryGraph x$49 = PlannerQuery$.MODULE$.apply$default$1();
                PlannerQuery pqWithLimit = new PlannerQuery(x$49, (QueryHorizon)x$47, (Option)x$48);
                Some x$50 = new Some((Object)pqWithLimit);
                QueryGraph x$51 = PlannerQuery$.MODULE$.apply$default$1();
                QueryHorizon x$52 = PlannerQuery$.MODULE$.apply$default$2();
                PlannerQuery pq = new PlannerQuery(x$51, x$52, (Option)x$50);
                this.$outer.convertToAnyShouldWrapper(pq.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(pqWithLimit.preferredStrictness()).should(this.$outer.equal(new Some((Object)LazyMode$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(pqWithLimitAndSort.preferredStrictness()).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

