/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.planner.logical.cardinality.triplet;

import org.neo4j.cypher.internal.compiler.v2_2.planner.QueryGraph;
import org.neo4j.cypher.internal.compiler.v2_2.planner.SemanticTable;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.Metrics;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.cardinality.ForumPostsCardinalityData;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.cardinality.ForumPostsCardinalityData$ForumPosts$;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.cardinality.ForumPostsCardinalityData$class;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.cardinality.RandomizedCardinalityModelTestSuite;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.cardinality.triplet.TripletQueryGraphCardinalityModel;
import org.neo4j.cypher.internal.compiler.v2_2.spi.GraphStatistics;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function3;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001%3A!\u0001\u0002\u0001/\t)CK]5qY\u0016$\u0018+^3ss\u001e\u0013\u0018\r\u001d5DCJ$\u0017N\\1mSRLXj\u001c3fYR+7\u000f\u001e\u0006\u0003\u0007\u0011\tq\u0001\u001e:ja2,GO\u0003\u0002\u0006\r\u0005Y1-\u0019:eS:\fG.\u001b;z\u0015\t9\u0001\"A\u0004m_\u001eL7-\u00197\u000b\u0005%Q\u0011a\u00029mC:tWM\u001d\u0006\u0003\u00171\tAA\u001e\u001a`e)\u0011QBD\u0001\tG>l\u0007/\u001b7fe*\u0011q\u0002E\u0001\tS:$XM\u001d8bY*\u0011\u0011CE\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005M!\u0012!\u00028f_RR'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001AB\u0004\u0005\u0002\u001a55\tA!\u0003\u0002\u001c\t\t\u0019#+\u00198e_6L'0\u001a3DCJ$\u0017N\\1mSRLXj\u001c3fYR+7\u000f^*vSR,\u0007CA\r\u001e\u0013\tqBAA\rG_J,X\u000eU8tiN\u001c\u0015M\u001d3j]\u0006d\u0017\u000e^=ECR\f\u0007\"\u0002\u0011\u0001\t\u0003\t\u0013A\u0002\u001fj]&$h\bF\u0001#!\t\u0019\u0003!D\u0001\u0003\u0011\u0015)\u0003\u0001\"\u0001'\u0003Y\u0019'/Z1uK\u000e\u000b'\u000fZ5oC2LG/_'pI\u0016dGCA\u0014B!\tAcH\u0004\u0002*y9\u0011!f\u000f\b\u0003Wir!\u0001L\u001d\u000f\u00055BdB\u0001\u00188\u001d\tycG\u0004\u00021k9\u0011\u0011\u0007N\u0007\u0002e)\u00111GF\u0001\u0007yI|w\u000e\u001e \n\u0003UI!a\u0005\u000b\n\u0005E\u0011\u0012BA\b\u0011\u0013\tia\"\u0003\u0002\f\u0019%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0010\u0004\u0002\u000f5+GO]5dg&\u0011q\b\u0011\u0002\u001b#V,'/_$sCBD7)\u0019:eS:\fG.\u001b;z\u001b>$W\r\u001c\u0006\u0003{\u0019AQA\u0011\u0013A\u0002\r\u000bQa\u001d;biN\u0004\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0006\u0002\u0007M\u0004\u0018.\u0003\u0002I\u000b\nyqI]1qQN#\u0018\r^5ti&\u001c7\u000f")
public class TripletQueryGraphCardinalityModelTest
extends RandomizedCardinalityModelTestSuite
implements ForumPostsCardinalityData {
    private volatile ForumPostsCardinalityData$ForumPosts$ ForumPosts$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ForumPostsCardinalityData$ForumPosts$ ForumPosts$lzycompute() {
        TripletQueryGraphCardinalityModelTest tripletQueryGraphCardinalityModelTest = this;
        synchronized (tripletQueryGraphCardinalityModelTest) {
            if (this.ForumPosts$module != null) return this.ForumPosts$module;
            this.ForumPosts$module = new ForumPostsCardinalityData$ForumPosts$(this);
            return this.ForumPosts$module;
        }
    }

    @Override
    public ForumPostsCardinalityData$ForumPosts$ ForumPosts() {
        return this.ForumPosts$module == null ? this.ForumPosts$lzycompute() : this.ForumPosts$module;
    }

    @Override
    public Function3<QueryGraph, Metrics.QueryGraphSolverInput, SemanticTable, Cardinality> createCardinalityModel(GraphStatistics stats) {
        return new TripletQueryGraphCardinalityModel(stats, this.combiner());
    }

    public TripletQueryGraphCardinalityModelTest() {
        ForumPostsCardinalityData$class.$init$(this);
        this.test("MATCH (person:Person {id: 10})-[r1:KNOWS]-(friend:Person)<-[r2:MEMBER_IN]-(forum:Forum) WHERE r2.count>1234 AND not(person=friend)", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TripletQueryGraphCardinalityModelTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                double persons = this.$outer.ForumPosts().Persons() * this.$outer.ForumPosts().PersonIdSel();
                double friends = this.$outer.ForumPosts().Persons();
                double forums = this.$outer.ForumPosts().Forums();
                double personKnowsDeg = this.$outer.degree(this.$outer.ForumPosts().Persons_KNOWS_STAR(), this.$outer.ForumPosts().Persons()) + this.$outer.degree(this.$outer.ForumPosts().STAR_KNOWS_Persons(), this.$outer.ForumPosts().Persons());
                double r1Left = personKnowsDeg * persons;
                double r1Right = personKnowsDeg * friends;
                double r1 = Math.min(r1Left, r1Right);
                double personMemberInDeg = this.$outer.degree(this.$outer.ForumPosts().STAR_MEMBER_IN_Persons(), this.$outer.ForumPosts().Persons());
                double forumMemberOutDeg = this.$outer.degree(this.$outer.ForumPosts().Forums_MEMBER_IN_STAR(), this.$outer.ForumPosts().Forums());
                double r2Left = forumMemberOutDeg * forums;
                double r2Right = personMemberInDeg * friends;
                double r2 = Math.min(r2Left, r2Right);
                double tripletCross = r1 * r2;
                double overlap = friends;
                double unselected = tripletCross / overlap;
                double selectivity = this.$outer.DEFAULT_RANGE_SELECTIVITY() * (1.0 - this.$outer.DEFAULT_EQUALITY_SELECTIVITY());
                double result = unselected * selectivity;
                this.$outer.RichTestUnit(this.$outer.RichCardinalityData(this.$outer.ForumPosts()).forQuery("MATCH (person:Person {id: 10})-[r1:KNOWS]-(friend:Person)<-[r2:MEMBER_IN]-(forum:Forum) WHERE r2.count>1234 AND not(person=friend)")).shouldHaveQueryGraphCardinality(result);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

