/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.planner.logical.idp;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.idp.DefaultIdRegistry;
import org.neo4j.cypher.internal.compiler.v2_2.planner.logical.idp.IdRegistry$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Symbol;
import scala.Symbol$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00052A!\u0001\u0002\u0001+\tq\u0011\n\u001a*fO&\u001cHO]=UKN$(BA\u0002\u0005\u0003\rIG\r\u001d\u0006\u0003\u000b\u0019\tq\u0001\\8hS\u000e\fGN\u0003\u0002\b\u0011\u00059\u0001\u000f\\1o]\u0016\u0014(BA\u0005\u000b\u0003\u00111(g\u0018\u001a\u000b\u0005-a\u0011\u0001C2p[BLG.\u001a:\u000b\u00055q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005=\u0001\u0012AB2za\",'O\u0003\u0002\u0012%\u0005)a.Z85U*\t1#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001-A\u0011qCG\u0007\u00021)\u0011\u0011\u0004D\u0001\bG>lWn\u001c8t\u0013\tY\u0002D\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001")
public class IdRegistryTest
extends CypherFunSuite {
    public IdRegistryTest() {
        this.test("IdRegistry registers elements starting from 0", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdRegistryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DefaultIdRegistry registry = IdRegistry$.MODULE$.apply();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.register((Object)Symbol$.MODULE$.apply("a")))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.register((Object)Symbol$.MODULE$.apply("a")))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.register((Object)Symbol$.MODULE$.apply("b")))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.register((Object)Symbol$.MODULE$.apply("a")))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.register((Object)Symbol$.MODULE$.apply("b")))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("IdRegistry can compact registered ids into new fresh ids", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdRegistryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DefaultIdRegistry registry = IdRegistry$.MODULE$.apply();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.register((Object)Symbol$.MODULE$.apply("a")))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.compact((BitSet)BitSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.register((Object)Symbol$.MODULE$.apply("a")))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)0)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)registry.register((Object)Symbol$.MODULE$.apply("b")))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("IdRegistry can register whole sets", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdRegistryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DefaultIdRegistry registry = IdRegistry$.MODULE$.apply();
                this.$outer.convertToAnyShouldWrapper(registry.registerAll((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("a"), Symbol$.MODULE$.apply("b")})))).should(this.$outer.equal(BitSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(registry.registerAll((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("b"), Symbol$.MODULE$.apply("c")})))).should(this.$outer.equal(BitSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("IdRegistry translates back while honoring previous compactions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ IdRegistryTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DefaultIdRegistry registry = IdRegistry$.MODULE$.apply();
                registry.register((Object)Symbol$.MODULE$.apply("a"));
                registry.compact((BitSet)BitSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})));
                registry.registerAll((Iterable)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("a"), Symbol$.MODULE$.apply("b"), Symbol$.MODULE$.apply("c")})));
                this.$outer.convertToAnyShouldWrapper(registry.lookup(0)).should(this.$outer.equal(new Some((Object)Symbol$.MODULE$.apply("a"))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(registry.lookup(1)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(registry.lookup(2)).should(this.$outer.equal(new Some((Object)Symbol$.MODULE$.apply("b"))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(registry.lookup(3)).should(this.$outer.equal(new Some((Object)Symbol$.MODULE$.apply("c"))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(registry.explode((BitSet)BitSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("a"), Symbol$.MODULE$.apply("b"), Symbol$.MODULE$.apply("c")}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(registry.explode((BitSet)BitSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Symbol[]{Symbol$.MODULE$.apply("a"), Symbol$.MODULE$.apply("b"), Symbol$.MODULE$.apply("c")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

