/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.prettifier;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.parser.ParserTest;
import org.neo4j.cypher.internal.compiler.v2_2.parser.ParserTest$class;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.AnyText;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.BreakingKeywords;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.EscapedText;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.EscapedText$;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.GroupToken;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.NonBreakingKeywords;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.PrettifierParser;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.SyntaxToken;
import org.parboiled.scala.rules.Rule1;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001#\t!\u0002K]3ui&4\u0017.\u001a:QCJ\u001cXM\u001d+fgRT!a\u0001\u0003\u0002\u0015A\u0014X\r\u001e;jM&,'O\u0003\u0002\u0006\r\u0005!aOM03\u0015\t9\u0001\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tI!\"\u0001\u0005j]R,'O\\1m\u0015\tYA\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001b9\tQA\\3pi)T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\t\u0003\u001d\u0019w.\\7p]NL!a\u0006\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uKB!\u0011\u0004\b\u0010\u001f\u001b\u0005Q\"BA\u000e\u0005\u0003\u0019\u0001\u0018M]:fe&\u0011QD\u0007\u0002\u000b!\u0006\u00148/\u001a:UKN$\bcA\u0010*Y9\u0011\u0001E\n\b\u0003C\u0011j\u0011A\t\u0006\u0003GA\ta\u0001\u0010:p_Rt\u0014\"A\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001dB\u0013a\u00029bG.\fw-\u001a\u0006\u0002K%\u0011!f\u000b\u0002\u0004'\u0016\f(BA\u0014)!\tic&D\u0001\u0003\u0013\ty#AA\u0006Ts:$\u0018\r\u001f+pW\u0016t\u0007\"B\u0019\u0001\t\u0003\u0011\u0014A\u0002\u001fj]&$h\bF\u00014!\ti\u0003\u0001C\u00046\u0001\t\u0007I1\u0001\u001c\u0002\u0019A\f'o]3s)>$Vm\u001d;\u0016\u0003]\u00022\u0001O\"\u001f\u001d\tI\u0014I\u0004\u0002;\u007f9\u00111(\u0010\b\u0003CqJ\u0011aD\u0005\u0003}9\t\u0011\u0002]1sE>LG.\u001a3\n\u0005\u0015\u0002%B\u0001 \u000f\u0013\t9#I\u0003\u0002&\u0001&\u0011A)\u0012\u0002\u0006%VdW-\r\u0006\u0003O\tCaa\u0012\u0001!\u0002\u00139\u0014!\u00049beN,'\u000fV8UKN$\b\u0005C\u0003J\u0001\u0011\u0005!*A\u0004d_:4XM\u001d;\u0015\u0005yY\u0005\"\u0002'I\u0001\u0004q\u0012A\u0002<bYV,7\u000f")
public class PrettifierParserTest
extends CypherFunSuite
implements ParserTest<Seq<SyntaxToken>, Seq<SyntaxToken>> {
    private final Rule1<Seq<SyntaxToken>> parserToTest;

    @Override
    public ParserTest.ResultCheck parsing(String s, Rule1<Seq<SyntaxToken>> p) {
        return ParserTest$class.parsing(this, s, p);
    }

    @Override
    public ParserTest.ResultCheck partiallyParsing(String s, Rule1<Seq<SyntaxToken>> p) {
        return ParserTest$class.partiallyParsing(this, s, p);
    }

    @Override
    public void assertFails(String s, Rule1<Seq<SyntaxToken>> p) {
        ParserTest$class.assertFails(this, s, p);
    }

    public Rule1<Seq<SyntaxToken>> parserToTest() {
        return this.parserToTest;
    }

    @Override
    public Seq<SyntaxToken> convert(Seq<SyntaxToken> values) {
        return values;
    }

    public PrettifierParserTest() {
        ParserTest$class.$init$(this);
        this.parserToTest = new PrettifierParser().main();
        this.test("shouldParseKeywords", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String keyword = "create";
                this.$outer.parsing(keyword, this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BreakingKeywords[]{new BreakingKeywords(keyword)})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldNotParseAssertAsANonBreakingKeyword", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String query = "create constraint on (person:Person) assert person.age is unique";
                this.$outer.parsing(query, this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SyntaxToken[]{new BreakingKeywords("create constraint on"), new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("person:Person")}))), new NonBreakingKeywords("assert"), new AnyText("person.age"), new NonBreakingKeywords("is unique")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseIndexAsKeyword", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String keyword = "asc";
                this.$outer.parsing(keyword, this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonBreakingKeywords[]{new NonBreakingKeywords(keyword)})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseAnyText", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "a-->b";
                this.$outer.parsing(input, this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText(input)})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseEscapedText", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "aha!";
                this.$outer.parsing(new StringBuilder().append((Object)"\"").append((Object)input).append((Object)"\"").toString(), this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText(input, EscapedText$.MODULE$.apply$default$2())})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseGroupingText", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "(){}[]";
                this.$outer.parsing(input, this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.empty()), new GroupToken("{", "}", (Seq)Seq$.MODULE$.empty()), new GroupToken("[", "]", (Seq)Seq$.MODULE$.empty())})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseComplexExample1", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "match a-->b where b.name = \"aha!\" return a.age";
                this.$outer.parsing(input, this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SyntaxToken[]{new BreakingKeywords("match"), new AnyText("a-->b"), new BreakingKeywords("where"), new AnyText("b.name"), new AnyText("="), new EscapedText("aha!", EscapedText$.MODULE$.apply$default$2()), new BreakingKeywords("return"), new AnyText("a.age")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseComplexExample2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String input = "merge n on create set n.age=32";
                ParserTest.ResultCheck result = this.$outer.parsing(input, this.$outer.parserToTest());
                Seq expectation = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SyntaxToken[]{new BreakingKeywords("merge"), new AnyText("n"), new BreakingKeywords("on create set"), new AnyText("n.age=32")}));
                result.shouldGive(expectation);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseSimpleGrouping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("[0,10]", this.$outer.parserToTest());
                result.shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("[", "]", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("0,10")})))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseComplexGrouping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("[(0,10)]", this.$outer.parserToTest());
                result.shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("[", "]", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("0,10")})))})))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseGroupingWithEscapedText", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("( \"Gunhild\" )", this.$outer.parserToTest());
                result.shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText("Gunhild", EscapedText$.MODULE$.apply$default$2())})))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseGrouping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.parsing("(x)", this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("x")})))})));
                this.$outer.parsing("[x]", this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("[", "]", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("x")})))})));
                this.$outer.parsing("{x}", this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("{", "}", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyText[]{new AnyText("x")})))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseWhereAsNonBreakingInsideGrouping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("( WHERE )", this.$outer.parserToTest());
                result.shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupToken[]{new GroupToken("(", ")", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonBreakingKeywords[]{new NonBreakingKeywords("WHERE")})))})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseUsingPeriodicCommitAndMatchAsDistinctKeywordGroups", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParserTest.ResultCheck result = this.$outer.parsing("USING PERIODIC COMMIT MATCH", this.$outer.parserToTest());
                result.shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new BreakingKeywords[]{new BreakingKeywords("USING PERIODIC COMMIT"), new BreakingKeywords("MATCH")})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldParseStringsAndKeepQuotes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierParserTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.parsing("\"I'm a literal\"", this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText("I'm a literal", EscapedText$.MODULE$.apply$default$2())})));
                this.$outer.parsing("'Im a literal'", this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText("Im a literal", '\'')})));
                this.$outer.parsing("'I\\'m a literal'", this.$outer.parserToTest()).shouldGive(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EscapedText[]{new EscapedText("I'm a literal", '\'')})));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

