/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.prettifier;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.prettifier.Prettifier$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001]2A!\u0001\u0002\u0001#\tq\u0001K]3ui&4\u0017.\u001a:UKN$(BA\u0002\u0005\u0003)\u0001(/\u001a;uS\u001aLWM\u001d\u0006\u0003\u000b\u0019\tAA\u001e\u001a`e)\u0011q\u0001C\u0001\tG>l\u0007/\u001b7fe*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0017\u001b\u0005!\"BA\u000b\t\u0003\u001d\u0019w.\\7p]NL!a\u0006\u000b\u0003\u001d\rK\b\u000f[3s\rVt7+^5uK\")\u0011\u0004\u0001C\u00015\u00051A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011A\u0001\u0005\u0006=\u0001!IaH\u0001\u0007C\u000e$X/\u00197\u0015\u0005\u0001B\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\nAA[1wC&\u0011qE\t\u0002\u0007'R\u0014\u0018N\\4\t\u000b%j\u0002\u0019\u0001\u0016\u0002\tQ,\u0007\u0010\u001e\t\u0003WEr!\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\na\u0001\u0015:fI\u00164\u0017BA\u00143\u0015\t\u0001T\u0006C\u00035\u0001\u0011%Q'\u0001\u0005fqB,7\r^3e)\t\u0001c\u0007C\u0003*g\u0001\u0007!\u0006")
public class PrettifierTest
extends CypherFunSuite {
    public String org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual(String text) {
        return Prettifier$.MODULE$.apply(text);
    }

    public String org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected(String text) {
        return String.format(text, new Object[0]);
    }

    public PrettifierTest() {
        this.test("should upcase keywords", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("create n")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("CREATE n")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break INDEX ON", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("create index on :Person(name)")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("CREATE INDEX ON :Person(name)")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break on ASC", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("order by n.name asc")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("ORDER BY n.name ASC")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break CREATE in FOREACH", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("match p=n foreach(x in p | create x--())")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MATCH p=n%nFOREACH (x IN p | CREATE x--())")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break CREATE in complex FOREACH", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("match p=n foreach(x in p | create x--() set x.foo = 'bar') return distinct p;")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MATCH p=n%nFOREACH (x IN p | CREATE x--()%nSET x.foo = 'bar')%nRETURN DISTINCT p;")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break CONSTRAINT ON", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("create constraint on (person:Person) assert person.age is unique")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("CREATE CONSTRAINT ON (person:Person) ASSERT person.age IS UNIQUE")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should break ON CREATE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("merge n on create set n.age=32")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MERGE n%nON CREATE SET n.age=32")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should correctly handle parenthesis in MATCH", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("match (a)-->(b) return b")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MATCH (a)-->(b)%nRETURN b")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should upcase multiple keywords", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("match n where n.name='B' return n")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MATCH n%nWHERE n.name='B'%nRETURN n")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should upcase multiple keywords 2", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("match a where a.name='A' return a.age as SomethingTotallyDifferent")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MATCH a%nWHERE a.name='A'%nRETURN a.age AS SomethingTotallyDifferent")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break CREATE UNIQUE", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("start me=node(3) match p1 = me-[*2]-friendOfFriend create p2 = me-[:MARRIED_TO]-(wife { name: \"Gunhild\" }) create unique p3 = wife-[:KNOWS]-friendOfFriend return p1,p2,p3")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("START me=node(3)%nMATCH p1 = me-[*2]-friendOfFriend%nCREATE p2 = me-[:MARRIED_TO]-(wife { name: \"Gunhild\" })%nCREATE UNIQUE p3 = wife-[:KNOWS]-friendOfFriend%nRETURN p1,p2,p3")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break WHERE in comprehensions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("return [x in range(0,10) where x + 2 = 0 | x^3] as result")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("RETURN [x IN range(0,10) WHERE x + 2 = 0 | x^3] AS result")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should upcase extra keywords", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("match david--otherPerson-->() where david.name='David' with otherPerson, count(*) as foaf where foaf > 1 return otherPerson")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MATCH david--otherPerson-->()%nWHERE david.name='David'%nWITH otherPerson, count(*) AS foaf%nWHERE foaf > 1%nRETURN otherPerson")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not break after OPTIONAL", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("optional MATCH (n)-->(x) return n, x")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("OPTIONAL MATCH (n)-->(x)%nRETURN n, x")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle LOAD CSV", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("LOAD CSV FROM \"f\" AS line")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("LOAD CSV FROM \"f\" AS line")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle LOAD CSV WITH HEADERS", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("LOAD CSV wiTh HEADERS FROM \"f\" AS line")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("LOAD CSV WITH HEADERS FROM \"f\" AS line")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should prettify and break LOAD CSV", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("MATCH (n) LOAD CSV FROM \"f\" AS line return (n)")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MATCH (n)%nLOAD CSV FROM \"f\" AS line%nRETURN (n)")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should prettify and break USING PERIODIC COMMIT LOAD CSV", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("using periodic commit match () MATCH (n) LOAD CSV FROM \"f\" AS line return (n)")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("USING PERIODIC COMMIT%nMATCH ()%nMATCH (n)%nLOAD CSV FROM \"f\" AS line%nRETURN (n)")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should prettify with correct string quotes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PrettifierTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToStringShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$actual("mATCH a WhERE a.name='A' RETURN a.age > 30, \"I'm a literal\", a-->()")).should(this.$outer.equal(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$prettifier$PrettifierTest$$expected("MATCH a%nWHERE a.name='A'%nRETURN a.age > 30, \"I'm a literal\", a-->()")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

