/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.profiler;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v2_2.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.NestedPipeExpression;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.ProjectedPath;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.ApplyPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.ApplyPipe$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.ExternalResource;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.PipeDecorator;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.PipeMonitor;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.ProjectionNewPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.ProjectionNewPipe$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryState$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.SingleRowPipe;
import org.neo4j.cypher.internal.compiler.v2_2.pipes.UnionPipe;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.Argument;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.compiler.v2_2.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.compiler.v2_2.profiler.Profiler;
import org.neo4j.cypher.internal.compiler.v2_2.profiler.ProfilerTestPipe;
import org.neo4j.cypher.internal.compiler.v2_2.profiler.ProfilingIterator;
import org.neo4j.cypher.internal.compiler.v2_2.profiler.ProfilingQueryContext;
import org.neo4j.cypher.internal.compiler.v2_2.spi.QueryContext;
import org.neo4j.graphdb.GraphDatabaseService;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.enablers.Emptiness$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001#\ta\u0001K]8gS2,'\u000fV3ti*\u00111\u0001B\u0001\taJ|g-\u001b7fe*\u0011QAB\u0001\u0005mJz&G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011aB2p[6|gn]\u0005\u0003/Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005!9a\u0004\u0001b\u0001\n\u0017y\u0012aB7p]&$xN]\u000b\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005B\u0001\u0006a&\u0004Xm]\u0005\u0003K\t\u00121\u0002U5qK6{g.\u001b;pe\"1q\u0005\u0001Q\u0001\n\u0001\n\u0001\"\\8oSR|'\u000f\t\u0005\u0006S\u0001!IAK\u0001\u000fCN\u001cXM\u001d;SK\u000e|'\u000fZ3e)\u0015Y\u0013'\u000f\"H!\tas&D\u0001.\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0005\u0011)f.\u001b;\t\u000bIB\u0003\u0019A\u001a\u0002\rI,7/\u001e7u!\t!t'D\u00016\u0015\t1D!A\bqY\u0006tG)Z:de&\u0004H/[8o\u0013\tATGA\fJ]R,'O\\1m!2\fg\u000eR3tGJL\u0007\u000f^5p]\")!\b\u000ba\u0001w\u0005!a.Y7f!\tatH\u0004\u0002-{%\u0011a(L\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?[!)1\t\u000ba\u0001\t\u0006aQ\r\u001f9fGR,GMU8xgB\u0011A&R\u0005\u0003\r6\u00121!\u00138u\u0011\u0015A\u0005\u00061\u0001E\u00039)\u0007\u0010]3di\u0016$GI\u0019%jiNDQA\u0013\u0001\u0005\n-\u000b1\"\\1uKJL\u0017\r\\5{KR\u00111\u0006\u0014\u0005\u0006\u001b&\u0003\rAT\u0001\tSR,'/\u0019;peB\u0012q*\u0018\t\u0004!b[fBA)W\u001d\t\u0011V+D\u0001T\u0015\t!\u0006#\u0001\u0004=e>|GOP\u0005\u0002]%\u0011q+L\u0001\ba\u0006\u001c7.Y4f\u0013\tI&L\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t9V\u0006\u0005\u0002];2\u0001A!\u00030M\u0003\u0003\u0005\tQ!\u0001`\u0005\ryF%M\t\u0003A\u000e\u0004\"\u0001L1\n\u0005\tl#a\u0002(pi\"Lgn\u001a\t\u0003Y\u0011L!!Z\u0017\u0003\u0007\u0005s\u0017\u0010")
public class ProfilerTest
extends CypherFunSuite {
    private final PipeMonitor org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor = (PipeMonitor)this.mock(ManifestFactory$.MODULE$.classType(PipeMonitor.class));

    public PipeMonitor org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor() {
        return this.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor;
    }

    public void org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$assertRecorded(InternalPlanDescription result, String name, int expectedRows, int expectedDbHits) {
        Seq pipeArgs = (Seq)result.find(name).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Argument> apply(InternalPlanDescription x$1) {
                return x$1.arguments();
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.convertToAnyShouldWrapper(pipeArgs).shouldNot(this.be().apply(this.empty()), (Object)Emptiness$.MODULE$.emptinessOfGenTraversable());
        pipeArgs.collect((PartialFunction)new Serializable(this, expectedDbHits){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;
            private final int expectedDbHits$1;

            public final <A1 extends Argument, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof InternalPlanDescription.Arguments$.DbHits) {
                    InternalPlanDescription.Arguments$.DbHits dbHits = (InternalPlanDescription.Arguments$.DbHits)A1;
                    long count = dbHits.value();
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)count)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)this.expectedDbHits$1)), (Object)Equality$.MODULE$.default());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Argument x1) {
                Argument argument = x1;
                boolean bl = argument instanceof InternalPlanDescription.Arguments$.DbHits;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expectedDbHits$1 = expectedDbHits$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        pipeArgs.collect((PartialFunction)new Serializable(this, expectedRows){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;
            private final int expectedRows$1;

            public final <A1 extends Argument, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof InternalPlanDescription.Arguments$.Rows) {
                    InternalPlanDescription.Arguments$.Rows rows = (InternalPlanDescription.Arguments$.Rows)A1;
                    long seenRows = rows.value();
                    this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)seenRows)).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)this.expectedRows$1)), (Object)Equality$.MODULE$.default());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Argument x2) {
                Argument argument = x2;
                boolean bl = argument instanceof InternalPlanDescription.Arguments$.Rows;
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expectedRows$1 = expectedRows$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$materialize(Iterator<Object> iterator) {
        iterator.size();
    }

    public ProfilerTest() {
        this.test("should report simplest case", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SingleRowPipe start = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                ProfilerTestPipe pipe = new ProfilerTestPipe((Pipe)start, "foo", 10, 20, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Profiler profiler = new Profiler();
                QueryContext x$2 = queryContext;
                Profiler x$3 = profiler;
                GraphDatabaseService x$4 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$5 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$6 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                Option<ExecutionContext> x$7 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(x$4, x$2, x$5, x$6, (PipeDecorator)x$3, x$7);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$materialize((Iterator<Object>)pipe.createResults(queryState));
                InternalPlanDescription decoratedResult = profiler.decorate(pipe.planDescription(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                });
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$assertRecorded(decoratedResult, "foo", 10, 20);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should report multiple pipes case", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SingleRowPipe start = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                ProfilerTestPipe pipe1 = new ProfilerTestPipe((Pipe)start, "foo", 10, 25, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                ProfilerTestPipe pipe2 = new ProfilerTestPipe((Pipe)pipe1, "bar", 20, 40, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                ProfilerTestPipe pipe3 = new ProfilerTestPipe((Pipe)pipe2, "baz", 1, 2, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Profiler profiler = new Profiler();
                QueryContext x$8 = queryContext;
                Profiler x$9 = profiler;
                GraphDatabaseService x$10 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$11 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$12 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                Option<ExecutionContext> x$13 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(x$10, x$8, x$11, x$12, (PipeDecorator)x$9, x$13);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$materialize((Iterator<Object>)pipe3.createResults(queryState));
                InternalPlanDescription decoratedResult = profiler.decorate(pipe3.planDescription(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                });
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$assertRecorded(decoratedResult, "foo", 10, 25);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$assertRecorded(decoratedResult, "bar", 20, 40);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$assertRecorded(decoratedResult, "baz", 1, 2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should ignore null pipe in profile", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                UnionPipe pipes = new UnionPipe(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SingleRowPipe[]{new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor()), new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor())})), (List)Nil$.MODULE$, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Profiler profiler = new Profiler();
                QueryContext x$14 = queryContext;
                Profiler x$15 = profiler;
                GraphDatabaseService x$16 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$17 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$18 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                Option<ExecutionContext> x$19 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(x$16, x$14, x$17, x$18, (PipeDecorator)x$15, x$19);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$materialize((Iterator<Object>)pipes.createResults(queryState));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should count stuff going through Apply multiple times", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProfilerTestPipe lhs = new ProfilerTestPipe((Pipe)new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor()), "lhs", 10, 10, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                ProfilerTestPipe rhs = new ProfilerTestPipe((Pipe)new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor()), "rhs", 20, 30, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                ProfilerTestPipe x$20 = lhs;
                ProfilerTestPipe x$21 = rhs;
                Option x$22 = ApplyPipe$.MODULE$.$lessinit$greater$default$3((Pipe)x$20, (Pipe)x$21);
                ApplyPipe apply2 = new ApplyPipe((Pipe)x$20, (Pipe)x$21, x$22, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Profiler profiler = new Profiler();
                QueryContext x$23 = queryContext;
                Profiler x$24 = profiler;
                GraphDatabaseService x$25 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$26 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$27 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                Option<ExecutionContext> x$28 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(x$25, x$23, x$26, x$27, (PipeDecorator)x$24, x$28);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$materialize((Iterator<Object>)apply2.createResults(queryState));
                InternalPlanDescription decoratedResult = profiler.decorate((InternalPlanDescription)apply2.planDescription(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                });
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$assertRecorded(decoratedResult, "rhs", 200, 300);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("count dbhits for NestedPipes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProjectedPath projectedPath = (ProjectedPath)this.$outer.mock(ManifestFactory$.MODULE$.classType(ProjectedPath.class));
                int DB_HITS = 100;
                NestedPipeExpression innerPipe = new NestedPipeExpression((Pipe)new ProfilerTestPipe((Pipe)new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor()), "nested pipe", 10, DB_HITS, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor()), projectedPath);
                SingleRowPipe x$29 = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                Map x$30 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"x"), (Object)innerPipe)}));
                Option x$31 = ProjectionNewPipe$.MODULE$.apply$default$3((Pipe)x$29, x$30);
                ProjectionNewPipe pipeUnderInspection = new ProjectionNewPipe((Pipe)x$29, x$30, x$31, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Profiler profiler = new Profiler();
                QueryContext x$32 = queryContext;
                Profiler x$33 = profiler;
                GraphDatabaseService x$34 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$35 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$36 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                Option<ExecutionContext> x$37 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(x$34, x$32, x$35, x$36, (PipeDecorator)x$33, x$37);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$materialize((Iterator<Object>)pipeUnderInspection.createResults(queryState));
                PlanDescriptionImpl description = pipeUnderInspection.planDescription();
                InternalPlanDescription decoratedResult = profiler.decorate((InternalPlanDescription)description, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                });
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$assertRecorded(decoratedResult, "Projection", 1, DB_HITS);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("count dbhits for deeply nested NestedPipes", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ProjectedPath projectedPath = (ProjectedPath)this.$outer.mock(ManifestFactory$.MODULE$.classType(ProjectedPath.class));
                int DB_HITS = 100;
                NestedPipeExpression nestedExpression = new NestedPipeExpression((Pipe)new ProfilerTestPipe((Pipe)new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor()), "nested pipe1", 10, DB_HITS, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor()), projectedPath);
                SingleRowPipe x$38 = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                Map x$39 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"y"), (Object)nestedExpression)}));
                Option x$40 = ProjectionNewPipe$.MODULE$.apply$default$3((Pipe)x$38, x$39);
                ProjectionNewPipe innerInnerPipe = new ProjectionNewPipe((Pipe)x$38, x$39, x$40, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                NestedPipeExpression innerPipe = new NestedPipeExpression((Pipe)new ProfilerTestPipe((Pipe)innerInnerPipe, "nested pipe2", 10, DB_HITS, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor()), projectedPath);
                SingleRowPipe x$41 = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                Map x$42 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"x"), (Object)innerPipe)}));
                Option x$43 = ProjectionNewPipe$.MODULE$.apply$default$3((Pipe)x$41, x$42);
                ProjectionNewPipe pipeUnderInspection = new ProjectionNewPipe((Pipe)x$41, x$42, x$43, this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                QueryContext queryContext = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                Profiler profiler = new Profiler();
                QueryContext x$44 = queryContext;
                Profiler x$45 = profiler;
                GraphDatabaseService x$46 = QueryStateHelper$.MODULE$.emptyWith$default$1();
                ExternalResource x$47 = QueryStateHelper$.MODULE$.emptyWith$default$3();
                Map<String, Object> x$48 = QueryStateHelper$.MODULE$.emptyWith$default$4();
                Option<ExecutionContext> x$49 = QueryStateHelper$.MODULE$.emptyWith$default$6();
                QueryState queryState = QueryStateHelper$.MODULE$.emptyWith(x$46, x$44, x$47, x$48, (PipeDecorator)x$45, x$49);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$materialize((Iterator<Object>)pipeUnderInspection.createResults(queryState));
                PlanDescriptionImpl description = pipeUnderInspection.planDescription();
                InternalPlanDescription decoratedResult = profiler.decorate((InternalPlanDescription)description, (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return true;
                    }
                });
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$assertRecorded(decoratedResult, "Projection", 1, DB_HITS * 2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not count rows multiple times when the same pipe is used multiple times", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Profiler profiler = new Profiler();
                SingleRowPipe pipe1 = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                Iterator iter1 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{ExecutionContext$.MODULE$.empty(), ExecutionContext$.MODULE$.empty(), ExecutionContext$.MODULE$.empty()}));
                Iterator profiled1 = profiler.decorate((Pipe)pipe1, iter1);
                profiled1.toList();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((ProfilingIterator)profiled1).count())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)3)), (Object)Equality$.MODULE$.default());
                SingleRowPipe pipe2 = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                Iterator iter2 = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutionContext[]{ExecutionContext$.MODULE$.empty(), ExecutionContext$.MODULE$.empty()}));
                Iterator profiled2 = profiler.decorate((Pipe)pipe2, iter2);
                profiled2.toList();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((ProfilingIterator)profiled2).count())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)2)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should not count dbhits multiple times when the same pipe is used multiple times", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ProfilerTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Profiler profiler = new Profiler();
                SingleRowPipe pipe1 = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                QueryContext ctx1 = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                QueryState state1 = new QueryState((GraphDatabaseService)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphDatabaseService.class)), ctx1, (ExternalResource)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExternalResource.class)), Predef$.MODULE$.Map().empty(), (PipeDecorator)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeDecorator.class)), QueryState$.MODULE$.apply$default$6(), QueryState$.MODULE$.apply$default$7(), QueryState$.MODULE$.apply$default$8());
                QueryState profiled1 = profiler.decorate((Pipe)pipe1, state1);
                profiled1.query().createNode();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((ProfilingQueryContext)profiled1.query()).count())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
                SingleRowPipe pipe2 = new SingleRowPipe(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$profiler$ProfilerTest$$monitor());
                QueryContext ctx2 = (QueryContext)this.$outer.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
                QueryState state2 = new QueryState((GraphDatabaseService)this.$outer.mock(ManifestFactory$.MODULE$.classType(GraphDatabaseService.class)), ctx2, (ExternalResource)this.$outer.mock(ManifestFactory$.MODULE$.classType(ExternalResource.class)), Predef$.MODULE$.Map().empty(), (PipeDecorator)this.$outer.mock(ManifestFactory$.MODULE$.classType(PipeDecorator.class)), QueryState$.MODULE$.apply$default$6(), QueryState$.MODULE$.apply$default$7(), QueryState$.MODULE$.apply$default$8());
                QueryState profiled2 = profiler.decorate((Pipe)pipe2, state2);
                profiled2.query().createNode();
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToLong((long)((ProfilingQueryContext)profiled2.query()).count())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)1)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

