/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.spi;

import java.io.PrintWriter;
import java.net.URL;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.commons.CreateTempFileTestSupport;
import org.neo4j.cypher.internal.commons.CreateTempFileTestSupport$class;
import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.commons.CypherTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_2.TaskCloser;
import org.neo4j.cypher.internal.compiler.v2_2.spi.CSVResources;
import org.neo4j.cypher.internal.compiler.v2_2.spi.CSVResourcesTest$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.io.File;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\r3A!\u0001\u0002\u0001#\t\u00012i\u0015,SKN|WO]2fgR+7\u000f\u001e\u0006\u0003\u0007\u0011\t1a\u001d9j\u0015\t)a!\u0001\u0003we}\u0013$BA\u0004\t\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0005\u000b\u0003!Ig\u000e^3s]\u0006d'BA\u0006\r\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011QBD\u0001\u0006]\u0016|GG\u001b\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011aB2p[6|gn]\u0005\u0003/Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\r\u0005\u0002\u00143%\u0011!\u0004\u0006\u0002\u001a\u0007J,\u0017\r^3UK6\u0004h)\u001b7f)\u0016\u001cHoU;qa>\u0014H\u000fC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u0005!I\u0011\u0005\u0001a\u0001\u0002\u0004%\tAI\u0001\ne\u0016\u001cx.\u001e:dKN,\u0012a\t\t\u0003?\u0011J!!\n\u0002\u0003\u0019\r\u001bfKU3t_V\u00148-Z:\t\u0013\u001d\u0002\u0001\u0019!a\u0001\n\u0003A\u0013!\u0004:fg>,(oY3t?\u0012*\u0017\u000f\u0006\u0002*_A\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t!QK\\5u\u0011\u001d\u0001d%!AA\u0002\r\n1\u0001\u001f\u00132\u0011\u0019\u0011\u0004\u0001)Q\u0005G\u0005Q!/Z:pkJ\u001cWm\u001d\u0011\t\u0013Q\u0002\u0001\u0019!a\u0001\n\u0003)\u0014aB2mK\u0006tWM]\u000b\u0002mA\u0011q\u0007O\u0007\u0002\t%\u0011\u0011\b\u0002\u0002\u000b)\u0006\u001c8n\u00117pg\u0016\u0014\b\"C\u001e\u0001\u0001\u0004\u0005\r\u0011\"\u0001=\u0003-\u0019G.Z1oKJ|F%Z9\u0015\u0005%j\u0004b\u0002\u0019;\u0003\u0003\u0005\rA\u000e\u0005\u0007\u007f\u0001\u0001\u000b\u0015\u0002\u001c\u0002\u0011\rdW-\u00198fe\u0002BQ!\u0011\u0001\u0005B\t\u000b!BY3g_J,W)Y2i)\u0005I\u0003")
public class CSVResourcesTest
extends CypherFunSuite
implements CreateTempFileTestSupport {
    private CSVResources resources;
    private TaskCloser cleaner;
    private Seq<File> org$neo4j$cypher$internal$commons$CreateTempFileTestSupport$$files;

    @Override
    public Seq<File> org$neo4j$cypher$internal$commons$CreateTempFileTestSupport$$files() {
        return this.org$neo4j$cypher$internal$commons$CreateTempFileTestSupport$$files;
    }

    @Override
    @TraitSetter
    public void org$neo4j$cypher$internal$commons$CreateTempFileTestSupport$$files_$eq(Seq<File> x$1) {
        this.org$neo4j$cypher$internal$commons$CreateTempFileTestSupport$$files = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$commons$CreateTempFileTestSupport$$super$stopTest() {
        CypherTestSupport$class.stopTest(this);
    }

    @Override
    public void stopTest() {
        CreateTempFileTestSupport$class.stopTest(this);
    }

    @Override
    public String createCSVTempFileURL(Function1<PrintWriter, BoxedUnit> f) {
        return CreateTempFileTestSupport$class.createCSVTempFileURL(this, f);
    }

    @Override
    public String createCSVTempFileURL(String filename, String dir, Function1<PrintWriter, BoxedUnit> f) {
        return CreateTempFileTestSupport$class.createCSVTempFileURL(this, filename, dir, f);
    }

    @Override
    public String createTempFile(String name, String ext, Function1<PrintWriter, BoxedUnit> f) {
        return CreateTempFileTestSupport$class.createTempFile(this, name, ext, f);
    }

    @Override
    public String createTempFileURL(String name, String ext, Function1<PrintWriter, BoxedUnit> f) {
        return CreateTempFileTestSupport$class.createTempFileURL(this, name, ext, f);
    }

    @Override
    public String createCSVTempFileURL$default$1() {
        return CreateTempFileTestSupport$class.createCSVTempFileURL$default$1(this);
    }

    @Override
    public String createCSVTempFileURL$default$2() {
        return CreateTempFileTestSupport$class.createCSVTempFileURL$default$2(this);
    }

    public CSVResources resources() {
        return this.resources;
    }

    public void resources_$eq(CSVResources x$1) {
        this.resources = x$1;
    }

    public TaskCloser cleaner() {
        return this.cleaner;
    }

    public void cleaner_$eq(TaskCloser x$1) {
        this.cleaner = x$1;
    }

    @Override
    public void beforeEach() {
        this.cleaner_$eq((TaskCloser)this.mock(ManifestFactory$.MODULE$.classType(TaskCloser.class)));
        this.resources_$eq(new CSVResources(this.cleaner()));
    }

    public CSVResourcesTest() {
        CreateTempFileTestSupport$class.$init$(this);
        this.test("should handle strings", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String url = this.$outer.createCSVTempFileURL((Function1<PrintWriter, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PrintWriter writer) {
                        writer.println("1");
                        writer.println("2");
                        writer.println("3");
                        writer.println("4");
                    }
                });
                CSVResources qual$1 = this.$outer.resources();
                URL x$2 = new URL(url);
                Option x$3 = qual$1.getCsvIterator$default$2();
                List result = qual$1.getCsvIterator(x$2, x$3).toList();
                ((List)result.zip((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"1"}), (String[])((Object[])new String[]{"2"}), (String[])((Object[])new String[]{"3"}), (String[])((Object[])new String[]{"4"})})), List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$1 $outer;

                    public final void apply(Tuple2<String[], String[]> x0$1) {
                        Tuple2<String[], String[]> tuple2 = x0$1;
                        if (tuple2 != null) {
                            String[] r = (String[])tuple2._1();
                            String[] expected = (String[])tuple2._2();
                            this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().convertToAnyShouldWrapper(r).should(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().equal(expected), (Object)Equality$.MODULE$.default());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CSVResourcesTest org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle with headers", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String url = this.$outer.createCSVTempFileURL((Function1<PrintWriter, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PrintWriter writer) {
                        writer.println("a,b");
                        writer.println("1,2");
                        writer.println("3,4");
                    }
                });
                CSVResources qual$2 = this.$outer.resources();
                URL x$4 = new URL(url);
                Option x$5 = qual$2.getCsvIterator$default$2();
                List result = qual$2.getCsvIterator(x$4, x$5).toList();
                ((List)result.zip((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"a", "b"}), (String[])((Object[])new String[]{"1", "2"}), (String[])((Object[])new String[]{"3", "4"})})), List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$2 $outer;

                    public final void apply(Tuple2<String[], String[]> x0$2) {
                        Tuple2<String[], String[]> tuple2 = x0$2;
                        if (tuple2 != null) {
                            String[] r = (String[])tuple2._1();
                            String[] expected = (String[])tuple2._2();
                            this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().convertToAnyShouldWrapper(r).should(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().equal(expected), (Object)Equality$.MODULE$.default());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CSVResourcesTest org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle with headers even for uneven files", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String url = this.$outer.createCSVTempFileURL((Function1<PrintWriter, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PrintWriter writer) {
                        writer.println("a,b");
                        writer.println("1,2");
                        writer.println("3");
                    }
                });
                CSVResources qual$3 = this.$outer.resources();
                URL x$6 = new URL(url);
                Option x$7 = qual$3.getCsvIterator$default$2();
                List result = qual$3.getCsvIterator(x$6, x$7).toList();
                ((List)result.zip((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"a", "b"}), (String[])((Object[])new String[]{"1", "2"}), (String[])((Object[])new String[]{"3"})})), List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$3 $outer;

                    public final void apply(Tuple2<String[], String[]> x0$3) {
                        Tuple2<String[], String[]> tuple2 = x0$3;
                        if (tuple2 != null) {
                            String[] r = (String[])tuple2._1();
                            String[] expected = (String[])tuple2._2();
                            this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().convertToAnyShouldWrapper(r).should(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().equal(expected), (Object)Equality$.MODULE$.default());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CSVResourcesTest org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should give a helpful message when asking for headers with empty file", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String url = this.$outer.createCSVTempFileURL((Function1<PrintWriter, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PrintWriter x$1) {
                    }
                });
                CSVResources qual$4 = this.$outer.resources();
                URL x$8 = new URL(url);
                Option x$9 = qual$4.getCsvIterator$default$2();
                List result = qual$4.getCsvIterator(x$8, x$9).toList();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(List$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should register a task in the cleanupper", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String url = this.$outer.createCSVTempFileURL((Function1<PrintWriter, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PrintWriter writer) {
                        writer.println("a,b");
                        writer.println("1,2");
                        writer.println("3,4");
                    }
                });
                CSVResources qual$5 = this.$outer.resources();
                URL x$10 = new URL(url);
                Option x$11 = qual$5.getCsvIterator$default$2();
                qual$5.getCsvIterator(x$10, x$11);
                ((TaskCloser)Mockito.verify((Object)this.$outer.cleaner(), (VerificationMode)Mockito.times((int)1))).addTask((Function1)Matchers.any(Function1.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should accept and use a custom field terminator", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String url = this.$outer.createCSVTempFileURL((Function1<PrintWriter, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PrintWriter writer) {
                        writer.println("122\tfoo");
                        writer.println("23\tbar");
                        writer.println("3455\tbaz");
                        writer.println("4\tx");
                    }
                });
                List result = this.$outer.resources().getCsvIterator(new URL(url), (Option)new Some((Object)"\t")).toList();
                ((List)result.zip((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"122", "foo"}), (String[])((Object[])new String[]{"23", "bar"}), (String[])((Object[])new String[]{"3455", "baz"}), (String[])((Object[])new String[]{"4", "x"})})), List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final void apply(Tuple2<String[], String[]> x0$4) {
                        Tuple2<String[], String[]> tuple2 = x0$4;
                        if (tuple2 != null) {
                            String[] r = (String[])tuple2._1();
                            String[] expected = (String[])tuple2._2();
                            this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().convertToAnyShouldWrapper(r).should(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().equal(expected), (Object)Equality$.MODULE$.default());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CSVResourcesTest org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should treat the file as UTF-8 encoded", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String url = this.$outer.createCSVTempFileURL((Function1<PrintWriter, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PrintWriter writer) {
                        writer.println("Malm\u0246");
                        writer.println("K\u0248benhavn");
                    }
                });
                CSVResources qual$6 = this.$outer.resources();
                URL x$12 = new URL(url);
                Option x$13 = qual$6.getCsvIterator$default$2();
                List result = qual$6.getCsvIterator(x$12, x$13).toList();
                ((List)result.zip((GenIterable)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"Malm\u0246"}), (String[])((Object[])new String[]{"K\u0248benhavn"})})), List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final void apply(Tuple2<String[], String[]> x0$5) {
                        Tuple2<String[], String[]> tuple2 = x0$5;
                        if (tuple2 != null) {
                            String[] r = (String[])tuple2._1();
                            String[] expected = (String[])tuple2._2();
                            this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().convertToAnyShouldWrapper(r).should(this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().equal(expected), (Object)Equality$.MODULE$.default());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CSVResourcesTest org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should propagate source description", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CSVResourcesTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                String url = this.$outer.createCSVTempFileURL((Function1<PrintWriter, BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(PrintWriter writer) {
                        writer.println("\"quoted\" and then some");
                    }
                });
                IllegalStateException e = (IllegalStateException)this.$outer.intercept((Function0<Object>)new Serializable(this, url){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;
                    private final String url$1;

                    public final Iterator<String[]> apply() {
                        CSVResources qual$7 = this.$outer.org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer().resources();
                        URL x$14 = new URL(this.url$1);
                        Option x$15 = qual$7.getCsvIterator$default$2();
                        return qual$7.getCsvIterator(x$14, x$15);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.url$1 = url$1;
                    }
                }, ManifestFactory$.MODULE$.classType(IllegalStateException.class));
                this.$outer.convertToStringShouldWrapper(e.getMessage()).should(this.$outer.include().apply(url));
            }

            public /* synthetic */ CSVResourcesTest org$neo4j$cypher$internal$compiler$v2_2$spi$CSVResourcesTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

