/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.symbols;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.AnyType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CollectionType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CypherType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.package$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001#\tq1)\u001f9iKJ$\u0016\u0010]3UKN$(BA\u0002\u0005\u0003\u001d\u0019\u00180\u001c2pYNT!!\u0002\u0004\u0002\tY\u0014tL\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019b#D\u0001\u0015\u0015\t)\u0002\"A\u0004d_6lwN\\:\n\u0005]!\"AD\"za\",'OR;o'VLG/\u001a\u0005\u00063\u0001!\tAG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"\u0001\b\u0001\u000e\u0003\tAQA\b\u0001\u0005\n}\tQ#Y:tKJ$H*Z1tiV\u0003\b/\u001a:C_VtG\r\u0006\u0003!M-j\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#\u0001B+oSRDQaJ\u000fA\u0002!\n\u0011!\u0019\t\u00039%J!A\u000b\u0002\u0003\u0015\rK\b\u000f[3s)f\u0004X\rC\u0003-;\u0001\u0007\u0001&A\u0001c\u0011\u0015qS\u00041\u0001)\u0003\u0019\u0011Xm];mi\")\u0001\u0007\u0001C\u0005c\u0005A\u0012m]:feR<%/Z1uKN$Hj\\<fe\n{WO\u001c3\u0015\t\u0001\u00124\u0007\u000e\u0005\u0006O=\u0002\r\u0001\u000b\u0005\u0006Y=\u0002\r\u0001\u000b\u0005\u0006]=\u0002\r!\u000e\t\u0004CYB\u0013BA\u001c#\u0005\u0019y\u0005\u000f^5p]\u0002")
public class CypherTypeTest
extends CypherFunSuite {
    public void org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertLeastUpperBound(CypherType a, CypherType b, CypherType result) {
        CypherType simpleMergedType = a.leastUpperBound(b);
        this.convertToAnyShouldWrapper(simpleMergedType).should(this.equal(result), (Object)Equality$.MODULE$.default());
        CypherType collectionMergedType = package$.MODULE$.CTCollection(a).leastUpperBound((CypherType)package$.MODULE$.CTCollection(b));
        this.convertToAnyShouldWrapper(collectionMergedType).should(this.equal(package$.MODULE$.CTCollection(result)), (Object)Equality$.MODULE$.default());
    }

    public void org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound(CypherType a, CypherType b, Option<CypherType> result) {
        Option simpleMergedType = a.greatestLowerBound(b);
        this.convertToAnyShouldWrapper(simpleMergedType).should(this.equal(result), (Object)Equality$.MODULE$.default());
        Option collectionMergedType = package$.MODULE$.CTCollection(a).greatestLowerBound((CypherType)package$.MODULE$.CTCollection(b));
        this.convertToAnyShouldWrapper(collectionMergedType).should(this.equal(result.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final CollectionType.CollectionTypeImpl apply(CypherType t) {
                return package$.MODULE$.CTCollection(t);
            }
        })), (Object)Equality$.MODULE$.default());
    }

    public CypherTypeTest() {
        this.test("parents should be full path up type tree branch", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(package$.MODULE$.CTInteger().parents()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{package$.MODULE$.CTNumber(), package$.MODULE$.CTAny()}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(package$.MODULE$.CTNumber().parents()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyType[]{package$.MODULE$.CTAny()}))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(package$.MODULE$.CTAny().parents()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()).parents()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CypherType[]{package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), package$.MODULE$.CTAny()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should be assignable from sub-type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTNumber().isAssignableFrom((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTAny().isAssignableFrom((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()).isAssignableFrom((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNumber()).isAssignableFrom((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTInteger())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTInteger().isAssignableFrom((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTInteger()).isAssignableFrom((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should find leastUpperBound", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTAny());
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTString(), (CypherType)package$.MODULE$.CTAny());
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTAny());
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTFloat(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertLeastUpperBound((CypherType)package$.MODULE$.CTMap(), (CypherType)package$.MODULE$.CTFloat(), (CypherType)package$.MODULE$.CTAny());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should find greatestLowerBound", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CypherTypeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber(), (Option<CypherType>)new Some((Object)package$.MODULE$.CTNumber()));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTAny(), (Option<CypherType>)new Some((Object)package$.MODULE$.CTNumber()));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNumber()), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTInteger()), (Option<CypherType>)new Some((Object)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTInteger())));
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTString(), (Option<CypherType>)None$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (Option<CypherType>)None$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTFloat(), (Option<CypherType>)None$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTMap(), (CypherType)package$.MODULE$.CTFloat(), (Option<CypherType>)None$.MODULE$);
                this.$outer.org$neo4j$cypher$internal$compiler$v2_2$symbols$CypherTypeTest$$assertGreatestLowerBound((CypherType)package$.MODULE$.CTBoolean(), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (Option<CypherType>)None$.MODULE$);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

