/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.symbols;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.CypherTypeException;
import org.neo4j.cypher.internal.compiler.v2_2.SyntaxException;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Add;
import org.neo4j.cypher.internal.compiler.v2_2.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CollectionType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CypherType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.FakeExpression;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.SymbolTable;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.package$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0001\u0002\u0001#\ty1+_7c_2$\u0016M\u00197f)\u0016\u001cHO\u0003\u0002\u0004\t\u000591/_7c_2\u001c(BA\u0003\u0007\u0003\u00111(g\u0018\u001a\u000b\u0005\u001dA\u0011\u0001C2p[BLG.\u001a:\u000b\u0005%Q\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005-a\u0011AB2za\",'O\u0003\u0002\u000e\u001d\u0005)a.Z85U*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011Q\u0003C\u0001\bG>lWn\u001c8t\u0013\t9BC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001\"\u0002\u0010\u0001\t\u0003y\u0012!D2sK\u0006$XmU=nE>d7\u000f\u0006\u0002!GA\u0011A$I\u0005\u0003E\t\u00111bU=nE>dG+\u00192mK\")A%\ba\u0001K\u0005)Q\r\\3ngB\u0019a%K\u0016\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012!\u0002\u0010:fa\u0016\fG/\u001a3?!\u00111CFL\u001b\n\u00055:#A\u0002+va2,'\u0007\u0005\u00020e9\u0011a\u0005M\u0005\u0003c\u001d\na\u0001\u0015:fI\u00164\u0017BA\u001a5\u0005\u0019\u0019FO]5oO*\u0011\u0011g\n\t\u00039YJ!a\u000e\u0002\u0003\u0015\rK\b\u000f[3s)f\u0004X\r")
public class SymbolTableTest
extends CypherFunSuite {
    public SymbolTable createSymbols(Seq<Tuple2<String, CypherType>> elems) {
        return new SymbolTable((Map)elems.toMap(Predef$.MODULE$.conforms()));
    }

    public SymbolTableTest() {
        this.test("anytype_is_ok", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable s = this.$outer.createSymbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"p"), (Object)package$.MODULE$.CTPath())}));
                this.$outer.convertToAnyShouldWrapper(s.evaluateType("p", (CypherType)package$.MODULE$.CTAny())).should(this.$outer.equal(package$.MODULE$.CTPath()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("missing_identifier", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable s = this.$outer.createSymbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$);
                this.$outer.intercept((Function0<Object>)new Serializable(this, s){
                    public static final long serialVersionUID = 0L;
                    private final SymbolTable s$1;

                    public final CypherType apply() {
                        return this.s$1.evaluateType("p", (CypherType)package$.MODULE$.CTAny());
                    }
                    {
                        this.s$1 = s$1;
                    }
                }, ManifestFactory$.MODULE$.classType(SyntaxException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("identifier_with_wrong_type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.createSymbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"x"), (Object)package$.MODULE$.CTString())}));
                this.$outer.intercept((Function0<Object>)new Serializable(this, symbolTable){
                    public static final long serialVersionUID = 0L;
                    private final SymbolTable symbolTable$1;

                    public final CypherType apply() {
                        return this.symbolTable$1.evaluateType("x", (CypherType)package$.MODULE$.CTNumber());
                    }
                    {
                        this.symbolTable$1 = symbolTable$1;
                    }
                }, ManifestFactory$.MODULE$.classType(CypherTypeException.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("identifier_with_type_not_specific_enough", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.createSymbols((Seq<Tuple2<String, CypherType>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"x"), (Object)package$.MODULE$.CTMap())}));
                symbolTable.evaluateType("x", (CypherType)package$.MODULE$.CTRelationship());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("adding_string_with_string_gives_string_type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.createSymbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$);
                Add exp = new Add((Expression)new FakeExpression((CypherType)package$.MODULE$.CTString()), (Expression)new FakeExpression((CypherType)package$.MODULE$.CTString()));
                CypherType returnType = exp.evaluateType((CypherType)package$.MODULE$.CTAny(), symbolTable);
                this.$outer.convertToAnyShouldWrapper(returnType).should(this.$outer.equal(package$.MODULE$.CTString()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("adding_number_with_number_gives_number_type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.createSymbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$);
                Add exp = new Add((Expression)new FakeExpression((CypherType)package$.MODULE$.CTNumber()), (Expression)new FakeExpression((CypherType)package$.MODULE$.CTNumber()));
                CypherType returnType = exp.evaluateType((CypherType)package$.MODULE$.CTAny(), symbolTable);
                this.$outer.convertToAnyShouldWrapper(returnType).should(this.$outer.equal(package$.MODULE$.CTNumber()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("adding_to_string_collection", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SymbolTable symbolTable = this.$outer.createSymbols((Seq<Tuple2<String, CypherType>>)Nil$.MODULE$);
                Add exp = new Add((Expression)new FakeExpression((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())), (Expression)new FakeExpression((CypherType)package$.MODULE$.CTString()));
                CypherType returnType = exp.evaluateType((CypherType)package$.MODULE$.CTAny(), symbolTable);
                this.$outer.convertToAnyShouldWrapper(returnType).should(this.$outer.equal(package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("covariance", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SymbolTableTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CollectionType.CollectionTypeImpl actual = package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNode());
                CollectionType.CollectionTypeImpl expected = package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTMap());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)expected.isAssignableFrom((CypherType)actual))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

