/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_2.symbols;

import org.neo4j.cypher.internal.commons.CypherFunSuite;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CollectionType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.CypherType;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.TypeRange;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.TypeRange$;
import org.neo4j.cypher.internal.compiler.v2_2.symbols.package$;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u1A!\u0001\u0002\u0001#\tiA+\u001f9f%\u0006tw-\u001a+fgRT!a\u0001\u0003\u0002\u000fMLXNY8mg*\u0011QAB\u0001\u0005mJz&G\u0003\u0002\b\u0011\u0005A1m\\7qS2,'O\u0003\u0002\n\u0015\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\f\u0019\u000511-\u001f9iKJT!!\u0004\b\u0002\u000b9,w\u000e\u000e6\u000b\u0003=\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\n\u0011\u0005M1R\"\u0001\u000b\u000b\u0005UA\u0011aB2p[6|gn]\u0005\u0003/Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001a\u0001\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u00027A\u0011A\u0004A\u0007\u0002\u0005\u0001")
public class TypeRangeTest
extends CypherFunSuite {
    public TypeRangeTest() {
        this.test("TypeRange of single type should contain only that type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeOfInteger = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfInteger.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumber.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfCollectionAny = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()));
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfCollectionAny.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfCollectionAny.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfCollectionAny.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfCollectionAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfCollectionAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNumber())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfCollectionAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfCollectionAny.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("unbounded TypeRange rooted at CTAny should contain all", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtAny = new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTNode()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTFloat())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTFloat()))))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("unbounded TypeRange rooted at leaf type should contain leaf", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtInteger = new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeRootedAtCollectionOfNumber = new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNumber()), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionOfNumber.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTInteger())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionOfNumber.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTFloat())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionOfNumber.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNumber())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionOfNumber.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionOfNumber.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("unbounded TypeRange rooted at branch type should contain all more specific types", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtInteger = new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTFloat()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTString()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeRootedAtCollectionAny = new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTInteger())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny())))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionAny.contains((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTInteger()))))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionAny.contains((CypherType)package$.MODULE$.CTBoolean()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtCollectionAny.contains((CypherType)package$.MODULE$.CTAny()))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should contain overlapping range", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtNumber = new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$);
                TypeRange rangeRootedAtInteger = new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtNumber.contains(rangeRootedAtInteger))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumberToDouble = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTFloat());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeRootedAtInteger))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeRootedAtNumber))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfDouble = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTFloat(), (CypherType)package$.MODULE$.CTFloat());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                TypeRange rangeOfInteger = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeOfDouble))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeOfNumber))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeOfInteger))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                TypeRange rangeRootedAtDouble = new TypeRange((CypherType)package$.MODULE$.CTFloat(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeOfNumberToDouble.contains(rangeRootedAtDouble))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtDouble.contains(rangeOfDouble))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)rangeRootedAtInteger.contains(rangeRootedAtDouble))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range with overlapping range should not change range", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeRootedAtInteger = new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeRootedAtInteger.$amp(new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)rangeRootedAtInteger)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfInteger = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger());
                this.$outer.convertToAnyShouldWrapper(rangeOfInteger.$amp(new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)rangeOfInteger)), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)rangeOfNumber)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range with intersecting range should return intersection", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeOfNumber = new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                TypeRange rangeToNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(rangeToNumber.$amp(new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range to sub range should return sub range", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeOfAll = new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeOfAll.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfAll.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfAll.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTInteger()))), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumberToInteger = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTInteger());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumberToInteger.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumberToInteger.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger()))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTInteger(), (CypherType)package$.MODULE$.CTInteger()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range within collection", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeFromCollectionAny = new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeFromCollectionAny.$amp(new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$))).should(this.$outer.equal(new Some((Object)new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeFromCollectionAny.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())))).should(this.$outer.equal(new Some((Object)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("intersection of range with non overlapping range should return none", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeFromNumber = new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeFromNumber.$amp(new TypeRange((CypherType)package$.MODULE$.CTString(), (Option)None$.MODULE$))).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(new TypeRange((CypherType)package$.MODULE$.CTString(), (Option)None$.MODULE$))).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTBoolean(), (CypherType)package$.MODULE$.CTBoolean()))).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfAny = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTAny());
                this.$outer.convertToAnyShouldWrapper(rangeOfAny.$amp(rangeFromNumber)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfAny.$amp(rangeOfNumber)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeFromNumber.$amp(rangeOfAny)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(rangeOfNumber.$amp(rangeOfAny)).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("leastUpperBound with super type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeFromAny = new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$);
                TypeRange rangeOfAny = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTAny());
                this.$outer.convertToAnyShouldWrapper(rangeFromAny.leastUpperBounds(rangeOfAny)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{rangeOfAny}))), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfInteger = new TypeRange((CypherType)package$.MODULE$.CTInteger(), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeOfInteger.leastUpperBounds(rangeOfAny)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{rangeOfAny}))), (Object)Equality$.MODULE$.default());
                TypeRange rangeOfNumber = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTNumber(), (CypherType)package$.MODULE$.CTNumber());
                this.$outer.convertToAnyShouldWrapper(rangeOfInteger.leastUpperBounds(rangeOfNumber)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{rangeOfNumber}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("leastUpperBound with sub type", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TypeRange rangeFromCollectionAny = new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (Option)None$.MODULE$);
                TypeRange rangeOfCollectionAny = TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()));
                this.$outer.convertToAnyShouldWrapper(rangeFromCollectionAny.leastUpperBounds(rangeOfCollectionAny)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{rangeOfCollectionAny}))), (Object)Equality$.MODULE$.default());
                TypeRange rangeFromCollectionString = new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$);
                this.$outer.convertToAnyShouldWrapper(rangeFromCollectionAny.leastUpperBounds(rangeFromCollectionString)).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeRange[]{TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())), new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$)}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should have indefinite size when allowing unbound any at any depth", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTAny(), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTString(), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTNumber(), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTInteger()).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny())), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString())), (Option)None$.MODULE$).hasDefiniteSize())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.test("should reparent into collection", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TypeRangeTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(new TypeRange((CypherType)package$.MODULE$.CTString(), (Option)None$.MODULE$).reparent((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CollectionType.CollectionTypeImpl apply(CypherType inner) {
                        return package$.MODULE$.CTCollection(inner);
                    }
                })).should(this.$outer.equal(new TypeRange((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTString()), (Option)None$.MODULE$)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTAny(), (CypherType)package$.MODULE$.CTNumber()).reparent((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CollectionType.CollectionTypeImpl apply(CypherType inner) {
                        return package$.MODULE$.CTCollection(inner);
                    }
                })).should(this.$outer.equal(TypeRange$.MODULE$.apply((CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTAny()), (CypherType)package$.MODULE$.CTCollection((CypherType)package$.MODULE$.CTNumber()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

