/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3;

import org.neo4j.cypher.internal.compiler.v2_3.LRUCache;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001M2A!\u0001\u0002\u0001\u001f\taAJU+DC\u000eDW\rV3ti*\u00111\u0001B\u0001\u0005mJz6G\u0003\u0002\u0006\r\u0005A1m\\7qS2,'O\u0003\u0002\b\u0011\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\n\u0015\u000511-\u001f9iKJT!a\u0003\u0007\u0002\u000b9,w\u000e\u000e6\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E9R\"\u0001\n\u000b\u0005M!\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0002\u0016\u0015\t1b!\u0001\u0005ge>tG/\u001a8e\u0013\tA\"C\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u0005\u0011\u0001\"B\u0010\u0001\t\u0003\u0001\u0013!\u00054jY2<\u0016\u000e\u001e5P]\u0016$vNR5wKR\u0011\u0011e\n\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0005+:LG\u000fC\u0003)=\u0001\u0007\u0011&A\u0003dC\u000eDW\r\u0005\u0003\u001eU1b\u0013BA\u0016\u0003\u0005!a%+V\"bG\",\u0007CA\u00171\u001d\t\u0011c&\u0003\u00020G\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\ty3\u0005")
public class LRUCacheTest
extends CypherFunSuite {
    public void fillWithOneToFive(LRUCache<String, String> cache) {
        cache.put((Object)"1", (Object)"1");
        cache.put((Object)"2", (Object)"2");
        cache.put((Object)"3", (Object)"3");
        cache.put((Object)"4", (Object)"4");
        cache.put((Object)"5", (Object)"5");
    }

    public LRUCacheTest() {
        this.test("shouldStoreSingleValue", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LRUCacheTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LRUCache cache = new LRUCache(5);
                cache.getOrElseUpdate((Object)"hello", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "world";
                    }
                });
                this.$outer.convertToAnyShouldWrapper(cache.get((Object)"hello")).should(this.$outer.equal(new Some((Object)"world")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldLooseTheFirstOne", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LRUCacheTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LRUCache cache = new LRUCache(5);
                this.$outer.fillWithOneToFive((LRUCache<String, String>)cache);
                cache.getOrElseUpdate((Object)"6", (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "6";
                    }
                });
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)cache.containsKey((Object)"1"))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("shouldLooseTheLeastUsedItem", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LRUCacheTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LRUCache cache = new LRUCache(5);
                this.$outer.fillWithOneToFive((LRUCache<String, String>)cache);
                cache.get((Object)"1");
                cache.get((Object)"3");
                cache.get((Object)"4");
                cache.get((Object)"5");
                cache.put((Object)"6", (Object)"6");
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)cache.containsKey((Object)"2"))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

