/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.commands.expressions;

import org.neo4j.cypher.internal.compiler.v2_3.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.ToIntFunction;
import org.neo4j.cypher.internal.compiler.v2_3.commands.expressions.ToIntFunctionTest$;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v2_3.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001'\t\tBk\\%oi\u001a+hn\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r|W.\\1oINT!a\u0002\u0005\u0002\tY\u0014tl\r\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)2$D\u0001\u0017\u0015\t9\u0002$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\b3)\u0011!DC\u0001\tMJ|g\u000e^3oI&\u0011AD\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!\u0001C\u0003$\u0001\u0011%A%A\u0003u_&sG\u000f\u0006\u0002&WA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t\u0019\u0011I\\=\t\u000b1\u0012\u0003\u0019A\u0013\u0002\t=\u0014\u0018n\u001a")
public class ToIntFunctionTest
extends CypherFunSuite {
    public Object org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt(Object orig) {
        return new ToIntFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public ToIntFunctionTest() {
        this.test("should return null if argument is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt(null));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string to an integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("10")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)10)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a double to an integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt(BoxesRunTime.boxToDouble((double)23.5))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)23)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should parse float and truncate to int if the argument is a float literal", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("20.5")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)20)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a partially numeric string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("20foobar2"));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a hexadecimal string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("0x20"));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading zeros to an integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("000123121")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)123121)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus in a negative integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("-12")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)-12)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus and zeros in a negative integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("-00012")).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)-12)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should throw an exception if the argument is an object which cannot be converted to integer", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$10 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt(new Object());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
            }

            public /* synthetic */ ToIntFunctionTest org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("given an integer should give the same value back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt(BoxesRunTime.boxToInteger((int)50))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)50)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should truncate floats if given a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt(BoxesRunTime.boxToFloat((float)20.6f))).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)20)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail for larger integers larger that 8 bytes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$13 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("10508455564958384115");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
            }

            public /* synthetic */ ToIntFunctionTest org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle floats larger than 2^31 - 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("8589934592.0")).should(this.$outer.equal(BoxesRunTime.boxToLong((long)0x200000000L)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle -2^63", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("-9223372036854775808")).should(this.$outer.equal(BoxesRunTime.boxToLong((long)Long.MIN_VALUE)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cannot handle -2^63-1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$16 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("-9223372036854775809");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
            }

            public /* synthetic */ ToIntFunctionTest org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should handle 2^63 - 1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("9223372036854775807")).should(this.$outer.equal(BoxesRunTime.boxToLong((long)Long.MAX_VALUE)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("cannot handle 2^63", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToIntFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$18 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$toInt("9223372036854775808");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(CypherTypeException.class)));
            }

            public /* synthetic */ ToIntFunctionTest org$neo4j$cypher$internal$compiler$v2_3$commands$expressions$ToIntFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

