/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.executionplan;

import java.net.URL;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.cypher.internal.compiler.v2_3.executionplan.LoadCsvPeriodicCommitObserver;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.ExternalResource;
import org.neo4j.cypher.internal.compiler.v2_3.spi.QueryContext;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001#\t\tCj\\1e\u0007N4\b+\u001a:j_\u0012L7mQ8n[&$xJY:feZ,'\u000fV3ti*\u00111\u0001B\u0001\u000eKb,7-\u001e;j_:\u0004H.\u00198\u000b\u0005\u00151\u0011\u0001\u0002<3?NR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u001435\tAC\u0003\u0002\u0016-\u0005aA/Z:u?\",G\u000e]3sg*\u0011Qa\u0006\u0006\u00031!\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00035Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u0005!I\u0011\u0005\u0001a\u0001\u0002\u0004%\tAI\u0001\u0012e\u0016\u001cx.\u001e:dKVsG-\u001a:UKN$X#A\u0012\u0011\u0005}!\u0013BA\u0013\u0003\u0005uau.\u00193DgZ\u0004VM]5pI&\u001c7i\\7nSR|%m]3sm\u0016\u0014\b\"C\u0014\u0001\u0001\u0004\u0005\r\u0011\"\u0001)\u0003U\u0011Xm]8ve\u000e,WK\u001c3feR+7\u000f^0%KF$\"!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\tUs\u0017\u000e\u001e\u0005\ba\u0019\n\t\u00111\u0001$\u0003\rAH%\r\u0005\u0007e\u0001\u0001\u000b\u0015B\u0012\u0002%I,7o\\;sG\u0016,f\u000eZ3s)\u0016\u001cH\u000f\t\u0005\ni\u0001\u0001\r\u00111A\u0005\u0002U\nA\"];fef\u001cuN\u001c;fqR,\u0012A\u000e\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0011\t1a\u001d9j\u0013\tY\u0004H\u0001\u0007Rk\u0016\u0014\u0018pQ8oi\u0016DH\u000fC\u0005>\u0001\u0001\u0007\t\u0019!C\u0001}\u0005\u0001\u0012/^3ss\u000e{g\u000e^3yi~#S-\u001d\u000b\u0003S}Bq\u0001\r\u001f\u0002\u0002\u0003\u0007a\u0007\u0003\u0004B\u0001\u0001\u0006KAN\u0001\u000ecV,'/_\"p]R,\u0007\u0010\u001e\u0011\t\u0013\r\u0003\u0001\u0019!a\u0001\n\u0003!\u0015\u0001\u0003:fg>,(oY3\u0016\u0003\u0015\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0003\u0002\u000bAL\u0007/Z:\n\u0005);%\u0001E#yi\u0016\u0014h.\u00197SKN|WO]2f\u0011%a\u0005\u00011AA\u0002\u0013\u0005Q*\u0001\u0007sKN|WO]2f?\u0012*\u0017\u000f\u0006\u0002*\u001d\"9\u0001gSA\u0001\u0002\u0004)\u0005B\u0002)\u0001A\u0003&Q)A\u0005sKN|WO]2fA!9!\u000b\u0001b\u0001\n\u0003\u0019\u0016aA;sYV\tA\u000b\u0005\u0002V56\taK\u0003\u0002X1\u0006\u0019a.\u001a;\u000b\u0003e\u000bAA[1wC&\u00111L\u0016\u0002\u0004+Jc\u0005BB/\u0001A\u0003%A+\u0001\u0003ve2\u0004\u0003\"B0\u0001\t#\u0002\u0017A\u00032fM>\u0014X-R1dQR\t\u0011\u0006")
public class LoadCsvPeriodicCommitObserverTest
extends CypherFunSuite {
    private LoadCsvPeriodicCommitObserver resourceUnderTest;
    private QueryContext queryContext;
    private ExternalResource resource;
    private final URL url = new URL("file:///tmp/something.csv");

    public LoadCsvPeriodicCommitObserver resourceUnderTest() {
        return this.resourceUnderTest;
    }

    public void resourceUnderTest_$eq(LoadCsvPeriodicCommitObserver x$1) {
        this.resourceUnderTest = x$1;
    }

    public QueryContext queryContext() {
        return this.queryContext;
    }

    public void queryContext_$eq(QueryContext x$1) {
        this.queryContext = x$1;
    }

    public ExternalResource resource() {
        return this.resource;
    }

    public void resource_$eq(ExternalResource x$1) {
        this.resource = x$1;
    }

    public URL url() {
        return this.url;
    }

    public void beforeEach() {
        this.queryContext_$eq((QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class)));
        this.resource_$eq((ExternalResource)this.mock(ManifestFactory$.MODULE$.classType(ExternalResource.class)));
        this.resourceUnderTest_$eq(new LoadCsvPeriodicCommitObserver(1L, this.resource(), this.queryContext()));
    }

    public LoadCsvPeriodicCommitObserverTest() {
        this.test("writing should not trigger tx restart until next csv line is fetched", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any())).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})})));
                LoadCsvPeriodicCommitObserver qual$1 = this.$outer.resourceUnderTest();
                URL x$1 = this.$outer.url();
                Option x$2 = qual$1.getCsvIterator$default$2();
                Iterator iterator = qual$1.getCsvIterator(x$1, x$2);
                ((QueryContext)Mockito.verify((Object)this.$outer.queryContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                iterator.next();
                ((QueryContext)Mockito.verify((Object)this.$outer.queryContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("multiple iterators are still handled correctly only commit when the first iterator advances", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Mockito.when((Object)this.$outer.resource().getCsvIterator((URL)Matchers.eq((Object)this.$outer.url()), (Option)Matchers.any())).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})}))).thenReturn((Object)package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[][]{(String[])((Object[])new String[]{"yo"})})));
                LoadCsvPeriodicCommitObserver qual$2 = this.$outer.resourceUnderTest();
                URL x$3 = this.$outer.url();
                Option x$4 = qual$2.getCsvIterator$default$2();
                Iterator iterator1 = qual$2.getCsvIterator(x$3, x$4);
                LoadCsvPeriodicCommitObserver qual$3 = this.$outer.resourceUnderTest();
                URL x$5 = this.$outer.url();
                Option x$6 = qual$3.getCsvIterator$default$2();
                Iterator iterator2 = qual$3.getCsvIterator(x$5, x$6);
                iterator2.next();
                ((QueryContext)Mockito.verify((Object)this.$outer.queryContext(), (VerificationMode)Mockito.never())).commitAndRestartTx();
                iterator1.next();
                ((QueryContext)Mockito.verify((Object)this.$outer.queryContext(), (VerificationMode)Mockito.times((int)1))).commitAndRestartTx();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("if a custom iterator is specified should be passed to the wrapped resource", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LoadCsvPeriodicCommitObserverTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resourceUnderTest().getCsvIterator(this.$outer.url(), (Option)new Some((Object)";"));
                ((ExternalResource)Mockito.verify((Object)this.$outer.resource(), (VerificationMode)Mockito.times((int)1))).getCsvIterator(this.$outer.url(), (Option)new Some((Object)";"));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

