/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.helpers;

import org.neo4j.cypher.internal.compiler.v2_3.helpers.ArrayBackedMap;
import org.neo4j.cypher.internal.compiler.v2_3.helpers.ArrayBackedMap$;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00012A!\u0001\u0002\u0001#\t\u0011\u0012I\u001d:bs\n\u000b7m[3e\u001b\u0006\u0004H+Z:u\u0015\t\u0019A!A\u0004iK2\u0004XM]:\u000b\u0005\u00151\u0011\u0001\u0002<3?NR!a\u0002\u0005\u0002\u0011\r|W\u000e]5mKJT!!\u0003\u0006\u0002\u0011%tG/\u001a:oC2T!a\u0003\u0007\u0002\r\rL\b\u000f[3s\u0015\tia\"A\u0003oK>$$NC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u001435\tAC\u0003\u0002\u0016-\u0005aA/Z:u?\",G\u000e]3sg*\u0011Qa\u0006\u0006\u00031!\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00035Q\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001d\u0001\u0011\u0005Q$\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011q\u0004A\u0007\u0002\u0005\u0001")
public class ArrayBackedMapTest
extends CypherFunSuite {
    public ArrayBackedMapTest() {
        this.test("updating and getting", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"other")).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("+ operator with existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                Map updatedMap = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)"oen"));
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"name")).should(this.$outer.equal(new Some((Object)"oen")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("+ operator with non-existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                Map updatedMap = map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"age"), (Object)"35"));
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"age")).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"age")).should(this.$outer.equal(new Some((Object)"35")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("- operator on existing key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                Map updatedMap = map.$minus((Object)"name");
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"name")).should(this.$outer.equal(None$.MODULE$), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(updatedMap.get((Object)"id")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("iterating over map", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", "id"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                this.$outer.convertToAnyShouldWrapper(map.iterator().toSet()).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"name", (Object)"neo"), new Tuple2((Object)"id", (Object)"123")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("support one null key", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", null}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", "123"});
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get(null)).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("support for null values", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{null, "123", null});
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"a")).should(this.$outer.equal(new Some(null)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"b")).should(this.$outer.equal(new Some((Object)"123")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"c")).should(this.$outer.equal(new Some(null)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("support one null key mapped to null value", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"name", null}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"neo", null});
                this.$outer.convertToAnyShouldWrapper(map.get((Object)"name")).should(this.$outer.equal(new Some((Object)"neo")), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(map.get(null)).should(this.$outer.equal(new Some(null)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("having multiple nulls means that the last null is mapped", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ArrayBackedMapTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ArrayBackedMap map = ArrayBackedMap$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{null, null, null}), ClassTag$.MODULE$.apply(String.class));
                map.putValues((Object)new String[]{"v1", "v2", "v3"});
                this.$outer.convertToAnyShouldWrapper(map.get(null)).should(this.$outer.equal(new Some((Object)"v3")), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

