/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.planDescription;

import org.neo4j.cypher.internal.compiler.v2_3.pipes.Pipe;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.Children;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.InternalPlanDescription;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.NoChildren$;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.PlanDescriptionImpl;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.SingleChild;
import org.neo4j.cypher.internal.compiler.v2_3.planDescription.TwoChildren;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%2A!\u0001\u0002\u0001#\tY\u0012J\u001c;fe:\fG\u000e\u00157b]\u0012+7o\u0019:jaRLwN\u001c+fgRT!a\u0001\u0003\u0002\u001fAd\u0017M\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:T!!\u0002\u0004\u0002\tY\u0014tl\r\u0006\u0003\u000f!\t\u0001bY8na&dWM\u001d\u0006\u0003\u0013)\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u00171\taaY=qQ\u0016\u0014(BA\u0007\u000f\u0003\u0015qWm\u001c\u001bk\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019\u0012$D\u0001\u0015\u0015\t)b#\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\u0006/)\u0011\u0001\u0004C\u0001\tMJ|g\u000e^3oI&\u0011!\u0004\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0003\u0019a\u0014N\\5u}Q\ta\u0004\u0005\u0002 \u00015\t!\u0001C\u0003\"\u0001\u0011\u0005!%\u0001\u0003qSB,W#A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011!\u00029ja\u0016\u001c\u0018B\u0001\u0015&\u0005\u0011\u0001\u0016\u000e]3")
public class InternalPlanDescriptionTest
extends CypherFunSuite {
    public Pipe pipe() {
        return (Pipe)this.mock(ManifestFactory$.MODULE$.classType(Pipe.class));
    }

    public InternalPlanDescriptionTest() {
        this.test("flatten behaves like expected for plan with two children", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InternalPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl child1 = new PlanDescriptionImpl(this.$outer.pipe().id(), "child1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl child2 = new PlanDescriptionImpl(this.$outer.pipe().id(), "child2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl top = new PlanDescriptionImpl(this.$outer.pipe().id(), "top", (Children)new TwoChildren((InternalPlanDescription)child1, (InternalPlanDescription)child2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(top.flatten()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlanDescriptionImpl[]{top, child1, child2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("single plan flattened stays single", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InternalPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl single2 = new PlanDescriptionImpl(this.$outer.pipe().id(), "single", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(single2.flatten()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlanDescriptionImpl[]{single2}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("left leaning plan should also flatten out nicely", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InternalPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl leaf = new PlanDescriptionImpl(this.$outer.pipe().id(), "leaf", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl lvl1 = new PlanDescriptionImpl(this.$outer.pipe().id(), "lvl1", (Children)new SingleChild((InternalPlanDescription)leaf), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl lvl2 = new PlanDescriptionImpl(this.$outer.pipe().id(), "lvl2", (Children)new SingleChild((InternalPlanDescription)lvl1), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl root = new PlanDescriptionImpl(this.$outer.pipe().id(), "root", (Children)new SingleChild((InternalPlanDescription)lvl2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(root.flatten()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlanDescriptionImpl[]{root, lvl2, lvl1, leaf}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("bushy tree flattens correctly", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ InternalPlanDescriptionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PlanDescriptionImpl C4 = new PlanDescriptionImpl(this.$outer.pipe().id(), "C4", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl C3 = new PlanDescriptionImpl(this.$outer.pipe().id(), "C3", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl C2 = new PlanDescriptionImpl(this.$outer.pipe().id(), "C2", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl C1 = new PlanDescriptionImpl(this.$outer.pipe().id(), "C1", (Children)NoChildren$.MODULE$, (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl B2 = new PlanDescriptionImpl(this.$outer.pipe().id(), "B2", (Children)new TwoChildren((InternalPlanDescription)C3, (InternalPlanDescription)C4), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl B1 = new PlanDescriptionImpl(this.$outer.pipe().id(), "B1", (Children)new TwoChildren((InternalPlanDescription)C1, (InternalPlanDescription)C2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                PlanDescriptionImpl A = new PlanDescriptionImpl(this.$outer.pipe().id(), "A", (Children)new TwoChildren((InternalPlanDescription)B1, (InternalPlanDescription)B2), (Seq)Seq$.MODULE$.empty(), (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(A.flatten()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PlanDescriptionImpl[]{A, B1, C1, C2, B2, C3, C4}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

