/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v2_3.planner.logical;

import org.neo4j.cypher.internal.compiler.v2_3.ASTRewriter;
import org.neo4j.cypher.internal.compiler.v2_3.SemanticChecker;
import org.neo4j.cypher.internal.compiler.v2_3.pipes.LazyLabel;
import org.neo4j.cypher.internal.compiler.v2_3.planner.FakePlan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.LogicalPlanConstructionTestSupport$class;
import org.neo4j.cypher.internal.compiler.v2_3.planner.LogicalPlanningConfiguration;
import org.neo4j.cypher.internal.compiler.v2_3.planner.LogicalPlanningTestSupport2;
import org.neo4j.cypher.internal.compiler.v2_3.planner.LogicalPlanningTestSupport2$class;
import org.neo4j.cypher.internal.compiler.v2_3.planner.PlannerQuery;
import org.neo4j.cypher.internal.compiler.v2_3.planner.RealLogicalPlanningConfiguration;
import org.neo4j.cypher.internal.compiler.v2_3.planner.SemanticPlan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.SimpleTokenResolver;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.Cardinality;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.DefaultQueryPlanner;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.LogicalPlanningContext;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.QueryGraphSolver;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.greedy.GreedyPlanTable;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.AllNodesScan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.IdName;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.Limit;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.LogicalPlan;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.Projection;
import org.neo4j.cypher.internal.compiler.v2_3.planner.logical.plans.rewriter.LogicalPlanRewriter;
import org.neo4j.cypher.internal.compiler.v2_3.tracing.rewriters.ValidatingRewriterStepSequencer;
import org.neo4j.cypher.internal.frontend.v2_3.InputPosition;
import org.neo4j.cypher.internal.frontend.v2_3.PropertyKeyId;
import org.neo4j.cypher.internal.frontend.v2_3.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Equals;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Expression;
import org.neo4j.cypher.internal.frontend.v2_3.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v2_3.ast.Identifier;
import org.neo4j.cypher.internal.frontend.v2_3.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v2_3.parser.CypherParser;
import org.neo4j.cypher.internal.frontend.v2_3.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import org.scalatest.matchers.BeMatcher;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Symbol;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u0001\u00192A!\u0001\u0002\u0001'\tYr+\u001b;i!2\fgN\\5oO&sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\u000f1|w-[2bY*\u0011QAB\u0001\ba2\fgN\\3s\u0015\t9\u0001\"\u0001\u0003we}\u001b$BA\u0005\u000b\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001F\u000f\u0011\u0005UYR\"\u0001\f\u000b\u0005]A\u0012\u0001\u0004;fgR|\u0006.\u001a7qKJ\u001c(BA\u0004\u001a\u0015\tQ\"\"\u0001\u0005ge>tG/\u001a8e\u0013\tabC\u0001\bDsBDWM\u001d$v]N+\u0018\u000e^3\u0011\u0005yyR\"\u0001\u0003\n\u0005\u0001\"!a\u0007'pO&\u001c\u0017\r\u001c)mC:t\u0017N\\4UKN$8+\u001e9q_J$(\u0007C\u0003#\u0001\u0011\u00051%\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0005A\u0007\u0002\u0005\u0001")
public class WithPlanningIntegrationTest
extends CypherFunSuite
implements LogicalPlanningTestSupport2 {
    private final PlannerQuery solved;
    private CypherParser parser;
    private SemanticChecker semanticChecker;
    private final Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer;
    private ASTRewriter astRewriter;
    private SimpleTokenResolver tokenResolver;
    private final LogicalPlanRewriter planRewriter;
    private DefaultQueryPlanner planner;
    private QueryGraphSolver queryGraphSolver;
    private final RealLogicalPlanningConfiguration realConfig;
    private final InputPosition pos;

    @Override
    public PlannerQuery solved() {
        return this.solved;
    }

    @Override
    public CypherParser parser() {
        return this.parser;
    }

    @Override
    @TraitSetter
    public void parser_$eq(CypherParser x$1) {
        this.parser = x$1;
    }

    @Override
    public SemanticChecker semanticChecker() {
        return this.semanticChecker;
    }

    @Override
    @TraitSetter
    public void semanticChecker_$eq(SemanticChecker x$1) {
        this.semanticChecker = x$1;
    }

    @Override
    public Function1<String, ValidatingRewriterStepSequencer> rewriterSequencer() {
        return this.rewriterSequencer;
    }

    @Override
    public ASTRewriter astRewriter() {
        return this.astRewriter;
    }

    @Override
    @TraitSetter
    public void astRewriter_$eq(ASTRewriter x$1) {
        this.astRewriter = x$1;
    }

    @Override
    public SimpleTokenResolver tokenResolver() {
        return this.tokenResolver;
    }

    @Override
    @TraitSetter
    public void tokenResolver_$eq(SimpleTokenResolver x$1) {
        this.tokenResolver = x$1;
    }

    @Override
    public LogicalPlanRewriter planRewriter() {
        return this.planRewriter;
    }

    @Override
    public final DefaultQueryPlanner planner() {
        return this.planner;
    }

    @Override
    @TraitSetter
    public final void planner_$eq(DefaultQueryPlanner x$1) {
        this.planner = x$1;
    }

    @Override
    public QueryGraphSolver queryGraphSolver() {
        return this.queryGraphSolver;
    }

    @Override
    @TraitSetter
    public void queryGraphSolver_$eq(QueryGraphSolver x$1) {
        this.queryGraphSolver = x$1;
    }

    @Override
    public RealLogicalPlanningConfiguration realConfig() {
        return this.realConfig;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$LogicalPlanningTestSupport2$_setter_$solved_$eq(PlannerQuery x$1) {
        this.solved = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$LogicalPlanningTestSupport2$_setter_$rewriterSequencer_$eq(Function1 x$1) {
        this.rewriterSequencer = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$LogicalPlanningTestSupport2$_setter_$planRewriter_$eq(LogicalPlanRewriter x$1) {
        this.planRewriter = x$1;
    }

    @Override
    public void org$neo4j$cypher$internal$compiler$v2_3$planner$LogicalPlanningTestSupport2$_setter_$realConfig_$eq(RealLogicalPlanningConfiguration x$1) {
        this.realConfig = x$1;
    }

    @Override
    public PlannerQuery solvedWithEstimation(Cardinality cardinality) {
        return LogicalPlanningTestSupport2$class.solvedWithEstimation(this, cardinality);
    }

    @Override
    public <C extends LogicalPlanningConfiguration> LogicalPlanningTestSupport2.LogicalPlanningEnvironment<C> LogicalPlanningEnvironment(C config) {
        return LogicalPlanningTestSupport2$class.LogicalPlanningEnvironment(this, config);
    }

    @Override
    public FakePlan fakeLogicalPlanFor(Seq<String> id) {
        return LogicalPlanningTestSupport2$class.fakeLogicalPlanFor(this, id);
    }

    @Override
    public SemanticPlan planFor(String queryString) {
        return LogicalPlanningTestSupport2$class.planFor(this, queryString);
    }

    @Override
    public GreedyPlanTable greedyPlanTableWith(Seq<LogicalPlan> plans, LogicalPlanningContext ctx) {
        return LogicalPlanningTestSupport2$class.greedyPlanTableWith(this, plans, ctx);
    }

    @Override
    public LazyLabel lazyLabel(String label, SemanticPlan plan) {
        return LogicalPlanningTestSupport2$class.lazyLabel(this, label, plan);
    }

    @Override
    public PropertyKeyId propertyKeyId(String label, SemanticPlan plan) {
        return LogicalPlanningTestSupport2$class.propertyKeyId(this, label, plan);
    }

    @Override
    public <T extends LogicalPlan> BeMatcher<SemanticPlan> using(ClassTag<T> tag) {
        return LogicalPlanningTestSupport2$class.using(this, tag);
    }

    @Override
    public IdName idName(String name) {
        return LogicalPlanConstructionTestSupport$class.idName(this, name);
    }

    @Override
    public IdName idSymbol(Symbol name) {
        return LogicalPlanConstructionTestSupport$class.idSymbol(this, name);
    }

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v2_3$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Identifier ident(String name) {
        return AstConstructionTestSupport.class.ident((AstConstructionTestSupport)this, (String)name);
    }

    public HasLabels hasLabels(String identifier, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)identifier, (String)label);
    }

    public Equals propEquality(String identifier, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)identifier, (String)propKey, (int)intValue);
    }

    public WithPlanningIntegrationTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        LogicalPlanConstructionTestSupport$class.$init$(this);
        LogicalPlanningTestSupport2$class.$init$(this);
        this.test("should build plans for simple WITH that adds a constant to the rows", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan result = this.$outer.planFor("MATCH (a) WITH a LIMIT 1 RETURN 1 as `b`").plan();
                Projection expected = new Projection((LogicalPlan)new Limit((LogicalPlan)new AllNodesScan(this.$outer.idName("a"), Predef$.MODULE$.Set().empty(), this.$outer.solved()), (Expression)new SignedDecimalIntegerLiteral("1", this.$outer.pos()), this.$outer.solved()), (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), this.$outer.withPos(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final SignedDecimalIntegerLiteral apply(InputPosition position) {
                        return new SignedDecimalIntegerLiteral("1", position);
                    }
                }))})), this.$outer.solved());
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(expected), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that contain multiple WITH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan result = this.$outer.planFor("MATCH (a) WITH a LIMIT 1 MATCH (a)-[r1]->(b) WITH a, b, r1 LIMIT 1 RETURN b as `b`").plan();
                String resultText = result.toString();
                this.$outer.convertToStringShouldWrapper(resultText).should(this.$outer.equal("Limit(Expand(Limit(AllNodesScan(IdName(a),Set()),SignedDecimalIntegerLiteral(1)),IdName(a),OUTGOING,List(),IdName(b),IdName(r1),ExpandAll),SignedDecimalIntegerLiteral(1))"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans with WITH and selections", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan result = this.$outer.planFor("MATCH (a) WITH a LIMIT 1 MATCH (a)-[r1]->(b) WHERE r1.prop = 42 RETURN r1").plan();
                this.$outer.convertToStringShouldWrapper(result.toString()).should(this.$outer.equal("Selection(Vector(In(Property(Identifier(r1),PropertyKeyName(prop)),Collection(List(SignedDecimalIntegerLiteral(42))))),Expand(Limit(AllNodesScan(IdName(a),Set()),SignedDecimalIntegerLiteral(1)),IdName(a),OUTGOING,List(),IdName(b),IdName(r1),ExpandAll))"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans for two matches separated by WITH", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan result = this.$outer.planFor("MATCH (a) WITH a LIMIT 1 MATCH (a)-[r]->(b) RETURN b").plan();
                this.$outer.convertToStringShouldWrapper(result.toString()).should(this.$outer.equal("Expand(Limit(AllNodesScan(IdName(a),Set()),SignedDecimalIntegerLiteral(1)),IdName(a),OUTGOING,List(),IdName(b),IdName(r),ExpandAll)"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project endpoints of re-matched directed relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = this.$outer.planFor("MATCH (a)-[r]->(b) WITH r LIMIT 1 MATCH (u)-[r]->(v) RETURN r").plan();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal("Apply(Limit(Expand(AllNodesScan(IdName(b),Set()),IdName(b),INCOMING,List(),IdName(a),IdName(r),ExpandAll),SignedDecimalIntegerLiteral(1)),ProjectEndpoints(Argument(Set(IdName(r))),IdName(r),IdName(u),false,IdName(v),false,None,true,SimplePatternLength))"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project endpoints of re-matched reversed directed relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = this.$outer.planFor("MATCH (a)-[r]->(b) WITH r AS r, a AS a LIMIT 1 MATCH (b2)<-[r]-(a) RETURN r").plan();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal("Apply(Limit(Expand(AllNodesScan(IdName(b),Set()),IdName(b),INCOMING,List(),IdName(a),IdName(r),ExpandAll),SignedDecimalIntegerLiteral(1)),ProjectEndpoints(Argument(Set(IdName(a), IdName(r))),IdName(r),IdName(a),true,IdName(b2),false,None,true,SimplePatternLength))"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that verify endpoints of re-matched directed relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = this.$outer.planFor("MATCH (a)-[r]->(b) WITH * LIMIT 1 MATCH (a)-[r]->(b) RETURN r").plan();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal("Apply(Limit(Expand(AllNodesScan(IdName(b),Set()),IdName(b),INCOMING,List(),IdName(a),IdName(r),ExpandAll),SignedDecimalIntegerLiteral(1)),ProjectEndpoints(Argument(Set(IdName(a), IdName(b), IdName(r))),IdName(r),IdName(a),true,IdName(b),true,None,true,SimplePatternLength))"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project and verify endpoints of re-matched directed relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = this.$outer.planFor("MATCH (a)-[r]->(b) WITH a AS a, r AS r LIMIT 1 MATCH (a)-[r]->(b2) RETURN r").plan();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal("Apply(Limit(Expand(AllNodesScan(IdName(b),Set()),IdName(b),INCOMING,List(),IdName(a),IdName(r),ExpandAll),SignedDecimalIntegerLiteral(1)),ProjectEndpoints(Argument(Set(IdName(a), IdName(r))),IdName(r),IdName(a),true,IdName(b2),false,None,true,SimplePatternLength))"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project and verify endpoints of re-matched undirected relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = this.$outer.planFor("MATCH (a)-[r]->(b) WITH a AS a, r AS r LIMIT 1 MATCH (a)-[r]-(b2) RETURN r").plan();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal("Apply(Limit(Expand(AllNodesScan(IdName(b),Set()),IdName(b),INCOMING,List(),IdName(a),IdName(r),ExpandAll),SignedDecimalIntegerLiteral(1)),ProjectEndpoints(Argument(Set(IdName(a), IdName(r))),IdName(r),IdName(a),true,IdName(b2),false,None,false,SimplePatternLength))"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should build plans that project and verify endpoints of re-matched directed var length relationship arguments", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ WithPlanningIntegrationTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                LogicalPlan plan = this.$outer.planFor("MATCH (a)-[r*]->(b) WITH a AS a, r AS r LIMIT 1 MATCH (a)-[r*]->(b2) RETURN r").plan();
                this.$outer.convertToStringShouldWrapper(plan.toString()).should(this.$outer.equal("Apply(Limit(VarExpand(AllNodesScan(IdName(b),Set()),IdName(b),INCOMING,OUTGOING,List(),IdName(a),IdName(r),VarPatternLength(1,None),ExpandAll,Vector()),SignedDecimalIntegerLiteral(1)),ProjectEndpoints(Argument(Set(IdName(a), IdName(r))),IdName(r),IdName(a),true,IdName(b2),false,None,true,VarPatternLength(1,None)))"), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

