/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1;

import org.neo4j.cypher.internal.frontend.v3_1.DummyPosition$;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticError;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticState;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticState$;
import org.neo4j.cypher.internal.frontend.v3_1.Symbol;
import org.neo4j.cypher.internal.frontend.v3_1.ast.DummyExpression;
import org.neo4j.cypher.internal.frontend.v3_1.ast.DummyExpression$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Expression;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_1.ast.PropertyKeyName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_1.symbols.CypherType;
import org.neo4j.cypher.internal.frontend.v3_1.symbols.TypeSpec;
import org.neo4j.cypher.internal.frontend.v3_1.symbols.package$;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001f\t\t2+Z7b]RL7m\u0015;bi\u0016$Vm\u001d;\u000b\u0005\r!\u0011\u0001\u0002<4?FR!!\u0002\u0004\u0002\u0011\r|W\u000e]5mKJT!a\u0002\u0005\u0002\u0011%tG/\u001a:oC2T!!\u0003\u0006\u0002\r\rL\b\u000f[3s\u0015\tYA\"A\u0003oK>$$NC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012/5\t!C\u0003\u0002\u0014)\u0005aA/Z:u?\",G\u000e]3sg*\u00111!\u0006\u0006\u0003-\u0019\t\u0001B\u001a:p]R,g\u000eZ\u0005\u00031I\u0011abQ=qQ\u0016\u0014h)\u001e8Tk&$X\rC\u0003\u001b\u0001\u0011\u00051$\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0005\u0019!q\u0004A\u0001!\u0005q\u0019\u0005.Y5oC\ndWmU3nC:$\u0018nY*uCR,W)\u001b;iKJ\u001c\"AH\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0011!AcD!A!\u0002\u0013I\u0013AB3ji\",'\u000f\u0005\u0003+eUJdBA\u00161\u001d\tas&D\u0001.\u0015\tqc\"\u0001\u0004=e>|GOP\u0005\u0002I%\u0011\u0011gI\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019DG\u0001\u0004FSRDWM\u001d\u0006\u0003c\r\u0002\"AN\u001c\u000e\u0003QI!\u0001\u000f\u000b\u0003\u001bM+W.\u00198uS\u000e,%O]8s!\t1$(\u0003\u0002<)\ti1+Z7b]RL7m\u0015;bi\u0016DQA\u0007\u0010\u0005\u0002u\"\"A\u0010!\u0011\u0005}rR\"\u0001\u0001\t\u000b!b\u0004\u0019A\u0015\t\u000b\tsB\u0011A\"\u0002\u000b\rD\u0017-\u001b8\u0015\u0005%\"\u0005\"B#B\u0001\u00041\u0015\u0001\u00028fqR\u0004BAI$:S%\u0011\u0001j\t\u0002\n\rVt7\r^5p]FBqA\u0013\u0001\u0002\u0002\u0013\r1*\u0001\u000fDQ\u0006Lg.\u00192mKN+W.\u00198uS\u000e\u001cF/\u0019;f\u000b&$\b.\u001a:\u0015\u0005yb\u0005\"\u0002\u0015J\u0001\u0004I\u0003")
public class SemanticStateTest
extends CypherFunSuite {
    public ChainableSemanticStateEither ChainableSemanticStateEither(Either<SemanticError, SemanticState> either) {
        return new ChainableSemanticStateEither(this, either);
    }

    public SemanticStateTest() {
        this.test("should declare variable once", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variable variable1 = new Variable("foo", DummyPosition$.MODULE$.apply(0));
                Variable variable2 = new Variable("foo", DummyPosition$.MODULE$.apply(3));
                SemanticState state = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(variable1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Either either = state.declareVariable(variable2, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), state.declareVariable$default$3());
                if (either instanceof Right) {
                    throw this.$outer.fail("Expected an error from second declaration");
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    SemanticError error = (SemanticError)left.a();
                    this.$outer.convertToAnyShouldWrapper(error.position()).should(this.$outer.equal(variable2.position()), (Object)Equality$.MODULE$.default());
                    this.$outer.convertToAnyShouldWrapper(error.references()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[]{variable1.position()}))), (Object)Equality$.MODULE$.default());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError((Object)either);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should collect all variables when implicitly declared", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variable variable1 = new Variable("foo", DummyPosition$.MODULE$.apply(0));
                Variable variable2 = new Variable("foo", DummyPosition$.MODULE$.apply(2));
                Variable variable3 = new Variable("foo", DummyPosition$.MODULE$.apply(3));
                Either<SemanticError, SemanticState> either = this.$outer.ChainableSemanticStateEither(this.$outer.ChainableSemanticStateEither((Either<SemanticError, SemanticState>)SemanticState$.MODULE$.clean().implicitVariable(variable1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()))).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this, variable2){
                    public static final long serialVersionUID = 0L;
                    private final Variable variable2$1;

                    public final Either<SemanticError, SemanticState> apply(SemanticState x$1) {
                        return x$1.implicitVariable(this.variable2$1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()));
                    }
                    {
                        this.variable2$1 = variable2$1;
                    }
                })).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this, variable3){
                    public static final long serialVersionUID = 0L;
                    private final Variable variable3$1;

                    public final Either<SemanticError, SemanticState> apply(SemanticState x$2) {
                        return x$2.implicitVariable(this.variable3$1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()));
                    }
                    {
                        this.variable3$1 = variable3$1;
                    }
                });
                if (either instanceof Left) {
                    throw this.$outer.fail("Expected success");
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    SemanticState state = (SemanticState)right.b();
                    Set positions = (Set)SemanticState.ScopeLocation$.MODULE$.localSymbol$extension(state.currentScope(), "foo").map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Set<InputPosition> apply(Symbol x$3) {
                            return x$3.positions();
                        }
                    }).get();
                    this.$outer.convertToAnyShouldWrapper(positions).should(this.$outer.equal(Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[]{variable1.position(), variable2.position(), variable3.position()}))), (Object)Equality$.MODULE$.default());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(either);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should constrain types for consecutive implicit variable declarations", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variable variable1 = new Variable("foo", DummyPosition$.MODULE$.apply(0));
                Variable variable2 = new Variable("foo", DummyPosition$.MODULE$.apply(3));
                Either<SemanticError, SemanticState> either = this.$outer.ChainableSemanticStateEither((Either<SemanticError, SemanticState>)SemanticState$.MODULE$.clean().implicitVariable(variable1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship())))).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this, variable2){
                    public static final long serialVersionUID = 0L;
                    private final Variable variable2$2;

                    public final Either<SemanticError, SemanticState> apply(SemanticState x$4) {
                        return x$4.implicitVariable(this.variable2$2, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()));
                    }
                    {
                        this.variable2$2 = variable2$2;
                    }
                });
                if (either instanceof Left) {
                    throw this.$outer.fail("Expected success");
                }
                if (either instanceof Right) {
                    Right right = (Right)either;
                    SemanticState state = (SemanticState)right.b();
                    TypeSpec types = state.symbolTypes("foo");
                    this.$outer.convertToAnyShouldWrapper(types).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())), (Object)Equality$.MODULE$.default());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Either<SemanticError, SemanticState> either2 = this.$outer.ChainableSemanticStateEither((Either<SemanticError, SemanticState>)SemanticState$.MODULE$.clean().implicitVariable(variable1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship()))).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this, variable2){
                        public static final long serialVersionUID = 0L;
                        private final Variable variable2$2;

                        public final Either<SemanticError, SemanticState> apply(SemanticState x$5) {
                            return x$5.implicitVariable(this.variable2$2, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship())));
                        }
                        {
                            this.variable2$2 = variable2$2;
                        }
                    });
                    if (either2 instanceof Left) {
                        throw this.$outer.fail("Expected success");
                    }
                    if (either2 instanceof Right) {
                        Right right2 = (Right)either2;
                        SemanticState state2 = (SemanticState)right2.b();
                        TypeSpec types2 = state2.symbolTypes("foo");
                        this.$outer.convertToAnyShouldWrapper(types2).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship())), (Object)Equality$.MODULE$.default());
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        Either<SemanticError, SemanticState> either3 = this.$outer.ChainableSemanticStateEither((Either<SemanticError, SemanticState>)SemanticState$.MODULE$.clean().implicitVariable(variable1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship())))).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this, variable2){
                            public static final long serialVersionUID = 0L;
                            private final Variable variable2$2;

                            public final Either<SemanticError, SemanticState> apply(SemanticState x$6) {
                                return x$6.implicitVariable(this.variable2$2, package$.MODULE$.CTAny().covariant());
                            }
                            {
                                this.variable2$2 = variable2$2;
                            }
                        });
                        if (either3 instanceof Left) {
                            throw this.$outer.fail("Expected success");
                        }
                        if (either3 instanceof Right) {
                            Right right3 = (Right)either3;
                            SemanticState state3 = (SemanticState)right3.b();
                            TypeSpec types3 = state3.symbolTypes("foo");
                            this.$outer.convertToAnyShouldWrapper(types3).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship()))), (Object)Equality$.MODULE$.default());
                            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
                            Either<SemanticError, SemanticState> either4 = this.$outer.ChainableSemanticStateEither((Either<SemanticError, SemanticState>)SemanticState$.MODULE$.clean().implicitVariable(variable1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()))).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this, variable2){
                                public static final long serialVersionUID = 0L;
                                private final Variable variable2$2;

                                public final Either<SemanticError, SemanticState> apply(SemanticState x$7) {
                                    return x$7.implicitVariable(this.variable2$2, package$.MODULE$.CTMap().covariant());
                                }
                                {
                                    this.variable2$2 = variable2$2;
                                }
                            });
                            if (either4 instanceof Left) {
                                throw this.$outer.fail("Expected success");
                            }
                            if (either4 instanceof Right) {
                                Right right4 = (Right)either4;
                                SemanticState state4 = (SemanticState)right4.b();
                                TypeSpec types4 = state4.symbolTypes("foo");
                                this.$outer.convertToAnyShouldWrapper(types4).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())), (Object)Equality$.MODULE$.default());
                                BoxedUnit boxedUnit4 = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(either4);
                        }
                        throw new MatchError(either3);
                    }
                    throw new MatchError(either2);
                }
                throw new MatchError(either);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail if no possible types remain after implicit variable declaration", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Either<SemanticError, SemanticState> either = this.$outer.ChainableSemanticStateEither((Either<SemanticError, SemanticState>)SemanticState$.MODULE$.clean().implicitVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTMap()))).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Either<SemanticError, SemanticState> apply(SemanticState x$8) {
                        return x$8.implicitVariable(new Variable("foo", DummyPosition$.MODULE$.apply(3)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()));
                    }
                });
                if (either instanceof Right) {
                    throw this.$outer.fail("Expected an error");
                }
                if (either instanceof Left) {
                    Left left = (Left)either;
                    SemanticError error = (SemanticError)left.a();
                    this.$outer.convertToAnyShouldWrapper(error.position()).should(this.$outer.equal(DummyPosition$.MODULE$.apply(3)), (Object)Equality$.MODULE$.default());
                    this.$outer.convertToAnyShouldWrapper(error.references()).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[]{DummyPosition$.MODULE$.apply(0)}))));
                    this.$outer.convertToStringShouldWrapper(error.msg()).should(this.$outer.equal("Type mismatch: foo already defined with conflicting type Map (expected Node)"), (Object)Equality$.MODULE$.default());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Either<SemanticError, SemanticState> either2 = this.$outer.ChainableSemanticStateEither(this.$outer.ChainableSemanticStateEither((Either<SemanticError, SemanticState>)SemanticState$.MODULE$.clean().implicitVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship())))).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Either<SemanticError, SemanticState> apply(SemanticState x$9) {
                            return x$9.implicitVariable(new Variable("foo", DummyPosition$.MODULE$.apply(3)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTInteger())));
                        }
                    })).chain((Function1<SemanticState, Either<SemanticError, SemanticState>>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Either<SemanticError, SemanticState> apply(SemanticState x$10) {
                            return x$10.implicitVariable(new Variable("foo", DummyPosition$.MODULE$.apply(9)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTInteger()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship())));
                        }
                    });
                    if (either2 instanceof Right) {
                        throw this.$outer.fail("Expected an error");
                    }
                    if (either2 instanceof Left) {
                        Left left2 = (Left)either2;
                        SemanticError error2 = (SemanticError)left2.a();
                        this.$outer.convertToAnyShouldWrapper(error2.position()).should(this.$outer.equal(DummyPosition$.MODULE$.apply(9)), (Object)Equality$.MODULE$.default());
                        this.$outer.convertToAnyShouldWrapper(error2.references()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[]{DummyPosition$.MODULE$.apply(0), DummyPosition$.MODULE$.apply(3)}))), (Object)Equality$.MODULE$.default());
                        this.$outer.convertToStringShouldWrapper(error2.msg()).should(this.$outer.equal("Type mismatch: foo already defined with conflicting type Node (expected Integer or Relationship)"), (Object)Equality$.MODULE$.default());
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(either2);
                }
                throw new MatchError(either);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should record type for expression when specifying type", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyExpression expression = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTInteger()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString())), DummyExpression$.MODULE$.apply$default$2());
                SemanticState state = (SemanticState)SemanticState$.MODULE$.clean().specifyType((Expression)expression, expression.possibleTypes()).right().get();
                this.$outer.convertToAnyShouldWrapper(state.expressionType((Expression)expression).specified()).should(this.$outer.equal(expression.possibleTypes()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(state.expressionType((Expression)expression).actual()).should(this.$outer.equal(expression.possibleTypes()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should expect type for expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                DummyExpression expression = new DummyExpression(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTInteger()).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString())).$bar(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTMap())), DummyExpression$.MODULE$.apply$default$2());
                SemanticState state = (SemanticState)SemanticState$.MODULE$.clean().specifyType((Expression)expression, expression.possibleTypes()).right().get();
                Tuple2 tuple2 = state.expectType((Expression)expression, package$.MODULE$.CTNumber().covariant());
                if (tuple2 != null) {
                    SemanticState s = (SemanticState)tuple2._1();
                    TypeSpec typ = (TypeSpec)tuple2._2();
                    this.$outer.convertToAnyShouldWrapper(typ).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTInteger())), (Object)Equality$.MODULE$.default());
                    this.$outer.convertToAnyShouldWrapper(s.expressionType((Expression)expression).actual()).should(this.$outer.equal(typ), (Object)Equality$.MODULE$.default());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    Tuple2 tuple22 = state.expectType((Expression)expression, package$.MODULE$.CTNode().covariant().$bar(package$.MODULE$.CTNumber().covariant()));
                    if (tuple22 != null) {
                        SemanticState s2 = (SemanticState)tuple22._1();
                        TypeSpec typ2 = (TypeSpec)tuple22._2();
                        this.$outer.convertToAnyShouldWrapper(typ2).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTInteger())), (Object)Equality$.MODULE$.default());
                        this.$outer.convertToAnyShouldWrapper(s2.expressionType((Expression)expression).actual()).should(this.$outer.equal(typ2), (Object)Equality$.MODULE$.default());
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)tuple22);
                }
                throw new MatchError((Object)tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should find symbol in parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState s1 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                SemanticState s2 = s1.newChildScope();
                this.$outer.convertToAnyShouldWrapper(s2.symbolTypes("foo")).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should override symbol in parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState s1 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                SemanticState qual$1 = s1.newChildScope();
                Variable x$11 = new Variable("foo", DummyPosition$.MODULE$.apply(0));
                TypeSpec x$12 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString());
                Set x$13 = qual$1.declareVariable$default$3();
                SemanticState s2 = (SemanticState)qual$1.declareVariable(x$11, x$12, x$13).right().get();
                this.$outer.convertToAnyShouldWrapper(s2.symbolTypes("foo")).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTString())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should extend symbol in parent", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState s1 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                SemanticState s2 = (SemanticState)s1.newChildScope().implicitVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.CTAny().covariant()).right().get();
                this.$outer.convertToAnyShouldWrapper(s2.symbolTypes("foo")).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return types of variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variable variable = new Variable("foo", DummyPosition$.MODULE$.apply(0));
                SemanticState s1 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(variable, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                this.$outer.convertToAnyShouldWrapper(s1.expressionType((Expression)variable).actual()).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return types of variable at later expression", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Variable variable1 = new Variable("foo", DummyPosition$.MODULE$.apply(0));
                Variable variable2 = new Variable("foo", DummyPosition$.MODULE$.apply(3));
                SemanticState s1 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(variable1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                SemanticState s2 = (SemanticState)s1.implicitVariable(variable2, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())).right().get();
                this.$outer.convertToAnyShouldWrapper(s2.expressionType((Expression)variable2).actual()).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should maintain separate TypeInfo for equivalent expressions", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Property exp1 = new Property((Expression)new Variable("n", DummyPosition$.MODULE$.apply(0)), new PropertyKeyName("prop", DummyPosition$.MODULE$.apply(3)), DummyPosition$.MODULE$.apply(0));
                Property exp2 = new Property((Expression)new Variable("n", DummyPosition$.MODULE$.apply(6)), new PropertyKeyName("prop", DummyPosition$.MODULE$.apply(9)), DummyPosition$.MODULE$.apply(6));
                SemanticState s1 = (SemanticState)SemanticState$.MODULE$.clean().specifyType((Expression)exp1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())).right().get();
                SemanticState s2 = (SemanticState)s1.specifyType((Expression)exp2, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship())).right().get();
                this.$outer.convertToAnyShouldWrapper(s2.expressionType((Expression)exp1).specified()).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode())), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(s2.expressionType((Expression)exp2).specified()).should(this.$outer.equal(package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship())), (Object)Equality$.MODULE$.default());
                SemanticState s3 = (SemanticState)((SemanticState)s2.expectType((Expression)exp1, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTMap()))._1()).expectType((Expression)exp2, package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTAny()))._1();
                this.$outer.convertToAnyShouldWrapper(s3.expressionType((Expression)exp1).expected()).should(this.$outer.equal(new Some((Object)package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTMap()))), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(s3.expressionType((Expression)exp2).expected()).should(this.$outer.equal(new Some((Object)package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTAny()))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should gracefully update a variable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState s1 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                SemanticState qual$2 = s1.newChildScope();
                Variable x$14 = new Variable("foo", DummyPosition$.MODULE$.apply(0));
                TypeSpec x$15 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTRelationship());
                Set x$16 = qual$2.declareVariable$default$3();
                SemanticState s2 = (SemanticState)qual$2.declareVariable(x$14, x$15, x$16).right().get();
                this.$outer.convertToAnyShouldWrapper(s1.symbolTypes("foo")).should(this.$outer.equal(package$.MODULE$.CTNode().invariant()), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(s2.symbolTypes("foo")).should(this.$outer.equal(package$.MODULE$.CTRelationship().invariant()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to merge scopes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState qual$3 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$17 = new Variable("bar", DummyPosition$.MODULE$.apply(1));
                TypeSpec x$18 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$19 = qual$3.declareVariable$default$3();
                SemanticState s1 = (SemanticState)qual$3.declareVariable(x$17, x$18, x$19).right().get();
                SemanticState qual$4 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(1)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$20 = new Variable("baz", DummyPosition$.MODULE$.apply(4));
                TypeSpec x$21 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$22 = qual$4.declareVariable$default$3();
                SemanticState s2 = (SemanticState)qual$4.declareVariable(x$20, x$21, x$22).right().get();
                SemanticState qual$5 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(1)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputPosition[]{DummyPosition$.MODULE$.apply(0)}))).right().get();
                Variable x$23 = new Variable("baz", DummyPosition$.MODULE$.apply(4));
                TypeSpec x$24 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$25 = qual$5.declareVariable$default$3();
                this.$outer.convertToAnyShouldWrapper(s2.mergeScope(s1.scopeTree(), s2.mergeScope$default$2())).should(this.$outer.equal(qual$5.declareVariable(x$23, x$24, x$25).right().get()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to merge scopes and honor excludes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState qual$6 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$26 = new Variable("bar", DummyPosition$.MODULE$.apply(1));
                TypeSpec x$27 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$28 = qual$6.declareVariable$default$3();
                SemanticState s1 = (SemanticState)qual$6.declareVariable(x$26, x$27, x$28).right().get();
                SemanticState qual$7 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(1)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$29 = new Variable("baz", DummyPosition$.MODULE$.apply(4));
                TypeSpec x$30 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$31 = qual$7.declareVariable$default$3();
                SemanticState s2 = (SemanticState)qual$7.declareVariable(x$29, x$30, x$31).right().get();
                this.$outer.convertToAnyShouldWrapper(s2.mergeScope(s1.scopeTree(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})))).should(this.$outer.equal(s2), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to import scopes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState qual$8 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$32 = new Variable("bar", DummyPosition$.MODULE$.apply(1));
                TypeSpec x$33 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$34 = qual$8.declareVariable$default$3();
                SemanticState s1 = (SemanticState)qual$8.declareVariable(x$32, x$33, x$34).right().get();
                SemanticState qual$9 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(1)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$35 = new Variable("baz", DummyPosition$.MODULE$.apply(4));
                TypeSpec x$36 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$37 = qual$9.declareVariable$default$3();
                SemanticState s2 = (SemanticState)qual$9.declareVariable(x$35, x$36, x$37).right().get();
                SemanticState actual = s1.importScope(s2.scopeTree(), s1.importScope$default$2());
                SemanticState qual$10 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(1)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$38 = new Variable("bar", DummyPosition$.MODULE$.apply(1));
                TypeSpec x$39 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$40 = qual$10.declareVariable$default$3();
                SemanticState qual$11 = (SemanticState)qual$10.declareVariable(x$38, x$39, x$40).right().get();
                Variable x$41 = new Variable("baz", DummyPosition$.MODULE$.apply(4));
                TypeSpec x$42 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$43 = qual$11.declareVariable$default$3();
                SemanticState expected = (SemanticState)qual$11.declareVariable(x$41, x$42, x$43).right().get();
                this.$outer.convertToAnyShouldWrapper(actual.scopeTree()).should(this.$outer.equal(expected.scopeTree()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be able to import scopes and honor excludes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SemanticStateTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                SemanticState qual$12 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$44 = new Variable("bar", DummyPosition$.MODULE$.apply(1));
                TypeSpec x$45 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$46 = qual$12.declareVariable$default$3();
                SemanticState s1 = (SemanticState)qual$12.declareVariable(x$44, x$45, x$46).right().get();
                SemanticState qual$13 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(1)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$47 = new Variable("baz", DummyPosition$.MODULE$.apply(4));
                TypeSpec x$48 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$49 = qual$13.declareVariable$default$3();
                SemanticState qual$14 = (SemanticState)qual$13.declareVariable(x$47, x$48, x$49).right().get();
                Variable x$50 = new Variable("frob", DummyPosition$.MODULE$.apply(5));
                TypeSpec x$51 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$52 = qual$14.declareVariable$default$3();
                SemanticState s2 = (SemanticState)qual$14.declareVariable(x$50, x$51, x$52).right().get();
                SemanticState actual = s1.importScope(s2.scopeTree(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "frob"})));
                SemanticState qual$15 = (SemanticState)SemanticState$.MODULE$.clean().declareVariable(new Variable("foo", DummyPosition$.MODULE$.apply(0)), package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode()), SemanticState$.MODULE$.clean().declareVariable$default$3()).right().get();
                Variable x$53 = new Variable("bar", DummyPosition$.MODULE$.apply(1));
                TypeSpec x$54 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$55 = qual$15.declareVariable$default$3();
                SemanticState qual$16 = (SemanticState)qual$15.declareVariable(x$53, x$54, x$55).right().get();
                Variable x$56 = new Variable("baz", DummyPosition$.MODULE$.apply(4));
                TypeSpec x$57 = package$.MODULE$.invariantTypeSpec((CypherType)package$.MODULE$.CTNode());
                Set x$58 = qual$16.declareVariable$default$3();
                SemanticState expected = (SemanticState)qual$16.declareVariable(x$56, x$57, x$58).right().get();
                this.$outer.convertToAnyShouldWrapper(actual.scopeTree()).should(this.$outer.equal(expected.scopeTree()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public class ChainableSemanticStateEither {
        private final Either<SemanticError, SemanticState> either;
        public final /* synthetic */ SemanticStateTest $outer;

        public Either<SemanticError, SemanticState> chain(Function1<SemanticState, Either<SemanticError, SemanticState>> next) {
            Either<SemanticError, SemanticState> either;
            block4: {
                Either either2;
                block3: {
                    block2: {
                        either = this.either;
                        if (!(either instanceof Left)) break block2;
                        either2 = this.either;
                        break block3;
                    }
                    if (!(either instanceof Right)) break block4;
                    Right right = (Right)either;
                    SemanticState state = (SemanticState)right.b();
                    either2 = (Either)next.apply((Object)state);
                }
                return either2;
            }
            throw new MatchError(either);
        }

        public /* synthetic */ SemanticStateTest org$neo4j$cypher$internal$compiler$v3_1$SemanticStateTest$ChainableSemanticStateEither$$$outer() {
            return this.$outer;
        }

        public ChainableSemanticStateEither(SemanticStateTest $outer, Either<SemanticError, SemanticState> either) {
            this.either = either;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

