/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_1.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v3_1.ast.rewriters.desugarMapProjection;
import org.neo4j.cypher.internal.compiler.v3_1.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.compiler.v3_1.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.compiler.v3_1.parser.ParserFixture$;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition$;
import org.neo4j.cypher.internal.frontend.v3_1.Rewritable;
import org.neo4j.cypher.internal.frontend.v3_1.Rewritable$;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticState$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_1.inSequence$;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y2A!\u0001\u0002\u0001'\t\tC)Z:vO\u0006\u0014H)Z:vO\u0006\u0014X\rZ'baB\u0013xN[3di&|g\u000eV3ti*\u00111\u0001B\u0001\ne\u0016<(/\u001b;feNT!!\u0002\u0004\u0002\u0007\u0005\u001cHO\u0003\u0002\b\u0011\u0005!aoM02\u0015\tI!\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYA\"\u0001\u0005j]R,'O\\1m\u0015\tia\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001fA\tQA\\3pi)T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!F\u000e\u000e\u0003YQ!a\u0006\r\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u001dI\"B\u0001\u000e\u000b\u0003!1'o\u001c8uK:$\u0017B\u0001\u000f\u0017\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0002\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\u001b\u0005\u001c8/\u001a:u%\u0016<(/\u001b;f)\r)3\u0006\u000e\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0005+:LG\u000fC\u0003-E\u0001\u0007Q&A\u0007pe&<\u0017N\\1m#V,'/\u001f\t\u0003]Er!AJ\u0018\n\u0005A:\u0013A\u0002)sK\u0012,g-\u0003\u00023g\t11\u000b\u001e:j]\u001eT!\u0001M\u0014\t\u000bU\u0012\u0003\u0019A\u0017\u0002\u001b\u0015D\b/Z2uK\u0012\fV/\u001a:z\u0001")
public class DesugarDesugaredMapProjectionTest
extends CypherFunSuite {
    public void assertRewrite(String originalQuery, String expectedQuery) {
        this.test(new StringBuilder().append((Object)originalQuery).append((Object)" is rewritten to ").append((Object)expectedQuery).toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, originalQuery, expectedQuery){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DesugarDesugaredMapProjectionTest $outer;
            private final String originalQuery$1;
            private final String expectedQuery$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Statement rewrittenOriginal = this.rewrite$1(this.originalQuery$1);
                Statement rewrittenExpected = this.rewrite$1(this.expectedQuery$1);
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(rewrittenOriginal);
                Statement $org_scalatest_assert_macro_right = rewrittenExpected;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }

            private final Statement rewrite$1(String q) {
                InputPosition$.MODULE$.NONE();
                SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(this.originalQuery$1, null);
                Function1 sequence = inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)}));
                Statement originalAst = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)ParserFixture$.MODULE$.parser().parse(q, ParserFixture$.MODULE$.parser().parse$default$2())), sequence);
                SemanticCheckResult semanticCheckResult = (SemanticCheckResult)originalAst.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
                return (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)originalAst), (Function1)new desugarMapProjection(semanticCheckResult.state()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.originalQuery$1 = originalQuery$1;
                this.expectedQuery$1 = expectedQuery$1;
            }
        });
    }

    public DesugarDesugaredMapProjectionTest() {
        this.assertRewrite("match (n) return n{k:42} as x", "match (n) return n{k:42} as x");
        this.assertRewrite("match (n) return n{.id} as x", "match (n) return n{id: n.id} as x");
        this.assertRewrite("with '42' as existing match (n) return n{existing} as x", "with '42' as existing match (n) return n{existing: existing} as x");
        this.assertRewrite("match (n) return n{.foo,.bar,.baz} as x", "match (n) return n{foo: n.foo, bar: n.bar, baz: n.baz} as x");
        this.assertRewrite("match (n) return n{.*, .apa} as x", "match (n) return n{.*, apa: n.apa} as x");
        this.assertRewrite(new StringOps(Predef$.MODULE$.augmentString("match (n), (m)\n      |return n {\n      | .foo,\n      | .bar,\n      | inner: m {\n      |   .baz,\n      |   .apa\n      | }\n      |} as x")).stripMargin(), new StringOps(Predef$.MODULE$.augmentString("match (n), (m)\n      |return n {\n      | foo: n.foo,\n      | bar: n.bar,\n      | inner: m {\n      |   baz: m.baz,\n      |   apa: m.apa\n      | }\n      |} as x")).stripMargin());
    }
}

