/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.ast.rewriters;

import org.neo4j.cypher.internal.compiler.v3_1.SyntaxExceptionCreator;
import org.neo4j.cypher.internal.compiler.v3_1.ast.rewriters.expandStar;
import org.neo4j.cypher.internal.compiler.v3_1.ast.rewriters.normalizeReturnClauses;
import org.neo4j.cypher.internal.compiler.v3_1.ast.rewriters.normalizeWithClauses;
import org.neo4j.cypher.internal.compiler.v3_1.parser.ParserFixture$;
import org.neo4j.cypher.internal.frontend.v3_1.InputPosition;
import org.neo4j.cypher.internal.frontend.v3_1.Rewritable;
import org.neo4j.cypher.internal.frontend.v3_1.Rewritable$;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticCheckResult;
import org.neo4j.cypher.internal.frontend.v3_1.SemanticState$;
import org.neo4j.cypher.internal.frontend.v3_1.ast.AstConstructionTestSupport;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Equals;
import org.neo4j.cypher.internal.frontend.v3_1.ast.HasLabels;
import org.neo4j.cypher.internal.frontend.v3_1.ast.LabelName;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Property;
import org.neo4j.cypher.internal.frontend.v3_1.ast.SignedDecimalIntegerLiteral;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Statement;
import org.neo4j.cypher.internal.frontend.v3_1.ast.Variable;
import org.neo4j.cypher.internal.frontend.v3_1.inSequence$;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m2A!\u0001\u0002\u0001'\tqQ\t\u001f9b]\u0012\u001cF/\u0019:UKN$(BA\u0002\u0005\u0003%\u0011Xm\u001e:ji\u0016\u00148O\u0003\u0002\u0006\r\u0005\u0019\u0011m\u001d;\u000b\u0005\u001dA\u0011\u0001\u0002<4?FR!!\u0003\u0006\u0002\u0011\r|W\u000e]5mKJT!a\u0003\u0007\u0002\u0011%tG/\u001a:oC2T!!\u0004\b\u0002\r\rL\b\u000f[3s\u0015\ty\u0001#A\u0003oK>$$NC\u0001\u0012\u0003\ry'oZ\u0002\u0001'\r\u0001A#\b\t\u0003+mi\u0011A\u0006\u0006\u0003/a\tA\u0002^3ti~CW\r\u001c9feNT!aB\r\u000b\u0005iQ\u0011\u0001\u00034s_:$XM\u001c3\n\u0005q1\"AD\"za\",'OR;o'VLG/\u001a\t\u0003=\u0001j\u0011a\b\u0006\u0003\u000baI!!I\u0010\u00035\u0005\u001bHoQ8ogR\u0014Xo\u0019;j_:$Vm\u001d;TkB\u0004xN\u001d;\t\u000b\r\u0002A\u0011\u0001\u0013\u0002\rqJg.\u001b;?)\u0005)\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\u0015\u0001\t\u0013I\u0013!D1tg\u0016\u0014HOU3xe&$X\rF\u0002+ae\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\")\u0011g\na\u0001e\u0005iqN]5hS:\fG.U;fef\u0004\"a\r\u001c\u000f\u0005-\"\u0014BA\u001b-\u0003\u0019\u0001&/\u001a3fM&\u0011q\u0007\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ub\u0003\"\u0002\u001e(\u0001\u0004\u0011\u0014!D3ya\u0016\u001cG/\u001a3Rk\u0016\u0014\u0018\u0010")
public class ExpandStarTest
extends CypherFunSuite
implements AstConstructionTestSupport {
    private final InputPosition pos;

    public InputPosition pos() {
        return this.pos;
    }

    public void org$neo4j$cypher$internal$frontend$v3_1$ast$AstConstructionTestSupport$_setter_$pos_$eq(InputPosition x$1) {
        this.pos = x$1;
    }

    public <T> T withPos(Function1<InputPosition, T> expr) {
        return (T)AstConstructionTestSupport.class.withPos((AstConstructionTestSupport)this, expr);
    }

    public Variable varFor(String name) {
        return AstConstructionTestSupport.class.varFor((AstConstructionTestSupport)this, (String)name);
    }

    public LabelName lblName(String s) {
        return AstConstructionTestSupport.class.lblName((AstConstructionTestSupport)this, (String)s);
    }

    public HasLabels hasLabels(String v, String label) {
        return AstConstructionTestSupport.class.hasLabels((AstConstructionTestSupport)this, (String)v, (String)label);
    }

    public Property prop(String variable, String propKey) {
        return AstConstructionTestSupport.class.prop((AstConstructionTestSupport)this, (String)variable, (String)propKey);
    }

    public Equals propEquality(String variable, String propKey, int intValue) {
        return AstConstructionTestSupport.class.propEquality((AstConstructionTestSupport)this, (String)variable, (String)propKey, (int)intValue);
    }

    public SignedDecimalIntegerLiteral literalInt(int intValue) {
        return AstConstructionTestSupport.class.literalInt((AstConstructionTestSupport)this, (int)intValue);
    }

    public void org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite(String originalQuery, String expectedQuery) {
        SyntaxExceptionCreator mkException = new SyntaxExceptionCreator(originalQuery, (Option)new Some((Object)this.pos()));
        Statement original = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)ParserFixture$.MODULE$.parser().parse(originalQuery, ParserFixture$.MODULE$.parser().parse$default$2())), inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        Statement expected = (Statement)Rewritable.RewritableAny$.MODULE$.endoRewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)ParserFixture$.MODULE$.parser().parse(expectedQuery, ParserFixture$.MODULE$.parser().parse$default$2())), inSequence$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new normalizeReturnClauses((Function2)mkException), new normalizeWithClauses((Function2)mkException)})));
        SemanticCheckResult checkResult = (SemanticCheckResult)original.semanticCheck().apply((Object)SemanticState$.MODULE$.clean());
        expandStar rewriter = new expandStar(checkResult.state());
        Object result = Rewritable.RewritableAny$.MODULE$.rewrite$extension(Rewritable$.MODULE$.RewritableAny((Object)original), (Function1)rewriter);
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(result);
        Statement $org_scalatest_assert_macro_right = expected;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()));
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
    }

    public ExpandStarTest() {
        AstConstructionTestSupport.class.$init$((AstConstructionTestSupport)this);
        this.test("rewrites * in return", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n) return *", "match (n) return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n),(c) return *", "match (n),(c) return c,n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-->(c) return *", "match (n)-->(c) return c,n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-[r]->(c) return *", "match (n)-[r]->(c) return c,n,r");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("create (n) return *", "create (n) return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match p = shortestPath((a)-[r*]->(x)) return *", "match p = shortestPath((a)-[r*]->(x)) return a,p,r,x");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match p=(a:Start)-->(b) return *", "match p=(a:Start)-->(b) return a, b, p");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("rewrites * in with", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n) with * return n", "match (n) with n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n),(c) with * return n", "match (n),(c) with c,n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-->(c) with * return n", "match (n)-->(c) with c,n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-[r]->(c) with * return n", "match (n)-[r]->(c) with c,n,r return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match (n)-[r]->(c) with *, r.pi as x return n", "match (n)-[r]->(c) with c, n, r, r.pi as x return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("create (n) with * return n", "create (n) with n return n");
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match p = shortestPath((a)-[r*]->(x)) with * return p", "match p = shortestPath((a)-[r*]->(x)) with a,p,r,x return p");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("symbol shadowing should be taken into account", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("match a,x,y with a match (b) return *", "match a,x,y with a match (b) return a, b");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("expands _PRAGMA WITHOUT", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("MATCH a,x,y _PRAGMA WITHOUT a MATCH b RETURN *", "MATCH a,x,y WITH x, y MATCH b RETURN b, x, y");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("keeps listed items during expand", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExpandStarTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.org$neo4j$cypher$internal$compiler$v3_1$ast$rewriters$ExpandStarTest$$assertRewrite("MATCH (n) WITH *, 1 AS b RETURN *", "MATCH (n) WITH n, 1 AS b RETURN b, n");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

