/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.commands;

import org.neo4j.cypher.internal.compiler.v3_1.executionplan.MatchPattern;
import org.neo4j.cypher.internal.compiler.v3_1.executionplan.MatchRelationship;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00012A!\u0001\u0002\u0001#\t\u0001R*\u0019;dQB\u000bG\u000f^3s]R+7\u000f\u001e\u0006\u0003\u0007\u0011\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u000b\u0019\tAA^\u001a`c)\u0011q\u0001C\u0001\tG>l\u0007/\u001b7fe*\u0011\u0011BC\u0001\tS:$XM\u001d8bY*\u00111\u0002D\u0001\u0007Gf\u0004\b.\u001a:\u000b\u00055q\u0011!\u00028f_RR'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u001a\u001b\u0005!\"BA\u000b\u0017\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t)qC\u0003\u0002\u0019\u0011\u0005AaM]8oi\u0016tG-\u0003\u0002\u001b)\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u000f\u0001\t\u0003i\u0012A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u0003\u0001")
public class MatchPatternTest
extends CypherFunSuite {
    public MatchPatternTest() {
        this.test("should find disjoint graph with single nodes", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatterns()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchPattern[]{new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should be non empty if it contains a node", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)).nonEmpty())).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should find single graph for simple rel", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)None$.MODULE$, "A", "B")})));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatterns()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchPattern[]{pattern}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should find deeply nested disjoint graphs", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", "C", "D"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)None$.MODULE$, "A", "B"), new MatchRelationship((Option)None$.MODULE$, "B", "D")})));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatterns()).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchPattern[]{new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", "D"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)None$.MODULE$, "A", "B"), new MatchRelationship((Option)None$.MODULE$, "B", "D")}))), new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should list subgraphs without specified points", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B", "C"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)None$.MODULE$, "A", "B")})));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatternsWithout((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"B"})))).should(this.$outer.equal(Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchPattern[]{new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"C"})), (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should not consider patterns bound by relationships as unbounded", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatchPatternTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                MatchPattern pattern = new MatchPattern((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A", "B"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MatchRelationship[]{new MatchRelationship((Option)new Some((Object)"r"), "A", "B")})));
                this.$outer.convertToAnyShouldWrapper(pattern.disconnectedPatternsWithout((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"r"})))).should(this.$outer.equal(Seq$.MODULE$.empty()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

