/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.commands.expressions;

import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.PathImpl;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.PathValueBuilder;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001'\t!\u0002+\u0019;i-\u0006dW/\u001a\"vS2$WM\u001d+fgRT!a\u0001\u0003\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003\u000b\u0019\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u000f!\tAA^\u001a`c)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u001c\u001b\u00051\"BA\f\u0019\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t9\u0011D\u0003\u0002\u001b\u0015\u0005AaM]8oi\u0016tG-\u0003\u0002\u001d-\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u0010\u0001\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0003\u0011\u001d\u0019\u0003A1A\u0005\u0002\u0011\n\u0011!Q\u000b\u0002KA\u0011a%K\u0007\u0002O)\u0011\u0001FD\u0001\bOJ\f\u0007\u000f\u001b3c\u0013\tQsE\u0001\u0003O_\u0012,\u0007B\u0002\u0017\u0001A\u0003%Q%\u0001\u0002BA!9a\u0006\u0001b\u0001\n\u0003!\u0013!\u0001\"\t\rA\u0002\u0001\u0015!\u0003&\u0003\t\u0011\u0005\u0005C\u00043\u0001\t\u0007I\u0011\u0001\u0013\u0002\u0003\rCa\u0001\u000e\u0001!\u0002\u0013)\u0013AA\"!\u0011\u001d1\u0004A1A\u0005\u0002\u0011\n\u0011\u0001\u0012\u0005\u0007q\u0001\u0001\u000b\u0011B\u0013\u0002\u0005\u0011\u0003\u0003b\u0002\u001e\u0001\u0005\u0004%\t\u0001J\u0001\u0002\u000b\"1A\b\u0001Q\u0001\n\u0015\n!!\u0012\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005!!/\u001a72+\u0005\u0001\u0005C\u0001\u0014B\u0013\t\u0011uE\u0001\u0007SK2\fG/[8og\"L\u0007\u000f\u0003\u0004E\u0001\u0001\u0006I\u0001Q\u0001\u0006e\u0016d\u0017\u0007\t\u0005\b\r\u0002\u0011\r\u0011\"\u0001@\u0003\u0011\u0011X\r\u001c\u001a\t\r!\u0003\u0001\u0015!\u0003A\u0003\u0015\u0011X\r\u001c\u001a!\u0011\u001dQ\u0005A1A\u0005\u0002}\nAA]3mg!1A\n\u0001Q\u0001\n\u0001\u000bQA]3mg\u0001BqA\u0014\u0001C\u0002\u0013\u0005q(\u0001\u0003sK2$\u0004B\u0002)\u0001A\u0003%\u0001)A\u0003sK2$\u0004\u0005C\u0003S\u0001\u0011%1+\u0001\nn_\u000e\\W\r\u001a*fY\u0006$\u0018n\u001c8tQ&\u0004H\u0003\u0002!U9zCQ!V)A\u0002Y\u000b!!\u001b3\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\t1{gn\u001a\u0005\u0006;F\u0003\r!J\u0001\u0006gR\f'\u000f\u001e\u0005\u0006?F\u0003\r!J\u0001\u0004K:$\u0007\"B1\u0001\t\u0013\u0011\u0017AC7pG.,GMT8eKR\u0011Qe\u0019\u0005\u0006+\u0002\u0004\rA\u0016")
public class PathValueBuilderTest
extends CypherFunSuite {
    private final Node A = this.mockedNode(1L);
    private final Node B = this.mockedNode(2L);
    private final Node C = this.mockedNode(3L);
    private final Node D = this.mockedNode(4L);
    private final Node E = this.mockedNode(5L);
    private final Relationship rel1 = this.mockedRelationship(1L, this.A(), this.B());
    private final Relationship rel2 = this.mockedRelationship(2L, this.B(), this.C());
    private final Relationship rel3 = this.mockedRelationship(3L, this.C(), this.D());
    private final Relationship rel4 = this.mockedRelationship(3L, this.D(), this.E());

    public Node A() {
        return this.A;
    }

    public Node B() {
        return this.B;
    }

    public Node C() {
        return this.C;
    }

    public Node D() {
        return this.D;
    }

    public Node E() {
        return this.E;
    }

    public Relationship rel1() {
        return this.rel1;
    }

    public Relationship rel2() {
        return this.rel2;
    }

    public Relationship rel3() {
        return this.rel3;
    }

    public Relationship rel4() {
        return this.rel4;
    }

    private Relationship mockedRelationship(long id, Node start, Node end) {
        Relationship rel = (Relationship)this.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)rel.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        Mockito.when((Object)rel.getStartNode()).thenReturn((Object)start);
        Mockito.when((Object)rel.getEndNode()).thenReturn((Object)end);
        Mockito.when((Object)rel.getType()).thenReturn((Object)RelationshipType.withName((String)"X"));
        Mockito.when((Object)rel.getOtherNode(start)).thenReturn((Object)end);
        Mockito.when((Object)rel.getOtherNode(end)).thenReturn((Object)start);
        return rel;
    }

    /*
     * WARNING - void declaration
     */
    private Node mockedNode(long id) {
        void var3_2;
        Node node2 = (Node)this.mock(ManifestFactory$.MODULE$.classType(Node.class));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)id));
        return var3_2;
    }

    public PathValueBuilderTest() {
        this.test("p = (a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]->(b)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addOutgoingRelationship(this.$outer.rel1());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.B()).addIncomingRelationship(this.$outer.rel1());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]-(b)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationship(this.$outer.rel1());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.B()).addUndirectedRelationship(this.$outer.rel1());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = <empty> should throw", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                this.$outer.evaluating((Function0)new Serializable(this, builder){
                    public static final long serialVersionUID = 0L;
                    private final PathValueBuilder builder$1;

                    public final PathImpl apply() {
                        return this.builder$1.result();
                    }
                    {
                        this.builder$1 = builder$1;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(IllegalArgumentException.class)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X*]->(b)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addOutgoingRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X*]->(b) when rels is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addOutgoingRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(null));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r:X]->(b)--(c)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addOutgoingRelationship(this.$outer.rel1()).addUndirectedRelationship(this.$outer.rel2());
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X*]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.C()).addIncomingRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)<-[r:X*]-(a) when rels is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addIncomingRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(null));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.C()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a) reversed", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.C()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C(), this.$outer.rel2(), this.$outer.B(), this.$outer.rel1(), this.$outer.A()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-()", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()}))).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel3(), this.$outer.rel4()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()}))).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel3(), this.$outer.rel4()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel1(), this.$outer.rel2()}))).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel4(), this.$outer.rel3()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r1*]-()-[r2*]-() reversed r1 && r2", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel2(), this.$outer.rel1()}))).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relationship[]{this.$outer.rel4(), this.$outer.rel3()})));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.A(), this.$outer.rel1(), this.$outer.B(), this.$outer.rel2(), this.$outer.C(), this.$outer.rel3(), this.$outer.D(), this.$outer.rel4(), this.$outer.E()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*0]-(a)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.C()).addUndirectedRelationships((Iterable)package$.MODULE$.Iterable().apply((Seq)Nil$.MODULE$));
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(new PathImpl((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PropertyContainer[]{this.$outer.C()}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (b)-[r:X*]-(a) when rels is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(this.$outer.A()).addUndirectedRelationships(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(null));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a) when single node is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                PathImpl result = builder.addNode(null).result();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(null));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a) when single node is null also for mutable builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                builder.addNode(null);
                this.$outer.convertToAnyShouldWrapper(builder.result()).should(this.$outer.equal(null));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("p = (a)-[r]->(b) when relationship is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PathValueBuilderTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                PathValueBuilder builder = new PathValueBuilder();
                PathImpl result = builder.addNode(this.$outer.A()).addIncomingRelationship(null).result();
                this.$outer.convertToAnyShouldWrapper(result).should(this.$outer.equal(null));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

