/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.commands.expressions;

import java.util.HashMap;
import org.mockito.Mockito;
import org.neo4j.cypher.internal.compiler.v3_1.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.PropertiesFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.PropertiesFunctionTest$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.compiler.v3_1.spi.Operations;
import org.neo4j.cypher.internal.compiler.v3_1.spi.QueryContext;
import org.neo4j.cypher.internal.frontend.v3_1.CypherTypeException;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001'\t1\u0002K]8qKJ$\u0018.Z:Gk:\u001cG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t)a!\u0001\u0005d_6l\u0017M\u001c3t\u0015\t9\u0001\"\u0001\u0003wg}\u000b$BA\u0005\u000b\u0003!\u0019w.\u001c9jY\u0016\u0014(BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'BA\u0007\u000f\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u0011q\u0002E\u0001\u0006]\u0016|GG\u001b\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+mi\u0011A\u0006\u0006\u0003/a\tA\u0002^3ti~CW\r\u001c9feNT!aB\r\u000b\u0005iQ\u0011\u0001\u00034s_:$XM\u001c3\n\u0005q1\"AD\"za\",'OR;o'VLG/\u001a\u0005\u0006=\u0001!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"!\t\u0001\u000e\u0003\tAqa\t\u0001C\u0002\u0013\u0005A%A\u0003rk\u0016\u0014\u00180F\u0001&!\t1\u0013&D\u0001(\u0015\tAc!A\u0002ta&L!AK\u0014\u0003\u0019E+XM]=D_:$X\r\u001f;\t\r1\u0002\u0001\u0015!\u0003&\u0003\u0019\tX/\u001a:zA!9a\u0006\u0001b\u0001\n\u0003y\u0013a\u00028pI\u0016|\u0005o]\u000b\u0002aA\u0019a%M\u001a\n\u0005I:#AC(qKJ\fG/[8ogB\u0011AgN\u0007\u0002k)\u0011aGD\u0001\bOJ\f\u0007\u000f\u001b3c\u0013\tATG\u0001\u0003O_\u0012,\u0007B\u0002\u001e\u0001A\u0003%\u0001'\u0001\u0005o_\u0012,w\n]:!\u0011\u001da\u0004A1A\u0005\u0002u\naA]3m\u001fB\u001cX#\u0001 \u0011\u0007\u0019\nt\b\u0005\u00025\u0001&\u0011\u0011)\u000e\u0002\r%\u0016d\u0017\r^5p]ND\u0017\u000e\u001d\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002 \u0002\u000fI,Gn\u00149tA!)Q\t\u0001C\u0005\r\u0006Q\u0001O]8qKJ$\u0018.Z:\u0015\u0005\u001dk\u0005C\u0001%L\u001b\u0005I%\"\u0001&\u0002\u000bM\u001c\u0017\r\\1\n\u00051K%aA!os\")a\n\u0012a\u0001\u000f\u0006!qN]5h\u0001")
public class PropertiesFunctionTest
extends CypherFunSuite {
    private final QueryContext query = (QueryContext)this.mock(ManifestFactory$.MODULE$.classType(QueryContext.class));
    private final Operations<Node> nodeOps = (Operations)this.mock(ManifestFactory$.MODULE$.classType(Operations.class, ManifestFactory$.MODULE$.classType(Node.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    private final Operations<Relationship> relOps = (Operations)this.mock(ManifestFactory$.MODULE$.classType(Operations.class, ManifestFactory$.MODULE$.classType(Relationship.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));

    public QueryContext query() {
        return this.query;
    }

    public Operations<Node> nodeOps() {
        return this.nodeOps;
    }

    public Operations<Relationship> relOps() {
        return this.relOps;
    }

    public Object org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties(Object orig) {
        return new PropertiesFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty().withQueryContext(this.query()));
    }

    public PropertiesFunctionTest() {
        Mockito.when((Object)this.query().nodeOps()).thenReturn(this.nodeOps());
        Mockito.when((Object)this.query().relationshipOps()).thenReturn(this.relOps());
        this.test("should return null if argument is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties(null)).should(this.$outer.be().apply(null));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should map Java maps to maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("a", "x");
                m.put("b", "y");
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties(m)).should(this.$outer.equal(JavaConverters$.MODULE$.mapAsScalaMapConverter(m).asScala()), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should map Scala maps to maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Map m = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"x"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"y")}));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties(m)).should(this.$outer.equal(m), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should map nodes to maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Node node2 = (Node)this.$outer.mock(ManifestFactory$.MODULE$.classType(Node.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)node2.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Mockito.when((Object)this.$outer.nodeOps().propertyKeyIds(0L)).thenReturn((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})).iterator());
                Mockito.when((Object)this.$outer.query().getPropertyKeyName(0)).thenReturn((Object)"a");
                Mockito.when((Object)this.$outer.query().getPropertyKeyName(1)).thenReturn((Object)"b");
                Mockito.when((Object)this.$outer.nodeOps().getProperty(0L, 0)).thenReturn((Object)"x", ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Seq$.MODULE$.empty()).toArray(ClassTag$.MODULE$.Any())));
                Mockito.when((Object)this.$outer.nodeOps().getProperty(0L, 1)).thenReturn((Object)"y", ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Seq$.MODULE$.empty()).toArray(ClassTag$.MODULE$.Any())));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties(node2)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"x"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"y")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should map relationships to maps", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Relationship rel = (Relationship)this.$outer.mock(ManifestFactory$.MODULE$.classType(Relationship.class));
                Mockito.when((Object)BoxesRunTime.boxToLong((long)rel.getId())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
                Mockito.when((Object)this.$outer.relOps().propertyKeyIds(0L)).thenReturn((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})).iterator());
                Mockito.when((Object)this.$outer.query().getPropertyKeyName(0)).thenReturn((Object)"a");
                Mockito.when((Object)this.$outer.query().getPropertyKeyName(1)).thenReturn((Object)"b");
                Mockito.when((Object)this.$outer.relOps().getProperty(0L, 0)).thenReturn((Object)"x", ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Seq$.MODULE$.empty()).toArray(ClassTag$.MODULE$.Any())));
                Mockito.when((Object)this.$outer.relOps().getProperty(0L, 1)).thenReturn((Object)"y", ScalaRunTime$.MODULE$.toObjectArray(((TraversableOnce)Seq$.MODULE$.empty()).toArray(ClassTag$.MODULE$.Any())));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties(rel)).should(this.$outer.equal(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)"x"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)"y")}))), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail trying to map an int", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$6 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties(BoxesRunTime.boxToInteger((int)12));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PropertiesFunctionTest org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail trying to map a string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$7 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties("Hullo");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PropertiesFunctionTest org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should fail trying to map a list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PropertiesFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.a(ManifestFactory$.MODULE$.classType(CypherTypeException.class)).should(this.$outer.be()).thrownBy((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$8 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$properties(List$.MODULE$.empty());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ PropertiesFunctionTest org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$PropertiesFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

