/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.commands.expressions;

import org.neo4j.cypher.internal.compiler.v3_1.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.SplitFunction;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001'\t\t2\u000b\u001d7ji\u001a+hn\u0019;j_:$Vm\u001d;\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r|W.\\1oINT!a\u0002\u0005\u0002\tY\u001ct,\r\u0006\u0003\u0013)\t\u0001bY8na&dWM\u001d\u0006\u0003\u00171\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u001b9\taaY=qQ\u0016\u0014(BA\b\u0011\u0003\u0015qWm\u001c\u001bk\u0015\u0005\t\u0012aA8sO\u000e\u00011C\u0001\u0001\u0015!\t)2$D\u0001\u0017\u0015\t9\u0002$\u0001\u0007uKN$x\f[3ma\u0016\u00148O\u0003\u0002\b3)\u0011!DC\u0001\tMJ|g\u000e^3oI&\u0011AD\u0006\u0002\u000f\u0007f\u0004\b.\u001a:Gk:\u001cV/\u001b;f\u0011\u0015q\u0002\u0001\"\u0001 \u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!\u0001C\u0004$\u0001\t\u0007I\u0011\u0001\u0013\u0002\u000f9,H\u000e\\*fcV\tQ\u0005E\u0002'aMr!aJ\u0017\u000f\u0005!ZS\"A\u0015\u000b\u0005)\u0012\u0012A\u0002\u001fs_>$h(C\u0001-\u0003\u0015\u00198-\u00197b\u0013\tqs&A\u0004qC\u000e\\\u0017mZ3\u000b\u00031J!!\r\u001a\u0003\u0007M+\u0017O\u0003\u0002/_A\u0011A\u0007\u000f\b\u0003kYj\u0011aL\u0005\u0003o=\na\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011qg\f\u0005\u0007y\u0001\u0001\u000b\u0011B\u0013\u0002\u00119,H\u000e\\*fc\u0002BqA\u0010\u0001C\u0002\u0013\u0005q(\u0001\u0006ok2d7\u000b\u001e:j]\u001e,\u0012a\r\u0005\u0007\u0003\u0002\u0001\u000b\u0011B\u001a\u0002\u00179,H\u000e\\*ue&tw\r\t\u0005\u0006\u0007\u0002!I\u0001R\u0001\u0006gBd\u0017\u000e\u001e\u000b\u0004\u000b\"S\u0005CA\u001bG\u0013\t9uFA\u0002B]fDQ!\u0013\"A\u0002M\nAa\u001c:jO\")1J\u0011a\u0001g\u0005a1\u000f\u001d7jiB\u000bG\u000f^3s]\u0002")
public class SplitFunctionTest
extends CypherFunSuite {
    private final Seq<String> nullSeq = null;
    private final String nullString;

    public Seq<String> nullSeq() {
        return this.nullSeq;
    }

    public String nullString() {
        return this.nullString;
    }

    public Object org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split(String orig, String splitPattern) {
        SplitFunction expr = new SplitFunction((Expression)new Literal((Object)orig), (Expression)new Literal((Object)splitPattern));
        return expr.apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public SplitFunctionTest() {
        this.nullString = null;
        this.test("passing null to split() returns null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split("something", this.$outer.nullString())).should(this.$outer.be().apply(this.$outer.nullSeq()));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split(this.$outer.nullString(), "something")).should(this.$outer.be().apply(this.$outer.nullSeq()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("splitting non-empty strings with one character", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split("first,second", ",")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second"}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("splitting non-empty strings with more than one character", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split("first11second11third", "11")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"first", "second", "third"}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("splitting an empty string should return an empty string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split("", ",")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("splitting a string containing only the split pattern should return two empty strings", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split(",", ",")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("using an empty separator should split on every character", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SplitFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split("banana", "")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"b", "a", "n", "a", "n", "a"}))));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split("a", "")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"a"}))));
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$SplitFunctionTest$$split("", "")).should(this.$outer.be().apply((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

