/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.commands.expressions;

import org.neo4j.cypher.internal.compiler.v3_1.ExecutionContext$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.Literal;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.ToFloatFunction;
import org.neo4j.cypher.internal.compiler.v3_1.commands.expressions.ToFloatFunctionTest$;
import org.neo4j.cypher.internal.compiler.v3_1.pipes.QueryStateHelper$;
import org.neo4j.cypher.internal.frontend.v3_1.ParameterWrongTypeException;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.TripleEqualsSupport;
import org.scalatest.Tag;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u000152A!\u0001\u0002\u0001'\t\u0019Bk\u001c$m_\u0006$h)\u001e8di&|g\u000eV3ti*\u00111\u0001B\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u0006\r\u0005A1m\\7nC:$7O\u0003\u0002\b\u0011\u0005!aoM02\u0015\tI!\"\u0001\u0005d_6\u0004\u0018\u000e\\3s\u0015\tYA\"\u0001\u0005j]R,'O\\1m\u0015\tia\"\u0001\u0004dsBDWM\u001d\u0006\u0003\u001fA\tQA\\3pi)T\u0011!E\u0001\u0004_J<7\u0001A\n\u0003\u0001Q\u0001\"!F\u000e\u000e\u0003YQ!a\u0006\r\u0002\u0019Q,7\u000f^0iK2\u0004XM]:\u000b\u0005\u001dI\"B\u0001\u000e\u000b\u0003!1'o\u001c8uK:$\u0017B\u0001\u000f\u0017\u00059\u0019\u0015\u0010\u001d5fe\u001a+hnU;ji\u0016DQA\b\u0001\u0005\u0002}\ta\u0001P5oSRtD#\u0001\u0011\u0011\u0005\u0005\u0002Q\"\u0001\u0002\t\u000b\r\u0002A\u0011\u0002\u0013\u0002\u000fQ|g\t\\8biR\u0011Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0002Q\u0005)1oY1mC&\u0011!f\n\u0002\u0004\u0003:L\b\"\u0002\u0017#\u0001\u0004)\u0013\u0001B8sS\u001e\u0004")
public class ToFloatFunctionTest
extends CypherFunSuite {
    public Object org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat(Object orig) {
        return new ToFloatFunction((Expression)new Literal(orig)).apply(ExecutionContext$.MODULE$.empty(), QueryStateHelper$.MODULE$.empty());
    }

    public ToFloatFunctionTest() {
        this.test("should return null if argument is null", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat(null));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat("10.599")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)10.599)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert an integer string to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat("21")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)21.0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert an integer to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat(BoxesRunTime.boxToInteger((int)23))).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)23.0)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should return null if the argument is a partially numeric string", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.$outer.convertToEqualizer(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat("20foobar2"));
                Null$ $org_scalatest_assert_macro_right = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", null, $org_scalatest_assert_macro_left.$eq$eq$eq($org_scalatest_assert_macro_right));
                this.$outer.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading zeros to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat("000123121.5")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)123121.5)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus to a negative float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat("-12.66")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)-12.66)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should convert a string with leading minus and zeros to a negative float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat("-00012.91")).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)-12.91)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("should throw an exception if the argument is an object which cannot be converted to a float", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ParameterWrongTypeException caughtException = (ParameterWrongTypeException)this.$outer.evaluating((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$9 $outer;

                    public final Object apply() {
                        return this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$anonfun$$$outer().org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat(new Object());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).should(this.$outer.produce(ManifestFactory$.MODULE$.classType(ParameterWrongTypeException.class)));
                this.$outer.convertToStringShouldWrapper(caughtException.getMessage()).should(this.$outer.startWith().apply("Expected a String or Number, got: "));
            }

            public /* synthetic */ ToFloatFunctionTest org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.test("given a float should give the same value back", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ToFloatFunctionTest $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.convertToAnyShouldWrapper(this.$outer.org$neo4j$cypher$internal$compiler$v3_1$commands$expressions$ToFloatFunctionTest$$toFloat(BoxesRunTime.boxToDouble((double)50.5))).should(this.$outer.be().apply((Object)BoxesRunTime.boxToDouble((double)50.5)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

