/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v3_1.commands.predicates;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.neo4j.cypher.internal.compiler.v3_1.CRS$;
import org.neo4j.cypher.internal.compiler.v3_1.GeographicPoint;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Equivalent;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.Equivalent$;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.ImplementsJavaCRS;
import org.neo4j.cypher.internal.compiler.v3_1.commands.predicates.ImplementsJavaPoint;
import org.neo4j.cypher.internal.frontend.v3_1.test_helpers.CypherFunSuite;
import org.scalactic.Equality$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001'\tqQ)];jm\u0006dWM\u001c;UKN$(BA\u0002\u0005\u0003)\u0001(/\u001a3jG\u0006$Xm\u001d\u0006\u0003\u000b\u0019\t\u0001bY8n[\u0006tGm\u001d\u0006\u0003\u000f!\tAA^\u001a`c)\u0011\u0011BC\u0001\tG>l\u0007/\u001b7fe*\u00111\u0002D\u0001\tS:$XM\u001d8bY*\u0011QBD\u0001\u0007Gf\u0004\b.\u001a:\u000b\u0005=\u0001\u0012!\u00028f_RR'\"A\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u001c\u001b\u00051\"BA\f\u0019\u00031!Xm\u001d;`Q\u0016d\u0007/\u001a:t\u0015\t9\u0011D\u0003\u0002\u001b\u0015\u0005AaM]8oi\u0016tG-\u0003\u0002\u001d-\tq1)\u001f9iKJ4UO\\*vSR,\u0007\"\u0002\u0010\u0001\t\u0003y\u0012A\u0002\u001fj]&$h\bF\u0001!!\t\t\u0003!D\u0001\u0003\u0011\u001d\u0019\u0003A1A\u0005\u0002\u0011\n1a\u0019:t+\u0005)\u0003CA\u0011'\u0013\t9#AA\tJ[BdW-\\3oiNT\u0015M^1D%NCa!\u000b\u0001!\u0002\u0013)\u0013\u0001B2sg\u0002BQa\u000b\u0001\u0005\n1\n1b\u001d5pk2$W*\u0019;dQR\u0019Qf\r\u001d\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\tUs\u0017\u000e\u001e\u0005\u0006i)\u0002\r!N\u0001\u0003mF\u0002\"A\f\u001c\n\u0005]z#aA!os\")\u0011H\u000ba\u0001k\u0005\u0011aO\r\u0005\u0006w\u0001!I\u0001P\u0001\u000fg\"|W\u000f\u001c3O_Rl\u0015\r^2i)\riSH\u0010\u0005\u0006ii\u0002\r!\u000e\u0005\u0006si\u0002\r!\u000e\u0005\u0006\u0001\u0002!I!Q\u0001\ti\u0016\u001cHOT1nKR!!)\u0013&L!\t\u0019eI\u0004\u0002/\t&\u0011QiL\u0001\u0007!J,G-\u001a4\n\u0005\u001dC%AB*ue&twM\u0003\u0002F_!)Ag\u0010a\u0001k!)\u0011h\u0010a\u0001k!)Aj\u0010a\u0001\u0005\u0006Aq\u000e]3sCR|'\u000f")
public class EquivalentTest
extends CypherFunSuite {
    private final ImplementsJavaCRS crs;

    public ImplementsJavaCRS crs() {
        return this.crs;
    }

    private void shouldMatch(Object v1, Object v2) {
        this.test(this.testName(v1, v2, "="), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, v1, v2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EquivalentTest $outer;
            private final Object v1$1;
            private final Object v2$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Equivalent eq1 = Equivalent$.MODULE$.apply(this.v1$1);
                Equivalent eq2 = Equivalent$.MODULE$.apply(this.v2$1);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)eq1.equals(this.v2$1))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)eq2.equals(this.v1$1))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)true)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToInteger((int)eq1.hashCode())).should(this.$outer.equal(BoxesRunTime.boxToInteger((int)eq2.hashCode())), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.v1$1 = v1$1;
                this.v2$1 = v2$1;
            }
        });
    }

    private void shouldNotMatch(Object v1, Object v2) {
        this.test(this.testName(v1, v2, "<>"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new Serializable(this, v1, v2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ EquivalentTest $outer;
            private final Object v1$2;
            private final Object v2$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Equivalent eq1 = Equivalent$.MODULE$.apply(this.v1$2);
                Equivalent eq2 = Equivalent$.MODULE$.apply(this.v2$2);
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)eq1.equals(this.v2$2))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
                this.$outer.convertToAnyShouldWrapper(BoxesRunTime.boxToBoolean((boolean)eq2.equals(this.v1$2))).should(this.$outer.equal(BoxesRunTime.boxToBoolean((boolean)false)), (Object)Equality$.MODULE$.default());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.v1$2 = v1$2;
                this.v2$2 = v2$2;
            }
        });
    }

    private String testName(Object v1, Object v2, String operator) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " (", ") ", " ", " (", ")\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{v1, v1.getClass().getSimpleName(), operator, v2, v2.getClass().getSimpleName()}));
    }

    public EquivalentTest() {
        this.shouldMatch(BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToLong((long)1L));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToInteger((int)1));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)1.0), BoxesRunTime.boxToDouble((double)1.0));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)0.9), BoxesRunTime.boxToDouble((double)0.9));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)Math.PI), BoxesRunTime.boxToDouble((double)Math.PI));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)1.1), BoxesRunTime.boxToDouble((double)1.1));
        this.shouldMatch(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)0));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)((double)Integer.MAX_VALUE + 1.0)), BoxesRunTime.boxToLong((long)((long)Integer.MAX_VALUE + 1L)));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY), BoxesRunTime.boxToDouble((double)Double.POSITIVE_INFINITY));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY), BoxesRunTime.boxToDouble((double)Double.NEGATIVE_INFINITY));
        this.shouldMatch(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)true));
        this.shouldMatch(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)false));
        this.shouldNotMatch(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)false));
        this.shouldNotMatch(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)true));
        this.shouldNotMatch(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)0));
        this.shouldNotMatch(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)0));
        this.shouldNotMatch(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToInteger((int)1));
        this.shouldNotMatch(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToInteger((int)1));
        this.shouldNotMatch(BoxesRunTime.boxToBoolean((boolean)false), "false");
        this.shouldNotMatch(BoxesRunTime.boxToBoolean((boolean)true), "true");
        this.shouldMatch(BoxesRunTime.boxToByte((byte)((byte)42)), BoxesRunTime.boxToByte((byte)((byte)42)));
        this.shouldMatch(BoxesRunTime.boxToByte((byte)((byte)42)), BoxesRunTime.boxToShort((short)((short)42)));
        this.shouldNotMatch(BoxesRunTime.boxToByte((byte)((byte)42)), BoxesRunTime.boxToInteger((int)298));
        this.shouldMatch(BoxesRunTime.boxToByte((byte)((byte)43)), BoxesRunTime.boxToInteger((int)43));
        this.shouldMatch(BoxesRunTime.boxToByte((byte)((byte)43)), BoxesRunTime.boxToLong((long)43));
        this.shouldMatch(BoxesRunTime.boxToByte((byte)((byte)23)), BoxesRunTime.boxToDouble((double)23.0));
        this.shouldMatch(BoxesRunTime.boxToByte((byte)((byte)23)), BoxesRunTime.boxToFloat((float)23.0f));
        this.shouldNotMatch(BoxesRunTime.boxToByte((byte)((byte)23)), BoxesRunTime.boxToDouble((double)23.5));
        this.shouldNotMatch(BoxesRunTime.boxToByte((byte)((byte)23)), BoxesRunTime.boxToFloat((float)23.5f));
        this.shouldMatch(BoxesRunTime.boxToShort((short)((short)11)), BoxesRunTime.boxToByte((byte)((byte)11)));
        this.shouldMatch(BoxesRunTime.boxToShort((short)((short)42)), BoxesRunTime.boxToShort((short)((short)42)));
        this.shouldNotMatch(BoxesRunTime.boxToShort((short)((short)42)), BoxesRunTime.boxToInteger((int)65578));
        this.shouldMatch(BoxesRunTime.boxToShort((short)((short)43)), BoxesRunTime.boxToInteger((int)43));
        this.shouldMatch(BoxesRunTime.boxToShort((short)((short)43)), BoxesRunTime.boxToLong((long)43));
        this.shouldMatch(BoxesRunTime.boxToShort((short)((short)23)), BoxesRunTime.boxToFloat((float)23.0f));
        this.shouldMatch(BoxesRunTime.boxToShort((short)((short)23)), BoxesRunTime.boxToDouble((double)23.0));
        this.shouldNotMatch(BoxesRunTime.boxToShort((short)((short)23)), BoxesRunTime.boxToDouble((double)23.5));
        this.shouldNotMatch(BoxesRunTime.boxToShort((short)((short)23)), BoxesRunTime.boxToFloat((float)23.5f));
        this.shouldMatch(BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToByte((byte)((byte)11)));
        this.shouldMatch(BoxesRunTime.boxToInteger((int)42), BoxesRunTime.boxToShort((short)((short)42)));
        this.shouldNotMatch(BoxesRunTime.boxToInteger((int)42), BoxesRunTime.boxToLong((long)4294967338L));
        this.shouldMatch(BoxesRunTime.boxToInteger((int)43), BoxesRunTime.boxToInteger((int)43));
        this.shouldMatch(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE));
        this.shouldMatch(BoxesRunTime.boxToInteger((int)43), BoxesRunTime.boxToLong((long)43));
        this.shouldMatch(BoxesRunTime.boxToInteger((int)23), BoxesRunTime.boxToDouble((double)23.0));
        this.shouldNotMatch(BoxesRunTime.boxToInteger((int)23), BoxesRunTime.boxToDouble((double)23.5));
        this.shouldNotMatch(BoxesRunTime.boxToInteger((int)23), BoxesRunTime.boxToFloat((float)23.5f));
        this.shouldMatch(BoxesRunTime.boxToLong((long)11L), BoxesRunTime.boxToByte((byte)((byte)11)));
        this.shouldMatch(BoxesRunTime.boxToLong((long)42L), BoxesRunTime.boxToShort((short)((short)42)));
        this.shouldMatch(BoxesRunTime.boxToLong((long)43L), BoxesRunTime.boxToInteger((int)43));
        this.shouldMatch(BoxesRunTime.boxToLong((long)43L), BoxesRunTime.boxToLong((long)43));
        this.shouldMatch(BoxesRunTime.boxToLong((long)87L), BoxesRunTime.boxToLong((long)87));
        this.shouldMatch(BoxesRunTime.boxToLong((long)Long.MAX_VALUE), BoxesRunTime.boxToLong((long)Long.MAX_VALUE));
        this.shouldMatch(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE), BoxesRunTime.boxToLong((long)Integer.MAX_VALUE));
        this.shouldMatch(BoxesRunTime.boxToLong((long)23L), BoxesRunTime.boxToDouble((double)23.0));
        this.shouldNotMatch(BoxesRunTime.boxToLong((long)23L), BoxesRunTime.boxToDouble((double)23.5));
        this.shouldNotMatch(BoxesRunTime.boxToLong((long)23L), BoxesRunTime.boxToFloat((float)23.5f));
        this.shouldMatch(BoxesRunTime.boxToLong((long)0x20000000000000L), BoxesRunTime.boxToDouble((double)9.007199254740992E15));
        this.shouldNotMatch(BoxesRunTime.boxToLong((long)0x4000000000000001L), BoxesRunTime.boxToLong((long)0x3FFFFFFFFFFFFFFCL));
        this.shouldMatch(BoxesRunTime.boxToFloat((float)11.0f), BoxesRunTime.boxToByte((byte)((byte)11)));
        this.shouldMatch(BoxesRunTime.boxToFloat((float)42.0f), BoxesRunTime.boxToShort((short)((short)42)));
        this.shouldMatch(BoxesRunTime.boxToFloat((float)43.0f), BoxesRunTime.boxToInteger((int)43));
        this.shouldMatch(BoxesRunTime.boxToFloat((float)43.0f), BoxesRunTime.boxToLong((long)43));
        this.shouldMatch(BoxesRunTime.boxToFloat((float)23.0f), BoxesRunTime.boxToDouble((double)23.0));
        this.shouldNotMatch(BoxesRunTime.boxToFloat((float)23.0f), BoxesRunTime.boxToDouble((double)23.5));
        this.shouldNotMatch(BoxesRunTime.boxToFloat((float)23.0f), BoxesRunTime.boxToFloat((float)23.5f));
        this.shouldMatch(BoxesRunTime.boxToFloat((float)3.14f), BoxesRunTime.boxToFloat((float)3.14f));
        this.shouldMatch(BoxesRunTime.boxToFloat((float)3.14f), BoxesRunTime.boxToDouble((double)3.14));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToByte((byte)((byte)11)));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)42.0), BoxesRunTime.boxToShort((short)((short)42)));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)43.0), BoxesRunTime.boxToInteger((int)43));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)43.0), BoxesRunTime.boxToLong((long)43));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)23.0), BoxesRunTime.boxToDouble((double)23.0));
        this.shouldNotMatch(BoxesRunTime.boxToDouble((double)23.0), BoxesRunTime.boxToDouble((double)23.5));
        this.shouldNotMatch(BoxesRunTime.boxToDouble((double)23.0), BoxesRunTime.boxToFloat((float)23.5f));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToFloat((float)3.14f));
        this.shouldMatch(BoxesRunTime.boxToDouble((double)3.14), BoxesRunTime.boxToDouble((double)3.14));
        this.shouldMatch("A", "A");
        this.shouldMatch(BoxesRunTime.boxToCharacter((char)'A'), BoxesRunTime.boxToCharacter((char)'A'));
        this.shouldMatch(BoxesRunTime.boxToCharacter((char)'A'), "A");
        this.shouldMatch("A", BoxesRunTime.boxToCharacter((char)'A'));
        this.shouldNotMatch("AA", BoxesRunTime.boxToCharacter((char)'A'));
        this.shouldNotMatch("a", "A");
        this.shouldNotMatch("A", "a");
        this.shouldNotMatch("0", BoxesRunTime.boxToInteger((int)0));
        this.shouldNotMatch(BoxesRunTime.boxToCharacter((char)'0'), BoxesRunTime.boxToInteger((int)0));
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), ClassTag$.MODULE$.Int()), Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), ClassTag$.MODULE$.Int()));
        this.shouldMatch((Object[])new int[][]{{1}, {2, 2}, {3, 3, 3}}, (Object[])new double[][]{{1.0}, {2.0, 2.0}, {3.0, 3.0, 3.0}});
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), ClassTag$.MODULE$.Int()), Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{1L, 2L, 3L}), ClassTag$.MODULE$.Long()));
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), ClassTag$.MODULE$.Int()), Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{1.0, 2.0, 3.0}), ClassTag$.MODULE$.Double()));
        this.shouldMatch(new String[]{"A", "B", "C"}, new String[]{"A", "B", "C"});
        this.shouldMatch(new String[]{"A", "B", "C"}, Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'A', 'B', 'C'}), ClassTag$.MODULE$.Char()));
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'A', 'B', 'C'}), ClassTag$.MODULE$.Char()), new String[]{"A", "B", "C"});
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), ClassTag$.MODULE$.Int()), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 2, 3})));
        this.shouldMatch(Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new int[]{1, 2, 3})), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new long[]{1L, 2L, 3L})));
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), ClassTag$.MODULE$.Int()), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new long[]{1L, 2L, 3L})));
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}), ClassTag$.MODULE$.Int()), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{1.0, 2.0, 3.0})));
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 2}), ClassTag$.MODULE$.Int()), BoxesRunTime.boxToInteger((int)3)}), ClassTag$.MODULE$.Any()), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)1.0), Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{2.0, 2.0})), BoxesRunTime.boxToDouble((double)3.0)})));
        this.shouldMatch(new String[]{"A", "B", "C"}, Arrays.asList((Object[])new String[]{"A", "B", "C"}));
        this.shouldMatch(new String[]{"A", "B", "C"}, Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new char[]{'A', 'B', 'C'})));
        this.shouldMatch(Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapCharArray(new char[]{'A', 'B', 'C'}), ClassTag$.MODULE$.Char()), Arrays.asList((Object[])new String[]{"A", "B", "C"}));
        this.shouldMatch(new ArrayList(), List$.MODULE$.empty());
        this.shouldMatch(Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Int()), List$.MODULE$.empty());
        this.shouldMatch(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)42))})), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)42))})));
        this.shouldMatch(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)42))})), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToDouble((double)42.0))})));
        this.shouldMatch(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)42))})), Collections.singletonMap("a", BoxesRunTime.boxToDouble((double)42.0)));
        this.shouldMatch(Collections.singletonMap("a", Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new double[]{41.0, 42.0}))), Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{41, 42})))})));
        this.shouldMatch(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), Collections.singletonMap("x", Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)41.0), BoxesRunTime.boxToCharacter((char)'c')}))))})), Collections.singletonMap("a", Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"x"), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)41), "c"})))}))));
        this.shouldMatch(new GeographicPoint(32.0, 43.0, CRS$.MODULE$.Cartesian()), new GeographicPoint(32.0, 43.0, CRS$.MODULE$.Cartesian()));
        this.crs = new ImplementsJavaCRS("cartesian", "http://spatialreference.org/ref/sr-org/7203/", 7203);
        this.shouldMatch(new ImplementsJavaPoint(32.0, 43.0, this.crs()), new GeographicPoint(32.0, 43.0, CRS$.MODULE$.Cartesian()));
        this.shouldMatch(new ImplementsJavaPoint(32.0, 43.0, this.crs()), new ImplementsJavaPoint(32.0, 43.0, this.crs()));
    }
}

